/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@GwtCompatible
public class S2CellIndex {
    private final List<CellNode> cellNodes = new ArrayList<CellNode>();
    private final ArrayList<RangeNode> rangeNodes = new ArrayList();

    public int numCells() {
        return this.cellNodes.size();
    }

    public void add(S2CellId cellId, int label) {
        assert (cellId.isValid());
        assert (label >= 0);
        this.cellNodes.add(new CellNode(cellId, label, -1));
    }

    public void add(Iterable<S2CellId> cellIds, int label) {
        for (S2CellId cellId : cellIds) {
            this.add(cellId, label);
        }
    }

    public void build() {
        Delta[] deltas = new Delta[2 * this.cellNodes.size() + 2];
        int size = 0;
        for (CellNode node : this.cellNodes) {
            deltas[size++] = new Delta(node.cellId.rangeMin(), node.cellId, node.label);
            deltas[size++] = new Delta(node.cellId.rangeMax().next(), S2CellId.sentinel(), -1);
        }
        deltas[size++] = new Delta(S2CellId.begin(30), S2CellId.none(), -1);
        deltas[size++] = new Delta(S2CellId.end(30), S2CellId.none(), -1);
        Arrays.sort(deltas, Delta.BY_START_CELL_NEG_LABEL);
        this.cellNodes.clear();
        this.rangeNodes.ensureCapacity(deltas.length);
        int contents = -1;
        int i = 0;
        while (i < deltas.length) {
            S2CellId startId = deltas[i].startId;
            while (i < deltas.length && deltas[i].startId.equals(startId)) {
                if (deltas[i].label >= 0) {
                    this.cellNodes.add(new CellNode(deltas[i].cellId, deltas[i].label, contents));
                    contents = this.cellNodes.size() - 1;
                } else if (deltas[i].cellId.equals(S2CellId.sentinel())) {
                    contents = this.cellNodes.get(contents).parent;
                }
                ++i;
            }
            this.rangeNodes.add(new RangeNode(startId, contents));
        }
    }

    public CellIterator cells() {
        Preconditions.checkState((!this.rangeNodes.isEmpty() ? 1 : 0) != 0, (Object)"Call build() first.");
        return new CellIterator();
    }

    public RangeIterator ranges() {
        Preconditions.checkState((!this.rangeNodes.isEmpty() ? 1 : 0) != 0, (Object)"Call build() first.");
        return new RangeIterator();
    }

    public NonEmptyRangeIterator nonEmptyRanges() {
        return new NonEmptyRangeIterator(this);
    }

    public ContentsIterator contents() {
        Preconditions.checkState((!this.rangeNodes.isEmpty() ? 1 : 0) != 0, (Object)"Call build() first.");
        return new ContentsIterator();
    }

    public void clear() {
        this.cellNodes.clear();
        this.rangeNodes.clear();
    }

    public boolean visitIntersectingCells(S2CellUnion target, CellVisitor visitor) {
        if (target.size() == 0) {
            return true;
        }
        ContentsIterator contents = this.contents();
        RangeIterator range = this.ranges();
        int i = 0;
        while (i < target.size()) {
            S2CellId id = target.cellId(i);
            if (range.limitId().lessOrEquals(id.rangeMin())) {
                range.seek(id.rangeMin());
            }
            while (range.startId().lessOrEquals(id.rangeMax())) {
                contents.startUnion(range);
                while (!contents.done()) {
                    if (!visitor.visit(contents.cellId(), contents.label())) {
                        return false;
                    }
                    contents.next();
                }
                range.next();
            }
            if (++i == target.size() || !target.cellId(i).rangeMax().lessThan(range.startId()) || !target.cellId((i = S2ShapeUtil.lowerBound(i + 1, target.size(), j -> range.startId().greaterThan(target.cellId(j)))) - 1).rangeMax().greaterOrEquals(range.startId())) continue;
            --i;
        }
        return true;
    }

    public Labels getIntersectingLabels(S2CellUnion target) {
        Labels result = new Labels();
        this.getIntersectingLabels(target, result);
        result.normalize();
        return result;
    }

    public void getIntersectingLabels(S2CellUnion target, Labels results) {
        this.visitIntersectingCells(target, (cellId, label) -> results.add(label));
    }

    public class ContentsIterator {
        private static final int DONE = -1;
        private S2CellId prevStartId;
        private int nodeCutoff;
        private int nextNodeCutoff;
        private final CellNode node = new CellNode(null, -1, -1);

        private ContentsIterator() {
            this.clear();
        }

        public void clear() {
            this.prevStartId = S2CellId.none();
            this.nodeCutoff = -1;
            this.nextNodeCutoff = -1;
            this.setDone();
        }

        public void startUnion(RangeIterator range) {
            if (range.startId().lessThan(this.prevStartId)) {
                this.nodeCutoff = -1;
            }
            this.prevStartId = range.startId();
            int contents = range.node.contents;
            if (contents <= this.nodeCutoff) {
                this.setDone();
            } else {
                this.node.setFrom((CellNode)S2CellIndex.this.cellNodes.get(contents));
            }
            this.nextNodeCutoff = contents;
        }

        public S2CellId cellId() {
            assert (!this.done());
            return this.node.cellId;
        }

        public int label() {
            assert (!this.done());
            return this.node.label;
        }

        public boolean done() {
            return this.node.label == -1;
        }

        public void next() {
            assert (!this.done());
            if (this.node.parent <= this.nodeCutoff) {
                this.nodeCutoff = this.nextNodeCutoff;
                this.setDone();
            } else {
                this.node.setFrom((CellNode)S2CellIndex.this.cellNodes.get(this.node.parent));
            }
        }

        private void setDone() {
            this.node.label = -1;
        }
    }

    public class NonEmptyRangeIterator
    extends RangeIterator {
        public NonEmptyRangeIterator(S2CellIndex this$0) {
        }

        @Override
        public void begin() {
            super.begin();
            while (this.isEmpty() && !this.done()) {
                super.next();
            }
        }

        @Override
        public void next() {
            do {
                super.next();
            } while (this.isEmpty() && !this.done());
        }

        @Override
        public boolean prev() {
            while (super.prev()) {
                if (this.isEmpty()) continue;
                return true;
            }
            if (this.isEmpty() && !this.done()) {
                this.next();
            }
            return false;
        }

        @Override
        public void seek(S2CellId target) {
            super.seek(target);
            while (this.isEmpty() && !this.done()) {
                super.next();
            }
        }
    }

    public class RangeIterator {
        private int offset;
        private RangeNode node;

        public RangeIterator() {
            this.node = (RangeNode)S2CellIndex.this.rangeNodes.get(this.offset);
        }

        public S2CellId startId() {
            return this.node.startId;
        }

        public S2CellId limitId() {
            assert (!this.done());
            return ((RangeNode)S2CellIndex.this.rangeNodes.get(this.offset + 1)).startId;
        }

        public boolean done() {
            return this.offset >= S2CellIndex.this.rangeNodes.size() - 1;
        }

        public void begin() {
            this.seekAndLoad(0);
        }

        public void finish() {
            this.seekAndLoad(S2CellIndex.this.rangeNodes.size() - 1);
        }

        public void next() {
            assert (!this.done());
            this.seekAndLoad(this.offset + 1);
        }

        public boolean prev() {
            if (this.offset == 0) {
                return false;
            }
            this.seekAndLoad(this.offset - 1);
            return true;
        }

        public void seek(S2CellId target) {
            assert (target.isLeaf());
            this.seekAndLoad(S2ShapeUtil.upperBound(0, S2CellIndex.this.rangeNodes.size(), i -> target.lessThan(((RangeNode)S2CellIndex.this.rangeNodes.get(i)).startId)) - 1);
        }

        public boolean isEmpty() {
            return this.node.contents == -1;
        }

        public boolean advance(int n) {
            if (n >= S2CellIndex.this.rangeNodes.size() - 1 - this.offset) {
                return false;
            }
            this.seekAndLoad(this.offset + n);
            return true;
        }

        private void seekAndLoad(int offset) {
            this.offset = offset;
            this.node = (RangeNode)S2CellIndex.this.rangeNodes.get(offset);
        }
    }

    private static class RangeNode {
        private final S2CellId startId;
        private final int contents;

        private RangeNode(S2CellId startId, int contents) {
            this.startId = startId;
            this.contents = contents;
        }
    }

    public final class CellIterator {
        private int offset;
        private CellNode cell;

        private CellIterator() {
            Preconditions.checkState((!S2CellIndex.this.rangeNodes.isEmpty() ? 1 : 0) != 0, (Object)"Call build() first.");
            this.seek(0);
        }

        public S2CellId cellId() {
            assert (!this.done());
            return this.cell.cellId;
        }

        public int label() {
            assert (!this.done());
            return this.cell.label;
        }

        public boolean done() {
            return this.offset == S2CellIndex.this.cellNodes.size();
        }

        public void next() {
            assert (!this.done());
            this.seek(this.offset + 1);
        }

        private void seek(int offset) {
            this.offset = offset;
            this.cell = this.done() ? null : (CellNode)S2CellIndex.this.cellNodes.get(offset);
        }
    }

    private static final class CellNode {
        private S2CellId cellId;
        private int label;
        private int parent;

        private CellNode(S2CellId cellId, int label, int parent) {
            this.cellId = cellId;
            this.label = label;
            this.parent = parent;
        }

        private void setFrom(CellNode node) {
            this.cellId = node.cellId;
            this.label = node.label;
            this.parent = node.parent;
        }
    }

    public static class Labels
    extends AbstractList<Integer> {
        private int[] labels = new int[8];
        private int size;

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        private boolean add(int label) {
            if (this.labels.length == this.size) {
                this.labels = Arrays.copyOf(this.labels, this.size * 2);
            }
            this.labels[this.size++] = label;
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Integer get(int index) {
            return this.getInt(index);
        }

        public int getInt(int index) {
            return this.labels[index];
        }

        public void normalize() {
            if (this.size == 0) {
                return;
            }
            Arrays.sort(this.labels, 0, this.size);
            int lastIndex = 0;
            for (int i = 1; i < this.size; ++i) {
                if (this.labels[lastIndex] == this.labels[i]) continue;
                this.labels[++lastIndex] = this.labels[i];
            }
            this.size = lastIndex + 1;
        }
    }

    public static interface CellVisitor {
        public boolean visit(S2CellId var1, int var2);
    }

    private static final class Delta {
        public static final Comparator<Delta> BY_START_CELL_NEG_LABEL = (a, b) -> {
            int result = a.startId.compareTo(b.startId);
            if (result != 0) {
                return result;
            }
            result = -a.cellId.compareTo(b.cellId);
            if (result != 0) {
                return result;
            }
            return Integer.compare(a.label, b.label);
        };
        private final S2CellId startId;
        private final S2CellId cellId;
        private final int label;

        private Delta(S2CellId startId, S2CellId cellId, int label) {
            this.startId = startId;
            this.cellId = cellId;
            this.label = label;
        }
    }
}

