/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;

@GwtCompatible
public class S2Error {
    private Code code = Code.NO_ERROR;
    private String text = "";

    public void init(Code code, String format, Object ... args) {
        this.code = code;
        this.text = Platform.formatString(format, args);
    }

    public Code code() {
        return this.code;
    }

    public String text() {
        return this.text;
    }

    public static enum Code {
        NO_ERROR(0),
        UNKNOWN(1000),
        UNIMPLEMENTED(1001),
        OUT_OF_RANGE(1002),
        INVALID_ARGUMENT(1003),
        FAILED_PRECONDITION(1004),
        INTERNAL(1005),
        DATA_LOSS(1006),
        RESOURCE_EXHAUSTED(1007),
        NOT_UNIT_LENGTH(1),
        DUPLICATE_VERTICES(2),
        ANTIPODAL_VERTICES(3),
        LOOP_NOT_ENOUGH_VERTICES(100),
        LOOP_SELF_INTERSECTION(101),
        POLYGON_LOOPS_SHARE_EDGE(200),
        POLYGON_LOOPS_CROSS(201),
        POLYGON_EMPTY_LOOP(202),
        POLYGON_EXCESS_FULL_LOOP(203),
        POLYGON_INVALID_LOOP_DEPTH(205),
        POLYGON_INVALID_LOOP_NESTING(206);

        private final int code;

        private Code(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

