/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

@GwtCompatible(serializable=true)
public class S2RegionIntersection
implements S2Region,
Serializable {
    final S2Region[] regions;
    private transient S2LatLngRect cachedRectBound = null;

    public S2RegionIntersection(Collection<S2Region> regions) {
        this.regions = regions.toArray(new S2Region[regions.size()]);
    }

    @Override
    public boolean contains(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (region.contains(cell)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(S2Point point) {
        for (S2Region region : this.regions) {
            if (region.contains(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        if (this.cachedRectBound != null) {
            return this.cachedRectBound;
        }
        S2LatLngRect.Builder builder = new S2LatLngRect.Builder(S2LatLngRect.full());
        for (S2Region region : this.regions) {
            builder.intersection(region.getRectBound());
        }
        this.cachedRectBound = builder.build();
        return this.cachedRectBound;
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (region.mayIntersect(cell)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object thatObject) {
        if (!(thatObject instanceof S2RegionIntersection)) {
            return false;
        }
        S2RegionIntersection that = (S2RegionIntersection)thatObject;
        return Arrays.equals(this.regions, that.regions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.regions);
    }
}

