/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.ngram;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;

public class NGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curGramSize;
    private int curPos;
    private int tokStart;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    public NGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public NGramTokenFilter(TokenStream input) {
        this(input, 1, 2);
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.termBuffer().clone();
                this.curTermLength = this.termAtt.termLength();
                this.curGramSize = this.minGram;
                this.curPos = 0;
                this.tokStart = this.offsetAtt.startOffset();
            }
            while (this.curGramSize <= this.maxGram) {
                if (this.curPos + this.curGramSize <= this.curTermLength) {
                    this.clearAttributes();
                    this.termAtt.setTermBuffer(this.curTermBuffer, this.curPos, this.curGramSize);
                    this.offsetAtt.setOffset(this.tokStart + this.curPos, this.tokStart + this.curPos + this.curGramSize);
                    ++this.curPos;
                    return true;
                }
                ++this.curGramSize;
                this.curPos = 0;
            }
            this.curTermBuffer = null;
        }
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
    }
}

