/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import mediautil.image.jpeg.BasicJpegIo;

class Header
extends BasicJpegIo {
    int minorVersion;
    int dllVersion;
    boolean intelByteOrder;
    int sectorSize;
    static final int SECTORSIZEOFF = 30;
    int miniSectorSize;
    static final int MINISECTORSIZEOFF = 32;
    int sectsFat;
    static final int SECTSFATOFF = 44;
    int sectDirStart;
    static final int SECTDIRSTARTOFF = 48;
    int miniSectorCutoff;
    static final int MINISECTORCUTOFFOFF = 56;
    int sectMiniFatStart;
    static final int SECTMINIFATSTARTOFF = 60;
    int sectsMiniFat;
    static final int SECTSMINIFATOFF = 64;
    int sectDifStart;
    static final int SECTDIFSTARTOFF = 68;
    int sectsDif;
    static final int SECTSDIFOFF = 72;
    int[] fat;
    static final int FATOFF = 76;
    static final int FIRST_FAT_SIZE = 109;

    Header() {
    }

    void fill(byte[] data, int offset) {
        this.data = data;
        this.intel = true;
        this.intelByteOrder = true;
        this.sectorSize = 1 << this.s2n(30 + offset, 2);
        this.miniSectorSize = 1 << this.s2n(32 + offset, 2);
        this.sectsFat = this.s2n(44 + offset, 4);
        this.sectDirStart = this.s2n(48 + offset, 4);
        this.miniSectorCutoff = this.s2n(56 + offset, 4);
        this.sectMiniFatStart = this.s2n(60 + offset, 4);
        this.sectsMiniFat = this.s2n(64 + offset, 4);
        this.sectDifStart = this.s2n(68 + offset, 4);
        this.sectsDif = this.s2n(72 + offset, 4);
        this.fat = new int[109];
        for (int i = 0; i < 109; ++i) {
            this.fat[i] = this.s2n(76 + offset + 4 * i, 4);
        }
    }

    public String toString() {
        int n = this.sectorSize;
        int n2 = this.miniSectorSize;
        int n3 = this.sectsFat;
        int n4 = this.sectDirStart;
        int n5 = this.miniSectorCutoff;
        int n6 = this.sectMiniFatStart;
        int n7 = this.sectsMiniFat;
        int n8 = this.sectDifStart;
        int n9 = this.sectsDif;
        String result = new StringBuilder(257).append("Sector size ").append(n).append(", mini sector size ").append(n2).append(", sectors in FAT ").append(n3).append(", directory sector ").append(n4).append(", max size of mini stream ").append(n5).append(", mini FAT starts ").append(n6).append(", sectors in mini FAT ").append(n7).append(", first DIF and numbers ").append(n8).append(':').append(n9).toString();
        return result;
    }
}

