/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.dev.GeometricQuery;
import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.PrefixFieldAnalyzerUtil;
import com.google.appengine.api.search.dev.WordSeparatorAnalyzer;
import com.google.appengine.api.search.query.ParserUtils;
import com.google.appengine.api.search.query.QueryTreeContext;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanClause;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.NumericRangeQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.PhraseQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.TermQuery;
import com.google.apphosting.api.search.DocumentPb;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class LuceneQueryTreeVisitor
implements QueryTreeVisitor<LuceneQueryTreeContext> {
    private static final ImmutableMap<DocumentPb.FieldValue.ContentType, QueryTreeContext.Type> TYPE_MAP = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)DocumentPb.FieldValue.ContentType.ATOM, (Object)QueryTreeContext.Type.TEXT).put((Object)DocumentPb.FieldValue.ContentType.DATE, (Object)QueryTreeContext.Type.DATE).put((Object)DocumentPb.FieldValue.ContentType.GEO, (Object)QueryTreeContext.Type.LOCATION).put((Object)DocumentPb.FieldValue.ContentType.HTML, (Object)QueryTreeContext.Type.TEXT).put((Object)DocumentPb.FieldValue.ContentType.NUMBER, (Object)QueryTreeContext.Type.NUMBER).put((Object)DocumentPb.FieldValue.ContentType.TEXT, (Object)QueryTreeContext.Type.TEXT).put((Object)DocumentPb.FieldValue.ContentType.UNTOKENIZED_PREFIX, (Object)QueryTreeContext.Type.TEXT).put((Object)DocumentPb.FieldValue.ContentType.TOKENIZED_PREFIX, (Object)QueryTreeContext.Type.TEXT).buildOrThrow());
    private static final ImmutableSet<DocumentPb.FieldValue.ContentType> TEXT_TYPES = Sets.immutableEnumSet((Enum)DocumentPb.FieldValue.ContentType.TEXT, (Enum[])new DocumentPb.FieldValue.ContentType[]{DocumentPb.FieldValue.ContentType.ATOM, DocumentPb.FieldValue.ContentType.HTML, DocumentPb.FieldValue.ContentType.UNTOKENIZED_PREFIX, DocumentPb.FieldValue.ContentType.TOKENIZED_PREFIX});
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes;

    LuceneQueryTreeVisitor(Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes) {
        this.allFieldTypes = allFieldTypes;
    }

    private void buildContextTextRecursive(StringBuffer builder, LuceneQueryTreeContext context) {
        if (context.getText() != null && !context.getText().equals("_GLOBAL")) {
            builder.append(" ").append(context.isFuzzy() ? "~" : (context.isStrict() ? "+" : "")).append(context.getText());
        } else {
            for (LuceneQueryTreeContext child : context.children()) {
                this.buildContextTextRecursive(builder, child);
            }
        }
    }

    public void visitSequence(Tree node, LuceneQueryTreeContext context) {
        this.visitConjunction(node, context);
        boolean found = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            int type = child.getType();
            if (type == 23 && child.getChild(0).getType() == 10) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuffer builder = new StringBuffer();
            this.buildContextTextRecursive(builder, context);
            String text = builder.substring(1);
            BooleanQuery disjunction = new BooleanQuery();
            disjunction.add(new TermQuery(new Term("_GLOBAL", text)), BooleanClause.Occur.SHOULD);
            disjunction.add(context.getQuery(), BooleanClause.Occur.SHOULD);
            context.setQuery(disjunction);
        }
    }

    public void visitConjunction(Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.MUST, context));
    }

    public void visitDisjunction(Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.SHOULD, context));
    }

    public void visitNegation(Tree node, LuceneQueryTreeContext context) {
        BooleanQuery query = new BooleanQuery();
        query.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
        context.setQuery(this.visitBooleanQueryChildren(query, BooleanClause.Occur.MUST_NOT, context));
    }

    private Query visitBooleanQueryChildren(BooleanQuery parentQuery, BooleanClause.Occur occur, LuceneQueryTreeContext context) {
        for (LuceneQueryTreeContext childContext : context.children()) {
            parentQuery.add(childContext.getQuery(), occur);
        }
        return parentQuery;
    }

    public void visitFuzzy(Tree node, LuceneQueryTreeContext context) {
        context.setRewriteMode(QueryTreeContext.RewriteMode.FUZZY);
    }

    public void visitLiteral(Tree node, LuceneQueryTreeContext context) {
        context.setRewriteMode(QueryTreeContext.RewriteMode.STRICT);
    }

    public void visitLessThan(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.LT);
    }

    public void visitLessOrEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.LE);
    }

    public void visitGreaterThan(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.GT);
    }

    public void visitGreaterOrEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.GE);
    }

    public void visitEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.HAS);
    }

    public void visitContains(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.HAS);
    }

    private void visitComparison(Tree node, LuceneQueryTreeContext context, LuceneQueryTreeContext.ComparisonOp op) {
        LuceneQueryTreeContext lhs = (LuceneQueryTreeContext)context.getChild(0);
        LuceneQueryTreeContext rhs = (LuceneQueryTreeContext)context.getChild(1);
        ArrayList<Query> children = new ArrayList<Query>();
        for (QueryTreeContext.Type type : lhs.getCommonReturnTypes(rhs)) {
            children.addAll(this.newQuery(type, lhs, op, rhs));
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query != null) continue;
            iter.remove();
        }
        if (children.isEmpty()) {
            context.setQuery(LuceneUtils.getMatchNoneQuery());
        } else if (children.size() == 1) {
            context.setQuery((Query)children.get(0));
        } else {
            BooleanQuery or = new BooleanQuery();
            for (Query query : children) {
                or.add(query, BooleanClause.Occur.SHOULD);
            }
            context.setQuery(or);
        }
    }

    public void visitValue(Tree node, LuceneQueryTreeContext context) {
        if (node.getChild(0).getType() == 13) {
            String text = node.getChild(2).getText();
            context.setRawText(text);
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < node.getChildCount(); ++i) {
                builder.append(node.getChild(i).getText());
            }
            context.setText(builder.toString());
            context.setKind(QueryTreeContext.Kind.PHRASE);
            context.setReturnType(QueryTreeContext.Type.TEXT);
            if (ParserUtils.isNumber((CharSequence)text)) {
                context.addReturnType(QueryTreeContext.Type.NUMBER);
            }
            if (LuceneUtils.isDateString(text)) {
                context.addReturnType(QueryTreeContext.Type.DATE);
            }
        } else {
            String text = node.getChild(1).getText();
            Set<DocumentPb.FieldValue.ContentType> types = this.allFieldTypes.get(text);
            if (types != null && !types.isEmpty()) {
                for (DocumentPb.FieldValue.ContentType type : types) {
                    context.addReturnType((QueryTreeContext.Type)TYPE_MAP.get((Object)type));
                }
                context.setKind(QueryTreeContext.Kind.FIELD);
                context.setFieldTypes(types);
            } else {
                context.setKind(QueryTreeContext.Kind.LITERAL);
                context.setReturnType(QueryTreeContext.Type.TEXT);
                if (ParserUtils.isNumber((CharSequence)text)) {
                    context.addReturnType(QueryTreeContext.Type.NUMBER);
                    context.addReturnType(QueryTreeContext.Type.DISTANCE);
                }
                if (LuceneUtils.isDateString(text)) {
                    context.addReturnType(QueryTreeContext.Type.DATE);
                }
            }
            context.setText(text);
        }
    }

    public void visitFunction(Tree node, LuceneQueryTreeContext context) {
        String token = node.getChild(0).getText();
        Function fn = Function.fromToken(token);
        ArrayList children = Lists.newArrayList((Iterable)context.children());
        if (children.size() != 2) {
            throw new SearchQueryException(String.format("%s() function requires exactly 2 arguments", token));
        }
        switch (fn) {
            case DISTANCE: {
                LuceneQueryTreeContext arg0 = (LuceneQueryTreeContext)((Object)children.get(0));
                LuceneQueryTreeContext arg1 = (LuceneQueryTreeContext)((Object)children.get(1));
                if (!arg0.isField() && arg1.isField()) {
                    LuceneQueryTreeContext tmp = arg0;
                    arg0 = arg1;
                    arg1 = tmp;
                    children.set(0, arg0);
                    children.set(1, arg1);
                }
                if (!arg0.isField() || !arg1.isLiteral()) {
                    throw new SearchQueryException("distance() function requires field-name and geopoint() arguments");
                }
                String field = arg0.getText();
                String point = arg1.getText();
                context.setReturnType(QueryTreeContext.Type.DISTANCE);
                context.setKind(QueryTreeContext.Kind.FUNCTION);
                context.setText(new StringBuilder(1 + String.valueOf(field).length() + String.valueOf(point).length()).append(field).append(":").append(point).toString());
                break;
            }
            case GEOPOINT: {
                context.setReturnType(QueryTreeContext.Type.LOCATION);
                context.setKind(QueryTreeContext.Kind.LITERAL);
                double lat = Double.parseDouble(((LuceneQueryTreeContext)((Object)children.get(0))).getText());
                double lng = Double.parseDouble(((LuceneQueryTreeContext)((Object)children.get(1))).getText());
                context.setText(new StringBuilder(49).append(lat).append(":").append(lng).toString());
            }
        }
    }

    public void visitGlobal(Tree node, LuceneQueryTreeContext context) {
        context.setReturnType(QueryTreeContext.Type.TEXT);
        context.addReturnType(QueryTreeContext.Type.DATE);
        context.addReturnType(QueryTreeContext.Type.NUMBER);
        context.setText("_GLOBAL");
    }

    public void visitOther(Tree node, LuceneQueryTreeContext context) {
        int n = node.getCharPositionInLine();
        String string = node.getText();
        throw new SearchQueryException(new StringBuilder(41 + String.valueOf(string).length()).append("Unexpected query found at ").append(n).append(": \"").append(string).append("\"").toString());
    }

    private List<Query> newQuery(QueryTreeContext.Type type, LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        ArrayList<Query> queries = new ArrayList<Query>();
        switch (type) {
            case TEXT: {
                EnumSet<DocumentPb.FieldValue.ContentType> types;
                if (lhs.getFieldTypes() == null) {
                    types = EnumSet.of(DocumentPb.FieldValue.ContentType.TEXT);
                } else {
                    types = EnumSet.copyOf(lhs.getFieldTypes());
                    types.retainAll((Collection<?>)TEXT_TYPES);
                }
                for (DocumentPb.FieldValue.ContentType subType : types) {
                    queries.add(LuceneQueryTreeVisitor.newTextQuery(subType, lhs, op, rhs));
                }
                break;
            }
            case NUMBER: {
                if (!ParserUtils.isNumber((CharSequence)rhs.getUnquotedText())) break;
                queries.add(LuceneQueryTreeVisitor.newNumericQuery(lhs, op, rhs));
                break;
            }
            case DATE: {
                if (!ParserUtils.isDate((CharSequence)rhs.getUnquotedText())) break;
                queries.add(LuceneQueryTreeVisitor.newDateQuery(lhs, op, rhs));
                break;
            }
            case DISTANCE: {
                queries.add(LuceneQueryTreeVisitor.newDistanceQuery(lhs, op, rhs));
                break;
            }
            case LOCATION: {
                throw new SearchQueryException("Comparison operator not available for Geo type");
            }
            default: {
                String string = String.valueOf(type.name().toLowerCase());
                throw new SearchQueryException(string.length() != 0 ? "Unknown field type ".concat(string) : new String("Unknown field type "));
            }
        }
        return queries;
    }

    private static Query newNumericQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        try {
            double value = Double.parseDouble(rhs.getUnquotedText());
            boolean minInclusive = true;
            boolean maxInclusive = true;
            double min = value;
            double max = value;
            switch (op) {
                case EQ: 
                case HAS: {
                    if (!"_GLOBAL".equals(lhs.getText())) break;
                    return new TermQuery(new Term(lhs.getText(), Double.toString(min)));
                }
                case LT: {
                    maxInclusive = false;
                    min = -1.7976931348623157E308;
                    break;
                }
                case LE: {
                    maxInclusive = true;
                    min = -1.7976931348623157E308;
                    break;
                }
                case GT: {
                    minInclusive = false;
                    max = Double.MAX_VALUE;
                    break;
                }
                case GE: {
                    minInclusive = true;
                    max = Double.MAX_VALUE;
                    break;
                }
                default: {
                    return null;
                }
            }
            String text = lhs.getText();
            if (lhs.isField()) {
                text = LuceneUtils.makeLuceneFieldName(text, DocumentPb.FieldValue.ContentType.NUMBER);
            }
            return NumericRangeQuery.newDoubleRange(text, min, max, minInclusive, maxInclusive);
        }
        catch (NumberFormatException e) {
            String string = lhs.getText();
            String string2 = String.valueOf((Object)op);
            String string3 = rhs.getText();
            throw new SearchQueryException(new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString());
        }
    }

    private static Query newDistanceQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        if (op == LuceneQueryTreeContext.ComparisonOp.HAS) {
            throw new SearchQueryException("Equality comparison not available for Geo type");
        }
        String[] parts = lhs.getText().split(Pattern.quote(":"));
        String fieldName = parts[0];
        double latitude = Double.parseDouble(parts[1]);
        double longitude = Double.parseDouble(parts[2]);
        double distance = Double.parseDouble(rhs.getText());
        return GeometricQuery.create(fieldName, latitude, longitude, op, distance);
    }

    private static Query newDateQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        long min;
        long time;
        try {
            time = LuceneUtils.dateStringToLong(rhs.getUnquotedText());
        }
        catch (ParseException e) {
            throw new SearchQueryException("Could not parse date");
        }
        boolean minInclusive = true;
        boolean maxInclusive = true;
        long max = min = time / 86400000L;
        switch (op) {
            case EQ: 
            case HAS: {
                if ("_GLOBAL".equals(lhs.getText())) {
                    return new TermQuery(new Term(lhs.getText(), Long.toString(min)));
                }
                max = min + 1L;
                maxInclusive = false;
                break;
            }
            case LT: {
                maxInclusive = false;
                min = Long.MIN_VALUE;
                break;
            }
            case LE: {
                maxInclusive = true;
                min = Long.MIN_VALUE;
                break;
            }
            case GT: {
                minInclusive = false;
                max = Long.MAX_VALUE;
                break;
            }
            case GE: {
                minInclusive = true;
                max = Long.MAX_VALUE;
                break;
            }
            default: {
                return null;
            }
        }
        return NumericRangeQuery.newLongRange(LuceneUtils.makeLuceneFieldName(lhs.getText(), DocumentPb.FieldValue.ContentType.DATE), min, max, minInclusive, maxInclusive);
    }

    private static Query newTextQuery(DocumentPb.FieldValue.ContentType subType, LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        Query base = LuceneQueryTreeVisitor.newTextMatchQuery(subType, lhs, rhs);
        switch (op) {
            case EQ: 
            case HAS: {
                return base;
            }
            case NE: {
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
                boolQuery.add(base, BooleanClause.Occur.MUST_NOT);
                return boolQuery;
            }
        }
        return null;
    }

    private static Query newTextMatchQuery(DocumentPb.FieldValue.ContentType subType, LuceneQueryTreeContext lhs, LuceneQueryTreeContext rhs) {
        String string;
        String field = lhs.getText();
        String value = rhs.getText();
        if (rhs.isPhrase()) {
            value = value.substring(1, value.length() - 1);
        }
        if (lhs.isField()) {
            field = LuceneUtils.makeLuceneFieldNameWithExtractedText(field, subType);
        } else if (!"_GLOBAL".equals(field)) {
            string = String.valueOf((Object)lhs);
            String string2 = value;
            value = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
            field = "_GLOBAL";
        }
        switch (subType) {
            case ATOM: {
                return new TermQuery(new Term(field, value.toLowerCase()));
            }
            case TEXT: 
            case HTML: {
                value = WordSeparatorAnalyzer.removeDiacriticals(value);
                break;
            }
            case UNTOKENIZED_PREFIX: {
                return new TermQuery(new Term(field, PrefixFieldAnalyzerUtil.normalizePrefixField(value)));
            }
            case TOKENIZED_PREFIX: {
                break;
            }
            default: {
                string = String.valueOf(subType);
                throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("type ").append(string).append(" cannot match text").toString());
            }
        }
        List<String> tokens = subType == DocumentPb.FieldValue.ContentType.TOKENIZED_PREFIX ? PrefixFieldAnalyzerUtil.tokenizePrefixFieldQuery(value) : WordSeparatorAnalyzer.tokenList(value);
        if (!rhs.isPhrase()) {
            if (tokens.size() == 1) {
                return new TermQuery(new Term(field, tokens.get(0)));
            }
            if (tokens.isEmpty()) {
                return LuceneUtils.getMatchAnyDocumentQuery();
            }
            BooleanQuery conjunction = new BooleanQuery();
            for (String token : tokens) {
                conjunction.add(new TermQuery(new Term(field, token)), BooleanClause.Occur.MUST);
            }
            BooleanQuery disjunction = new BooleanQuery();
            disjunction.add(new TermQuery(new Term(field, value.toLowerCase())), BooleanClause.Occur.SHOULD);
            disjunction.add(conjunction, BooleanClause.Occur.SHOULD);
            return disjunction;
        }
        PhraseQuery phraseQuery = new PhraseQuery();
        for (String token : tokens) {
            phraseQuery.add(new Term(field, token));
        }
        BooleanQuery disjunction = new BooleanQuery();
        disjunction.add(phraseQuery, BooleanClause.Occur.SHOULD);
        PhraseQuery literalPhraseQuery = new PhraseQuery();
        literalPhraseQuery.add(new Term(field, value.toLowerCase()));
        disjunction.add(literalPhraseQuery, BooleanClause.Occur.SHOULD);
        return disjunction;
    }

    static enum Function {
        GEOPOINT,
        DISTANCE;

        final String token = this.name().toLowerCase();

        static Function fromToken(String token) {
            for (Function f : Function.values()) {
                if (!f.token.equals(token)) continue;
                return f;
            }
            throw new SearchQueryException(new StringBuilder(19 + String.valueOf(token).length()).append("unknown function '").append(token).append("'").toString());
        }
    }
}

