/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@GwtCompatible
public final class PrimitiveArrays {

    public static class Cursor {
        public long position;
        public long limit;

        Cursor(long position, long limit) {
            Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((position <= limit ? 1 : 0) != 0);
            this.position = position;
            this.limit = limit;
        }

        public long remaining() {
            return this.limit - this.position;
        }
    }

    static interface Longs {
        public long get(int var1);

        public int length();

        public static Longs fromImmutableLongArray(final ImmutableLongArray immutableLongArray) {
            return new Longs(){

                @Override
                public long get(int position) {
                    return immutableLongArray.get(position);
                }

                @Override
                public int length() {
                    return immutableLongArray.length();
                }
            };
        }

        default public int[] toIntArray() {
            int[] result = new int[this.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Ints.checkedCast((long)this.get(i));
            }
            return result;
        }
    }

    public static interface Bytes {
        public byte get(long var1);

        public long length();

        default public Cursor cursor(long position, long limit) {
            Preconditions.checkArgument((position <= limit && position <= this.length() ? 1 : 0) != 0);
            return new Cursor(position, limit);
        }

        default public Cursor cursor(long position) {
            return this.cursor(position, this.length());
        }

        default public Cursor cursor() {
            return this.cursor(0L);
        }

        @GwtIncompatible(value="ByteBuffer")
        public static Bytes fromByteBuffer(final ByteBuffer buffer) {
            Preconditions.checkState((buffer.position() == 0 ? 1 : 0) != 0);
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return buffer.get(Ints.checkedCast((long)position));
                }

                @Override
                public long length() {
                    return buffer.limit();
                }
            };
        }

        public static Bytes fromByteArray(final byte[] bytes) {
            return new Bytes(){

                @Override
                public byte get(long position) {
                    return bytes[Ints.checkedCast((long)position)];
                }

                @Override
                public long length() {
                    return bytes.length;
                }
            };
        }

        default public InputStream toInputStream(final long offset) {
            Preconditions.checkArgument((offset >= 0L && offset <= this.length() ? 1 : 0) != 0);
            return new InputStream(){
                long position;
                {
                    this.position = offset;
                }

                @Override
                public int read() {
                    if (this.position == this.length()) {
                        return -1;
                    }
                    return this.get(this.position++) & 0xFF;
                }
            };
        }

        default public InputStream toInputStream(final Cursor cursor) {
            Preconditions.checkArgument((cursor.position >= 0L && cursor.position <= this.length() ? 1 : 0) != 0);
            return new InputStream(){

                @Override
                public int read() {
                    if (cursor.position == this.length()) {
                        return -1;
                    }
                    return this.get(cursor.position++) & 0xFF;
                }
            };
        }

        default public InputStream toInputStream() {
            return this.toInputStream(0L);
        }

        default public void writeTo(OutputStream output) throws IOException {
            for (long i = 0L; i < this.length(); ++i) {
                output.write(this.get(i));
            }
        }

        default public byte readByte(Cursor cursor) {
            return this.get(cursor.position++);
        }

        default public long readVarint64(Cursor cursor) {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.get(cursor.position++);
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new IllegalArgumentException("Malformed varint.");
        }

        default public int readVarint32(Cursor cursor) {
            return Ints.checkedCast((long)this.readVarint64(cursor));
        }

        default public long readUintWithLength(Cursor cursor, int numBytes) {
            long result = this.readUintWithLength(cursor.position, numBytes);
            cursor.position += (long)numBytes;
            return result;
        }

        default public long readUintWithLength(long position, int numBytes) {
            long x = 0L;
            for (int i = 0; i < numBytes; ++i) {
                x += ((long)this.get(position++) & 0xFFL) << 8 * i;
            }
            return x;
        }

        default public long readLittleEndianLong(Cursor cursor) {
            return this.readUintWithLength(cursor, 8);
        }

        default public double readLittleEndianDouble(long position) {
            return Double.longBitsToDouble(this.readUintWithLength(position, 8));
        }
    }
}

