/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndexRegion;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@GwtIncompatible
public class S2DensityTree {
    public static final String VERSION = "S2DensityTree0";
    private static final byte[] VERSION_BYTES = "S2DensityTree0".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] REVERSED_VERSION_BYTES = new byte[VERSION_BYTES.length];
    public static final S2Coder<S2DensityTree> CODER;
    private static final int CHILD_MASK_BITS = 4;
    private static final int CHILD_MASK = 15;
    private static final long MAX_WEIGHT = 0x7FFFFFFFFFFFFFFL;
    private final PrimitiveArrays.Bytes encoded;
    private final long[] facePositions;

    private S2DensityTree(PrimitiveArrays.Bytes encoded, PrimitiveArrays.Cursor cursor) throws IOException {
        this.encoded = encoded;
        this.facePositions = DecodedFace.decodeHeader(encoded, cursor);
    }

    public long size() {
        return this.encoded.length();
    }

    public PrimitiveArrays.Bytes encoded() {
        return this.encoded;
    }

    public static S2DensityTree decode(PrimitiveArrays.Bytes bytes) throws IOException {
        return new S2DensityTree(bytes, bytes.cursor());
    }

    public static S2DensityTree decode(PrimitiveArrays.Bytes bytes, PrimitiveArrays.Cursor cursor) throws IOException {
        return new S2DensityTree(bytes, cursor);
    }

    public Map<S2CellId, Long> decode() {
        TreeMap<S2CellId, Long> results = new TreeMap<S2CellId, Long>();
        this.visitAll(results::put);
        return results;
    }

    public void visitAll(CellVisitor.All visitor) {
        this.visitCells(visitor);
    }

    public boolean visitWhile(CellVisitor.While visitor) {
        return this.visitCells((cell, node) -> visitor.visit(cell, node.weight) ? CellVisitor.Action.ENTER_CELL : CellVisitor.Action.STOP);
    }

    public List<S2CellId> getPartitioning(int maxWeight) {
        ArrayList<S2CellId> clusters = new ArrayList<S2CellId>();
        this.visitCells((cell, node) -> {
            if (node.weight > (long)maxWeight && node.hasChildren()) {
                return CellVisitor.Action.ENTER_CELL;
            }
            clusters.add(cell);
            return CellVisitor.Action.SKIP_CELL;
        });
        return clusters;
    }

    public boolean visitCells(CellVisitor visitor) {
        PrimitiveArrays.Cursor cursor = this.encoded.cursor();
        Cell cell = new Cell();
        for (int i = 0; i < S2CellId.FACE_CELLS.length; ++i) {
            cursor.position = this.facePositions[i];
            if (cursor.position < 0L || this.visitCells(cell, cursor, S2CellId.FACE_CELLS[i], visitor)) continue;
            return false;
        }
        return true;
    }

    private boolean visitCells(Cell decoded, PrimitiveArrays.Cursor cursor, S2CellId cell, CellVisitor visitor) {
        decoded.decode(this.encoded, cursor);
        switch (visitor.visit(cell, decoded)) {
            case SKIP_CELL: {
                return true;
            }
            case ENTER_CELL: {
                int p0 = decoded.positions[0];
                int p1 = decoded.positions[1];
                int p2 = decoded.positions[2];
                int p3 = decoded.positions[3];
                return !(p0 >= 0 && !this.visitCells(decoded, cursor, cell.child(0), visitor) || p1 >= 0 && !this.visitCells(decoded, cursor, cell.child(1), visitor) || p2 >= 0 && !this.visitCells(decoded, cursor, cell.child(2), visitor) || p3 >= 0 && !this.visitCells(decoded, cursor, cell.child(3), visitor));
            }
            case STOP: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected next state");
    }

    public static S2DensityTree shapeDensity(S2ShapeIndex index, ShapeWeightFunction weigher, int approximateSizeBytes, int maxLevel) {
        return S2DensityTree.createShapeDensityOp(approximateSizeBytes, maxLevel).apply(index, weigher);
    }

    public static S2DensityTree vertexDensity(S2ShapeIndex index, int approximateSizeBytes, int maxLevel) {
        return S2DensityTree.createVertexDensityOp(approximateSizeBytes, maxLevel).apply(index);
    }

    public static S2DensityTree sumDensity(Iterable<S2DensityTree> trees, int approximateSizeBytes, int maxLevel) {
        return S2DensityTree.createSumDensityOp(approximateSizeBytes, maxLevel).apply(trees);
    }

    public static ShapeDensityOp createShapeDensityOp(int approximateSizeBytes, int maxLevel) {
        BreadthFirstTreeBuilder acc = new BreadthFirstTreeBuilder(approximateSizeBytes, maxLevel);
        return (index, weigher) -> acc.build(new IndexCellWeightFunction(index, weigher));
    }

    public static VertexDensityOp createVertexDensityOp(int approximateSizeBytes, int maxLevel) {
        BreadthFirstTreeBuilder acc = new BreadthFirstTreeBuilder(approximateSizeBytes, maxLevel);
        IdentityHashMap vertices = new IdentityHashMap();
        return index -> {
            vertices.clear();
            for (S2Shape s : index.getShapes()) {
                vertices.put(s, S2ShapeUtil.numVertices(s));
            }
            return acc.build(new IndexCellWeightFunction(index, vertices::get));
        };
    }

    public static SumDensityOp createSumDensityOp(int approximateSizeBytes, int maxLevel) {
        BreadthFirstTreeBuilder acc = new BreadthFirstTreeBuilder(approximateSizeBytes, maxLevel);
        SumDensity sum = new SumDensity();
        return trees -> {
            sum.set(trees);
            return acc.build(sum);
        };
    }

    private static int checkLength(long length) {
        Preconditions.checkState((length > 0L ? 1 : 0) != 0, (Object)"Invalid length, corrupt bytes");
        Preconditions.checkState((length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Invalid length, corrupt bytes");
        return (int)length;
    }

    static {
        int i = 0;
        for (int j = VERSION_BYTES.length - 1; j >= 0; --j) {
            S2DensityTree.REVERSED_VERSION_BYTES[i] = VERSION_BYTES[j];
            ++i;
        }
        CODER = new S2Coder<S2DensityTree>(){

            @Override
            public void encode(S2DensityTree value, OutputStream output) throws IOException {
                value.encoded.writeTo(output);
            }

            @Override
            public S2DensityTree decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
                return S2DensityTree.decode(data, cursor);
            }
        };
    }

    @VisibleForTesting
    static class TreeEncoder {
        private final ReversibleBytes output = new ReversibleBytes();
        private WeightedCell[] weights = new WeightedCell[8];
        private int size;
        private static final Comparator<WeightedCell> ENCODER_ORDER = (a, b) -> {
            if (b.cell.contains(a.cell)) {
                return -1;
            }
            if (a.cell.contains(b.cell)) {
                return 1;
            }
            return a.cell.compareTo(b.cell);
        };

        TreeEncoder() {
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = new WeightedCell();
            }
            this.clear();
        }

        public void clear() {
            this.size = 0;
            this.output.clear();
        }

        static int estimateSize(long weight) {
            int weightSize = EncodedInts.varIntSize(weight << 4 | 0xFL);
            return weightSize + 2 * EncodedInts.varIntSize(weightSize);
        }

        public void put(S2CellId cell, long weight) {
            if (this.size == this.weights.length) {
                this.weights = Arrays.copyOf(this.weights, this.weights.length * 2);
                for (int i = this.size; i < this.weights.length; ++i) {
                    this.weights[i] = new WeightedCell();
                }
            }
            this.weights[this.size++].set(cell, weight);
        }

        public S2DensityTree build() {
            try {
                Arrays.sort(this.weights, 0, this.size, ENCODER_ORDER);
                this.output.clear();
                ReversedLengthsWriter lengths = new ReversedLengthsWriter(this.output);
                int faceMask = 0;
                while (this.size > 0) {
                    WeightedCell weighted = this.weights[--this.size];
                    int face = weighted.cell.face();
                    this.encodeCellReverse(0, weighted);
                    lengths.next();
                    faceMask |= 1 << face;
                }
                lengths.write(faceMask);
                this.output.write(REVERSED_VERSION_BYTES);
                S2DensityTree s2DensityTree = S2DensityTree.decode(PrimitiveArrays.Bytes.fromByteArray(this.output.reversedCopy()));
                return s2DensityTree;
            }
            catch (IOException e) {
                throw new IllegalStateException("ByteStack EOF", e);
            }
            finally {
                this.clear();
            }
        }

        private void encodeCellReverse(int level, WeightedCell parent) {
            int childMask = 0;
            ReversedLengthsWriter lengths = new ReversedLengthsWriter(this.output);
            while (this.size > 0 && parent.cell.contains(this.weights[this.size - 1].cell)) {
                WeightedCell child = this.weights[--this.size];
                int childLevel = level + 1;
                childMask |= 1 << child.cell.childPosition(childLevel);
                this.encodeCellReverse(childLevel, child);
                lengths.next();
            }
            lengths.write(parent.weight << 4 | (long)childMask);
            parent.cell = null;
        }

        @VisibleForTesting
        static final class ReversibleBytes
        extends OutputStream {
            private byte[] bytes = new byte[256];
            private int size;

            ReversibleBytes() {
            }

            public void clear() {
                this.size = 0;
            }

            @Override
            public void write(int b) {
                this.maybeResize(1);
                this.bytes[this.size++] = (byte)b;
            }

            @Override
            public void write(byte[] b) {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                this.maybeResize(len);
                for (int i = 0; i < len; ++i) {
                    this.bytes[this.size++] = b[off++];
                }
            }

            private void maybeResize(int increase) {
                while (this.size + increase > this.bytes.length) {
                    this.bytes = Arrays.copyOf(this.bytes, this.bytes.length * 2);
                }
            }

            public void reverseFrom(int start) {
                int i = start;
                for (int j = this.size - 1; i < j; ++i, --j) {
                    byte b = this.bytes[i];
                    this.bytes[i] = this.bytes[j];
                    this.bytes[j] = b;
                }
            }

            public byte[] toByteArray() {
                return Arrays.copyOf(this.bytes, this.size);
            }

            public byte[] reversedCopy() {
                byte[] reversed = new byte[this.size];
                int i = 0;
                int j = this.size - 1;
                while (i < this.size) {
                    reversed[i] = this.bytes[j];
                    ++i;
                    --j;
                }
                return reversed;
            }
        }

        @VisibleForTesting
        static class ReversedLengthsWriter {
            final ReversibleBytes output;
            final int[] lengths = new int[6];
            int size;
            int start;

            ReversedLengthsWriter(ReversibleBytes output) {
                this.output = output;
                this.start = output.size;
            }

            void next() {
                this.lengths[this.size++] = this.output.size - this.start;
                this.start = this.output.size;
            }

            void write(long mask) {
                try {
                    EncodedInts.writeVarint64(this.output, mask);
                    for (int i = this.size - 1; i > 0; --i) {
                        EncodedInts.writeVarint64(this.output, this.lengths[i]);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't be thrown by ReversibleBytes");
                }
                this.output.reverseFrom(this.start);
                this.start = this.output.size;
            }
        }

        private static class WeightedCell {
            S2CellId cell;
            long weight;

            private WeightedCell() {
            }

            void set(S2CellId cell, long weight) {
                this.cell = cell;
                this.weight = weight;
            }
        }
    }

    public static class Cell {
        private static final int[] NO_CHILDREN = new int[]{-1, -1, -1, -1};
        long weight;
        final int[] positions = new int[4];

        public void setNoChildren() {
            System.arraycopy(NO_CHILDREN, 0, this.positions, 0, this.positions.length);
        }

        public boolean hasChildren() {
            return !Arrays.equals(this.positions, NO_CHILDREN);
        }

        public void decode(PrimitiveArrays.Bytes encoded, PrimitiveArrays.Cursor cursor) {
            int i;
            long bits = encoded.readVarint64(cursor);
            this.weight = bits >>> 4;
            int childMask = (int)bits & 0xF;
            int offset = 0;
            for (i = 0; i < 4; ++i) {
                if ((childMask & 1) != 0) {
                    this.positions[i] = offset;
                    if (childMask > 1) {
                        offset += S2DensityTree.checkLength(encoded.readVarint64(cursor));
                    }
                } else {
                    this.positions[i] = -1;
                }
                childMask >>>= 1;
            }
            for (i = 0; i < 4; ++i) {
                if (this.positions[i] < 0) continue;
                this.positions[i] = S2DensityTree.checkLength((long)this.positions[i] + cursor.position);
            }
        }

        public long weight() {
            return this.weight;
        }
    }

    private static final class DecodedFace {
        final S2CellId cellId;
        final long position;

        DecodedFace(S2CellId cellId, long position) {
            Preconditions.checkArgument((cellId.level() == 0 ? 1 : 0) != 0);
            this.cellId = cellId;
            this.position = position;
        }

        static long[] decodeHeader(PrimitiveArrays.Bytes encoded, PrimitiveArrays.Cursor cursor) throws IOException {
            int i;
            for (byte versionByte : VERSION_BYTES) {
                Preconditions.checkState((versionByte == encoded.get(cursor.position++) ? 1 : 0) != 0);
            }
            long[] offsets = new long[6];
            long faceMask = encoded.readVarint64(cursor);
            int lengthsRemaining = Long.bitCount(faceMask) - 1;
            int offset = 0;
            for (i = 0; i < S2CellId.FACE_CELLS.length; ++i) {
                if ((faceMask & 1L << i) == 0L) {
                    offsets[i] = -1L;
                    continue;
                }
                offsets[i] = offset;
                if (lengthsRemaining-- <= 0) continue;
                offset += S2DensityTree.checkLength(encoded.readVarint64(cursor));
            }
            for (i = 0; i < S2CellId.FACE_CELLS.length; ++i) {
                if (offsets[i] < 0L) continue;
                int n = i;
                offsets[n] = offsets[n] + cursor.position;
            }
            return offsets;
        }
    }

    public static class BreadthFirstTreeBuilder {
        private final int approximateSizeBytes;
        private final int maxLevel;
        private final TreeEncoder encoder;
        private long[] ranges = new long[8];
        private int rangesSize;
        private long[] nextLevelRanges = new long[8];
        private int nextLevelRangesSize;

        public BreadthFirstTreeBuilder(int approximateSizeBytes, int maxLevel) {
            this(approximateSizeBytes, maxLevel, new TreeEncoder());
        }

        public BreadthFirstTreeBuilder(int approximateSizeBytes, int maxLevel, TreeEncoder encoder) {
            this.approximateSizeBytes = approximateSizeBytes;
            this.maxLevel = maxLevel;
            this.encoder = encoder;
            this.clear();
        }

        public void clear() {
            this.rangesSize = 0;
            this.nextLevelRangesSize = 0;
            this.encoder.clear();
        }

        public S2DensityTree build(CellWeightFunction weigher) {
            this.clear();
            int sizeEstimateBytes = 0;
            this.ranges[this.rangesSize++] = S2CellId.begin(30).id();
            this.ranges[this.rangesSize++] = S2CellId.end(30).id();
            for (int level = 0; level <= this.maxLevel && sizeEstimateBytes < this.approximateSizeBytes; ++level) {
                long lastHilbertEnd = S2CellId.sentinel().id();
                for (int i = 0; i < this.rangesSize; i += 2) {
                    S2CellId start = new S2CellId(this.ranges[i]);
                    S2CellId end = new S2CellId(this.ranges[i + 1]);
                    S2CellId cell = start.parent(level);
                    while (cell.lessThan(end)) {
                        long weight = weigher.applyAsLong(cell);
                        if (weight != 0L) {
                            if (weight < 0L) {
                                weight = -weight;
                            } else {
                                long hilbertStart = cell.childBegin(30).id();
                                long hilbertEnd = cell.childEnd(30).id();
                                if (hilbertStart == lastHilbertEnd) {
                                    this.nextLevelRanges[this.nextLevelRangesSize - 1] = hilbertEnd;
                                } else {
                                    if (this.nextLevelRangesSize == this.nextLevelRanges.length) {
                                        this.nextLevelRanges = Arrays.copyOf(this.nextLevelRanges, this.nextLevelRanges.length * 2);
                                    }
                                    this.nextLevelRanges[this.nextLevelRangesSize++] = hilbertStart;
                                    this.nextLevelRanges[this.nextLevelRangesSize++] = hilbertEnd;
                                }
                                lastHilbertEnd = hilbertEnd;
                            }
                            Preconditions.checkArgument((weight <= 0x7FFFFFFFFFFFFFFL ? 1 : 0) != 0, (Object)"Weigher exceeded max weight");
                            this.encoder.put(cell, weight);
                            sizeEstimateBytes += TreeEncoder.estimateSize(weight);
                        }
                        cell = cell.next();
                    }
                }
                long[] tempArray = this.ranges;
                this.ranges = this.nextLevelRanges;
                this.nextLevelRanges = tempArray;
                this.rangesSize = this.nextLevelRangesSize;
                this.nextLevelRangesSize = 0;
            }
            S2DensityTree tree = this.encoder.build();
            this.clear();
            return tree;
        }

        public static interface CellWeightFunction {
            public long applyAsLong(S2CellId var1);
        }
    }

    @VisibleForTesting
    static class DecodedPath {
        private S2DensityTree tree;
        private PrimitiveArrays.Cursor cursor;
        private final List<Cell> stack = new ArrayList<Cell>();
        private S2CellId last;

        DecodedPath() {
        }

        void set(S2DensityTree tree) {
            this.tree = tree;
            this.cursor = tree.encoded.cursor();
            this.last = null;
        }

        long weight(S2CellId id) {
            int level = id.level();
            int loadedLevel = this.loadedLevel(id);
            Cell cell = null;
            if (loadedLevel < 0) {
                cell = this.loadFace(id.face());
                loadedLevel = 0;
            }
            if (level > 0) {
                cell = this.loadCell(loadedLevel, level, id);
            }
            return cell.weight;
        }

        private int loadedLevel(S2CellId cell) {
            if (this.last == null) {
                return -1;
            }
            if (this.last.contains(cell)) {
                return this.last.level();
            }
            return this.last.getCommonAncestorLevel(cell);
        }

        private Cell loadFace(int face) {
            Cell cell = this.get(0);
            if (this.tree.facePositions[face] < 0L) {
                cell.weight = 0L;
                cell.setNoChildren();
                this.last = null;
                return cell;
            }
            this.cursor.position = this.tree.facePositions[face];
            cell.decode(this.tree.encoded, this.cursor);
            this.last = S2CellId.FACE_CELLS[face];
            return cell;
        }

        private Cell loadCell(int loadedLevel, int level, S2CellId cell) {
            Cell decodedCell = this.get(loadedLevel);
            for (int i = loadedLevel + 1; i <= level; ++i) {
                this.cursor.position = decodedCell.positions[cell.childPosition(i)];
                decodedCell = this.get(i);
                if (this.cursor.position < 0L) {
                    decodedCell.weight = 0L;
                    decodedCell.setNoChildren();
                    continue;
                }
                decodedCell.decode(this.tree.encoded, this.cursor);
                this.last = cell;
            }
            return decodedCell;
        }

        private Cell get(int level) {
            if (this.stack.size() == level) {
                this.stack.add(new Cell());
            }
            return this.stack.get(level);
        }
    }

    @VisibleForTesting
    static class SumDensity
    implements BreadthFirstTreeBuilder.CellWeightFunction {
        private final List<DecodedPath> decodedPaths = new ArrayList<DecodedPath>();
        private int size;

        SumDensity() {
        }

        public void set(Iterable<S2DensityTree> trees) {
            this.size = Iterables.size(trees);
            while (this.decodedPaths.size() < this.size) {
                this.decodedPaths.add(new DecodedPath());
            }
            int i = 0;
            for (S2DensityTree tree : trees) {
                this.decodedPaths.get(i++).set(tree);
            }
        }

        @Override
        public long applyAsLong(S2CellId cell) {
            long sum = 0L;
            boolean contained = true;
            for (int i = 0; i < this.size; ++i) {
                long weight = this.decodedPaths.get(i).weight(cell);
                if (weight < 0L) {
                    sum += -weight;
                    continue;
                }
                if (weight <= 0L) continue;
                sum += weight;
                contained = false;
            }
            sum = Math.min(0x7FFFFFFFFFFFFFFL, sum);
            return contained ? -sum : sum;
        }
    }

    @VisibleForTesting
    static class IndexCellWeightFunction
    implements BreadthFirstTreeBuilder.CellWeightFunction {
        private final S2ShapeIndex index;
        private final ShapeWeightFunction weigher;

        public IndexCellWeightFunction(S2ShapeIndex index, ShapeWeightFunction weigher) {
            this.index = index;
            this.weigher = weigher;
        }

        @Override
        public long applyAsLong(S2CellId cell) {
            class IntersectingVisitor
            implements S2ShapeIndexRegion.ShapeVisitor {
                long sum = 0L;
                long limit = 0x7FFFFFFFFFFFFFFL;
                boolean allContained = true;

                IntersectingVisitor() {
                }

                @Override
                public boolean test(S2Shape shape, boolean containsTarget) {
                    long weight = IndexCellWeightFunction.this.weigher.applyAsLong(shape);
                    Preconditions.checkState((weight >= 0L ? 1 : 0) != 0, (Object)"Weight must not be negative.");
                    this.limit -= weight;
                    Preconditions.checkState((this.limit >= 0L ? 1 : 0) != 0, (Object)"Weight must be at most 576460752303423487");
                    this.sum += weight;
                    this.allContained &= containsTarget;
                    return true;
                }

                long finalWeight() {
                    return this.allContained ? -this.sum : this.sum;
                }
            }
            IntersectingVisitor visitor = new IntersectingVisitor();
            new S2ShapeIndexRegion(this.index).visitIntersectingShapes(new S2Cell(cell), visitor);
            this.weigher.reset();
            return visitor.finalWeight();
        }
    }

    public static interface SumDensityOp {
        public S2DensityTree apply(Iterable<S2DensityTree> var1);
    }

    public static interface VertexDensityOp {
        public S2DensityTree apply(S2ShapeIndex var1);
    }

    public static interface ShapeDensityOp {
        public S2DensityTree apply(S2ShapeIndex var1, ShapeWeightFunction var2);
    }

    public static interface ShapeWeightFunction {
        public long applyAsLong(S2Shape var1);

        default public void reset() {
        }
    }

    public static interface CellVisitor {
        public Action visit(S2CellId var1, Cell var2);

        public static interface While
        extends CellVisitor {
            @Override
            default public Action visit(S2CellId cell, Cell node) {
                return this.visit(cell, node.weight) ? Action.ENTER_CELL : Action.STOP;
            }

            public boolean visit(S2CellId var1, long var2);
        }

        public static interface All
        extends CellVisitor {
            @Override
            default public Action visit(S2CellId cell, Cell node) {
                this.visit(cell, node.weight);
                return Action.ENTER_CELL;
            }

            public void visit(S2CellId var1, long var2);
        }

        public static enum Action {
            SKIP_CELL,
            ENTER_CELL,
            STOP;

        }
    }
}

