/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.Matrix;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2PointCompression;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtCompatible(serializable=true)
public strictfp final class S2Polyline
implements S2Shape,
S2Region,
Serializable {
    private static final Logger log = Platform.getLoggerForClass(S2Polyline.class);
    private static final S2Point[] ARR_TEMPLATE = new S2Point[0];
    private static final byte LOSSLESS_ENCODING_VERSION = 1;
    private static final byte COMPRESSED_ENCODING_VERSION = 2;
    public static final S2Coder<S2Polyline> FAST_CODER = new S2Coder<S2Polyline>(){

        @Override
        public void encode(S2Polyline value, OutputStream output) throws IOException {
            value.encodeUncompressed(new LittleEndianOutput(output));
        }

        @Override
        public S2Polyline decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Polyline.decode(data.toInputStream(cursor));
        }
    };
    public static final S2Coder<S2Polyline> COMPACT_CODER = new S2Coder<S2Polyline>(){

        @Override
        public void encode(S2Polyline value, OutputStream output) throws IOException {
            value.encodeCompact(output);
        }

        @Override
        public S2Polyline decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Polyline.decode(data.toInputStream(cursor));
        }
    };
    private final int numVertices;
    private final S2Point[] vertices;

    public S2Polyline(List<S2Point> vertices) {
        this(vertices.toArray(ARR_TEMPLATE));
    }

    private S2Polyline(S2Point[] vertices) {
        this.numVertices = vertices.length;
        this.vertices = vertices;
    }

    public List<S2Point> vertices() {
        return Collections.unmodifiableList(Arrays.asList(this.vertices));
    }

    public boolean isValid() {
        return this.isValid(this.vertices());
    }

    public boolean isValid(List<S2Point> vertices) {
        int i;
        int n = vertices.size();
        for (i = 0; i < n; ++i) {
            if (S2.isUnitLength(vertices.get(i))) continue;
            int n2 = i;
            log.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.geometry.S2Polyline", "isValid", new StringBuilder(37).append("Vertex ").append(n2).append(" is not unit length").toString());
            return false;
        }
        for (i = 1; i < n; ++i) {
            if (!vertices.get(i - 1).equalsPoint(vertices.get(i)) && !vertices.get(i - 1).equalsPoint(S2Point.neg(vertices.get(i)))) continue;
            int n3 = i - 1;
            int n4 = i;
            log.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.geometry.S2Polyline", "isValid", new StringBuilder(63).append("Vertices ").append(n3).append(" and ").append(n4).append(" are identical or antipodal").toString());
            return false;
        }
        return true;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int k) {
        return this.vertices[k];
    }

    public S1Angle getArclengthAngle() {
        double lengthSum = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            lengthSum += this.vertex(i - 1).angle(this.vertex(i));
        }
        return S1Angle.radians(lengthSum);
    }

    public S2Point interpolate(double fraction) {
        if (fraction <= 0.0) {
            return this.vertex(0);
        }
        double lengthSum = 0.0;
        for (int i = 1; i < this.numVertices(); ++i) {
            lengthSum += this.vertex(i - 1).angle(this.vertex(i));
        }
        double target = fraction * lengthSum;
        for (int i = 1; i < this.numVertices(); ++i) {
            double length = this.vertex(i - 1).angle(this.vertex(i));
            if (target < length) {
                double f = Math.sin(target) / Math.sin(length);
                return this.vertex(i - 1).mul(Math.cos(target) - f * Math.cos(length)).add(this.vertex(i).mul(f));
            }
            target -= length;
        }
        return this.vertex(this.numVertices() - 1);
    }

    public double uninterpolate(S2Point queryPoint) {
        int i;
        double arcLength = S2EdgeUtil.getClosestPoint(queryPoint, this.vertex(i), this.vertex(i + 1)).angle(this.vertex(i));
        for (i = this.getNearestEdgeIndex(queryPoint); i > 0; --i) {
            arcLength += this.vertex(i - 1).angle(this.vertex(i));
        }
        return Math.min(arcLength / this.getArclengthAngle().radians(), 1.0);
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2EdgeUtil.RectBounder bounder = new S2EdgeUtil.RectBounder();
        for (int i = 0; i < this.numVertices(); ++i) {
            bounder.addPoint(this.vertex(i));
        }
        return bounder.getBound();
    }

    @Override
    public boolean contains(S2Cell cell) {
        return false;
    }

    @Override
    public boolean contains(S2Point point) {
        return false;
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        if (this.numVertices() == 0) {
            return false;
        }
        for (int i = 0; i < this.numVertices(); ++i) {
            if (!cell.contains(this.vertex(i))) continue;
            return true;
        }
        S2Point[] cellVertices = new S2Point[4];
        for (int i = 0; i < 4; ++i) {
            cellVertices[i] = cell.getVertex(i);
        }
        for (int j = 0; j < 4; ++j) {
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(cellVertices[j], cellVertices[j + 1 & 3], this.vertex(0));
            for (int i = 1; i < this.numVertices(); ++i) {
                if (crosser.robustCrossing(this.vertex(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static S2Polyline fromSnapped(S2Polyline a, int snapLevel) {
        ArrayList<S2Point> snappedVertices = new ArrayList<S2Point>(a.numVertices());
        S2Point prev = S2Polyline.snapPointToLevel(a.vertex(0), snapLevel);
        snappedVertices.add(prev);
        for (int i = 1; i < a.numVertices(); ++i) {
            S2Point curr = S2Polyline.snapPointToLevel(a.vertex(i), snapLevel);
            if (curr.equalsPoint(prev)) continue;
            prev = curr;
            snappedVertices.add(curr);
        }
        return new S2Polyline(snappedVertices);
    }

    private static S2Point snapPointToLevel(S2Point p, int level) {
        return S2CellId.fromPoint(p).parent(level).toPoint();
    }

    public S2Polyline subsampleVertices(S1Angle tolerance) {
        if (this.vertices.length == 0) {
            return this;
        }
        ArrayList results = Lists.newArrayList();
        results.add(this.vertex(0));
        S1Angle clampedTolerance = S1Angle.max(tolerance, S1Angle.ZERO);
        int i = 0;
        while (i < this.vertices.length - 1) {
            int nextIndex = this.findEndVertex(clampedTolerance, i);
            if (!this.vertex(nextIndex).equalsPoint(this.vertex(i))) {
                results.add(this.vertex(nextIndex));
            }
            i = nextIndex;
        }
        return new S2Polyline(results);
    }

    private int findEndVertex(S1Angle tolerance, int index) {
        S2Point candidate;
        double distance;
        S2Point origin = this.vertex(index);
        Matrix frame = S2.getFrame(origin);
        S1Interval currentWedge = S1Interval.full();
        double lastDistance = 0.0;
        ++index;
        while (!(index >= this.vertices.length || (distance = origin.angle(candidate = this.vertex(index))) > 1.5707963267948966 && lastDistance > 0.0 || distance < lastDistance && lastDistance > tolerance.radians())) {
            lastDistance = distance;
            if (!(distance <= tolerance.radians())) {
                S2Point direction = S2.toFrame(frame, candidate);
                double center = Math.atan2(direction.y, direction.x);
                if (!currentWedge.contains(center)) break;
                double halfAngle = Math.asin(Math.sin(tolerance.radians()) / Math.sin(distance));
                S1Interval target = S1Interval.fromPoint(center).expanded(halfAngle);
                currentWedge = currentWedge.intersection(target);
            }
            ++index;
        }
        return index - 1;
    }

    public int getNearestEdgeIndex(S2Point point) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        if (this.numVertices() == 1) {
            return 0;
        }
        S1Angle minDistance = S1Angle.radians(10.0);
        int minIndex = -1;
        for (int i = 0; i < this.numVertices() - 1; ++i) {
            S1Angle distanceToSegment = S2EdgeUtil.getDistance(point, this.vertex(i), this.vertex(i + 1));
            if (!distanceToSegment.lessThan(minDistance)) continue;
            minDistance = distanceToSegment;
            minIndex = i;
        }
        return minIndex;
    }

    public S2Point projectToEdge(S2Point point, int index) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        Preconditions.checkState((this.numVertices() == 1 || index < this.numVertices() - 1 ? 1 : 0) != 0, (Object)"Invalid edge index");
        if (this.numVertices() == 1) {
            return this.vertex(0);
        }
        return S2EdgeUtil.getClosestPoint(point, this.vertex(index), this.vertex(index + 1));
    }

    public S2Point project(S2Point queryPoint) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        if (this.numVertices() == 1) {
            return this.vertex(0);
        }
        int i = this.getNearestEdgeIndex(queryPoint);
        return S2EdgeUtil.getClosestPoint(queryPoint, this.vertex(i), this.vertex(i + 1));
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Polyline)) {
            return false;
        }
        S2Polyline thatPolyline = (S2Polyline)that;
        if (this.numVertices != thatPolyline.numVertices) {
            return false;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].equalsPoint(thatPolyline.vertices[i])) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(S2Polyline line) {
        if (this.numVertices() <= 0 || line.numVertices() <= 0) {
            return false;
        }
        if (!this.getRectBound().intersects(line.getRectBound())) {
            return false;
        }
        for (int i = 1; i < this.numVertices(); ++i) {
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(this.vertex(i - 1), this.vertex(i), line.vertex(0));
            for (int j = 1; j < line.numVertices(); ++j) {
                if (crosser.robustCrossing(line.vertex(j)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numVertices, Arrays.deepHashCode(this.vertices)});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("S2Polyline, ");
        builder.append(this.vertices.length).append(" points. [");
        for (S2Point v : this.vertices) {
            builder.append(v.toDegreesString()).append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int numEdges() {
        return Math.max(0, this.numVertices - 1);
    }

    @Override
    public void getEdge(int index, S2Shape.MutableEdge result) {
        result.set(this.vertices[index], this.vertices[index + 1]);
    }

    @Override
    public boolean hasInterior() {
        return false;
    }

    @Override
    public boolean containsOrigin() {
        throw new IllegalStateException("An S2Polyline has no interior, so containsOrigin() should never be called on one.");
    }

    @Override
    public int numChains() {
        return this.numVertices > 1 ? 1 : 0;
    }

    @Override
    public int getChainStart(int chainId) {
        Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
        return 0;
    }

    @Override
    public int getChainLength(int chainId) {
        Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
        return this.numEdges();
    }

    @Override
    public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
        Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
        this.getEdge(offset, result);
    }

    @Override
    public S2Point getChainVertex(int chainId, int edgeOffset) {
        Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
        return this.vertex(edgeOffset);
    }

    @Override
    public int dimension() {
        return 1;
    }

    public void encode(OutputStream os) throws IOException {
        this.encodeUncompressed(new LittleEndianOutput(os));
    }

    public void encodeCompact(OutputStream output) throws IOException {
        int level = this.numVertices == 0 ? 30 : this.getBestSnapLevel();
        LittleEndianOutput encoder = new LittleEndianOutput(output);
        if (level == -1) {
            this.encodeUncompressed(encoder);
        } else {
            this.encodeCompressed(level, encoder);
        }
    }

    void encodeUncompressed(LittleEndianOutput os) throws IOException {
        os.writeByte((byte)1);
        os.writeInt(this.numVertices);
        for (S2Point p : this.vertices) {
            p.encode(os);
        }
    }

    void encodeCompressed(int snapLevel, LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)2);
        encoder.writeByte((byte)snapLevel);
        encoder.writeVarint32(this.numVertices);
        S2PointCompression.encodePointsCompressed(this.vertices(), snapLevel, encoder);
    }

    public static S2Polyline decode(InputStream is) throws IOException {
        return S2Polyline.decode(new LittleEndianInput(is));
    }

    static S2Polyline decode(LittleEndianInput decoder) throws IOException {
        byte version = decoder.readByte();
        switch (version) {
            case 1: {
                return S2Polyline.decodeLossless(decoder);
            }
            case 2: {
                return S2Polyline.decodeCompressed(decoder);
            }
        }
        throw new IOException(new StringBuilder(44).append("Unsupported S2Polyline encoding version ").append(version).toString());
    }

    private static S2Polyline decodeLossless(LittleEndianInput is) throws IOException {
        S2Point[] vertices = new S2Point[is.readInt()];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = S2Point.decode(is);
        }
        return new S2Polyline(vertices);
    }

    private static S2Polyline decodeCompressed(LittleEndianInput decoder) throws IOException {
        byte level = decoder.readByte();
        if (level > 30) {
            throw new IOException(new StringBuilder(25).append("Invalid level ").append(level).toString());
        }
        int numVertices = decoder.readVarint32();
        return new S2Polyline(S2PointCompression.decodePointsCompressed(numVertices, (int)level, decoder));
    }

    public int getSnapLevel() {
        int snapLevel = -1;
        for (S2Point p : this.vertices) {
            S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(p);
            int level = S2Projections.PROJ.levelIfCenter(faceSiTi, p);
            if (level < 0) {
                return level;
            }
            if (level == snapLevel) continue;
            if (snapLevel < 0) {
                snapLevel = level;
                continue;
            }
            return -1;
        }
        return snapLevel;
    }

    int getBestSnapLevel() {
        int[] histogram = new int[31];
        for (S2Point p : this.vertices) {
            S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(p);
            int level = S2Projections.PROJ.levelIfCenter(faceSiTi, p);
            if (level < 0) continue;
            int n = level;
            histogram[n] = histogram[n] + 1;
        }
        int snapLevel = 0;
        for (int i = 1; i < histogram.length; ++i) {
            if (histogram[i] <= histogram[snapLevel]) continue;
            snapLevel = i;
        }
        if (histogram[snapLevel] == 0 && this.numVertices > 0) {
            return -1;
        }
        return snapLevel;
    }

    public S2Polyline reversed() {
        return new S2Polyline(Lists.reverse(this.vertices()));
    }
}

