/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellIdVectorCoder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp class S2CellUnion
implements S2Region,
Iterable<S2CellId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte LOSSLESS_ENCODING_VERSION = 1;
    public static final S2Coder<S2CellUnion> FAST_CODER = new S2Coder<S2CellUnion>(){

        @Override
        public void encode(S2CellUnion value, OutputStream output) throws IOException {
            value.encode(output);
        }

        @Override
        public S2CellUnion decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2CellUnion.decode(data.toInputStream(cursor));
        }
    };
    public static final S2Coder<S2CellUnion> COMPACT_CODER = S2CellIdVectorCoder.INSTANCE.delegating(cells -> cells.cellIds, S2CellUnion::copyFrom);
    private ArrayList<S2CellId> cellIds = new ArrayList();

    @JsConstructor
    public S2CellUnion() {
    }

    public static S2CellUnion copyFrom(Iterable<S2CellId> cells) {
        S2CellUnion result = new S2CellUnion();
        Iterables.addAll(result.cellIds, cells);
        return result;
    }

    public void initFromCellIds(ArrayList<S2CellId> cellIds) {
        this.initRawCellIds(cellIds);
        this.normalize();
    }

    public void initFromIds(List<Long> cellIds) {
        this.initRawIds(cellIds);
        this.normalize();
    }

    public void initSwap(List<S2CellId> cellIds) {
        this.initRawSwap(cellIds);
        this.normalize();
    }

    public void initRawCellIds(ArrayList<S2CellId> cellIds) {
        this.cellIds = cellIds;
    }

    public void initRawIds(List<Long> cellIds) {
        int size = cellIds.size();
        this.cellIds = new ArrayList(size);
        for (Long id : cellIds) {
            this.cellIds.add(new S2CellId(id));
        }
    }

    public void initRawSwap(List<S2CellId> cellIds) {
        this.cellIds = new ArrayList<S2CellId>(cellIds);
        cellIds.clear();
    }

    public void initFromMinMax(S2CellId minId, S2CellId maxId) {
        this.initFromBeginEnd(minId, maxId.next());
    }

    public void initFromBeginEnd(S2CellId begin, S2CellId end) {
        this.cellIds.clear();
        S2CellId nextBegin = begin;
        while (nextBegin.compareTo(end) < 0) {
            S2CellId nextId = nextBegin;
            while (!nextId.isFace() && nextId.parent().rangeMin().equals(nextBegin) && nextId.parent().rangeMax().compareTo(end) < 0) {
                nextId = nextId.parent();
            }
            this.cellIds.add(nextId);
            nextBegin = nextId.rangeMax().next();
        }
    }

    public int size() {
        return this.cellIds.size();
    }

    public S2CellId cellId(int i) {
        return this.cellIds.get(i);
    }

    @Override
    @JsIgnore
    public Iterator<S2CellId> iterator() {
        return this.cellIds.iterator();
    }

    public ArrayList<S2CellId> cellIds() {
        return this.cellIds;
    }

    public boolean isValid() {
        for (int i = 1; i < this.cellIds.size(); ++i) {
            if (this.cellIds.get(i - 1).rangeMax().compareTo(this.cellIds.get(i).rangeMin()) < 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNormalized() {
        for (int i = 1; i < this.cellIds.size(); ++i) {
            if (this.cellIds.get(i - 1).rangeMax().compareTo(this.cellIds.get(i).rangeMin()) >= 0) {
                return false;
            }
            if (i < 3 || !S2CellUnion.areSiblings(this.cellIds.get(i - 3), this.cellIds.get(i - 2), this.cellIds.get(i - 1), this.cellIds.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areSiblings(S2CellId a, S2CellId b, S2CellId c, S2CellId d) {
        if ((a.id() ^ b.id() ^ c.id()) != d.id()) {
            return false;
        }
        long mask = d.lowestOnBit() << 1;
        mask = mask + (mask << 1) ^ 0xFFFFFFFFFFFFFFFFL;
        long idMasked = d.id() & mask;
        return !d.isFace() && (a.id() & mask) == idMasked && (b.id() & mask) == idMasked && (c.id() & mask) == idMasked;
    }

    public void denormalize(int minLevel, int levelMod, ArrayList<S2CellId> output) {
        output.clear();
        output.ensureCapacity(this.size());
        for (S2CellId id : this) {
            int level = id.level();
            int newLevel = Math.max(minLevel, level);
            if (levelMod > 1) {
                newLevel += (30 - (newLevel - minLevel)) % levelMod;
                newLevel = Math.min(30, newLevel);
            }
            if (newLevel == level) {
                output.add(id);
                continue;
            }
            S2CellId end = id.childEnd(newLevel);
            id = id.childBegin(newLevel);
            while (!id.equals(end)) {
                output.add(id);
                id = id.next();
            }
        }
    }

    public void pack() {
        this.cellIds.trimToSize();
    }

    @JsMethod(name="containsCellId")
    public boolean contains(S2CellId id) {
        int pos = Collections.binarySearch(this.cellIds, id);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos < this.cellIds.size() && this.cellIds.get(pos).rangeMin().lessOrEquals(id)) {
            return true;
        }
        return pos != 0 && this.cellIds.get(pos - 1).rangeMax().greaterOrEquals(id);
    }

    @JsMethod(name="intersectsCellId")
    public boolean intersects(S2CellId id) {
        int pos = Collections.binarySearch(this.cellIds, id);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos < this.cellIds.size() && this.cellIds.get(pos).rangeMin().lessOrEquals(id.rangeMax())) {
            return true;
        }
        return pos != 0 && this.cellIds.get(pos - 1).rangeMax().greaterOrEquals(id.rangeMin());
    }

    public boolean contains(S2CellUnion that) {
        S2CellUnion result = new S2CellUnion();
        result.getIntersection(this, that);
        return result.cellIds.equals(that.cellIds);
    }

    @Override
    @JsMethod(name="containsCell")
    public boolean contains(S2Cell cell) {
        return this.contains(cell.id());
    }

    public boolean intersects(S2CellUnion union) {
        S2CellUnion result = new S2CellUnion();
        result.getIntersection(this, union);
        return result.size() > 0;
    }

    public void getUnion(S2CellUnion x, S2CellUnion y) {
        this.cellIds.clear();
        this.cellIds.ensureCapacity(x.size() + y.size());
        this.cellIds.addAll(x.cellIds);
        this.cellIds.addAll(y.cellIds);
        this.normalize();
    }

    public void getIntersection(S2CellUnion x, S2CellId id) {
        this.cellIds.clear();
        if (x.contains(id)) {
            this.cellIds.add(id);
        } else {
            int pos = Collections.binarySearch(x.cellIds, id.rangeMin());
            if (pos < 0) {
                pos = -pos - 1;
            }
            S2CellId idmax = id.rangeMax();
            int size = x.cellIds.size();
            while (pos < size && x.cellIds.get(pos).lessOrEquals(idmax)) {
                this.cellIds.add(x.cellIds.get(pos++));
            }
        }
    }

    @JsMethod(name="getIntersectionCellUnion")
    public void getIntersection(S2CellUnion x, S2CellUnion y) {
        S2CellUnion.getIntersection(x.cellIds, y.cellIds, this.cellIds);
    }

    @JsIgnore
    public static void getIntersection(List<S2CellId> x, List<S2CellId> y, List<S2CellId> results) {
        results.clear();
        int i = 0;
        int j = 0;
        while (i < x.size() && j < y.size()) {
            S2CellId yCell;
            S2CellId yMin;
            S2CellId xCell = x.get(i);
            S2CellId xMin = xCell.rangeMin();
            if (xMin.greaterThan(yMin = (yCell = y.get(j)).rangeMin())) {
                if (xCell.lessOrEquals(yCell.rangeMax())) {
                    results.add(xCell);
                    ++i;
                    continue;
                }
                if (!xCell.lessOrEquals(y.get((j = S2CellUnion.indexedBinarySearch(y, xMin, j + 1)) - 1).rangeMax())) continue;
                --j;
                continue;
            }
            if (yMin.greaterThan(xMin)) {
                if (yCell.lessOrEquals(xCell.rangeMax())) {
                    results.add(yCell);
                    ++j;
                    continue;
                }
                if (!yCell.lessOrEquals(x.get((i = S2CellUnion.indexedBinarySearch(x, yMin, i + 1)) - 1).rangeMax())) continue;
                --i;
                continue;
            }
            if (xCell.lessThan(yCell)) {
                results.add(xCell);
                ++i;
                continue;
            }
            results.add(yCell);
            ++j;
        }
    }

    public void getDifference(S2CellUnion x, S2CellUnion y) {
        this.cellIds.clear();
        for (S2CellId id : x) {
            this.getDifferenceInternal(id, y);
        }
    }

    private void getDifferenceInternal(S2CellId cell, S2CellUnion y) {
        if (!y.intersects(cell)) {
            this.cellIds.add(cell);
        } else if (!y.contains(cell)) {
            for (int i = 0; i < 4; ++i) {
                this.getDifferenceInternal(cell.child(i), y);
            }
        }
    }

    private static int indexedBinarySearch(List<S2CellId> l, S2CellId key, int low) {
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            S2CellId midVal = l.get(mid);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    @JsMethod(name="expandAtLevel")
    public void expand(int level) {
        ArrayList<S2CellId> output = new ArrayList<S2CellId>();
        long levelLsb = S2CellId.lowestOnBitForLevel(level);
        int i = this.size();
        while (--i >= 0) {
            S2CellId id = this.cellId(i);
            if (id.lowestOnBit() < levelLsb) {
                id = id.parent(level);
                while (i > 0 && id.contains(this.cellId(i - 1))) {
                    --i;
                }
            }
            output.add(id);
            id.getAllNeighbors(level, output);
        }
        this.initSwap(output);
    }

    public void expand(S1Angle minRadius, int maxLevelDiff) {
        int minLevel = 30;
        for (S2CellId id : this) {
            minLevel = Math.min(minLevel, id.level());
        }
        int radiusLevel = S2Projections.PROJ.minWidth.getMaxLevel(minRadius.radians());
        if (radiusLevel == 0 && minRadius.radians() > S2Projections.PROJ.minWidth.getValue(0)) {
            this.expand(0);
        }
        this.expand(Math.min(minLevel + maxLevelDiff, radiusLevel));
    }

    public S2CellUnion clone() {
        S2CellUnion copy = new S2CellUnion();
        copy.initRawCellIds(Lists.newArrayList(this.cellIds));
        return copy;
    }

    @Override
    public S2Cap getCapBound() {
        if (this.cellIds.isEmpty()) {
            return S2Cap.empty();
        }
        S2Point centroid = S2Point.ORIGIN;
        for (S2CellId id : this) {
            double area = S2Cell.averageArea(id.level());
            centroid = centroid.add(id.toPoint().mul(area));
        }
        centroid = centroid.equalsPoint(S2Point.ORIGIN) ? S2Point.X_POS : centroid.normalize();
        S2Cap cap = S2Cap.fromAxisChord(centroid, S1ChordAngle.ZERO);
        for (S2CellId id : this) {
            cap = cap.addCap(new S2Cell(id).getCapBound());
        }
        return cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLngRect.Builder builder = S2LatLngRect.Builder.empty();
        for (S2CellId id : this) {
            builder.union(new S2Cell(id).getRectBound());
        }
        return builder.build();
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.intersects(cell.id());
    }

    @Override
    @JsMethod(name="containsPoint")
    public boolean contains(S2Point p) {
        return this.contains(S2CellId.fromPoint(p));
    }

    public long leafCellsCovered() {
        long numLeaves = 0L;
        for (S2CellId cellId : this.cellIds) {
            int invertedLevel = 30 - cellId.level();
            numLeaves += 1L << (invertedLevel << 1);
        }
        return numLeaves;
    }

    public double averageBasedArea() {
        return S2Cell.averageArea(30) * (double)this.leafCellsCovered();
    }

    public double approxArea() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).approxArea();
        }
        return area;
    }

    public double approxAreaM2() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).approxAreaM2();
        }
        return area;
    }

    public double approxAreaKm2() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).approxAreaKm2();
        }
        return area;
    }

    public double exactArea() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).exactArea();
        }
        return area;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2CellUnion)) {
            return false;
        }
        S2CellUnion union = (S2CellUnion)that;
        return this.cellIds.equals(union.cellIds);
    }

    public int hashCode() {
        int value = 17;
        for (S2CellId id : this) {
            value = 37 * value + id.hashCode();
        }
        return value;
    }

    public boolean normalize() {
        return S2CellUnion.normalize(this.cellIds);
    }

    @JsIgnore
    public static boolean normalize(List<S2CellId> ids) {
        boolean trimmed;
        Collections.sort(ids);
        int out = 0;
        for (int i = 0; i < ids.size(); ++i) {
            S2CellId id = ids.get(i);
            if (out > 0 && ids.get(out - 1).contains(id)) continue;
            while (out > 0 && id.contains(ids.get(out - 1))) {
                --out;
            }
            while (out >= 3 && (ids.get(out - 3).id() ^ ids.get(out - 2).id() ^ ids.get(out - 1).id()) == id.id()) {
                long mask = id.lowestOnBit() << 1;
                mask = mask + (mask << 1) ^ 0xFFFFFFFFFFFFFFFFL;
                long idMasked = id.id() & mask;
                if ((ids.get(out - 3).id() & mask) != idMasked || (ids.get(out - 2).id() & mask) != idMasked || (ids.get(out - 1).id() & mask) != idMasked || id.isFace()) break;
                id = id.parent();
                out -= 3;
            }
            ids.set(out++, id);
        }
        int size = ids.size();
        boolean bl = trimmed = out < size;
        while (out < size) {
            ids.remove(--size);
        }
        return trimmed;
    }

    @JsIgnore
    public void encode(OutputStream output) throws IOException {
        output.write(1);
        LittleEndianOutput.writeLong(output, this.cellIds.size());
        for (S2CellId cellId : this) {
            LittleEndianOutput.writeLong(output, cellId.id());
        }
    }

    @JsIgnore
    public static S2CellUnion decode(InputStream input) throws IOException {
        byte version = (byte)input.read();
        if (version != 1) {
            throw new IOException(new StringBuilder(32).append("Unrecognized version number ").append(version).toString());
        }
        long numCells = LittleEndianInput.readLong(input);
        if (numCells < 0L || numCells > Integer.MAX_VALUE) {
            throw new IOException(new StringBuilder(61).append("Unsupported number of cells encountered: ").append(numCells).toString());
        }
        S2CellUnion result = new S2CellUnion();
        int i = 0;
        while ((long)i < numCells) {
            result.cellIds().add(new S2CellId(LittleEndianInput.readLong(input)));
            ++i;
        }
        return result;
    }
}

