/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

@GwtCompatible
public interface S2Coder<T>
extends Serializable {
    public void encode(T var1, OutputStream var2) throws IOException;

    public T decode(PrimitiveArrays.Bytes var1, PrimitiveArrays.Cursor var2) throws IOException;

    default public T decode(PrimitiveArrays.Bytes data) throws IOException {
        return this.decode(data, data.cursor());
    }

    default public <U> S2Coder<U> delegating(final S2.SerializableFunction<U, T> encode, final S2.SerializableFunction<T, U> decode) {
        final S2Coder base = this;
        return new S2Coder<U>(this){

            @Override
            public void encode(U value, OutputStream output) throws IOException {
                base.encode(encode.apply(value), output);
            }

            @Override
            public U decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
                return decode.apply(base.decode(data, cursor));
            }
        };
    }
}

