/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;

@GwtCompatible
public class S2PaddedCell {
    private final S2CellId id;
    private final double padding;
    private final R2Rect bound;
    private R2Rect middle;
    private final int iLo;
    private final int jLo;
    private final int orientation;
    private final int level;

    public S2PaddedCell(S2CellId id, double padding) {
        this.id = id;
        this.padding = padding;
        if (id.isFace()) {
            double limit = 1.0 + padding;
            this.bound = new R2Rect(new R1Interval(-limit, limit), new R1Interval(-limit, limit));
            this.middle = new R2Rect(new R1Interval(-padding, padding), new R1Interval(-padding, padding));
            this.jLo = 0;
            this.iLo = 0;
            this.orientation = id.face() & 1;
            this.level = 0;
        } else {
            long ijo = id.toIJOrientation();
            int i = S2CellId.getI(ijo);
            int j = S2CellId.getJ(ijo);
            this.orientation = S2CellId.getOrientation(ijo);
            this.level = id.level();
            this.bound = S2CellId.ijLevelToBoundUv(i, j, this.level).expanded(padding);
            int ijSize = S2CellId.getSizeIJ(this.level);
            this.iLo = i & -ijSize;
            this.jLo = j & -ijSize;
        }
    }

    public S2PaddedCell childAtIJ(int i, int j) {
        return new S2PaddedCell(this, S2.ijToPos(this.orientation, i * 2 + j), i, j);
    }

    public S2PaddedCell childAtPos(int pos) {
        int ij = S2.posToIJ(this.orientation, pos);
        return new S2PaddedCell(this, pos, ij >> 1, ij & 1);
    }

    private S2PaddedCell(S2PaddedCell parent, int pos, int i, int j) {
        this.padding = parent.padding;
        this.bound = new R2Rect(parent.bound);
        this.level = parent.level + 1;
        this.id = parent.id.child(pos);
        int ijSize = S2CellId.getSizeIJ(this.level);
        this.iLo = parent.iLo + i * ijSize;
        this.jLo = parent.jLo + j * ijSize;
        this.orientation = parent.orientation ^ S2.posToOrientation(pos);
        R2Rect middle = parent.middle();
        R1Interval.Endpoint uEnd = i == 0 ? R1Interval.Endpoint.HI : R1Interval.Endpoint.LO;
        this.bound.x().setValue(uEnd, middle.x().getValue(uEnd));
        R1Interval.Endpoint vEnd = j == 0 ? R1Interval.Endpoint.HI : R1Interval.Endpoint.LO;
        this.bound.y().setValue(vEnd, middle.y().getValue(vEnd));
    }

    public S2CellId id() {
        return this.id;
    }

    public double padding() {
        return this.padding;
    }

    public int level() {
        return this.level;
    }

    public int orientation() {
        return this.orientation;
    }

    public R2Rect bound() {
        return this.bound;
    }

    public R2Rect middle() {
        if (this.middle == null) {
            int ijSize = S2CellId.getSizeIJ(this.level);
            double u = S2Projections.PROJ.stToUV(S2Projections.siTiToSt(2L * (long)this.iLo + (long)ijSize));
            double v = S2Projections.PROJ.stToUV(S2Projections.siTiToSt(2L * (long)this.jLo + (long)ijSize));
            this.middle = new R2Rect(new R1Interval(u - this.padding, u + this.padding), new R1Interval(v - this.padding, v + this.padding));
        }
        return this.middle;
    }

    public S2CellId shrinkToFit(R2Rect rect) {
        int jMax;
        int jXor;
        int ijSize = S2CellId.getSizeIJ(this.level);
        if (this.level == 0 ? rect.x().contains(0.0) || rect.y().contains(0.0) : rect.x().contains(S2Projections.PROJ.stToUV(S2Projections.siTiToSt(2L * (long)this.iLo + (long)ijSize))) || rect.y().contains(S2Projections.PROJ.stToUV(S2Projections.siTiToSt(2L * (long)this.jLo + (long)ijSize)))) {
            return this.id();
        }
        R2Rect padded = rect.expanded(this.padding() + 1.5 * S2.DBL_EPSILON);
        int iMin = Math.max(this.iLo, S2Projections.stToIj(S2Projections.PROJ.uvToST(padded.x().lo())));
        int jMin = Math.max(this.jLo, S2Projections.stToIj(S2Projections.PROJ.uvToST(padded.y().lo())));
        int iMax = Math.min(this.iLo + ijSize - 1, S2Projections.stToIj(S2Projections.PROJ.uvToST(padded.x().hi())));
        int iXor = iMin ^ iMax;
        int levelMsb = ((iXor | (jXor = jMin ^ (jMax = Math.min(this.jLo + ijSize - 1, S2Projections.stToIj(S2Projections.PROJ.uvToST(padded.y().hi())))))) << 1) + 1;
        int level = 30 - S2PaddedCell.floorLog2(levelMsb);
        if (level <= this.level) {
            return this.id();
        }
        return S2CellId.fromFaceIJ(this.id().face(), iMin, jMin).parent(level);
    }

    private static final int floorLog2(long x) {
        return 63 - Long.numberOfLeadingZeros(x);
    }

    public S2Point getCenter() {
        int ijSize = S2CellId.getSizeIJ(this.level);
        long si = 2L * (long)this.iLo + (long)ijSize;
        long ti = 2L * (long)this.jLo + (long)ijSize;
        return S2Projections.PROJ.faceSiTiToXyz(this.id.face(), si, ti).normalize();
    }

    public S2Point getEntryVertex() {
        int i = this.iLo;
        int j = this.jLo;
        if ((this.orientation & 2) != 0) {
            int ijSize = S2CellId.getSizeIJ(this.level);
            i += ijSize;
            j += ijSize;
        }
        return S2Projections.PROJ.faceSiTiToXyz(this.id.face(), 2L * (long)i, 2L * (long)j).normalize();
    }

    public S2Point getExitVertex() {
        int i = this.iLo;
        int j = this.jLo;
        int ijSize = S2CellId.getSizeIJ(this.level);
        if (this.orientation == 0 || this.orientation == 3) {
            i += ijSize;
        } else {
            j += ijSize;
        }
        return S2Projections.PROJ.faceSiTiToXyz(this.id.face(), 2L * (long)i, 2L * (long)j).normalize();
    }
}

