/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.index.CorruptIndexException;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.Collector;
import com.google.appengine.repackaged.org.apache.lucene.search.Explanation;
import com.google.appengine.repackaged.org.apache.lucene.search.Filter;
import com.google.appengine.repackaged.org.apache.lucene.search.HitCollector;
import com.google.appengine.repackaged.org.apache.lucene.search.HitCollectorWrapper;
import com.google.appengine.repackaged.org.apache.lucene.search.Hits;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.Searchable;
import com.google.appengine.repackaged.org.apache.lucene.search.Similarity;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.Weight;
import java.io.IOException;

public abstract class Searcher
implements Searchable {
    private Similarity similarity = Similarity.getDefault();

    public final Hits search(Query query) throws IOException {
        return this.search(query, (Filter)null);
    }

    public Hits search(Query query, Filter filter) throws IOException {
        return new Hits(this, query, filter);
    }

    public Hits search(Query query, Sort sort) throws IOException {
        return new Hits(this, query, null, sort);
    }

    public Hits search(Query query, Filter filter, Sort sort) throws IOException {
        return new Hits(this, query, filter, sort);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.search(this.createWeight(query), filter, n, sort);
    }

    public void search(Query query, HitCollector results) throws IOException {
        this.search(this.createWeight(query), null, (Collector)new HitCollectorWrapper(results));
    }

    public void search(Query query, Collector results) throws IOException {
        this.search(this.createWeight(query), null, results);
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        this.search(this.createWeight(query), filter, (Collector)new HitCollectorWrapper(results));
    }

    public void search(Query query, Filter filter, Collector results) throws IOException {
        this.search(this.createWeight(query), filter, results);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.search(this.createWeight(query), filter, n);
    }

    public TopDocs search(Query query, int n) throws IOException {
        return this.search(query, null, n);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.explain(this.createWeight(query), doc);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    protected Weight createWeight(Query query) throws IOException {
        return query.weight(this);
    }

    public int[] docFreqs(Term[] terms) throws IOException {
        int[] result = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            result[i] = this.docFreq(terms[i]);
        }
        return result;
    }

    public void search(Weight weight, Filter filter, HitCollector results) throws IOException {
        this.search(weight, filter, (Collector)new HitCollectorWrapper(results));
    }

    public abstract void search(Weight var1, Filter var2, Collector var3) throws IOException;

    public abstract void close() throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public abstract int maxDoc() throws IOException;

    public abstract TopDocs search(Weight var1, Filter var2, int var3) throws IOException;

    public abstract Document doc(int var1) throws CorruptIndexException, IOException;

    public abstract Query rewrite(Query var1) throws IOException;

    public abstract Explanation explain(Weight var1, int var2) throws IOException;

    public abstract TopFieldDocs search(Weight var1, Filter var2, int var3, Sort var4) throws IOException;
}

