/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;

@GwtCompatible
public final class Matrix {
    private final double[] values;
    private final int rows;
    private final int cols;

    public static Matrix fromCols(S2Point ... columns) {
        Matrix result = new Matrix(3, columns.length);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, columns[col].get(row));
            }
        }
        return result;
    }

    public static Matrix fromCols(List<S2Point> frame) {
        return Matrix.fromCols(frame.toArray(new S2Point[0]));
    }

    public Matrix(int cols, double ... values) {
        Preconditions.checkArgument((cols >= 0 ? 1 : 0) != 0, (Object)"Negative rows not allowed.");
        this.rows = values.length / cols;
        this.cols = cols;
        Preconditions.checkArgument((this.rows * cols == values.length ? 1 : 0) != 0, (Object)"Values not an even multiple of 'cols'");
        this.values = values;
    }

    public Matrix(int rows, int cols) {
        Preconditions.checkArgument((rows >= 0 ? 1 : 0) != 0, (Object)"Negative rows not allowed.");
        Preconditions.checkArgument((cols >= 0 ? 1 : 0) != 0, (Object)"Negative cols not allowed.");
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows * cols];
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public void set(int row, int col, double value) {
        this.values[row * this.cols + col] = value;
    }

    public double get(int row, int col) {
        return this.values[row * this.cols + col];
    }

    @CheckReturnValue
    public Matrix transpose() {
        Matrix result = new Matrix(this.cols, this.rows);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, this.get(col, row));
            }
        }
        return result;
    }

    @CheckReturnValue
    public Matrix mult(Matrix m) {
        Preconditions.checkArgument((this.cols == m.rows ? 1 : 0) != 0);
        Matrix result = new Matrix(this.rows, m.cols);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < this.cols; ++i) {
                    sum += this.get(row, i) * m.get(i, col);
                }
                result.set(row, col, sum);
            }
        }
        return result;
    }

    public S2Point getCol(int col) {
        Preconditions.checkState((this.rows == 3 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= col && col < this.cols ? 1 : 0) != 0);
        return new S2Point(this.values[col], this.values[this.cols + col], this.values[2 * this.cols + col]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)o;
        if (this.rows != m.rows || this.cols != m.cols) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == m.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long hash = 37L * (long)this.cols;
        for (int i = 0; i < this.values.length; ++i) {
            hash = 37L * hash + Platform.doubleHash(this.values[i]);
        }
        return (int)hash;
    }
}

