/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.cloud.datastore.core.exception.Problem;
import com.google.cloud.datastore.logs.ProblemCode;
import java.time.Duration;
import java.time.Instant;

public final class StaleSnapshotProblem
extends Problem {
    private final Instant requested;
    private final Instant minAllowed;
    private final Duration maxStaleness;

    private StaleSnapshotProblem(Instant requested, Instant minAllowed, Duration maxStaleness) {
        super(ProblemCode.SNAPSHOT_TOO_OLD);
        this.requested = requested;
        this.minAllowed = minAllowed;
        this.maxStaleness = maxStaleness;
    }

    public Instant requested() {
        return this.requested;
    }

    public Instant minAllowed() {
        return this.minAllowed;
    }

    public Duration maxStaleness() {
        return this.maxStaleness;
    }

    public static StaleSnapshotProblem create(Instant requested, Instant minAllowed, Duration maxStaleness) {
        return new StaleSnapshotProblem(requested, minAllowed, maxStaleness);
    }
}

