/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.names;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.names.AutoValue_ProjectIds_ParsedAppId;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ProjectIds {
    public static final String METADATA_PROJECT_PREFIX = "__metadata-";
    public static final String METADATA_PROJECT_SUFFIX = "__";
    public static final int MAX_PARTITION_ID_LENGTH = 100;
    public static final Pattern PARTITION_ID_REGEX;
    public static final Pattern DATABASE_ID_REGEX;
    public static final int MAX_APP_ID_SECTION_LENGTH = 100;
    public static final char PARTITION_DELIMITER = '~';

    private ProjectIds() {
    }

    public static String appToProjectId(String appId) {
        return ProjectIds.parseAppId(appId).projectId();
    }

    public static String cluster(String appId) {
        try {
            return ProjectIds.parseAppId(appId).partitionId();
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static String projectIdToApp(String cluster, String projectId) {
        Preconditions.checkArgument((projectId.indexOf(126) == -1 ? 1 : 0) != 0);
        if (cluster.isEmpty()) {
            return projectId;
        }
        return new StringBuilder(cluster.length() + projectId.length() + 1).append(cluster).append('~').append(projectId).toString();
    }

    public static boolean isValidAppId(String appId) {
        try {
            ProjectIds.parseAppId(appId);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ParsedAppId parseAppId(String appId) {
        int projectIdStartIndex = appId.indexOf(126) + 1;
        Preconditions.checkArgument((projectIdStartIndex < appId.length() ? 1 : 0) != 0, (Object)ProjectIds.invalidAppIdMessage(appId));
        String partitionId = projectIdStartIndex == 0 ? "" : ProjectIds.validateAppIdPartition(appId, projectIdStartIndex);
        Integer metadata = null;
        String projectId = null;
        if (appId.startsWith(METADATA_PROJECT_PREFIX, projectIdStartIndex)) {
            Preconditions.checkArgument((boolean)appId.endsWith(METADATA_PROJECT_SUFFIX), (Object)ProjectIds.invalidAppIdMessage(appId));
            int replicaIdStartIndex = projectIdStartIndex + METADATA_PROJECT_PREFIX.length();
            int replicaIdEndIndex = -1;
            for (int i = replicaIdStartIndex; i < appId.length(); ++i) {
                char c = appId.charAt(i);
                if (Character.isDigit(c)) continue;
                if (c == '_') {
                    replicaIdEndIndex = i;
                    break;
                }
                throw new IllegalArgumentException(ProjectIds.invalidAppIdMessage(appId));
            }
            Preconditions.checkArgument((replicaIdEndIndex != -1 && replicaIdStartIndex < replicaIdEndIndex ? 1 : 0) != 0, (Object)ProjectIds.invalidAppIdMessage(appId));
            metadata = Integer.parseInt(appId.substring(replicaIdStartIndex, replicaIdEndIndex));
            Preconditions.checkArgument((replicaIdEndIndex + 1 < appId.length() - 2 ? 1 : 0) != 0, (Object)ProjectIds.invalidAppIdMessage(appId));
            projectId = appId.substring(replicaIdEndIndex + 1, appId.length() - 2);
        } else {
            projectId = appId.substring(projectIdStartIndex);
        }
        if (!ProjectIds.isValidProjectId(projectId)) {
            throw new IllegalArgumentException(ProjectIds.invalidAppIdMessage(appId));
        }
        return new AutoValue_ProjectIds_ParsedAppId(partitionId, metadata, projectId);
    }

    private static String validateAppIdPartition(String appId, int projectIdStartIndex) {
        String partition = appId.substring(0, projectIdStartIndex - 1);
        Preconditions.checkArgument((partition.length() > 0 && partition.length() <= 100 ? 1 : 0) != 0, (Object)ProjectIds.invalidAppIdMessage(appId));
        for (int i = 0; i < partition.length(); ++i) {
            char c = partition.charAt(i);
            Preconditions.checkArgument((ProjectIds.isAsciiLowercaseLetter(c) || Character.isDigit(c) || c == '-' ? 1 : 0) != 0, (Object)ProjectIds.invalidAppIdMessage(appId));
        }
        return partition;
    }

    private static String invalidAppIdMessage(String appId) {
        return "Invalid app id: " + appId;
    }

    public static boolean isValidProjectId(String projectId) {
        char c;
        int i;
        int domainIndex;
        int start = 0;
        int end = projectId.length();
        if (projectId.startsWith(METADATA_PROJECT_SUFFIX)) {
            if (!projectId.endsWith(METADATA_PROJECT_SUFFIX) || projectId.length() < 4) {
                return false;
            }
            start = 2;
            end = projectId.length() - 2;
        }
        if ((domainIndex = projectId.indexOf(58)) != -1) {
            if (domainIndex - start > 100) {
                return false;
            }
            for (i = start; i < domainIndex; ++i) {
                c = projectId.charAt(i);
                if (ProjectIds.isAsciiLowercaseLetter(c) || Character.isDigit(c) || i > start && (c == '.' || c == '-')) continue;
                return false;
            }
            start = domainIndex + 1;
        }
        if (end - start > 100) {
            return false;
        }
        for (i = start; i < end; ++i) {
            c = projectId.charAt(i);
            if (ProjectIds.isAsciiLowercaseLetter(c) || Character.isDigit(c) || i > start && c == '-') continue;
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public static boolean isValidDatabaseId(String databaseId) {
        return DATABASE_ID_REGEX.matcher(databaseId).matches();
    }

    private static boolean isAsciiLowercaseLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    static {
        DATABASE_ID_REGEX = PARTITION_ID_REGEX = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));
    }

    @AutoValue
    public static abstract class ParsedAppId {
        public abstract String partitionId();

        @Nullable
        public abstract Integer metadata();

        public abstract String projectId();
    }
}

