/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.BasicJpeg;
import mediautil.image.jpeg.LLJTran;

public class JPEG
extends AbstractImageInfo<LLJTran> {
    int width;
    int height;
    int precision;
    byte[] header = new byte[2];

    public JPEG(int width, int height, int precision, LLJTran format) throws FileFormatException {
        this.width = width;
        this.height = height;
        this.precision = precision;
        this.format = format;
    }

    public JPEG(InputStream is, byte[] data, int offset, String name, String comments, int width, int height, LLJTran format) throws FileFormatException {
        super(is, data, offset, name, comments, format);
        if (this.width <= 0 && width > 0) {
            this.width = width;
            this.height = height;
        } else {
            int len;
            if (data.length == 2) {
                len = this.readMarker(is, true);
                if (len <= 0) {
                    return;
                }
                if (data[1] >= -64 && data[1] <= -49 && data[1] != -60 && data[1] != -56) {
                    this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                    this.width = this.bs2i(3, 2);
                    this.height = this.bs2i(1, 2);
                    return;
                }
            }
            while ((len = this.readMarker(is, false)) > 0) {
                if (this.header[1] < -64 || this.header[1] > -49 || this.header[1] == -60 || this.header[1] == -56) continue;
                this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                this.width = this.bs2i(3, 2);
                this.height = this.bs2i(1, 2);
                break;
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.width + " x " + this.height + ")";
    }

    @Override
    public int getResolutionX() {
        return this.width;
    }

    @Override
    public int getResolutionY() {
        return this.height;
    }

    @Override
    public int getMetering() {
        return 0;
    }

    @Override
    public int getExpoProgram() {
        return 0;
    }

    @Override
    public String getFormat() {
        return "n/a";
    }

    @Override
    public void readInfo() {
        this.data = null;
    }

    @Override
    public String getMake() {
        return "n/a";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    @Override
    public String getDataTimeOriginalString() {
        return dateformat.format(new Date());
    }

    @Override
    public float getFNumber() {
        return 0.0f;
    }

    @Override
    public Rational getShutter() {
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        return false;
    }

    @Override
    public float getFocalLength() {
        return 0.0f;
    }

    @Override
    public String getQuality() {
        return "n/a";
    }

    @Override
    public String getReport() {
        return "n/a";
    }

    @Override
    public boolean saveThumbnailImage(OutputStream os) {
        try {
            if (!super.saveThumbnailImage(os)) {
                return this.saveSizedImage(os, DEFAULT_THUMB_SIZE);
            }
            return true;
        }
        catch (Exception e) {
            if (Log.debugLevel >= 1) {
                e.printStackTrace(System.err);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSizedImage(OutputStream os, Dimension size) throws IOException {
        block12: {
            if (os == null) {
                return false;
            }
            if (!super.saveThumbnailImage(os)) {
                Image i = this.createImage();
                Dimension imageSize = BasicJpeg.getScaledSize(i, size, null);
                BufferedImage biDest = new BufferedImage(imageSize.width, imageSize.height, 1);
                Graphics2D big = biDest.createGraphics();
                try {
                    final Object monitor = new Object();
                    ImageObserver observer = new ImageObserver(this){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                            if ((infoflags & 0x20) == 32 || (infoflags & 0x80) == 128 || (infoflags & 0x40) == 64) {
                                Object object = monitor;
                                synchronized (object) {
                                    monitor.notify();
                                }
                                return false;
                            }
                            return true;
                        }
                    };
                    Object object = monitor;
                    synchronized (object) {
                        if (!big.drawImage(i, 0, 0, imageSize.width, imageSize.height, observer)) {
                            try {
                                monitor.wait(3600000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("JPEG");
                    if (writers != null && writers.hasNext()) {
                        ImageWriter wr = writers.next();
                        wr.setOutput(new MemoryCacheImageOutputStream(os));
                        wr.write(biDest);
                        boolean bl = true;
                        return bl;
                    }
                    break block12;
                }
                finally {
                    big.dispose();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Icon getThumbnailIcon(Dimension size) {
        try {
            return new ImageIcon(BasicJpeg.getScaled(Toolkit.getDefaultToolkit().getImage(this.getImageFile().getPath()), size == null ? DEFAULT_THUMB_SIZE : size, 2, null));
        }
        catch (Exception ex) {
            block8: {
                if (Log.debugLevel >= 1) {
                    System.err.println("Exception '" + ex + "' in scaling thumdnail image.");
                }
                if (this.getAdvancedImage() != null) {
                    try {
                        return this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), size);
                    }
                    catch (Throwable t) {
                        if (Log.debugLevel < 1) break block8;
                        System.err.println(t);
                    }
                }
            }
            int w = 100;
            int h = 100;
            int[] pix = new int[w * h];
            int index = 0;
            for (int y = 0; y < h; ++y) {
                int red = y * 255 / (h - 1);
                for (int x = 0; x < w; ++x) {
                    int blue = x * 255 / (w - 1);
                    pix[index++] = 0xFF000000 | red << 16 | blue;
                }
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pix, 0, w)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage() throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try (ImageInputStream iis = ImageIO.createImageInputStream(this.getImageFile());){
                reader.setInput(iis, true);
                BufferedImage bufferedImage = reader.read(0, reader.getDefaultReadParam());
                return bufferedImage;
            }
        }
        return null;
    }

    int readMarker(InputStream is, boolean bodyOnly) {
        try {
            if (!bodyOnly && is.read(this.header) < this.header.length) {
                return -1;
            }
            this.data = new byte[2];
            if (is.read(this.data) < this.data.length) {
                return -1;
            }
            int len = this.bs2i(0, 2) - 2;
            this.data = new byte[len];
            return JPEG.read(is, this.data) + this.header.length + 2;
        }
        catch (Exception e) {
            if (Log.debugLevel >= 1) {
                e.printStackTrace(System.err);
            }
            return -1;
        }
    }
}

