/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.LocalSearchService;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import com.google.appengine.repackaged.org.apache.lucene.store.RAMDirectory;
import com.google.appengine.repackaged.org.apache.lucene.store.SimpleFSDirectory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class LuceneDirectoryMap {
    private static final Logger LOG = LocalSearchService.LOG;
    protected final ConcurrentMap<String, ConcurrentNavigableMap<String, LuceneIndexSpec>> appMap = new ConcurrentHashMap<String, ConcurrentNavigableMap<String, LuceneIndexSpec>>();

    private static SearchServicePb.IndexSpec normalize(SearchServicePb.IndexSpec indexSpec) {
        SearchServicePb.IndexSpec defaultInstance = SearchServicePb.IndexSpec.getDefaultInstance();
        SearchServicePb.IndexSpec.Builder builder = indexSpec.toBuilder();
        if (indexSpec.getConsistency() == defaultInstance.getConsistency()) {
            builder.clearConsistency();
        }
        if (!indexSpec.hasNamespace()) {
            builder.setNamespace(defaultInstance.getNamespace());
        }
        return builder.build();
    }

    private static String getAppNamespaceKey(String appId, String namespace) {
        return appId + "/" + namespace;
    }

    protected LuceneDirectoryMap() {
    }

    public Directory getDirectory(String appId, SearchServicePb.IndexSpec indexSpec) throws IOException {
        LuceneIndexSpec luceneIndexSpec;
        String appNamespaceKey = LuceneDirectoryMap.getAppNamespaceKey(appId, (indexSpec = LuceneDirectoryMap.normalize(indexSpec)).getNamespace());
        ConcurrentSkipListMap<String, LuceneIndexSpec> indexMap = (ConcurrentSkipListMap<String, LuceneIndexSpec>)this.appMap.get(appNamespaceKey);
        if (indexMap == null) {
            indexMap = new ConcurrentSkipListMap<String, LuceneIndexSpec>();
            this.appMap.put(appNamespaceKey, indexMap);
        }
        if ((luceneIndexSpec = (LuceneIndexSpec)indexMap.get(indexSpec.getName())) == null) {
            luceneIndexSpec = this.newDirectory(appId, indexSpec);
            indexMap.put(indexSpec.getName(), luceneIndexSpec);
        } else if (!luceneIndexSpec.indexSpec.equals((Object)indexSpec)) {
            String message = String.format("Changed index specification for %s (%s vs. %s)", indexSpec.getName(), TextFormat.shortDebugString((MessageOrBuilder)indexSpec), TextFormat.shortDebugString((MessageOrBuilder)luceneIndexSpec.indexSpec));
            throw new IOException(message);
        }
        return luceneIndexSpec.directory;
    }

    public List<SearchServicePb.IndexMetadata.Builder> listIndexes(String appId, SearchServicePb.ListIndexesParams params) {
        Map.Entry dirEntry;
        String indexName;
        String appNamespaceKey = LuceneDirectoryMap.getAppNamespaceKey(appId, params.getNamespace());
        ArrayList<SearchServicePb.IndexMetadata.Builder> indexMetadatas = new ArrayList<SearchServicePb.IndexMetadata.Builder>();
        SortedMap appIndexes = (SortedMap)this.appMap.get(appNamespaceKey);
        if (appIndexes == null) {
            return indexMetadatas;
        }
        int startPos = 0;
        String prefix = params.getIndexNamePrefix();
        String startIndexName = params.getStartIndexName();
        String start = startIndexName;
        if (start.length() == 0) {
            start = prefix;
        }
        if (start.length() > 0) {
            if ((appIndexes = appIndexes.tailMap(start)).isEmpty()) {
                return indexMetadatas;
            }
            if (appIndexes.firstKey().equals(startIndexName) && !params.getIncludeStartIndex()) {
                ++startPos;
            }
        }
        Map.Entry[] indexes = appIndexes.entrySet().toArray(new Map.Entry[0]);
        int endPos = Math.min((startPos += params.getOffset()) + params.getLimit(), indexes.length);
        for (int i = startPos; i < endPos && (indexName = (String)(dirEntry = indexes[i]).getKey()).startsWith(prefix); ++i) {
            SearchServicePb.IndexMetadata.Builder metadataBuilder = SearchServicePb.IndexMetadata.newBuilder().setIndexSpec(((LuceneIndexSpec)dirEntry.getValue()).indexSpec);
            indexMetadatas.add(metadataBuilder);
        }
        return indexMetadatas;
    }

    public void close() throws IOException {
        for (Map.Entry entry : this.appMap.entrySet()) {
            for (Map.Entry dirEntry : ((ConcurrentNavigableMap)entry.getValue()).entrySet()) {
                ((LuceneIndexSpec)dirEntry.getValue()).directory.close();
            }
        }
    }

    protected abstract LuceneIndexSpec newDirectory(String var1, SearchServicePb.IndexSpec var2) throws IOException;

    private static class LuceneIndexSpec {
        public final Directory directory;
        public final SearchServicePb.IndexSpec indexSpec;

        public LuceneIndexSpec(Directory directory, SearchServicePb.IndexSpec indexSpec) {
            this.directory = directory;
            this.indexSpec = LuceneDirectoryMap.normalize(indexSpec);
        }
    }

    private static class Cmp
    implements Comparator<Map.Entry<String, LuceneIndexSpec>> {
        private Cmp() {
        }

        @Override
        public int compare(Map.Entry<String, LuceneIndexSpec> o1, Map.Entry<String, LuceneIndexSpec> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    public static final class FileBased
    extends LuceneDirectoryMap {
        private static final String ILLEGAL_CHARS = "*:\\/<>|*?\"'";
        private final File rootDir;

        public FileBased(File rootDir) {
            this.rootDir = rootDir;
            File[] appDirs = rootDir.listFiles();
            if (appDirs == null) {
                LOG.logp(Level.SEVERE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "<init>", "File base storage: root directory doesn't exist");
                return;
            }
            for (File appDir : appDirs) {
                String appId;
                try {
                    appId = FileBased.decode(appDir.getName());
                }
                catch (DecodingException e) {
                    LOG.logp(Level.SEVERE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "<init>", "File base storage: ignoring app dir:" + appDir.getName(), e);
                    continue;
                }
                try {
                    File[] indexDirs = appDir.listFiles();
                    if (indexDirs == null) {
                        LOG.logp(Level.SEVERE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "<init>", "File base storage: failed to read app dir:" + appDir.getName());
                        continue;
                    }
                    for (File indexDir : indexDirs) {
                        SearchServicePb.IndexSpec indexSpec;
                        try {
                            indexSpec = FileBased.decodeIndexSpec(indexDir.getName());
                        }
                        catch (DecodingException e) {
                            LOG.logp(Level.SEVERE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "<init>", "File base storage: ignoring index dir:" + indexDir.getName(), e);
                            continue;
                        }
                        String appNamespaceKey = LuceneDirectoryMap.getAppNamespaceKey(appId, indexSpec.getNamespace());
                        ConcurrentSkipListMap<String, LuceneIndexSpec> indexMap = (ConcurrentSkipListMap<String, LuceneIndexSpec>)this.appMap.get(appNamespaceKey);
                        if (indexMap == null) {
                            indexMap = new ConcurrentSkipListMap<String, LuceneIndexSpec>();
                            this.appMap.put(appNamespaceKey, indexMap);
                        }
                        indexMap.put(indexSpec.getName(), new LuceneIndexSpec(new SimpleFSDirectory(indexDir), indexSpec));
                    }
                }
                catch (IOException e) {
                    LOG.logp(Level.SEVERE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "<init>", "File base storage: failed to initialize storage for appId: " + appId, e);
                }
            }
        }

        @Override
        protected LuceneIndexSpec newDirectory(String appId, SearchServicePb.IndexSpec indexSpec) throws IOException {
            File appDir = new File(this.rootDir, FileBased.encode(appId));
            File indexDir = new File(appDir, FileBased.encodeIndexSpec(indexSpec));
            indexDir.mkdirs();
            LOG.logp(Level.FINE, "com.google.appengine.api.search.dev.LuceneDirectoryMap$FileBased", "newDirectory", String.format("For %s.%s returning FS directory %s", appId, indexSpec.getName(), indexDir.getPath()));
            return new LuceneIndexSpec(new SimpleFSDirectory(indexDir), indexSpec);
        }

        private static String encodeIndexSpec(SearchServicePb.IndexSpec indexSpec) {
            return FileBased.encode(indexSpec.getName()) + "." + FileBased.encode(indexSpec.getNamespace()) + "." + (indexSpec.getConsistency() == SearchServicePb.IndexSpec.Consistency.GLOBAL ? "G" : "P");
        }

        private static SearchServicePb.IndexSpec decodeIndexSpec(String filename) throws DecodingException {
            String[] parts = filename.split("\\.");
            if (parts.length != 3) {
                throw new DecodingException();
            }
            return SearchServicePb.IndexSpec.newBuilder().setName(FileBased.decode(parts[0])).setNamespace(FileBased.decode(parts[1])).setConsistency(parts[2].charAt(0) == 'G' ? SearchServicePb.IndexSpec.Consistency.GLOBAL : SearchServicePb.IndexSpec.Consistency.PER_DOCUMENT).build();
        }

        private static String encode(String name) {
            try {
                return BaseEncoding.base64Url().omitPadding().encode(name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("should never happen", e);
            }
        }

        private static String decode(String name) throws DecodingException {
            try {
                return new String(BaseEncoding.base64Url().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)name)), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("should never happen", e);
            }
            catch (IllegalArgumentException e) {
                throw new DecodingException();
            }
        }

        private static class DecodingException
        extends Exception {
            private DecodingException() {
            }
        }
    }

    public static class RamBased
    extends LuceneDirectoryMap {
        @Override
        protected LuceneIndexSpec newDirectory(String appId, SearchServicePb.IndexSpec indexSpec) {
            return new LuceneIndexSpec(new RAMDirectory(), indexSpec);
        }
    }
}

