/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.UrlFetchJobDetail;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.apphosting.utils.config.QueueXml;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class UrlFetchJob
implements Job {
    private static final Logger logger = Logger.getLogger(UrlFetchJob.class.getName());
    static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    static final String X_APPENGINE_QUEUE_NAME = "X-AppEngine-QueueName";
    static final String X_APPENGINE_TASK_NAME = "X-AppEngine-TaskName";
    static final String X_APPENGINE_TASK_RETRY_COUNT = "X-AppEngine-TaskRetryCount";
    static final String X_APPENGINE_TASK_EXECUTION_COUNT = "X-AppEngine-TaskExecutionCount";
    static final String X_APPENGINE_TASK_ETA = "X-AppEngine-TaskETA";
    static final String X_APPENGINE_SERVER_NAME = "X-AppEngine-ServerName";
    static final String X_APPENGINE_TASK_PREVIOUS_RESPONSE = "X-AppEngine-TaskPreviousResponse";
    private static LocalServerEnvironment localServerEnvironment;
    private static Clock clock;

    static URLFetchServicePb.URLFetchRequest.RequestMethod translateRequestMethod(TaskQueuePb.TaskQueueAddRequest.RequestMethod rm) {
        return URLFetchServicePb.URLFetchRequest.RequestMethod.valueOf((String)rm.name());
    }

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        int status;
        try {
            localServerEnvironment.waitForServerToStart();
        }
        catch (InterruptedException e) {
            throw new JobExecutionException("Interrupted while waiting for server to initialize.", (Exception)e, false);
        }
        Trigger trigger = context.getTrigger();
        UrlFetchJobDetail jd = (UrlFetchJobDetail)context.getJobDetail();
        URLFetchServicePb.URLFetchRequest fetchReq = this.newFetchRequest(jd.getTaskName(), jd.getAddRequest(), jd.getServerUrl(), jd.getRetryCount(), jd.getQueueXmlEntry(), jd.getPreviousResponse());
        long firstTryMs = jd.getFirstTryMs();
        if (firstTryMs == 0L) {
            firstTryMs = clock.getCurrentTime();
        }
        if (((status = jd.getCallback().execute(fetchReq)) < 200 || status > 299) && this.canRetry(jd, firstTryMs)) {
            logger.logp(Level.INFO, "com.google.appengine.api.taskqueue.dev.UrlFetchJob", "execute", String.format("Web hook at %s returned status code %d.  Rescheduling...", fetchReq.getUrl(), status));
            this.reschedule(context.getScheduler(), trigger, jd, firstTryMs, status);
        } else {
            try {
                context.getScheduler().unscheduleJob(trigger.getName(), trigger.getGroup());
            }
            catch (SchedulerException e) {
                logger.logp(Level.SEVERE, "com.google.appengine.api.taskqueue.dev.UrlFetchJob", "execute", String.format("Unsubscription of task %s failed.", jd.getAddRequest()), e);
            }
        }
    }

    private boolean canRetry(UrlFetchJobDetail jd, long firstTryMs) {
        TaskQueuePb.TaskQueueRetryParameters retryParams = jd.getRetryParameters();
        if (retryParams != null) {
            int newRetryCount = jd.getRetryCount() + 1;
            long ageMs = clock.getCurrentTime() - firstTryMs;
            if (retryParams.hasRetryLimit() && retryParams.hasAgeLimitSec()) {
                return retryParams.getRetryLimit() >= newRetryCount || retryParams.getAgeLimitSec() * 1000L >= ageMs;
            }
            if (retryParams.hasRetryLimit()) {
                return retryParams.getRetryLimit() >= newRetryCount;
            }
            if (retryParams.hasAgeLimitSec()) {
                return retryParams.getAgeLimitSec() * 1000L >= ageMs;
            }
        }
        return true;
    }

    private void reschedule(Scheduler scheduler, Trigger trigger, UrlFetchJobDetail jd, long firstTryMs, int previousResponse) {
        UrlFetchJobDetail newJobDetail = jd.retry(firstTryMs, previousResponse);
        SimpleTrigger newTrigger = new SimpleTrigger(trigger.getName(), trigger.getGroup());
        newTrigger.setStartTime(new Date(clock.getCurrentTime() + (long)newJobDetail.getRetryDelayMs()));
        try {
            scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
            scheduler.scheduleJob(newJobDetail, newTrigger);
        }
        catch (SchedulerException e) {
            logger.logp(Level.SEVERE, "com.google.appengine.api.taskqueue.dev.UrlFetchJob", "reschedule", String.format("Reschedule of task %s failed.", jd.getAddRequest()), e);
        }
    }

    URLFetchServicePb.URLFetchRequest newFetchRequest(String taskName, TaskQueuePb.TaskQueueAddRequest.Builder addReq, String serverUrl, int retryCount, QueueXml.Entry queueXmlEntry, int previousResponse) {
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder().setUrl(serverUrl + addReq.getUrl().toStringUtf8());
        if (addReq.hasBody()) {
            requestProto.setPayload(addReq.getBody());
        }
        requestProto.setMethod(UrlFetchJob.translateRequestMethod(addReq.getMethod()));
        this.addHeadersToFetchRequest(requestProto, taskName, addReq, retryCount, queueXmlEntry, previousResponse);
        if (requestProto.getMethod() == URLFetchServicePb.URLFetchRequest.RequestMethod.PUT) {
            requestProto.setFollowRedirects(false);
        }
        return requestProto.build();
    }

    private void addHeadersToFetchRequest(URLFetchServicePb.URLFetchRequest.Builder requestProto, String taskName, TaskQueuePb.TaskQueueAddRequest.Builder addReq, int retryCount, QueueXml.Entry queueXmlEntry, int previousResponse) {
        for (TaskQueuePb.TaskQueueAddRequest.Header header : addReq.getHeaderList()) {
            requestProto.addHeader(this.buildHeader(header.getKey().toStringUtf8(), header.getValue().toStringUtf8()));
        }
        requestProto.addHeader(this.buildHeader(X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK, "true")).addHeader(this.buildHeader(X_APPENGINE_QUEUE_NAME, addReq.getQueueName().toStringUtf8())).addHeader(this.buildHeader(X_APPENGINE_TASK_NAME, taskName)).addHeader(this.buildHeader(X_APPENGINE_TASK_RETRY_COUNT, Integer.toString(retryCount))).addHeader(this.buildHeader(X_APPENGINE_TASK_ETA, new DecimalFormat("0.000000").format((double)addReq.getEtaUsec() / 1000000.0)));
        if (queueXmlEntry.getTarget() != null) {
            requestProto.addHeader(this.buildHeader(X_APPENGINE_SERVER_NAME, queueXmlEntry.getTarget()));
        }
        requestProto.addHeader(this.buildHeader(X_APPENGINE_TASK_EXECUTION_COUNT, Integer.toString(retryCount)));
        if (previousResponse > 0) {
            requestProto.addHeader(this.buildHeader(X_APPENGINE_TASK_PREVIOUS_RESPONSE, Integer.toString(previousResponse)));
        }
    }

    private URLFetchServicePb.URLFetchRequest.Header.Builder buildHeader(String key, String value) {
        return URLFetchServicePb.URLFetchRequest.Header.newBuilder().setKey(key).setValue(value);
    }

    static void initialize(LocalServerEnvironment localServerEnvironment, Clock clock) {
        UrlFetchJob.localServerEnvironment = localServerEnvironment;
        UrlFetchJob.clock = clock;
    }
}

