/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.DistanceCollector;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Distance;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestDistanceTarget;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2ContainsPointQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2RegionCoverer;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@CheckReturnValue
@GwtCompatible
public abstract class S2BestEdgesQueryBase<D extends S1Distance<D>> {
    private static final Logger log = Platform.getLoggerForClass(S2BestEdgesQueryBase.class);
    private static final int MIN_EDGES_TO_ENQUEUE = 10;
    private final Comparator<Result<D>> resultDistanceComparator = Comparator.comparing(result -> Result.access$000(result), this.distanceComparator());
    private final Comparator<Result<D>> resultShapeEdgeComparator = Comparator.comparingInt(result -> System.identityHashCode(((Result)result).shape)).thenComparingInt(result -> Result.access$200(result));
    private final Comparator<Result<D>> resultDistanceStableComparator = this.resultDistanceComparator.thenComparing(this.resultShapeEdgeComparator);
    private final PriorityQueue<QueueEntry<D>> queue = new PriorityQueue<QueueEntry>(Comparator.comparing(arg -> arg.distance, this.distanceComparator()));
    private final ArrayList<S2CellId> initialCells = new ArrayList();
    private final Comparator<D> distanceComparator = this.distanceComparator();
    protected final Options<D> options;
    protected S2ShapeIndex index;
    protected S2BestDistanceTarget<D> target;
    private final IdentityHashMap<S2Shape, Boolean> shapeInteriors = new IdentityHashMap();
    protected int maxResults = Integer.MAX_VALUE;
    protected D maxError;
    private boolean useConservativeCellDistance;
    private final ArrayList<S2CellId> indexCovering = new ArrayList(6);
    private final ArrayList<S2ShapeIndex.Cell> indexCells = new ArrayList(6);
    private int indexNumEdges;
    private int indexNumEdgesLimit;
    protected D distanceLimit;
    protected final PriorityQueue<Result<D>> resultQueue = new PriorityQueue<Result<D>>(this.resultDistanceComparator.reversed());
    private final HashSet<ShapeEdgeId> testedEdges = new HashSet();
    private final List<Result<D>> resultPool = new ArrayList<Result<D>>();

    protected abstract DistanceCollector<D> newDistanceCollector();

    protected abstract boolean atBestLimit(DistanceCollector<D> var1);

    protected abstract D zeroDistance();

    protected abstract D bestDistance();

    protected abstract D worstDistance();

    protected abstract D beyondWorstDistance();

    protected abstract S1ChordAngle searchCapRadius(S1ChordAngle var1, D var2);

    protected abstract Comparator<D> distanceComparator();

    protected abstract D errorBoundedDistance(D var1);

    @CanIgnoreReturnValue
    protected abstract boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> var1, S2ContainsPointQuery.ShapeVisitor var2);

    S2BestEdgesQueryBase(Options<D> options) {
        this.options = options;
    }

    public void init(S2ShapeIndex index) {
        this.index = index;
        this.reInit();
    }

    public void reInit() {
        this.indexNumEdges = 0;
        this.indexNumEdgesLimit = 0;
        this.indexCells.clear();
    }

    public S2ShapeIndex index() {
        return this.index;
    }

    public Options<D> options() {
        return this.options;
    }

    protected boolean distanceAtLimit(D distance) {
        return this.distanceComparator.compare(distance, this.distanceLimit) >= 0;
    }

    public Optional<Result<D>> findBestEdge(S2BestDistanceTarget<D> target) {
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = 1;
        this.maxError = this.options.maxError;
        this.findBestEdgesInternal(target);
        Optional<Result<D>> result = this.resultQueue.isEmpty() ? Optional.empty() : Optional.of(this.resultQueue.poll());
        this.resultQueue.clear();
        return result;
    }

    public boolean updateBestDistance(S2BestDistanceTarget<D> target, DistanceCollector<D> collector) {
        this.maxResults = 1;
        this.maxError = this.options.maxError;
        this.distanceLimit = collector.distance();
        this.findBestEdgesInternal(target);
        if (this.resultQueue.isEmpty()) {
            this.resultQueue.clear();
            return false;
        }
        Result<D> result = this.resultQueue.peek();
        this.resultPool.add(result);
        this.resultQueue.clear();
        return collector.update(result.distance());
    }

    public List<Result<D>> findBestEdges(S2BestDistanceTarget<D> target) {
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = this.options.maxResults();
        this.maxError = this.options.maxError;
        this.findBestEdgesInternal(target);
        ArrayList<Result<D>> results = new ArrayList<Result<D>>(this.resultQueue);
        Collections.sort(results, this.resultDistanceStableComparator);
        this.resultQueue.clear();
        return results;
    }

    public void findBestEdges(S2BestDistanceTarget<D> target, ResultVisitor<D> visitor) {
        Result result;
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = this.options.maxResults();
        this.maxError = this.options.maxError;
        this.findBestEdgesInternal(target);
        ArrayList<Result<D>> results = new ArrayList<Result<D>>(this.resultQueue);
        Collections.sort(results, this.resultDistanceStableComparator);
        this.resultQueue.clear();
        Iterator iterator = results.iterator();
        while (iterator.hasNext() && visitor.accept((result = (Result)iterator.next()).distance, result.shape, result.edgeId)) {
        }
        this.resultPool.addAll(results);
    }

    protected void findBestEdgesInternal(S2BestDistanceTarget<D> target) {
        this.target = target;
        this.testedEdges.clear();
        if (this.distanceLimit.equals(this.bestDistance())) {
            log.logp(Level.FINE, "com.google.appengine.repackaged.com.google.common.geometry.S2BestEdgesQueryBase", "findBestEdgesInternal", "No possible results, cannot be better than the best possible distance.");
            return;
        }
        if (this.maxResults == Integer.MAX_VALUE && this.distanceLimit.equals(this.beyondWorstDistance())) {
            log.logp(Level.FINE, "com.google.appengine.repackaged.com.google.common.geometry.S2BestEdgesQueryBase", "findBestEdgesInternal", "Returning all edges! maxResults and distanceLimit set no limits.");
        }
        if (this.options.includeInteriors()) {
            this.shapeInteriors.clear();
            this.visitBestDistanceContainingShapes(target, shape -> {
                if (!this.shapeInteriors.containsKey(shape)) {
                    this.shapeInteriors.put((S2Shape)shape, true);
                    this.addResult(this.bestDistance(), (S2Shape)shape, -1);
                    if (this.distanceLimit.equals(this.bestDistance())) {
                        return false;
                    }
                }
                return true;
            });
        }
        boolean targetUsesMaxError = !this.maxError.isZero() && target.setMaxError(this.maxError);
        this.useConservativeCellDistance = targetUsesMaxError && (this.distanceLimit.equals(this.beyondWorstDistance()) || this.maxError.lessThan(this.distanceLimit));
        int minOptimizedEdges = target.maxBruteForceIndexSize() + 1;
        if (minOptimizedEdges > this.indexNumEdgesLimit && this.indexNumEdges >= this.indexNumEdgesLimit) {
            this.indexNumEdges = S2ShapeUtil.countEdgesUpTo(this.index, minOptimizedEdges);
            this.indexNumEdgesLimit = minOptimizedEdges;
        }
        if (this.options.useBruteForce() || this.indexNumEdges < minOptimizedEdges) {
            this.findBestEdgesBruteForce();
        } else {
            this.findBestEdgesOptimized();
        }
    }

    private void findBestEdgesBruteForce() {
        for (S2Shape shape : this.index.getShapes()) {
            if (shape == null) continue;
            int numEdges = shape.numEdges();
            for (int e = 0; e < numEdges; ++e) {
                this.maybeAddResult(shape, e);
            }
        }
    }

    private void findBestEdgesOptimized() {
        S2Iterator<S2ShapeIndex.Cell> iter = this.initQueue();
        while (!this.queue.isEmpty()) {
            QueueEntry<D> entry = this.queue.poll();
            if (this.distanceAtLimit(entry.distance)) {
                this.queue.clear();
                break;
            }
            if (entry.indexCell != null) {
                this.processEdges(entry.indexCell);
                continue;
            }
            S2CellId id = entry.id;
            iter.seek(id.child(1).rangeMin());
            if (!iter.done() && iter.id().lessOrEquals(id.child(1).rangeMax())) {
                this.processOrEnqueueChild(id.child(1), iter);
            }
            if (iter.prev() && iter.id().greaterOrEquals(id.rangeMin())) {
                this.processOrEnqueueChild(id.child(0), iter);
            }
            iter.seek(id.child(3).rangeMin());
            if (!iter.done() && iter.id().lessOrEquals(id.child(3).rangeMax())) {
                this.processOrEnqueueChild(id.child(3), iter);
            }
            if (!iter.prev() || !iter.id().greaterOrEquals(id.child(2).rangeMin())) continue;
            this.processOrEnqueueChild(id.child(2), iter);
        }
    }

    private void processOrEnqueueChild(S2CellId id, S2Iterator<S2ShapeIndex.Cell> iter) {
        if (iter.id().equals(id)) {
            this.processOrEnqueue(id, iter.entry());
        } else {
            this.processOrEnqueue(id, null);
        }
    }

    private S2Iterator<S2ShapeIndex.Cell> initQueue() {
        S2Iterator<S2ShapeIndex.Cell> iter = this.index.iterator();
        S2Cap targetCap = this.target.getCapBound();
        if (targetCap.isEmpty()) {
            return iter;
        }
        if (this.maxResults == 1 && iter.locate(targetCap.axis())) {
            this.processEdges(iter.entry());
            if (this.distanceLimit.equals(this.bestDistance())) {
                return iter;
            }
        }
        if (this.indexCovering.isEmpty()) {
            this.initCovering();
        }
        if (this.distanceLimit == this.beyondWorstDistance()) {
            for (int i = 0; i < this.indexCovering.size(); ++i) {
                this.processOrEnqueue(this.indexCovering.get(i), this.indexCells.get(i));
            }
        } else {
            ArrayList<S2CellId> searchCapCovering = new ArrayList<S2CellId>();
            this.initialCells.clear();
            S1ChordAngle radius = this.searchCapRadius(targetCap.radius(), this.distanceLimit);
            S2Cap searchCap = S2Cap.fromAxisChord(targetCap.axis(), radius);
            S2RegionCoverer coverer = S2RegionCoverer.builder().setMaxCells(4).build();
            coverer.getFastCovering(searchCap, searchCapCovering);
            S2CellUnion.getIntersection(this.indexCovering, searchCapCovering, this.initialCells);
            int i = 0;
            int j = 0;
            while (i < this.initialCells.size()) {
                S2CellId initialCellId = this.initialCells.get(i);
                while (this.indexCovering.get(j).rangeMax().lessThan(initialCellId)) {
                    ++j;
                }
                S2CellId coveringCellId = this.indexCovering.get(j);
                if (initialCellId.equals(coveringCellId)) {
                    this.processOrEnqueue(coveringCellId, this.indexCells.get(j));
                    ++i;
                    ++j;
                    continue;
                }
                S2ShapeIndex.CellRelation r = iter.locate(initialCellId);
                if (r == S2ShapeIndex.CellRelation.INDEXED) {
                    this.processOrEnqueue(iter.id(), iter.entry());
                    S2CellId lastId = iter.id().rangeMax();
                    while (++i < this.initialCells.size() && this.initialCells.get(i).lessOrEquals(lastId)) {
                    }
                    continue;
                }
                if (r == S2ShapeIndex.CellRelation.SUBDIVIDED) {
                    this.processOrEnqueue(initialCellId, null);
                }
                ++i;
            }
        }
        return iter;
    }

    private void initCovering() {
        this.indexCovering.clear();
        this.indexCells.clear();
        S2Iterator<S2ShapeIndex.Cell> next = this.index.iterator();
        if (next.done()) {
            return;
        }
        S2Iterator<S2ShapeIndex.Cell> last = this.index.iterator();
        last.finish();
        last.prev();
        if (!next.id().equals(last.id())) {
            int level = next.id().getCommonAncestorLevel(last.id()) + 1;
            S2CellId lastId = last.id().parent(level);
            S2CellId id = next.id().parent(level);
            while (!id.equals(lastId)) {
                if (!id.rangeMax().lessThan(next.id())) {
                    S2Iterator<S2ShapeIndex.Cell> cellFirst = S2Iterator.copy(next);
                    next.seek(id.rangeMax().next());
                    S2Iterator<S2ShapeIndex.Cell> cellLast = S2Iterator.copy(next);
                    cellLast.prev();
                    this.addInitialRange(cellFirst, cellLast);
                }
                id = id.next();
            }
        }
        this.addInitialRange(next, last);
    }

    private void addInitialRange(S2Iterator<S2ShapeIndex.Cell> first, S2Iterator<S2ShapeIndex.Cell> last) {
        if (first.id().equals(last.id())) {
            this.indexCovering.add(first.id());
            this.indexCells.add(first.entry());
        } else {
            int level = first.id().getCommonAncestorLevel(last.id());
            this.indexCovering.add(first.id().parent(level));
            this.indexCells.add(null);
        }
    }

    private void maybeAddResult(S2Shape shape, int edgeId) {
        if (!this.testedEdges.add(new ShapeEdgeId(shape, edgeId))) {
            return;
        }
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        shape.getEdge(edgeId, edge);
        DistanceCollector<D> collector = this.newDistanceCollector();
        collector.set(this.distanceLimit);
        if (this.target.updateBestDistance(edge.a, edge.b, collector)) {
            this.addResult(collector.distance(), shape, edgeId);
        }
    }

    private void addResult(D distance, S2Shape shape, int edgeId) {
        Result<D> result;
        if (this.resultPool.isEmpty()) {
            result = new Result<D>(distance, shape, edgeId);
        } else {
            result = this.resultPool.remove(this.resultPool.size() - 1);
            result.set(distance, shape, edgeId);
        }
        this.resultQueue.add(result);
        int size = this.resultQueue.size();
        if (size >= this.maxResults) {
            if (size > this.maxResults) {
                this.resultPool.add(this.resultQueue.poll());
            }
            this.distanceLimit = this.errorBoundedDistance(this.resultQueue.peek().distance());
        }
    }

    private static int countEdges(S2ShapeIndex.Cell cell) {
        int count = 0;
        for (int s = 0; s < cell.numShapes(); ++s) {
            count += cell.clipped(s).numEdges();
        }
        return count;
    }

    private void processEdges(S2ShapeIndex.Cell shapeIndexCell) {
        for (int s = 0; s < shapeIndexCell.numShapes(); ++s) {
            S2ShapeIndex.S2ClippedShape clipped = shapeIndexCell.clipped(s);
            S2Shape shape = clipped.shape();
            for (int j = 0; j < clipped.numEdges(); ++j) {
                this.maybeAddResult(shape, clipped.edge(j));
            }
        }
    }

    private void processOrEnqueue(S2CellId id, @Nullable S2ShapeIndex.Cell indexCell) {
        if (indexCell != null) {
            int numEdges = S2BestEdgesQueryBase.countEdges(indexCell);
            if (numEdges == 0) {
                return;
            }
            if (numEdges < 10) {
                this.processEdges(indexCell);
                return;
            }
        }
        S2Cell cell = new S2Cell(id);
        DistanceCollector<D> collector = this.newDistanceCollector();
        collector.set(this.distanceLimit);
        if (!this.target.updateBestDistance(cell, collector)) {
            return;
        }
        D distance = this.useConservativeCellDistance ? this.errorBoundedDistance(collector.distance()) : collector.distance();
        this.queue.add(new QueueEntry<D>(distance, id, indexCell));
    }

    public static final class Options<D extends S1Distance<D>> {
        final int maxResults;
        final D distanceLimit;
        final D maxError;
        final boolean includeInteriors;
        final boolean useBruteForce;

        Options(Builder<D> b) {
            this.maxResults = b.maxResults();
            this.distanceLimit = b.distanceLimit();
            this.maxError = b.maxError();
            this.includeInteriors = b.includeInteriors();
            this.useBruteForce = b.useBruteForce();
        }

        public int maxResults() {
            return this.maxResults;
        }

        public D distanceLimit() {
            return this.distanceLimit;
        }

        public D maxError() {
            return this.maxError;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }

        public boolean useBruteForce() {
            return this.useBruteForce;
        }
    }

    public static class Result<D extends S1Distance<D>> {
        private D distance;
        private S2Shape shape;
        private int edgeId;

        public Result(D distance, S2Shape shape, int edgeId) {
            this.distance = distance;
            this.shape = shape;
            this.edgeId = edgeId;
        }

        public void set(D distance, S2Shape shape, int edgeId) {
            this.distance = distance;
            this.shape = shape;
            this.edgeId = edgeId;
        }

        public boolean isInterior() {
            return this.shape != null && this.edgeId < 0;
        }

        public D distance() {
            return this.distance;
        }

        public S2Shape shape() {
            return this.shape;
        }

        public int edgeId() {
            return this.edgeId;
        }

        public boolean equalsResult(Result<D> other) {
            return this.distance.equals(other.distance) && this.shape == other.shape && this.edgeId == other.edgeId;
        }
    }

    public static interface ResultVisitor<D> {
        public boolean accept(D var1, S2Shape var2, int var3);
    }

    protected static class QueueEntry<D extends S1Distance<D>> {
        final D distance;
        final S2CellId id;
        final S2ShapeIndex.Cell indexCell;

        QueueEntry(D distance, S2CellId id, S2ShapeIndex.Cell indexCell) {
            Preconditions.checkNotNull(distance);
            this.distance = distance;
            this.id = id;
            this.indexCell = indexCell;
        }
    }

    private static class ShapeEdgeId {
        private final S2Shape shape;
        private final int edgeId;

        public ShapeEdgeId(S2Shape shape, int edgeId) {
            this.shape = shape;
            this.edgeId = edgeId;
        }

        public int hashCode() {
            return System.identityHashCode(this.shape) + 17 * this.edgeId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ShapeEdgeId)) {
                return false;
            }
            return this.shape.equals(((ShapeEdgeId)obj).shape) && this.edgeId == ((ShapeEdgeId)obj).edgeId;
        }
    }

    protected static abstract class CellTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Cell cell;

        public CellTarget(S2Cell cell) {
            this.cell = cell;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(p, this.cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(v0, v1, this.cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell c, DistanceCollector<D> collector) {
            return collector.update(this.cell, c);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            return visitor.apply(this.cell.getCenter());
        }
    }

    protected static abstract class EdgeTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Point a;
        protected final S2Point b;

        public EdgeTarget(S2Point a, S2Point b) {
            this.a = a.normalize();
            this.b = b.normalize();
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(p, this.a, this.b);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(v0, v1, this.a, this.b);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return collector.update(this.a, this.b, cell);
        }

        protected double getHalfEdgeLength2() {
            double d2 = new S1ChordAngle(this.a, this.b).getLength2();
            return 0.5 * d2 / (1.0 + Math.sqrt(1.0 - 0.25 * d2));
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            S2Point edgeCenter = this.a.add(this.b).normalize();
            return visitor.apply(edgeCenter);
        }
    }

    protected static abstract class PointTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Point point;

        public PointTarget(S2Point point) {
            this.point = point;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(this.point, p);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(this.point, v0, v1);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return collector.update(this.point, cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            return visitor.apply(this.point);
        }
    }

    public static abstract class Builder<D extends S1Distance<D>> {
        protected int maxResults;
        protected D distanceLimit;
        protected D maxError;
        protected boolean includeInteriors;
        protected boolean useBruteForce;

        protected Builder(D defaultDistanceLimit, D zero) {
            this.distanceLimit = defaultDistanceLimit;
            this.maxError = zero;
            this.maxResults = Integer.MAX_VALUE;
            this.includeInteriors = true;
            this.useBruteForce = false;
        }

        public Builder(Options<D> options) {
            this.distanceLimit = options.distanceLimit;
            this.maxError = options.maxError;
            this.maxResults = options.maxResults;
            this.includeInteriors = options.includeInteriors;
            this.useBruteForce = options.useBruteForce;
        }

        public Builder(Builder<D> other) {
            this.distanceLimit = other.distanceLimit;
            this.maxError = other.maxError;
            this.maxResults = other.maxResults;
            this.includeInteriors = other.includeInteriors;
            this.useBruteForce = other.useBruteForce;
        }

        public abstract S2BestEdgesQueryBase<D> build();

        public S2BestEdgesQueryBase<D> build(S2ShapeIndex index) {
            S2BestEdgesQueryBase<D> query = this.build();
            query.init(index);
            return query;
        }

        @CanIgnoreReturnValue
        public Builder<D> setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public int maxResults() {
            return this.maxResults;
        }

        @CanIgnoreReturnValue
        public Builder<D> setDistanceLimit(D distanceLimit) {
            this.distanceLimit = distanceLimit;
            return this;
        }

        public D distanceLimit() {
            return this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder<D> setMaxError(D maxError) {
            this.maxError = maxError;
            return this;
        }

        public D maxError() {
            return this.maxError;
        }

        @CanIgnoreReturnValue
        public Builder<D> setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }

        @CanIgnoreReturnValue
        public Builder<D> setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }

        public boolean useBruteForce() {
            return this.useBruteForce;
        }
    }
}

