/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.DistanceCollector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Distance;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestDistanceTarget;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2ContainsPointQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2MinDistanceTargets;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@CheckReturnValue
@GwtCompatible
public abstract class S2ClosestEdgeQuery<D extends S1Distance<D>>
extends S2BestEdgesQueryBase<D> {
    S2ClosestEdgeQuery(S2BestEdgesQueryBase.Options<D> options) {
        super(options);
    }

    public List<S2BestEdgesQueryBase.Result<D>> findClosestEdges(S2BestDistanceTarget<D> target) {
        return this.findBestEdges(target);
    }

    public void findClosestEdges(S2BestDistanceTarget<D> target, S2BestEdgesQueryBase.ResultVisitor<D> visitor) {
        this.findBestEdges(target, visitor);
    }

    public Optional<S2BestEdgesQueryBase.Result<D>> findClosestEdge(S2BestDistanceTarget<D> target) {
        return this.findBestEdge(target);
    }

    public D getDistance(S2BestDistanceTarget<D> target) {
        Optional<S2BestEdgesQueryBase.Result<D>> result = this.findBestEdge(target);
        return result.isPresent() ? result.get().distance() : this.beyondWorstDistance();
    }

    public boolean isDistanceLess(S2BestDistanceTarget<D> target, D limit) {
        this.maxResults = 1;
        this.maxError = this.worstDistance();
        this.distanceLimit = limit;
        this.findBestEdgesInternal(target);
        boolean result = !this.resultQueue.isEmpty();
        this.resultQueue.clear();
        return result;
    }

    public static void getEdge(S2BestEdgesQueryBase.Result<?> result, S2Shape.MutableEdge edge) {
        result.shape().getEdge(result.edgeId(), edge);
    }

    public S2Point project(S2Point targetPoint, S2BestEdgesQueryBase.Result<D> result) {
        if (result.edgeId() < 0) {
            return targetPoint;
        }
        S2Shape.MutableEdge resultEdge = new S2Shape.MutableEdge();
        S2ClosestEdgeQuery.getEdge(result, resultEdge);
        return S2EdgeUtil.getClosestPoint(targetPoint, resultEdge.getStart(), resultEdge.getEnd());
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    public boolean visitContainingShapes(Target<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        return this.visitBestDistanceContainingShapes(target, visitor);
    }

    @Override
    @CanIgnoreReturnValue
    protected boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        S2ContainsPointQuery containsPointQuery = new S2ContainsPointQuery(this.index);
        return target.visitConnectedComponentPoints(targetPoint -> containsPointQuery.visitContainingShapes((S2Point)targetPoint, visitor));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ShapeIndexTarget<S1ChordAngle> createShapeIndexTarget(S2ShapeIndex index) {
        return new ShapeIndexTarget<S1ChordAngle>(index, new Builder());
    }

    public static class Builder
    extends S2BestEdgesQueryBase.Builder<S1ChordAngle> {
        public Builder() {
            super(S1ChordAngle.INFINITY, S1ChordAngle.ZERO);
        }

        public Builder(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        public Query build() {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this));
        }

        public Query build(S2ShapeIndex index) {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this), index);
        }

        @CanIgnoreReturnValue
        public Builder setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxDistance(S1Angle maxDistance) {
            this.distanceLimit = S1ChordAngle.fromS1Angle(maxDistance);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance.successor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMaxDistance(S1Angle maxDistance) {
            this.setInclusiveMaxDistance(S1ChordAngle.fromS1Angle(maxDistance));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMaxDistance(S1ChordAngle maxDistance) {
            this.distanceLimit = maxDistance.plusError(S2EdgeUtil.getMinDistanceMaxError(maxDistance)).successor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMaxDistance(S1Angle maxDistance) {
            this.setConservativeMaxDistance(S1ChordAngle.fromS1Angle(maxDistance));
            return this;
        }

        public S1ChordAngle maxDistance() {
            return (S1ChordAngle)this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1ChordAngle maxError) {
            this.maxError = maxError;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1Angle maxError) {
            this.maxError = S1ChordAngle.fromS1Angle(maxError);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }
    }

    public static class ShapeIndexTarget<D extends S1Distance<D>>
    extends S2MinDistanceTargets.ShapeIndexTarget<D>
    implements Target<D> {
        public ShapeIndexTarget(S2ShapeIndex index, S2BestEdgesQueryBase.Builder<D> queryBuilder) {
            super(index, queryBuilder);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class Query
    extends S2ClosestEdgeQuery<S1ChordAngle> {
        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options, S2ShapeIndex index) {
            super(options);
            this.init(index);
        }

        public Builder toBuilder() {
            return new Builder(this.options());
        }

        @Override
        protected DistanceCollector<S1ChordAngle> newDistanceCollector() {
            return S1ChordAngle.minCollector();
        }

        @Override
        protected boolean atBestLimit(DistanceCollector<S1ChordAngle> distanceCollector) {
            return distanceCollector.distance().getLength2() <= 0.0;
        }

        @Override
        protected Comparator<S1ChordAngle> distanceComparator() {
            return Comparator.naturalOrder();
        }

        @Override
        protected S1ChordAngle zeroDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle bestDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle worstDistance() {
            return S1ChordAngle.STRAIGHT;
        }

        @Override
        protected S1ChordAngle beyondWorstDistance() {
            return S1ChordAngle.INFINITY;
        }

        @Override
        protected S1ChordAngle errorBoundedDistance(S1ChordAngle value) {
            return S1ChordAngle.sub(value, (S1ChordAngle)this.options().maxError());
        }

        @Override
        protected S1ChordAngle searchCapRadius(S1ChordAngle targetCapRadius, S1ChordAngle maxDistance) {
            Preconditions.checkArgument((!targetCapRadius.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!targetCapRadius.isInfinity() ? 1 : 0) != 0);
            Preconditions.checkArgument((!maxDistance.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!maxDistance.isInfinity() ? 1 : 0) != 0);
            return S1ChordAngle.add(targetCapRadius, maxDistance.plusError(maxDistance.getS1AngleConstructorMaxError()));
        }

        public boolean isDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.successor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = !this.resultQueue.isEmpty();
            this.resultQueue.clear();
            return result;
        }

        public boolean isConservativeDistanceLessOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.plusError(S2EdgeUtil.getMinDistanceMaxError(limit)).successor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = !this.resultQueue.isEmpty();
            this.resultQueue.clear();
            return result;
        }
    }

    public static class CellTarget<D extends S1Distance<D>>
    extends S2MinDistanceTargets.CellTarget<D>
    implements Target<D> {
        public CellTarget(S2Cell c) {
            super(c);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class EdgeTarget<D extends S1Distance<D>>
    extends S2MinDistanceTargets.EdgeTarget<D>
    implements Target<D> {
        public EdgeTarget(S2Point a, S2Point b) {
            super(a, b);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class PointTarget<D extends S1Distance<D>>
    extends S2MinDistanceTargets.PointTarget<D>
    implements Target<D> {
        public PointTarget(S2Point p) {
            super(p);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static interface Target<D extends S1Distance<D>>
    extends S2BestDistanceTarget<D> {
    }
}

