/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.DistanceCollector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Distance;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestDistanceTarget;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2ContainsPointQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2MaxDistanceTargets;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@CheckReturnValue
@GwtCompatible
public abstract class S2FurthestEdgeQuery<D extends S1Distance<D>>
extends S2BestEdgesQueryBase<D> {
    S2FurthestEdgeQuery(S2BestEdgesQueryBase.Options<D> options) {
        super(options);
    }

    public List<S2BestEdgesQueryBase.Result<D>> findFurthestEdges(S2BestDistanceTarget<D> target) {
        return this.findBestEdges(target);
    }

    public void findFurthestEdges(S2BestDistanceTarget<D> target, S2BestEdgesQueryBase.ResultVisitor<D> visitor) {
        this.findBestEdges(target, visitor);
    }

    public Optional<S2BestEdgesQueryBase.Result<D>> findFurthestEdge(S2BestDistanceTarget<D> target) {
        return this.findBestEdge(target);
    }

    public D getDistance(S2BestDistanceTarget<D> target) {
        Optional<S2BestEdgesQueryBase.Result<D>> result = this.findBestEdge(target);
        return result.isPresent() ? result.get().distance() : this.beyondWorstDistance();
    }

    public boolean isDistanceGreater(S2BestDistanceTarget<D> target, D limit) {
        this.maxResults = 1;
        this.maxError = this.worstDistance();
        this.distanceLimit = limit;
        this.findBestEdgesInternal(target);
        boolean result = !this.resultQueue.isEmpty();
        this.resultQueue.clear();
        return result;
    }

    public static void getEdge(S2BestEdgesQueryBase.Result<?> result, S2Shape.MutableEdge edge) {
        result.shape().getEdge(result.edgeId(), edge);
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    public boolean visitAntipodalShapes(Target<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        return this.visitBestDistanceContainingShapes(target, visitor);
    }

    @Override
    @CanIgnoreReturnValue
    protected boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> target, S2ContainsPointQuery.ShapeVisitor visitor) {
        S2ContainsPointQuery containsPointQuery = new S2ContainsPointQuery(this.index);
        return target.visitConnectedComponentPoints(targetPoint -> containsPointQuery.visitContainingShapes(targetPoint.neg(), visitor));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ShapeIndexTarget<S1ChordAngle> createShapeIndexTarget(S2ShapeIndex index) {
        return new ShapeIndexTarget<S1ChordAngle>(index, new Builder());
    }

    public static class Builder
    extends S2BestEdgesQueryBase.Builder<S1ChordAngle> {
        public Builder() {
            super(S1ChordAngle.ZERO, S1ChordAngle.ZERO);
        }

        public Builder(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        public Query build() {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this));
        }

        public Query build(S2ShapeIndex index) {
            return new Query(new S2BestEdgesQueryBase.Options<S1ChordAngle>(this), index);
        }

        @CanIgnoreReturnValue
        public Builder setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinDistance(S1Angle minDistance) {
            this.distanceLimit = S1ChordAngle.fromS1Angle(minDistance);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance.predecessor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInclusiveMinDistance(S1Angle minDistance) {
            this.setInclusiveMinDistance(S1ChordAngle.fromS1Angle(minDistance));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMinDistance(S1ChordAngle minDistance) {
            this.distanceLimit = minDistance.plusError(-S2EdgeUtil.getMinDistanceMaxError(minDistance)).predecessor();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConservativeMinDistance(S1Angle minDistance) {
            this.setConservativeMinDistance(S1ChordAngle.fromS1Angle(minDistance));
            return this;
        }

        public S1ChordAngle minDistance() {
            return (S1ChordAngle)this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1ChordAngle maxError) {
            this.maxError = maxError;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxError(S1Angle maxError) {
            this.maxError = S1ChordAngle.fromS1Angle(maxError);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }
    }

    public static class ShapeIndexTarget<D extends S1Distance<D>>
    extends S2MaxDistanceTargets.ShapeIndexTarget<D>
    implements Target<D> {
        public ShapeIndexTarget(S2ShapeIndex index, S2BestEdgesQueryBase.Builder<D> queryBuilder) {
            super(index, queryBuilder);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class Query
    extends S2FurthestEdgeQuery<S1ChordAngle> {
        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options) {
            super(options);
        }

        Query(S2BestEdgesQueryBase.Options<S1ChordAngle> options, S2ShapeIndex index) {
            super(options);
            this.init(index);
        }

        public Builder toBuilder() {
            return new Builder(this.options());
        }

        @Override
        protected DistanceCollector<S1ChordAngle> newDistanceCollector() {
            return S1ChordAngle.maxCollector();
        }

        @Override
        protected boolean atBestLimit(DistanceCollector<S1ChordAngle> distanceCollector) {
            return distanceCollector.distance().getLength2() >= 4.0;
        }

        @Override
        protected Comparator<S1ChordAngle> distanceComparator() {
            return Comparator.reverseOrder();
        }

        @Override
        protected S1ChordAngle zeroDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle bestDistance() {
            return S1ChordAngle.STRAIGHT;
        }

        @Override
        protected S1ChordAngle worstDistance() {
            return S1ChordAngle.ZERO;
        }

        @Override
        protected S1ChordAngle beyondWorstDistance() {
            return S1ChordAngle.NEGATIVE;
        }

        @Override
        protected S1ChordAngle errorBoundedDistance(S1ChordAngle value) {
            return S1ChordAngle.add(value, (S1ChordAngle)this.options().maxError());
        }

        @Override
        protected S1ChordAngle searchCapRadius(S1ChordAngle antipodalCapRadius, S1ChordAngle minDistance) {
            Preconditions.checkArgument((!antipodalCapRadius.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!antipodalCapRadius.isInfinity() ? 1 : 0) != 0);
            Preconditions.checkArgument((!minDistance.isNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!minDistance.isInfinity() ? 1 : 0) != 0);
            return S1ChordAngle.add(antipodalCapRadius, S1ChordAngle.sub(S1ChordAngle.STRAIGHT, minDistance));
        }

        public boolean isDistanceGreaterOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.predecessor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = !this.resultQueue.isEmpty();
            this.resultQueue.clear();
            return result;
        }

        public boolean isConservativeDistanceGreaterOrEqual(Target<S1ChordAngle> target, S1ChordAngle limit) {
            this.distanceLimit = limit.plusError(-S2EdgeUtil.getMinDistanceMaxError(limit)).predecessor();
            this.maxResults = 1;
            this.maxError = this.worstDistance();
            this.findBestEdgesInternal(target);
            boolean result = !this.resultQueue.isEmpty();
            this.resultQueue.clear();
            return result;
        }
    }

    public static class CellTarget<D extends S1Distance<D>>
    extends S2MaxDistanceTargets.CellTarget<D>
    implements Target<D> {
        public CellTarget(S2Cell c) {
            super(c);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class EdgeTarget<D extends S1Distance<D>>
    extends S2MaxDistanceTargets.EdgeTarget<D>
    implements Target<D> {
        public EdgeTarget(S2Point a, S2Point b) {
            super(a, b);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static class PointTarget<D extends S1Distance<D>>
    extends S2MaxDistanceTargets.PointTarget<D>
    implements Target<D> {
        public PointTarget(S2Point p) {
            super(p);
        }

        @Override
        public int maxBruteForceIndexSize() {
            return 1;
        }
    }

    public static interface Target<D extends S1Distance<D>>
    extends S2BestDistanceTarget<D> {
    }
}

