/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.DistanceCollector;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S2ClosestEdgeQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Predicates;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import java.util.Optional;

@CheckReturnValue
@GwtCompatible
public final class S2HausdorffDistanceQuery {
    private final Options options;
    private final DistanceCollector<S1ChordAngle> maxDistance = S1ChordAngle.maxCollector();
    private S2Point sourcePoint = null;
    private S2Point targetPoint = null;

    S2HausdorffDistanceQuery(Options options) {
        this.options = options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Options options() {
        return this.options;
    }

    public Optional<DirectedResult> getDirectedResult(S2ShapeIndex target, S2ShapeIndex source) {
        S2ClosestEdgeQuery.Query closestEdgeQuery = S2ClosestEdgeQuery.builder().setMaxResults(1).setIncludeInteriors(this.options.includeInteriors()).build(source);
        this.maxDistance.reset();
        this.sourcePoint = null;
        this.targetPoint = null;
        for (S2Shape shape : target.getShapes()) {
            for (List<S2Point> chain : shape.chains()) {
                for (S2Point vertex : chain) {
                    this.updateMaxDistance(vertex, closestEdgeQuery);
                }
            }
        }
        if (this.maxDistance.distance().lessThan(S1ChordAngle.ZERO)) {
            return Optional.empty();
        }
        return Optional.of(new DirectedResult(this.maxDistance.distance(), this.targetPoint));
    }

    public S1ChordAngle getDirectedDistance(S2ShapeIndex target, S2ShapeIndex source) {
        Optional<DirectedResult> directedResult = this.getDirectedResult(target, source);
        return directedResult.isPresent() ? directedResult.get().distance() : S1ChordAngle.INFINITY;
    }

    public Optional<Result> getResult(S2ShapeIndex target, S2ShapeIndex source) {
        Optional<DirectedResult> targetToSource = this.getDirectedResult(target, source);
        if (targetToSource.isPresent()) {
            return Optional.of(new Result(targetToSource.get(), this.getDirectedResult(source, target).get()));
        }
        return Optional.empty();
    }

    public S1ChordAngle getDistance(S2ShapeIndex target, S2ShapeIndex source) {
        Optional<Result> result = this.getResult(target, source);
        return result.isPresent() ? result.get().distance() : S1ChordAngle.INFINITY;
    }

    private void updateMaxDistance(S2Point point, S2ClosestEdgeQuery.Query closestEdgeQuery) {
        if (this.maxDistance.distance().greaterOrEquals(S1ChordAngle.ZERO) && S2Predicates.compareDistance(point, this.sourcePoint, this.maxDistance.distance().getLength2()) <= 0) {
            return;
        }
        S2ClosestEdgeQuery.PointTarget target = new S2ClosestEdgeQuery.PointTarget(point);
        closestEdgeQuery.findClosestEdges(target, (distance, shape, edgeId) -> {
            if (this.maxDistance.update((S1ChordAngle)distance)) {
                this.targetPoint = point;
                if (edgeId == -1) {
                    this.sourcePoint = this.targetPoint;
                } else {
                    S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                    shape.getEdge(edgeId, edge);
                    this.sourcePoint = S2EdgeUtil.getClosestPoint(this.targetPoint, edge.getStart(), edge.getEnd());
                }
            }
            return true;
        });
    }

    public static class Options {
        protected final boolean includeInteriors;

        Options(Builder b) {
            this.includeInteriors = b.includeInteriors();
        }

        public Builder toBuilder() {
            Builder b = new Builder();
            b.setIncludeInteriors(this.includeInteriors());
            return b;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }
    }

    public static class Builder {
        private boolean includeInteriors = true;

        @CanIgnoreReturnValue
        public Builder setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }

        public S2HausdorffDistanceQuery build() {
            return new S2HausdorffDistanceQuery(new Options(this));
        }
    }

    public static class DirectedResult {
        private final S1ChordAngle distance;
        private final S2Point targetPoint;

        public DirectedResult(S1ChordAngle distance, S2Point targetPoint) {
            this.distance = distance;
            this.targetPoint = targetPoint;
        }

        public S1ChordAngle distance() {
            return this.distance;
        }

        public S2Point targetPoint() {
            return this.targetPoint;
        }
    }

    public static class Result {
        private final DirectedResult targetToSource;
        private final DirectedResult sourceToTarget;

        public Result(DirectedResult targetToSource, DirectedResult sourceToTarget) {
            this.targetToSource = targetToSource;
            this.sourceToTarget = sourceToTarget;
        }

        public S1ChordAngle distance() {
            return S1ChordAngle.max(this.targetToSource.distance(), this.sourceToTarget.distance());
        }

        public DirectedResult targetToSource() {
            return this.targetToSource;
        }

        public DirectedResult sourceToTarget() {
            return this.sourceToTarget;
        }
    }
}

