/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.DistanceCollector;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Distance;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestDistanceTarget;
import com.google.appengine.repackaged.com.google.common.geometry.S2BestEdgesQueryBase;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndexRegion;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;

@CheckReturnValue
@GwtCompatible
class S2MinDistanceTargets {
    private S2MinDistanceTargets() {
    }

    public static class ShapeIndexTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        private final S2ShapeIndex index;
        private final S2BestEdgesQueryBase.Builder<D> queryBuilder;
        private S2BestEdgesQueryBase<D> minDistanceQuery = null;

        public ShapeIndexTarget(S2ShapeIndex index, S2BestEdgesQueryBase.Builder<D> queryBuilder) {
            this.index = index;
            this.queryBuilder = queryBuilder;
        }

        @Override
        public boolean setMaxError(D maxError) {
            this.queryBuilder.setMaxError(maxError);
            this.minDistanceQuery = null;
            return true;
        }

        @Override
        public void setIncludeInteriors(boolean includeInteriors) {
            this.queryBuilder.setIncludeInteriors(includeInteriors);
            this.minDistanceQuery = null;
        }

        @Override
        public boolean includeInteriors() {
            return this.queryBuilder.includeInteriors();
        }

        @Override
        public S2Cap getCapBound() {
            return new S2ShapeIndexRegion(this.index).getCapBound();
        }

        private boolean updateMinDistance(S2BestDistanceTarget<D> target, DistanceCollector<D> minDist) {
            if (this.minDistanceQuery == null) {
                this.minDistanceQuery = this.queryBuilder.build(this.index);
            }
            if (this.minDistanceQuery.atBestLimit(minDist)) {
                return false;
            }
            return this.minDistanceQuery.updateBestDistance(target, minDist);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> minDist) {
            return this.updateMinDistance(new PointTarget(p), minDist);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> minDist) {
            return this.updateMinDistance(new EdgeTarget(v0, v1), minDist);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> minDist) {
            return this.updateMinDistance(new CellTarget(cell), minDist);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            for (S2Shape shape : this.index.getShapes()) {
                S2Shape.ReferencePoint ref;
                if (shape == null) continue;
                boolean testedPoint = false;
                for (int chain = 0; chain < shape.numChains(); ++chain) {
                    if (shape.getChainLength(chain) == 0) continue;
                    testedPoint = true;
                    if (visitor.apply(shape.getChainVertex(chain, 0))) continue;
                    return false;
                }
                if (testedPoint || !(ref = shape.getReferencePoint()).contained() || visitor.apply(ref)) continue;
                return false;
            }
            return true;
        }
    }

    public static class CellTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.CellTarget<D2>
    implements S2BestDistanceTarget<D2> {
        public CellTarget(S2Cell c) {
            super(c);
        }

        @Override
        public S2Cap getCapBound() {
            return this.cell.getCapBound();
        }
    }

    public static class EdgeTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.EdgeTarget<D2>
    implements S2BestDistanceTarget<D2> {
        public EdgeTarget(S2Point a, S2Point b) {
            super(a, b);
        }

        @Override
        public S2Cap getCapBound() {
            double r2 = this.getHalfEdgeLength2();
            return S2Cap.fromAxisChord(this.a.add(this.b).normalize(), S1ChordAngle.fromLength2(r2));
        }
    }

    public static class PointTarget<D2 extends S1Distance<D2>>
    extends S2BestEdgesQueryBase.PointTarget<D2>
    implements S2BestDistanceTarget<D2> {
        public PointTarget(S2Point p) {
            super(p);
        }

        @Override
        public S2Cap getCapBound() {
            return S2Cap.fromAxisChord(this.point, S1ChordAngle.ZERO);
        }
    }
}

