/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.collect.TreeMultimap;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.ParametrizedS2Point;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2AreaCentroid;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2ContainsPointQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2Edge;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Error;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2PolygonBuilder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp final class S2Polygon
implements S2Region,
Comparable<S2Polygon>,
Serializable {
    private static final byte LOSSLESS_ENCODING_VERSION = 1;
    private static final byte COMPRESSED_ENCODING_VERSION = 4;
    private final List<S2Loop> loops = Lists.newArrayList();
    private S2LatLngRect bound;
    private S2LatLngRect subregionBound;
    @VisibleForTesting
    transient S2ShapeIndex index;
    private AtomicInteger unindexedContainsCalls = new AtomicInteger();
    private boolean hasHoles = false;
    private int numVertices = 0;
    public static final S2Coder<S2Polygon> FAST_CODER = new S2Coder<S2Polygon>(){

        @Override
        public void encode(S2Polygon value, OutputStream output) throws IOException {
            value.encodeUncompressed(new LittleEndianOutput(output));
        }

        @Override
        public S2Polygon decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Polygon.decode(data.toInputStream(cursor));
        }
    };
    public static final S2Coder<S2Polygon> COMPACT_CODER = new S2Coder<S2Polygon>(){

        @Override
        public void encode(S2Polygon value, OutputStream output) throws IOException {
            value.encode(output);
        }

        @Override
        public S2Polygon decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Polygon.decode(data.toInputStream(cursor));
        }
    };

    private static boolean reverseNone(S2Shape input) {
        return false;
    }

    private static boolean reverseHoles(S2Shape input) {
        if (input instanceof S2Loop) {
            S2Loop loop = (S2Loop)input;
            return loop.isHole();
        }
        return false;
    }

    @JsIgnore
    public S2Polygon() {
        this.bound = S2LatLngRect.empty();
        this.subregionBound = S2LatLngRect.empty();
        this.initIndex();
    }

    @JsIgnore
    public S2Polygon(S2Cell cell) {
        this.loops.add(new S2Loop(cell));
        this.initOneLoop();
    }

    @JsIgnore
    public S2Polygon(List<S2Loop> loops) {
        this.initNested(loops);
    }

    @JsIgnore
    public S2Polygon(S2Loop loop) {
        this.numVertices = loop.numVertices();
        this.bound = loop.getRectBound();
        this.subregionBound = loop.getSubregionBound();
        this.loops.add(loop);
        this.initIndex();
    }

    @JsIgnore
    public S2Polygon(S2Polygon src) {
        this.copy(src);
    }

    void copy(S2Polygon src) {
        this.bound = src.bound;
        this.subregionBound = src.subregionBound;
        this.hasHoles = src.hasHoles;
        this.numVertices = src.numVertices;
        for (int i = 0; i < src.numLoops(); ++i) {
            this.loops.add(new S2Loop(src.loop(i)));
        }
        this.initIndex();
    }

    private void initIndex() {
        int maxUnindexedContainsCalls = this.numVertices <= 8 ? 10 : (this.numVertices <= 8192 ? 50 : (this.numVertices <= 50000 ? 10 : 2));
        this.unindexedContainsCalls.set(maxUnindexedContainsCalls);
        this.index = new S2ShapeIndex();
        for (int i = 0; i < this.numLoops(); ++i) {
            this.index.add(this.loop(i));
        }
    }

    @CanIgnoreReturnValue
    private Object readResolve() {
        this.initIndex();
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof S2Polygon) {
            S2Polygon that = (S2Polygon)o;
            return this.numVertices == that.numVertices && this.bound.equals(that.bound) && this.loops.equals(that.loops);
        }
        return false;
    }

    public int hashCode() {
        return this.bound.hashCode();
    }

    @Override
    public int compareTo(S2Polygon other) {
        if (this.numLoops() != other.numLoops()) {
            return this.numLoops() - other.numLoops();
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            int compare = this.loops.get(i).compareTo(other.loops.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public void init(List<S2Loop> loops) {
        this.initNested(loops);
    }

    public void initNested(List<S2Loop> loops) {
        this.clearLoops();
        if (loops.size() == 1) {
            this.loops.clear();
            this.loops.add(loops.remove(0));
            this.initOneLoop();
            return;
        }
        IdentityHashMap loopMap = Maps.newIdentityHashMap();
        loopMap.put(null, Lists.newArrayList());
        for (S2Loop loop : loops) {
            S2Polygon.insertLoop(loop, null, loopMap);
        }
        loops.clear();
        S2Polygon.sortValueLoops(loopMap);
        this.initLoop(null, -1, loopMap);
        this.initLoopProperties();
    }

    public void initOriented(List<S2Loop> loops) {
        Preconditions.checkState((boolean)this.loops.isEmpty());
        Set containedOrigin = Sets.newIdentityHashSet();
        for (S2Loop loop : loops) {
            double angle;
            if (loop.containsOrigin()) {
                containedOrigin.add(loop);
            }
            if (Math.abs(angle = loop.getTurningAngle()) > S2.getTurningAngleMaxError(loop.numVertices())) {
                if (!(angle < 0.0)) continue;
                loop.invert();
                continue;
            }
            if (!loop.containsOrigin()) continue;
            loop.invert();
        }
        this.initNested(loops);
        if (this.numLoops() > 0) {
            S2Loop originLoop = this.loop(0);
            boolean polygonContainsOrigin = false;
            for (int i = 0; i < this.numLoops(); ++i) {
                if (!this.loop(i).containsOrigin()) continue;
                polygonContainsOrigin ^= true;
                originLoop = this.loop(i);
            }
            if (containedOrigin.contains(originLoop) != polygonContainsOrigin) {
                this.invert();
            }
        }
        for (S2Loop loop : loops) {
            assert (containedOrigin.contains(loop) != loop.containsOrigin() == loop.isHole());
        }
    }

    private void initLoopProperties() {
        this.hasHoles = false;
        this.numVertices = 0;
        S2LatLngRect.Builder builder = S2LatLngRect.Builder.empty();
        for (S2Loop loop : this.loops) {
            if (loop.isHole()) {
                this.hasHoles = true;
            } else {
                builder.union(loop.getRectBound());
            }
            this.numVertices += loop.numVertices();
        }
        this.bound = builder.build();
        this.subregionBound = S2EdgeUtil.RectBounder.expandForSubregions(this.bound);
        this.initIndex();
    }

    private void initOneLoop() {
        assert (1 == this.loops.size());
        S2Loop loop = this.loops.get(0);
        loop.setDepth(0);
        this.hasHoles = false;
        this.numVertices = loop.numVertices();
        this.bound = loop.getRectBound();
        this.subregionBound = loop.getSubregionBound();
        this.initIndex();
    }

    public void initWithNestedLoops(Map<S2Loop, List<S2Loop>> nestedLoops) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        this.initLoop(null, -1, nestedLoops);
        nestedLoops.clear();
        this.initLoopProperties();
    }

    public void release(List<S2Loop> loops) {
        loops.addAll(this.loops);
        this.loops.clear();
        this.bound = S2LatLngRect.empty();
        this.subregionBound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
        this.initIndex();
    }

    private void clearLoops() {
        this.loops.clear();
        this.initIndex();
    }

    @JsIgnore
    public static boolean isValid(List<S2Loop> loops) {
        return new S2Polygon(Lists.newArrayList(loops)).isValid();
    }

    public boolean isValid() {
        S2Error error = new S2Error();
        return !this.findValidationError(error);
    }

    public boolean findValidationError(S2Error error) {
        for (int i = 0; i < this.numLoops(); ++i) {
            if (this.loop(i).findValidationErrorNoIndex(error)) {
                error.init(error.code(), "Loop " + i + ": " + error.text(), new Object[0]);
                return true;
            }
            if (this.loop(i).isEmpty()) {
                error.init(S2Error.Code.POLYGON_EMPTY_LOOP, "Loop " + i + ": empty loops are not allowed.", new Object[0]);
                return true;
            }
            if (!this.loop(i).isFull() || this.numLoops() <= 1) continue;
            error.init(S2Error.Code.POLYGON_EXCESS_FULL_LOOP, "Loop " + i + ": full loop appears in non-full polygon", new Object[0]);
            return true;
        }
        if (S2ShapeUtil.findAnyCrossing(this.index, this.loops, error)) {
            return true;
        }
        return this.findLoopNestingError(error);
    }

    private boolean findLoopNestingError(S2Error error) {
        int lastDepth = -1;
        for (int i = 0; i < this.numLoops(); ++i) {
            int depth = this.loop(i).depth();
            if (depth < 0 || depth > lastDepth + 1) {
                error.init(S2Error.Code.POLYGON_INVALID_LOOP_DEPTH, "Loop %d: invalid loop depth (%d)", i, depth);
                return true;
            }
            lastDepth = depth;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop loop = this.loop(i);
            int last = this.getLastDescendant(i);
            for (int j = 0; j < this.numLoops(); ++j) {
                if (i == j) continue;
                boolean nested = j >= i + 1 && j <= last;
                boolean bReverse = false;
                if (this.containsNonCrossingBoundary(loop, this.loop(j), bReverse) == nested) continue;
                error.init(S2Error.Code.POLYGON_INVALID_LOOP_NESTING, "Invalid nesting: loop %d should %scontain loop %d", i, nested ? "" : "not ", j);
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.loops.isEmpty();
    }

    public boolean isFull() {
        return this.loops.size() == 1 && this.loops.get(0).isFull();
    }

    public int numLoops() {
        return this.loops.size();
    }

    public S2Loop loop(int k) {
        return this.loops.get(k);
    }

    public List<S2Loop> getLoops() {
        return new AbstractList<S2Loop>(){

            @Override
            public int size() {
                return S2Polygon.this.loops.size();
            }

            @Override
            public S2Loop get(int index) {
                return S2Polygon.this.loop(index);
            }
        };
    }

    public S2ShapeIndex index() {
        return this.index;
    }

    public int getParent(int k) {
        int depth = this.loop(k).depth();
        if (depth == 0) {
            return -1;
        }
        while (--k >= 0 && this.loop(k).depth() >= depth) {
        }
        return k;
    }

    public int getLastDescendant(int k) {
        if (k < 0) {
            return this.numLoops() - 1;
        }
        int depth = this.loop(k).depth();
        while (++k < this.numLoops() && this.loop(k).depth() > depth) {
        }
        return k - 1;
    }

    private S2AreaCentroid getAreaCentroid(boolean doCentroid) {
        double areaSum = 0.0;
        S2Point centroidSum = S2Point.ORIGIN;
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Point currentCentroid;
            S2AreaCentroid areaCentroid = doCentroid ? this.loop(i).getAreaAndCentroid() : null;
            double loopArea = doCentroid ? areaCentroid.getArea() : this.loop(i).getArea();
            int loopSign = this.loop(i).sign();
            areaSum += (double)loopSign * loopArea;
            if (!doCentroid || this.loop(i).isEmptyOrFull() || (currentCentroid = areaCentroid.getCentroid()) == null) continue;
            centroidSum = new S2Point(centroidSum.x + (double)loopSign * currentCentroid.x, centroidSum.y + (double)loopSign * currentCentroid.y, centroidSum.z + (double)loopSign * currentCentroid.z);
        }
        return new S2AreaCentroid(areaSum, doCentroid ? centroidSum : null);
    }

    public S2AreaCentroid getAreaAndCentroid() {
        return this.getAreaCentroid(true);
    }

    public double getArea() {
        return this.getAreaCentroid(false).getArea();
    }

    public S2Point getCentroid() {
        return this.getAreaCentroid(true).getCentroid();
    }

    public int getSnapLevel() {
        int snapLevel = -1;
        for (S2Loop loop : this.loops) {
            for (int j = 0; j < loop.numVertices(); ++j) {
                S2Point p = loop.vertex(j);
                S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(p);
                int level = S2Projections.PROJ.levelIfCenter(faceSiTi, p);
                if (level < 0) {
                    return level;
                }
                if (level == snapLevel) continue;
                if (snapLevel < 0) {
                    snapLevel = level;
                    continue;
                }
                return -1;
            }
        }
        return snapLevel;
    }

    int getBestSnapLevel() {
        int[] histogram = new int[31];
        for (S2Loop loop : this.loops) {
            for (S2Point p : loop.vertices()) {
                S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(p);
                int level = S2Projections.PROJ.levelIfCenter(faceSiTi, p);
                if (level < 0) continue;
                int n = level;
                histogram[n] = histogram[n] + 1;
            }
        }
        int snapLevel = 0;
        for (int i = 1; i < histogram.length; ++i) {
            if (histogram[i] <= histogram[snapLevel]) continue;
            snapLevel = i;
        }
        if (histogram[snapLevel] == 0 && !this.isEmpty()) {
            return -1;
        }
        return snapLevel;
    }

    public S1Angle getDistance(S2Point p) {
        if (this.contains(p)) {
            return S1Angle.radians(0.0);
        }
        S1Angle minDistance = S1Angle.radians(Math.PI);
        for (int i = 0; i < this.numLoops(); ++i) {
            minDistance = S1Angle.min(minDistance, this.loop(i).getDistance(p));
        }
        return minDistance;
    }

    public static double getOverlapFraction(S2Polygon a, S2Polygon b) {
        S2Polygon intersection = new S2Polygon();
        intersection.initToIntersection(a, b);
        double intersectionArea = intersection.getArea();
        double aArea = a.getArea();
        if (aArea > 0.0) {
            return intersectionArea >= aArea ? 1.0 : intersectionArea / aArea;
        }
        return 0.0;
    }

    public S2Point project(S2Point p) {
        Preconditions.checkState((!this.loops.isEmpty() ? 1 : 0) != 0);
        if (this.contains(p)) {
            return p;
        }
        S2Point normalized = S2Point.normalize(p);
        S1Angle minDistance = S1Angle.radians(Math.PI);
        int minLoopIndex = 0;
        int minVertexIndex = 0;
        for (int loopIndex = 0; loopIndex < this.loops.size(); ++loopIndex) {
            S2Loop loop = this.loops.get(loopIndex);
            for (int vertexIndex = 0; vertexIndex < loop.numVertices(); ++vertexIndex) {
                S1Angle distanceToSegment = S2EdgeUtil.getDistance(normalized, loop.vertex(vertexIndex), loop.vertex(vertexIndex + 1));
                if (!minDistance.greaterThan(distanceToSegment)) continue;
                minDistance = distanceToSegment;
                minLoopIndex = loopIndex;
                minVertexIndex = vertexIndex;
            }
        }
        S2Loop minLoop = this.loop(minLoopIndex);
        return S2EdgeUtil.getClosestPoint(p, minLoop.vertex(minVertexIndex), minLoop.vertex(minVertexIndex + 1));
    }

    public boolean contains(S2Polygon b) {
        if (this.numLoops() == 1 && b.numLoops() == 1) {
            return this.loop(0).contains(b.loop(0));
        }
        if (!this.subregionBound.contains(b.getRectBound()) && !this.bound.lng().union(b.getRectBound().lng()).isFull()) {
            return false;
        }
        if (!this.hasHoles && !b.hasHoles) {
            for (int j = 0; j < b.numLoops(); ++j) {
                if (this.anyLoopContains(b.loop(j))) continue;
                return false;
            }
            return true;
        }
        return this.containsBoundary(b) && b.excludesNonCrossingComplementShells(this);
    }

    public boolean approxContains(S2Polygon b, S1Angle vertexMergeRadius) {
        S2Polygon difference = new S2Polygon();
        difference.initToDifferenceSloppy(b, this, vertexMergeRadius);
        return difference.numLoops() == 0;
    }

    public boolean intersects(S2Polygon b) {
        if (this.numLoops() == 1 && b.numLoops() == 1) {
            return this.loop(0).intersects(b.loop(0));
        }
        if (!this.bound.intersects(b.getRectBound())) {
            return false;
        }
        if (!this.hasHoles && !b.hasHoles) {
            for (S2Loop loop : b.loops) {
                if (!this.anyLoopIntersects(loop)) continue;
                return true;
            }
            return false;
        }
        return !this.excludesBoundary(b) || !b.excludesNonCrossingShells(this);
    }

    private static void clipBoundary(S2Polygon a, boolean reverseA, S2Polygon b, boolean invertB, boolean addSharedEdges, S2PolygonBuilder builder) {
        EdgeClipper clipper = new EdgeClipper(b.index, addSharedEdges, (Predicate<S2Shape>)((Predicate)S2Polygon::reverseHoles));
        ArrayList intersections = Lists.newArrayList();
        for (S2Loop aLoop : a.loops) {
            int j;
            int n = aLoop.numVertices();
            int dir = aLoop.isHole() ^ reverseA ? -1 : 1;
            boolean inside = b.contains(aLoop.vertex(0)) ^ invertB;
            int n2 = j = dir > 0 ? 0 : n;
            while (n > 0) {
                S2Point a0 = aLoop.vertex(j);
                S2Point a1 = aLoop.vertex(j + dir);
                clipper.clipEdge(a0, a1, intersections);
                if (inside) {
                    intersections.add(new ParametrizedS2Point(0.0, a0));
                }
                boolean bl = inside = (intersections.size() & 1) == 1;
                if (inside) {
                    intersections.add(new ParametrizedS2Point(1.0, a1));
                }
                Collections.sort(intersections);
                for (int k = 0; k < intersections.size(); k += 2) {
                    S2Point y;
                    S2Point x = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                    if (x.equalsPoint(y = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) continue;
                    builder.addEdge(x, y);
                }
                intersections.clear();
                --n;
                j += dir;
            }
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void initToComplement(S2Polygon a) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        this.copy(a);
        this.invert();
    }

    public static S2Polygon fromCellUnionBorder(S2CellUnion cells) {
        double snapRadius = 0.5 * S2Projections.PROJ.minWidth.getValue(30);
        S2PolygonBuilder builder = new S2PolygonBuilder(S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(S1Angle.radians(snapRadius)).build());
        for (S2CellId id : cells) {
            builder.addLoop(new S2Loop(new S2Cell(id)));
        }
        S2Polygon result = builder.assemblePolygon();
        if (result.numLoops() == 0 && !cells.cellIds().isEmpty()) {
            result.invert();
        }
        return result;
    }

    public void initToSnapped(S2Polygon a, int snapLevel) {
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.builder().setRobustnessRadius(S1Angle.radians(S2Projections.PROJ.maxDiag.getValue(snapLevel) / 2.0 + 1.0E-15)).setSnapToCellCenters(true).build();
        S2PolygonBuilder polygonBuilder = new S2PolygonBuilder(options);
        polygonBuilder.addPolygon(a);
        polygonBuilder.assemblePolygon(this, null);
        if (this.numLoops() == 0 && a.bound.area() > Math.PI * 2 && a.getArea() > Math.PI * 2) {
            this.invert();
        }
    }

    private void invert() {
        if (this.isEmpty()) {
            this.loops.add(S2Loop.full());
        } else if (this.isFull()) {
            this.clearLoops();
        } else {
            S2Loop loop;
            int i;
            int best = -1;
            double bestAngle = 0.0;
            for (int i2 = 1; i2 < this.numLoops(); ++i2) {
                double angle;
                S2Loop loop2 = this.loop(i2);
                if (loop2.depth() != 0) continue;
                if (best == -1) {
                    best = 0;
                    bestAngle = this.loop(best).getTurningAngle();
                }
                if (!((angle = loop2.getTurningAngle()) < bestAngle)) continue;
                best = i2;
                bestAngle = angle;
            }
            if (best < 0) {
                best = 0;
            }
            this.loop(best).invert();
            ArrayList newLoops = Lists.newArrayListWithCapacity((int)this.numLoops());
            newLoops.add(this.loop(best));
            int lastBest = this.getLastDescendant(best);
            for (i = 0; i < this.numLoops(); ++i) {
                if (i >= best && i <= lastBest) continue;
                loop = this.loop(i);
                loop.setDepth(loop.depth() + 1);
                newLoops.add(loop);
            }
            for (i = 0; i < this.numLoops(); ++i) {
                if (i <= best || i > lastBest) continue;
                loop = this.loop(i);
                loop.setDepth(loop.depth() - 1);
                newLoops.add(loop);
            }
            Preconditions.checkState((this.loops.size() == newLoops.size() ? 1 : 0) != 0);
            this.loops.clear();
            this.loops.addAll(newLoops);
        }
        this.initLoopProperties();
    }

    public void initToIntersection(S2Polygon a, S2Polygon b) {
        this.initToIntersectionSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToIntersectionSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!a.isEmpty() && !b.isEmpty()) {
            if (a.isFull()) {
                this.copy(b);
            } else if (b.isFull()) {
                this.copy(a);
            } else {
                if (!a.bound.intersects(b.bound)) {
                    return;
                }
                S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
                S2PolygonBuilder builder = new S2PolygonBuilder(options);
                S2Polygon.clipBoundary(a, false, b, false, true, builder);
                S2Polygon.clipBoundary(b, false, a, false, false, builder);
                builder.assemblePolygon(this, null);
                if (this.numLoops() == 0) {
                    double maxArea;
                    double bArea;
                    if (a.bound.area() <= Math.PI * 2 || b.bound.area() <= Math.PI * 2) {
                        return;
                    }
                    double aArea = a.getArea();
                    double minArea = Math.max(0.0, aArea + (bArea = b.getArea()) - Math.PI * 4);
                    if (minArea > Math.PI * 4 - (maxArea = Math.min(aArea, bArea))) {
                        this.invert();
                    }
                }
            }
        }
    }

    public void initToUnion(S2Polygon a, S2Polygon b) {
        this.initToUnionSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToUnionSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (a.isEmpty() || b.isFull()) {
            this.copy(b);
        } else if (b.isEmpty() || a.isFull()) {
            this.copy(a);
        } else {
            S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
            S2PolygonBuilder builder = new S2PolygonBuilder(options);
            S2Polygon.clipBoundary(a, false, b, true, true, builder);
            S2Polygon.clipBoundary(b, false, a, true, false, builder);
            builder.assemblePolygon(this, null);
            if (this.numLoops() == 0) {
                double maxArea;
                double bArea;
                if (a.bound.area() + b.bound.area() <= Math.PI * 2) {
                    return;
                }
                double aArea = a.getArea();
                double minArea = Math.max(aArea, bArea = b.getArea());
                if (minArea > Math.PI * 4 - (maxArea = Math.min(Math.PI * 4, aArea + bArea))) {
                    this.invert();
                }
            }
        }
    }

    public void initToDifference(S2Polygon a, S2Polygon b) {
        this.initToDifferenceSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToDifferenceSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!a.isEmpty() && !b.isFull()) {
            if (a.isFull()) {
                this.initToComplement(b);
            } else {
                S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
                S2PolygonBuilder builder = new S2PolygonBuilder(options);
                S2Polygon.clipBoundary(a, false, b, true, true, builder);
                S2Polygon.clipBoundary(b, true, a, false, false, builder);
                builder.assemblePolygon(this, null);
                if (this.numLoops() == 0) {
                    double maxArea;
                    double bArea;
                    if (a.bound.area() <= Math.PI * 2 || b.bound.area() >= Math.PI * 2) {
                        return;
                    }
                    double aArea = a.getArea();
                    double minArea = Math.max(0.0, aArea - (bArea = b.getArea()));
                    if (minArea > Math.PI * 4 - (maxArea = Math.min(aArea, Math.PI * 4 - bArea))) {
                        this.invert();
                    }
                }
            }
        }
    }

    public void initToSimplified(S2Polygon a, S1Angle tolerance, boolean snapToCellCenters) {
        this.initToSimplifiedInternal(a, tolerance, snapToCellCenters, null);
    }

    public void initToSimplifiedInCell(S2Polygon a, final S2Cell cell, S1Angle tolerance) {
        this.initToSimplifiedInternal(a, tolerance, false, new Predicate<S2Point>(){
            private final S2Point[] corners;
            private final S1Angle d;
            {
                this.corners = new S2Point[]{cell.getVertex(0), cell.getVertex(1), cell.getVertex(2), cell.getVertex(3)};
                this.d = S1Angle.radians(1.0E-15);
            }

            public boolean apply(S2Point vertex) {
                for (int i = 0; i < 4; ++i) {
                    if (!S2EdgeUtil.getDistance(vertex, this.corners[i], this.corners[(i + 1) % 4]).lessThan(this.d)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void initToSimplifiedInternal(S2Polygon a, S1Angle tolerance, boolean snapToCellCenters, Predicate<S2Point> vertexFilter) {
        S2PolygonBuilder.Options.Builder options = S2PolygonBuilder.Options.UNDIRECTED_XOR.toBuilder();
        options.setValidate(false);
        if (vertexFilter != null) {
            options.setMergeDistance(S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
        } else {
            options.setMergeDistance(S1Angle.radians(tolerance.radians() * 0.1));
            options.setSnapToCellCenters(snapToCellCenters);
        }
        S2PolygonBuilder builder = new S2PolygonBuilder(options.build());
        S2ShapeIndex index = new S2ShapeIndex();
        for (int i = 0; i < a.numLoops(); ++i) {
            S2Loop simpler = a.loop(i).simplify(tolerance, vertexFilter);
            if (simpler == null) continue;
            index.add(simpler);
        }
        if (!index.shapes.isEmpty()) {
            S2Polygon.breakEdgesAndAddToBuilder(index, builder);
            builder.assemblePolygon(this, null);
            if (this.numLoops() == 0 && a.bound.area() > Math.PI * 2 && a.getArea() > Math.PI * 2) {
                this.invert();
            }
        }
    }

    public static void breakEdgesAndAddToBuilder(S2ShapeIndex index, S2PolygonBuilder builder) {
        EdgeClipper clipper = new EdgeClipper(index, true, (Predicate<S2Shape>)((Predicate)S2Polygon::reverseNone));
        ArrayList intersections = Lists.newArrayList();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (S2Shape shape : index.getShapes()) {
            int numEdges = shape.numEdges();
            for (int e = 0; e < numEdges; ++e) {
                shape.getEdge(e, edge);
                if (edge.a.equalsPoint(edge.b)) continue;
                intersections.add(new ParametrizedS2Point(0.0, edge.a));
                clipper.clipEdge(edge.a, edge.b, intersections);
                intersections.add(new ParametrizedS2Point(1.0, edge.b));
                Collections.sort(intersections);
                int k = 0;
                while (k + 1 < intersections.size()) {
                    S2Point p2;
                    S2Point p1 = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                    if (!p1.equalsPoint(p2 = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) {
                        builder.addEdge(p1, p2);
                    }
                    ++k;
                }
                intersections.clear();
            }
        }
    }

    public static S2Polygon union(Iterable<S2Polygon> polygons) {
        return S2Polygon.unionSloppy(polygons, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public static S2Polygon unionSloppy(Iterable<S2Polygon> polygons, S1Angle vertexMergeRadius) {
        TreeMultimap queue = TreeMultimap.create();
        for (S2Polygon polygon : polygons) {
            queue.put((Object)polygon.getNumVertices(), (Object)polygon);
        }
        Set queueSet = queue.entries();
        while (queueSet.size() > 1) {
            queueSet = queue.entries();
            Iterator smallestIter = queueSet.iterator();
            Map.Entry smallest = (Map.Entry)smallestIter.next();
            int aSize = (Integer)smallest.getKey();
            S2Polygon aPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            smallest = (Map.Entry)smallestIter.next();
            int bSize = (Integer)smallest.getKey();
            S2Polygon bPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            S2Polygon unionPolygon = new S2Polygon();
            unionPolygon.initToUnionSloppy(aPolygon, bPolygon, vertexMergeRadius);
            int unionSize = aSize + bSize;
            queue.put((Object)unionSize, (Object)unionPolygon);
        }
        if (queue.isEmpty()) {
            return new S2Polygon();
        }
        return (S2Polygon)queue.get((Object)((Integer)queue.asMap().firstKey())).first();
    }

    public List<S2Polyline> intersectWithPolyline(S2Polyline in) {
        return this.intersectWithPolylineSloppy(in, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public List<S2Polyline> intersectWithPolylineSloppy(S2Polyline in, S1Angle vertexMergeRadius) {
        return this.internalClipPolyline(false, in, vertexMergeRadius);
    }

    public List<S2Polyline> subtractFromPolyline(S2Polyline in) {
        return this.subtractFromPolylineSloppy(in, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public List<S2Polyline> subtractFromPolylineSloppy(S2Polyline in, S1Angle vertexMergeRadius) {
        return this.internalClipPolyline(true, in, vertexMergeRadius);
    }

    private List<S2Polyline> internalClipPolyline(boolean invert, S2Polyline a, S1Angle mergeRadius) {
        ArrayList out = Lists.newArrayList();
        EdgeClipper clipper = new EdgeClipper(this.index, true, (Predicate<S2Shape>)((Predicate)S2Polygon::reverseNone));
        ArrayList intersections = Lists.newArrayList();
        ArrayList vertices = Lists.newArrayList();
        int n = a.numVertices();
        boolean inside = this.contains(a.vertex(0)) ^ invert;
        for (int j = 0; j < n - 1; ++j) {
            S2Point a0 = a.vertex(j);
            S2Point a1 = a.vertex(j + 1);
            clipper.clipEdge(a0, a1, intersections);
            if (inside) {
                intersections.add(new ParametrizedS2Point(0.0, a0));
            }
            boolean bl = inside = (intersections.size() & 1) != 0;
            if (inside) {
                intersections.add(new ParametrizedS2Point(1.0, a1));
            }
            Collections.sort(intersections);
            for (int k = 0; k < intersections.size(); k += 2) {
                S2Point v1;
                S2Point v0 = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                if (v0.equalsPoint(v1 = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) continue;
                if (!vertices.isEmpty() && ((S2Point)vertices.get(vertices.size() - 1)).angle(v0) > mergeRadius.radians()) {
                    out.add(new S2Polyline(vertices));
                    vertices.clear();
                }
                if (vertices.isEmpty()) {
                    vertices.add(v0);
                }
                if (!(((S2Point)vertices.get(vertices.size() - 1)).angle(v1) > mergeRadius.radians())) continue;
                vertices.add(v1);
            }
            intersections.clear();
        }
        if (!vertices.isEmpty()) {
            out.add(new S2Polyline(vertices));
        }
        return out;
    }

    public boolean isNormalized() {
        HashSet vertices = Sets.newHashSet();
        S2Loop lastParent = null;
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop child = this.loop(i);
            if (child.depth() == 0) continue;
            S2Loop parent = this.loop(this.getParent(i));
            if (parent != lastParent) {
                vertices.clear();
                for (int j = 0; j < parent.numVertices(); ++j) {
                    vertices.add(parent.vertex(j));
                }
                lastParent = parent;
            }
            int count = 0;
            for (int j = 0; j < child.numVertices(); ++j) {
                if (!vertices.contains(child.vertex(j))) continue;
                ++count;
            }
            if (count <= true) continue;
            return false;
        }
        return true;
    }

    boolean boundaryApproxEquals(S2Polygon b, double maxError) {
        if (this.numLoops() != b.numLoops()) {
            return false;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop aLoop = this.loop(i);
            boolean success = false;
            for (int j = 0; j < this.numLoops(); ++j) {
                S2Loop bLoop = b.loop(j);
                if (bLoop.depth() != aLoop.depth() || !bLoop.boundaryApproxEquals(aLoop, maxError)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    boolean boundaryNear(S2Polygon b, double maxError) {
        if (this.numLoops() != b.numLoops()) {
            return false;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop aLoop = this.loop(i);
            boolean success = false;
            for (int j = 0; j < this.numLoops(); ++j) {
                S2Loop bLoop = b.loop(j);
                if (bLoop.depth() != aLoop.depth() || !bLoop.boundaryNear(aLoop, maxError)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    @Override
    @JsIgnore
    public boolean contains(S2Cell cell) {
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(cell.id());
        if (relation != S2ShapeIndex.CellRelation.INDEXED) {
            return false;
        }
        if (this.boundaryApproxIntersects(it, cell)) {
            return false;
        }
        return this.contains(it, cell.getCenter());
    }

    @Override
    public boolean mayIntersect(S2Cell target) {
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(target.id());
        if (relation == S2ShapeIndex.CellRelation.DISJOINT) {
            return false;
        }
        if (relation == S2ShapeIndex.CellRelation.SUBDIVIDED) {
            return true;
        }
        if (this.boundaryApproxIntersects(it, target)) {
            return true;
        }
        return this.contains(it, target.getCenter());
    }

    private boolean boundaryApproxIntersects(S2Iterator<S2ShapeIndex.Cell> it, S2Cell target) {
        S2ShapeIndex.Cell cell = it.entry();
        R2Rect bound = target.getBoundUV().expanded(S2EdgeUtil.MAX_CELL_EDGE_ERROR);
        R2Vector v0 = new R2Vector();
        R2Vector v1 = new R2Vector();
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            int aNumClipped = aClipped.numEdges();
            if (aNumClipped == 0) continue;
            if (it.compareTo(target.id()) == 0) {
                return true;
            }
            S2Loop aLoop = (S2Loop)aClipped.shape();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                if (!S2EdgeUtil.clipToPaddedFace(aLoop.vertex(ai), aLoop.vertex(ai + 1), target.face(), S2EdgeUtil.MAX_CELL_EDGE_ERROR, v0, v1) || !S2EdgeUtil.intersectsRect(v0, v1, bound)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(S2Point p) {
        if (!this.index.isFresh() && !this.bound.contains(p)) {
            return false;
        }
        int maxBruteForceVertices = 32;
        if (this.getNumVertices() <= maxBruteForceVertices || !this.index.isFresh() && this.unindexedContainsCalls.decrementAndGet() > 0) {
            boolean inside = false;
            for (int i = 0; i < this.numLoops(); ++i) {
                boolean loopContainsP = this.loop(i).bruteForceContains(p);
                inside ^= loopContainsP;
            }
            return inside;
        }
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        if (!it.locate(p)) {
            return false;
        }
        return this.contains(it, p);
    }

    private boolean contains(S2Iterator<S2ShapeIndex.Cell> it, S2Point p) {
        S2ShapeIndex.Cell cell = it.entry();
        boolean inside = false;
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(it.center(), p);
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            inside ^= aClipped.containsCenter();
            int aNumClipped = aClipped.numEdges();
            if (aNumClipped <= 0) continue;
            int aiPrev = -2;
            S2Loop aLoop = (S2Loop)aClipped.shape();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                if (ai != aiPrev + 1) {
                    crosser.restartAt(aLoop.vertex(ai));
                }
                aiPrev = ai;
                inside ^= crosser.edgeOrVertexCrossing(aLoop.vertex(ai + 1));
            }
        }
        return inside;
    }

    private static void sortValueLoops(Map<S2Loop, List<S2Loop>> loopMap) {
        for (List<S2Loop> value : loopMap.values()) {
            Collections.sort(value);
        }
    }

    private static void insertLoop(S2Loop newLoop, S2Loop parent, Map<S2Loop, List<S2Loop>> loopMap) {
        ArrayList children = loopMap.get(parent);
        if (children == null) {
            children = Lists.newArrayList();
            loopMap.put(parent, children);
        }
        for (S2Loop child : children) {
            if (!child.containsNested(newLoop)) continue;
            S2Polygon.insertLoop(newLoop, child, loopMap);
            return;
        }
        ArrayList newChildren = loopMap.get(newLoop);
        int i = 0;
        while (i < children.size()) {
            S2Loop child = (S2Loop)children.get(i);
            if (newLoop.containsNested(child)) {
                if (newChildren == null) {
                    newChildren = Lists.newArrayList();
                    loopMap.put(newLoop, newChildren);
                }
                newChildren.add(child);
                children.remove(i);
                continue;
            }
            ++i;
        }
        children.add(newLoop);
    }

    private void initLoop(S2Loop loop, int depth, Map<S2Loop, List<S2Loop>> loopMap) {
        List<S2Loop> children;
        if (loop != null) {
            loop.setDepth(depth);
            this.loops.add(loop);
        }
        if ((children = loopMap.get(loop)) != null) {
            for (S2Loop child : children) {
                this.initLoop(child, depth + 1, loopMap);
            }
        }
    }

    int compareBoundary(S2Loop b) {
        int result = -1;
        for (S2Loop loop : this.loops) {
            if ((result *= -loop.compareBoundary(b)) == 0) break;
        }
        return result;
    }

    private boolean containsBoundary(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (this.compareBoundary(loop) > 0) continue;
            return false;
        }
        return true;
    }

    private boolean excludesBoundary(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (this.compareBoundary(loop) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean containsNonCrossingBoundary(S2Loop b, boolean bReverse) {
        boolean inside = false;
        for (S2Loop a : this.loops) {
            inside ^= this.containsNonCrossingBoundary(a, b, bReverse);
        }
        return inside;
    }

    private boolean containsNonCrossingBoundary(S2Loop a, S2Loop b, boolean bReverse) {
        S2Point b0;
        assert (!a.isEmpty() && !b.isEmpty());
        assert (!b.isFull() || !bReverse);
        if (!a.getRectBound().intersects(b.getRectBound())) {
            return false;
        }
        if (a.isFull()) {
            return true;
        }
        if (b.isFull()) {
            return false;
        }
        S2Iterator<S2ShapeIndex.Cell> it = this.index.iterator();
        if (!it.locate(b0 = b.vertex(0))) {
            return false;
        }
        S2ShapeIndex.S2ClippedShape shape = it.entry().findClipped(a);
        if (shape == null) {
            return false;
        }
        for (int i = 0; i < shape.numEdges(); ++i) {
            int edge = shape.edge(i);
            if (!b0.equalsPoint(a.vertex(edge))) continue;
            return S2Loop.wedgeContainsSemiwedge(a.vertex((edge == 0 ? a.numVertices() : edge) - 1), a.vertex(edge), a.vertex(edge + 1), b.vertex(1), bReverse);
        }
        return S2ContainsPointQuery.S2VertexModel.OPEN.shapeContains(it.center(), shape, b.vertex(0));
    }

    private boolean excludesNonCrossingShells(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (loop.isHole() || !this.containsNonCrossingBoundary(loop, false)) continue;
            return false;
        }
        return true;
    }

    private boolean excludesNonCrossingComplementShells(S2Polygon b) {
        if (b.isEmpty()) {
            return !this.isFull();
        }
        if (b.isFull()) {
            return true;
        }
        for (int j = 0; j < b.numLoops(); ++j) {
            if (j > 0 && !b.loop(j).isHole() || !this.containsNonCrossingBoundary(b.loop(j), j == 0)) continue;
            return false;
        }
        return true;
    }

    private boolean anyLoopContains(S2Loop b) {
        for (S2Loop loop : this.loops) {
            if (!loop.contains(b)) continue;
            return true;
        }
        return false;
    }

    private boolean anyLoopIntersects(S2Loop b) {
        for (S2Loop loop : this.loops) {
            if (!loop.intersects(b)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon: (").append(this.numLoops()).append(") loops:\n");
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop s2Loop = this.loop(i);
            sb.append("loop <\n");
            for (int v = 0; v < s2Loop.numVertices(); ++v) {
                S2Point s2Point = s2Loop.vertex(v);
                sb.append(s2Point.toDegreesString());
                sb.append("\n");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }

    public void encode(OutputStream output) throws IOException {
        int level = this.getNumVertices() == 0 ? 30 : this.getBestSnapLevel();
        LittleEndianOutput encoder = new LittleEndianOutput(output);
        if (level == -1) {
            this.encodeUncompressed(encoder);
        } else {
            this.encodeCompressed(level, encoder);
        }
    }

    @VisibleForTesting
    public void encodeUncompressed(LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)1);
        encoder.writeByte((byte)1);
        encoder.writeByte((byte)(this.hasHoles ? 1 : 0));
        encoder.writeInt(this.loops.size());
        for (S2Loop loop : this.loops) {
            loop.encode(encoder);
        }
        this.bound.encode(encoder);
    }

    private void encodeCompressed(int level, LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)4);
        encoder.writeByte((byte)level);
        encoder.writeVarint32(this.numLoops());
        for (int i = 0; i < this.numLoops(); ++i) {
            this.loop(i).encodeCompressed(level, encoder);
        }
    }

    public static S2Polygon decode(InputStream input) throws IOException {
        LittleEndianInput decoder = new LittleEndianInput(input);
        byte version = decoder.readByte();
        switch (version) {
            case 1: {
                return S2Polygon.decodeUncompressed(decoder);
            }
            case 4: {
                return S2Polygon.decodeCompressed(decoder);
            }
        }
        throw new IOException("Unsupported S2Polygon encoding version " + version);
    }

    @VisibleForTesting
    public static S2Polygon decodeUncompressed(LittleEndianInput decoder) throws IOException {
        S2Polygon result = new S2Polygon();
        decoder.readByte();
        result.hasHoles = decoder.readByte() == 1;
        result.numVertices = 0;
        int numLoops = decoder.readInt();
        Preconditions.checkState((numLoops >= 0 ? 1 : 0) != 0, (Object)"Can only decode polygons with up to 2^31 - 1 loops");
        for (int i = 0; i < numLoops; ++i) {
            S2Loop loop = S2Loop.decode(decoder);
            result.numVertices += loop.numVertices();
            result.loops.add(loop);
        }
        result.bound = S2LatLngRect.decode(decoder);
        result.subregionBound = S2EdgeUtil.RectBounder.expandForSubregions(result.bound);
        result.initIndex();
        return result;
    }

    private static S2Polygon decodeCompressed(LittleEndianInput decoder) throws IOException {
        byte level = decoder.readByte();
        if (level > 30) {
            throw new IOException("Invalid level");
        }
        int numLoops = decoder.readVarint32();
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>(numLoops);
        for (int i = 0; i < numLoops; ++i) {
            loops.add(S2Loop.decodeCompressed(level, decoder));
        }
        S2Polygon result = new S2Polygon();
        result.loops.addAll(loops);
        result.initLoopProperties();
        return result;
    }

    public Shape shape() {
        if (this.numLoops() > 5) {
            return this.binarySearchShape();
        }
        return this.linearSearchShape();
    }

    Shape binarySearchShape() {
        final int[] cumulativeEdges = new int[this.numLoops()];
        int numEdges = 0;
        for (int i = 0; i < this.loops.size(); ++i) {
            cumulativeEdges[i] = numEdges;
            numEdges += this.loops.get(i).numVertices();
        }
        return new Shape(this){
            private static final long serialVersionUID = 1L;

            @Override
            public void getEdge(int edgeId, S2Shape.MutableEdge result) {
                int start = Arrays.binarySearch(cumulativeEdges, edgeId);
                if (start < 0) {
                    start = -start - 2;
                }
                S2Loop loop = S2Polygon.this.loop(start);
                result.set(loop.orientedVertex(edgeId -= cumulativeEdges[start]), loop.orientedVertex(edgeId + 1));
            }

            @Override
            public int getChainStart(int chainId) {
                Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
                return cumulativeEdges[chainId];
            }
        };
    }

    Shape linearSearchShape() {
        return new Shape(this){
            private static final long serialVersionUID = 1L;

            @Override
            public void getEdge(int edgeId, S2Shape.MutableEdge result) {
                S2Loop loop = S2Polygon.this.loop(0);
                int i = 1;
                while (edgeId >= loop.numVertices()) {
                    edgeId -= loop.numVertices();
                    loop = S2Polygon.this.loop(i++);
                }
                result.set(loop.orientedVertex(edgeId), loop.orientedVertex(edgeId + 1));
            }

            @Override
            public int getChainStart(int chainId) {
                Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
                int start = 0;
                for (int i = 0; i < chainId; ++i) {
                    start += ((S2Loop)S2Polygon.this.loops.get(i)).numVertices();
                }
                return start;
            }
        };
    }

    public strictfp static abstract class Shape
    implements S2Shape,
    Serializable {
        private final S2Polygon polygon;
        public static final S2Coder<Shape> FAST_CODER = FAST_CODER.delegating(Shape::polygon, S2Polygon::shape);
        public static final S2Coder<Shape> COMPACT_CODER = COMPACT_CODER.delegating(Shape::polygon, S2Polygon::shape);
        private static final int MAX_LINEAR_SEARCH_LOOPS = 5;
        private static final long serialVersionUID = 1L;

        public Shape(S2Polygon polygon) {
            this.polygon = polygon;
        }

        public S2Polygon polygon() {
            return this.polygon;
        }

        @Override
        public int numEdges() {
            return this.polygon.isFull() ? 0 : this.polygon.numVertices;
        }

        @Override
        public boolean hasInterior() {
            return true;
        }

        @Override
        public boolean containsOrigin() {
            boolean containsOrigin = false;
            for (S2Loop loop : this.polygon.loops) {
                containsOrigin ^= loop.containsOrigin();
            }
            return containsOrigin;
        }

        @Override
        public int numChains() {
            return this.polygon.numLoops();
        }

        @Override
        public int getChainLength(int chainId) {
            Preconditions.checkElementIndex((int)chainId, (int)this.numChains());
            return this.polygon.isFull() ? 0 : ((S2Loop)this.polygon.loops.get(chainId)).numVertices();
        }

        @Override
        public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
            Preconditions.checkElementIndex((int)offset, (int)this.getChainLength(chainId));
            S2Loop loop = this.polygon.loop(chainId);
            result.set(loop.orientedVertex(offset), loop.orientedVertex(offset + 1));
        }

        @Override
        public S2Point getChainVertex(int chainId, int edgeOffset) {
            Preconditions.checkElementIndex((int)edgeOffset, (int)(this.getChainLength(chainId) + 1));
            S2Loop loop = this.polygon.loop(chainId);
            return loop.orientedVertex(edgeOffset);
        }

        @Override
        public int dimension() {
            return 2;
        }
    }

    private strictfp static class EdgeClipper {
        private final S2EdgeQuery query;
        private final boolean addSharedEdges;
        private final Predicate<S2Shape> reverseEdges;

        public EdgeClipper(S2ShapeIndex index, boolean addSharedEdges, Predicate<S2Shape> reverseEdges) {
            this.query = new S2EdgeQuery(index);
            this.addSharedEdges = addSharedEdges;
            this.reverseEdges = reverseEdges;
        }

        public void clipEdge(S2Point a0, S2Point a1, List<ParametrizedS2Point> intersections) {
            Map<S2Shape, S2EdgeQuery.Edges> edgeMap = this.query.getCandidates(a0, a1);
            if (edgeMap.isEmpty()) {
                return;
            }
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(a0, a1);
            S2Shape.MutableEdge result = new S2Shape.MutableEdge();
            for (Map.Entry<S2Shape, S2EdgeQuery.Edges> entry : edgeMap.entrySet()) {
                S2Shape bShape = entry.getKey();
                S2EdgeQuery.Edges edges = entry.getValue();
                int b1Prev = -2;
                while (!edges.isEmpty()) {
                    int crossing;
                    int edge = edges.nextEdge();
                    bShape.getEdge(edge, result);
                    if (edge != b1Prev + 1) {
                        crosser.restartAt(result.getStart());
                    }
                    if ((crossing = crosser.robustCrossing(result.getEnd())) < 0) continue;
                    this.addIntersection(a0, a1, result.getStart(), result.getEnd(), bShape, crossing, intersections);
                    b1Prev = edge;
                }
            }
        }

        private void addIntersection(S2Point a0, S2Point a1, S2Point b0, S2Point b1, S2Shape bShape, int crossing, List<ParametrizedS2Point> intersections) {
            if (crossing > 0) {
                S2Point x = S2EdgeUtil.getIntersection(a0, a1, b0, b1);
                double t = S2EdgeUtil.getDistanceFraction(x, a0, a1);
                intersections.add(new ParametrizedS2Point(t, x));
            } else if (S2EdgeUtil.vertexCrossing(a0, a1, b0, b1)) {
                double t;
                double d = t = a0.equalsPoint(b0) || a0.equalsPoint(b1) ? 0.0 : 1.0;
                if (!this.addSharedEdges && a1.equalsPoint(this.reverseEdges.apply((Object)bShape) ? b0 : b1)) {
                    t = 1.0;
                }
                intersections.add(new ParametrizedS2Point(t, t == 0.0 ? a0 : a1));
            }
        }
    }

    @GwtCompatible(serializable=false)
    private strictfp static final class LoopVertexIndexPair {
        private final int loopIndex;
        private final int vertexIndex;

        public LoopVertexIndexPair(int loopIndex, int vertexIndex) {
            this.loopIndex = loopIndex;
            this.vertexIndex = vertexIndex;
        }

        public int getLoopIndex() {
            return this.loopIndex;
        }

        public int getVertexIndex() {
            return this.vertexIndex;
        }
    }

    public strictfp static final class S2PolygonIndex
    extends S2LoopSequenceIndex {
        private final S2Polygon poly;
        private final boolean reverse;

        private static int[] getVertices(S2Polygon poly) {
            int[] vertices = new int[poly.numLoops()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = poly.loop(i).numVertices();
            }
            return vertices;
        }

        public S2PolygonIndex(S2Polygon poly) {
            this(poly, false);
        }

        S2PolygonIndex(S2Polygon poly, boolean reverse) {
            super(S2PolygonIndex.getVertices(poly));
            this.poly = poly;
            this.reverse = reverse;
        }

        @Override
        public S2Edge edgeFromTo(int index) {
            int toIndex;
            int fromIndex;
            LoopVertexIndexPair indices = this.decodeIndex(index);
            int loopIndex = indices.getLoopIndex();
            int vertexInLoop = indices.getVertexIndex();
            S2Loop loop = this.poly.loop(loopIndex);
            if (loop.isHole() ^ this.reverse) {
                fromIndex = loop.numVertices() - 1 - vertexInLoop;
                toIndex = 2 * loop.numVertices() - 2 - vertexInLoop;
            } else {
                fromIndex = vertexInLoop;
                toIndex = vertexInLoop + 1;
            }
            S2Point from = loop.vertex(fromIndex);
            S2Point to = loop.vertex(toIndex);
            return new S2Edge(from, to);
        }
    }

    private strictfp static abstract class S2LoopSequenceIndex
    extends S2EdgeIndex {
        private final int[] indexToLoop;
        private final int[] loopToFirstIndex;

        public S2LoopSequenceIndex(int[] numVertices) {
            int totalEdges = 0;
            for (int edges : numVertices) {
                totalEdges += edges;
            }
            this.indexToLoop = new int[totalEdges];
            this.loopToFirstIndex = new int[numVertices.length];
            totalEdges = 0;
            for (int j = 0; j < numVertices.length; ++j) {
                this.loopToFirstIndex[j] = totalEdges;
                for (int i = 0; i < numVertices[j]; ++i) {
                    this.indexToLoop[totalEdges] = j;
                    ++totalEdges;
                }
            }
        }

        public final LoopVertexIndexPair decodeIndex(int index) {
            int loopIndex = this.indexToLoop[index];
            int vertexInLoop = index - this.loopToFirstIndex[loopIndex];
            return new LoopVertexIndexPair(loopIndex, vertexInLoop);
        }

        @Override
        public final int getNumEdges() {
            return this.indexToLoop.length;
        }

        @Override
        public abstract S2Edge edgeFromTo(int var1);

        @Override
        public S2Point edgeFrom(int index) {
            return this.edgeFromTo(index).getStart();
        }

        @Override
        public S2Point edgeTo(int index) {
            return this.edgeFromTo(index).getEnd();
        }
    }
}

