/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp final class S2RegionCoverer
implements Serializable {
    public static final S2RegionCoverer DEFAULT = S2RegionCoverer.builder().build();
    private static final ImmutableList<S2Cell> FACE_CELLS;
    private final int minLevel;
    private final int maxLevel;
    private final int levelMod;
    private final int maxCells;

    public static Builder builder() {
        return new Builder();
    }

    private S2RegionCoverer(Builder builder) {
        this.minLevel = builder.getMinLevel();
        this.maxLevel = builder.getMaxLevel();
        this.levelMod = builder.getLevelMod();
        this.maxCells = builder.getMaxCells();
    }

    public boolean equals(Object obj) {
        if (obj instanceof S2RegionCoverer) {
            S2RegionCoverer that = (S2RegionCoverer)obj;
            return this.minLevel == that.minLevel && this.maxLevel == that.maxLevel && this.levelMod == that.levelMod && this.maxCells == that.maxCells;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.minLevel, this.maxLevel, this.levelMod, this.maxCells});
    }

    public int minLevel() {
        return this.minLevel;
    }

    public int maxLevel() {
        return this.maxLevel;
    }

    public int maxCells() {
        return this.maxCells;
    }

    public int levelMod() {
        return this.levelMod;
    }

    @JsMethod(name="getCoveringList")
    public void getCovering(S2Region region, ArrayList<S2CellId> covering) {
        S2CellUnion tmp = this.getCovering(region);
        tmp.denormalize(this.minLevel(), this.levelMod(), covering);
    }

    @JsMethod(name="getInteriorCoveringList")
    public void getInteriorCovering(S2Region region, ArrayList<S2CellId> interior) {
        S2CellUnion tmp = this.getInteriorCovering(region);
        tmp.denormalize(this.minLevel(), this.levelMod(), interior);
    }

    public S2CellUnion getCovering(S2Region region) {
        S2CellUnion covering = new S2CellUnion();
        this.getCovering(region, covering);
        return covering;
    }

    @JsMethod(name="getCoveringCellUnion")
    public void getCovering(S2Region region, S2CellUnion covering) {
        ActiveCovering state = new ActiveCovering(false, region);
        state.getCoveringInternal();
        covering.initSwap(state.result);
    }

    public S2CellUnion getInteriorCovering(S2Region region) {
        S2CellUnion covering = new S2CellUnion();
        this.getInteriorCovering(region, covering);
        return covering;
    }

    @JsMethod(name="getInteriorCoveringCellUnion")
    public void getInteriorCovering(S2Region region, S2CellUnion covering) {
        ActiveCovering state = new ActiveCovering(true, region);
        state.getCoveringInternal();
        covering.initSwap(state.result);
    }

    public static void getSimpleCovering(S2Region region, S2Point start, int level, ArrayList<S2CellId> output) {
        S2RegionCoverer.floodFill(region, S2CellId.fromPoint(start).parent(level), output);
    }

    public void getFastCovering(S2Cap cap, ArrayList<S2CellId> results) {
        S2RegionCoverer.getRawFastCovering(cap, this.maxCells(), results);
        this.normalizeCovering(results);
    }

    private static void getRawFastCovering(S2Cap cap, int maxCellsHint, List<S2CellId> covering) {
        covering.clear();
        int level = S2Projections.PROJ.minWidth.getMaxLevel(2.0 * cap.angle().radians());
        level = Math.min(level, 29);
        if (level == 0) {
            Collections.addAll(covering, S2CellId.FACE_CELLS);
        } else {
            S2CellId id = S2CellId.fromPoint(cap.axis());
            id.getVertexNeighbors(level, covering);
        }
    }

    public void normalizeCovering(ArrayList<S2CellId> covering) {
        if (this.maxLevel() < 30 || this.levelMod() > 1) {
            for (int i = 0; i < covering.size(); ++i) {
                S2CellId id = covering.get(i);
                int level = id.level();
                int newLevel = this.adjustLevel(Math.min(level, this.maxLevel()));
                if (newLevel == level) continue;
                covering.set(i, id.parent(newLevel));
            }
        }
        S2CellUnion.normalize(covering);
        while (covering.size() > this.maxCells()) {
            int bestIndex = -1;
            int bestLevel = -1;
            int i = 0;
            while (i + 1 < covering.size()) {
                int level = covering.get(i).getCommonAncestorLevel(covering.get(i + 1));
                if ((level = this.adjustLevel(level)) > bestLevel) {
                    bestLevel = level;
                    bestIndex = i;
                }
                ++i;
            }
            if (bestLevel < this.minLevel()) break;
            covering.set(bestIndex, covering.get(bestIndex).parent(bestLevel));
            S2CellUnion.normalize(covering);
        }
        if (this.minLevel() > 0 || this.levelMod() > 1) {
            S2CellUnion result = new S2CellUnion();
            result.initRawSwap(covering);
            result.denormalize(this.minLevel(), this.levelMod(), covering);
        }
    }

    private int adjustLevel(int level) {
        if (this.levelMod() > 1 && level > this.minLevel()) {
            level -= (level - this.minLevel()) % this.levelMod();
        }
        return level;
    }

    private static void floodFill(S2Region region, S2CellId start, ArrayList<S2CellId> output) {
        HashSet<S2CellId> all = new HashSet<S2CellId>();
        ArrayList<S2CellId> frontier = new ArrayList<S2CellId>();
        output.clear();
        all.add(start);
        frontier.add(start);
        while (!frontier.isEmpty()) {
            S2CellId id = (S2CellId)frontier.get(frontier.size() - 1);
            frontier.remove(frontier.size() - 1);
            if (!region.mayIntersect(new S2Cell(id))) continue;
            output.add(id);
            S2CellId[] neighbors = new S2CellId[4];
            id.getEdgeNeighbors(neighbors);
            for (int edge = 0; edge < 4; ++edge) {
                S2CellId nbr = neighbors[edge];
                if (all.contains(nbr)) continue;
                frontier.add(nbr);
                all.add(nbr);
            }
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int face = 0; face < 6; ++face) {
            builder.add((Object)S2Cell.fromFace(face));
        }
        FACE_CELLS = builder.build();
    }

    @JsType
    public strictfp static final class Builder {
        private static final int DEFAULT_MAX_CELLS = 8;
        private int minLevel = 0;
        private int maxLevel = 30;
        private int levelMod = 1;
        private int maxCells = 8;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setMinLevel(int minLevel) {
            this.minLevel = Math.max(0, Math.min(30, minLevel));
            return this;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        @CanIgnoreReturnValue
        public Builder setMaxLevel(int maxLevel) {
            this.maxLevel = Math.max(0, Math.min(30, maxLevel));
            return this;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        @CanIgnoreReturnValue
        public Builder setLevelMod(int levelMod) {
            this.levelMod = Math.max(1, Math.min(3, levelMod));
            return this;
        }

        public int getLevelMod() {
            return this.levelMod;
        }

        @CanIgnoreReturnValue
        public Builder setMaxCells(int maxCells) {
            this.maxCells = maxCells;
            return this;
        }

        public int getMaxCells() {
            return this.maxCells;
        }

        public S2RegionCoverer build() {
            return new S2RegionCoverer(this);
        }
    }

    strictfp final class ActiveCovering {
        final boolean interiorCovering;
        final S2Region region;
        int candidatesCreatedCounter = 0;
        final ArrayList<S2CellId> result = new ArrayList();
        final PriorityQueue<QueueEntry> candidateQueue = new PriorityQueue<QueueEntry>(10, new QueueEntriesComparator());

        ActiveCovering(boolean interior, S2Region region) {
            this.interiorCovering = interior;
            this.region = region;
        }

        @Nullable
        private Candidate newCandidate(S2Cell cell) {
            if (!this.region.mayIntersect(cell)) {
                return null;
            }
            boolean isTerminal = false;
            if (cell.level() >= S2RegionCoverer.this.minLevel) {
                if (this.interiorCovering) {
                    if (this.region.contains(cell)) {
                        isTerminal = true;
                    } else if (cell.level() + S2RegionCoverer.this.levelMod > S2RegionCoverer.this.maxLevel) {
                        return null;
                    }
                } else if (cell.level() + S2RegionCoverer.this.levelMod > S2RegionCoverer.this.maxLevel || this.region.contains(cell)) {
                    isTerminal = true;
                }
            }
            Candidate candidate = new Candidate();
            candidate.cell = cell;
            candidate.isTerminal = isTerminal;
            if (!isTerminal) {
                Candidate.access$902(candidate, new Candidate[1 << this.maxChildrenShift()]);
            }
            ++this.candidatesCreatedCounter;
            return candidate;
        }

        private int maxChildrenShift() {
            return 2 * S2RegionCoverer.this.levelMod;
        }

        private void addCandidate(Candidate candidate) {
            if (candidate == null) {
                return;
            }
            if (candidate.isTerminal) {
                this.result.add(candidate.cell.id());
                return;
            }
            int numLevels = candidate.cell.level() < S2RegionCoverer.this.minLevel ? 1 : S2RegionCoverer.this.levelMod;
            int numTerminals = this.expandChildren(candidate, candidate.cell, numLevels);
            if (candidate.numChildren != 0) {
                if (!this.interiorCovering && numTerminals == 1 << this.maxChildrenShift() && candidate.cell.level() >= S2RegionCoverer.this.minLevel) {
                    candidate.isTerminal = true;
                    this.addCandidate(candidate);
                } else {
                    int priority = -(((candidate.cell.level() << this.maxChildrenShift()) + candidate.numChildren << this.maxChildrenShift()) + numTerminals);
                    this.candidateQueue.add(new QueueEntry(priority, candidate));
                }
            }
        }

        private int expandChildren(Candidate candidate, S2Cell cell, int numLevels) {
            --numLevels;
            S2Cell[] childCells = new S2Cell[4];
            for (int i = 0; i < 4; ++i) {
                childCells[i] = new S2Cell();
            }
            cell.subdivide(childCells);
            int numTerminals = 0;
            for (int i = 0; i < 4; ++i) {
                if (numLevels > 0) {
                    if (!this.region.mayIntersect(childCells[i])) continue;
                    numTerminals += this.expandChildren(candidate, childCells[i], numLevels);
                    continue;
                }
                Candidate child = this.newCandidate(childCells[i]);
                if (child == null) continue;
                ((Candidate)candidate).children[((Candidate)candidate).numChildren++] = child;
                if (!child.isTerminal) continue;
                ++numTerminals;
            }
            return numTerminals;
        }

        private void getInitialCandidates() {
            if (S2RegionCoverer.this.maxCells >= 4) {
                S2Cap cap = this.region.getCapBound();
                int level = Ints.min((int[])new int[]{S2Projections.PROJ.minWidth.getMaxLevel(2.0 * cap.angle().radians()), S2RegionCoverer.this.maxLevel(), 29});
                if (S2RegionCoverer.this.levelMod() > 1 && level > S2RegionCoverer.this.minLevel()) {
                    level -= (level - S2RegionCoverer.this.minLevel()) % S2RegionCoverer.this.levelMod();
                }
                if (level > 0) {
                    ArrayList<S2CellId> base = new ArrayList<S2CellId>(4);
                    S2CellId id = S2CellId.fromPoint(cap.axis());
                    id.getVertexNeighbors(level, base);
                    for (int i = 0; i < base.size(); ++i) {
                        this.addCandidate(this.newCandidate(new S2Cell(base.get(i))));
                    }
                    return;
                }
            }
            for (int face = 0; face < 6; ++face) {
                this.addCandidate(this.newCandidate((S2Cell)FACE_CELLS.get(face)));
            }
        }

        private void getCoveringInternal() {
            Preconditions.checkState((this.candidateQueue.isEmpty() && this.result.isEmpty() ? 1 : 0) != 0);
            this.getInitialCandidates();
            while (!(this.candidateQueue.isEmpty() || this.interiorCovering && this.result.size() >= S2RegionCoverer.this.maxCells)) {
                Candidate candidate = this.candidateQueue.poll().candidate;
                if (this.interiorCovering || candidate.cell.level() < S2RegionCoverer.this.minLevel || candidate.numChildren == 1 || this.result.size() + this.candidateQueue.size() + candidate.numChildren <= S2RegionCoverer.this.maxCells) {
                    for (int i = 0; i < candidate.numChildren; ++i) {
                        if (this.interiorCovering && this.result.size() >= S2RegionCoverer.this.maxCells) continue;
                        this.addCandidate(candidate.children[i]);
                    }
                    continue;
                }
                candidate.isTerminal = true;
                this.addCandidate(candidate);
            }
        }
    }

    strictfp static class QueueEntriesComparator
    implements Comparator<QueueEntry> {
        QueueEntriesComparator() {
        }

        @Override
        public int compare(QueueEntry x, QueueEntry y) {
            return x.id < y.id ? 1 : (x.id > y.id ? -1 : 0);
        }
    }

    strictfp static class QueueEntry {
        private final int id;
        private final Candidate candidate;

        public QueueEntry(int id, Candidate candidate) {
            this.id = id;
            this.candidate = candidate;
        }
    }

    strictfp static class Candidate {
        private S2Cell cell;
        private boolean isTerminal;
        private int numChildren;
        private Candidate[] children;

        Candidate() {
        }

        static /* synthetic */ Candidate[] access$902(Candidate x0, Candidate[] x1) {
            x0.children = x1;
            return x1;
        }
    }
}

