/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@GwtCompatible
strictfp final class S2ShapeMeasures {
    private S2ShapeMeasures() {
    }

    public static S1Angle length(S2Shape shape) {
        if (shape.dimension() != 1) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
            builder.add(S2ShapeMeasures.polylineLength(shape, chainId));
        }
        return builder.build();
    }

    @VisibleForTesting
    static S1Angle polylineLength(S2Shape shape, int chainId) {
        S1Angle.Builder builder = new S1Angle.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(a.angle((S2Point)b)));
        return builder.build();
    }

    public static S1Angle perimeter(S2Shape shape) {
        if (shape.dimension() != 2) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
            builder.add(S2ShapeMeasures.loopPerimeter(shape, chainId));
        }
        return builder.build();
    }

    @VisibleForTesting
    static S1Angle loopPerimeter(S2Shape shape, int chainId) {
        if (shape.getChainLength(chainId) <= 1) {
            return S1Angle.ZERO;
        }
        S1Angle.Builder builder = new S1Angle.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(a.angle((S2Point)b)));
        return builder.build();
    }

    public static double area(S2Shape shape) {
        if (shape.dimension() != 2) {
            return 0.0;
        }
        double area = 0.0;
        for (int chainId = 0; chainId < shape.numChains(); ++chainId) {
            area += S2ShapeMeasures.signedLoopArea(shape, chainId);
        }
        if (area < 0.0) {
            area += Math.PI * 4;
        }
        return area;
    }

    @VisibleForTesting
    static double loopArea(S2Shape shape, int chainId) {
        return S2ShapeMeasures.loopArea(S2ShapeMeasures.vertices(shape, chainId));
    }

    static double loopArea(List<S2Point> loop) {
        double area = S2ShapeMeasures.signedLoopArea(loop);
        assert (Math.abs(area) <= Math.PI * 2);
        if (area < 0.0) {
            area += Math.PI * 4;
        }
        return area;
    }

    private static double signedLoopArea(S2Shape shape, int chainId) {
        return S2ShapeMeasures.signedLoopArea(S2ShapeMeasures.vertices(shape, chainId));
    }

    private static double signedLoopArea(List<S2Point> loop) {
        MutableDouble mutableArea = new MutableDouble();
        S2ShapeUtil.visitSurfaceIntegral(loop, (a, b, c) -> mutableArea.d += S2.signedArea(a, b, c));
        double maxError = S2.getTurningAngleMaxError(loop.size());
        assert (Math.abs(mutableArea.d) <= Math.PI * 4 + maxError);
        double area = mutableArea.d % (Math.PI * 4);
        if (area == Math.PI * -2) {
            area = Math.PI * 2;
        }
        if (Math.abs(area) <= maxError) {
            double curvature = S2ShapeMeasures.turningAngle(loop);
            assert (area != 0.0 || curvature != 0.0);
            if (curvature == Math.PI * 2) {
                return 0.0;
            }
            if (area <= 0.0 && curvature > 0.0) {
                return Double.MIN_VALUE;
            }
            if (area >= 0.0 && curvature < 0.0) {
                return -4.9E-324;
            }
        }
        return area;
    }

    static double turningAngle(S2Shape shape, int chainId) {
        return S2ShapeMeasures.turningAngle(S2ShapeMeasures.vertices(shape, chainId));
    }

    static double turningAngle(List<S2Point> loop) {
        if (loop.isEmpty()) {
            return Math.PI * -2;
        }
        if ((loop = S2ShapeMeasures.pruneDegeneracies(loop)).isEmpty()) {
            return Math.PI * 2;
        }
        LoopOrder loopOrder = S2ShapeMeasures.canonicalLoopOrder(loop);
        int i = loopOrder.first;
        int dir = loopOrder.dir;
        int n = loop.size();
        double sum = S2.turnAngle(loop.get((i + n - dir) % n), loop.get(i % n), loop.get((i + dir) % n));
        double compensation = 0.0;
        for (int x = 0; x < n - 1; ++x) {
            double angle = S2.turnAngle(loop.get(((i += dir) - dir) % n), loop.get(i % n), loop.get((i + dir) % n));
            double oldSum = sum;
            compensation = oldSum - (sum += (angle += compensation)) + angle;
        }
        double maxCurvature = Math.PI * 2 - 4.0 * S2.DBL_EPSILON;
        return Math.max(-maxCurvature, Math.min(maxCurvature, (double)dir * (sum += compensation)));
    }

    @VisibleForTesting
    static LoopOrder canonicalLoopOrder(List<S2Point> loop) {
        if (loop.isEmpty()) {
            return new LoopOrder(0, 1);
        }
        ArrayList minIndexes = Lists.newArrayList((Object[])new Integer[]{0});
        for (int i = 1; i < loop.size(); ++i) {
            if (loop.get(i).compareTo(loop.get((Integer)minIndexes.get(0))) > 0) continue;
            if (loop.get(i).compareTo(loop.get((Integer)minIndexes.get(0))) < 0) {
                minIndexes.clear();
            }
            minIndexes.add(i);
        }
        LoopOrder minOrder = new LoopOrder((Integer)minIndexes.get(0), 1);
        LoopOrderComparator loopOrderComparator = new LoopOrderComparator(loop);
        Iterator iterator = minIndexes.iterator();
        while (iterator.hasNext()) {
            int minIndex = (Integer)iterator.next();
            LoopOrder loopOrder1 = new LoopOrder(minIndex, 1);
            LoopOrder loopOrder2 = new LoopOrder(minIndex + loop.size(), -1);
            if (loopOrderComparator.compare(loopOrder1, minOrder) < 0) {
                minOrder = loopOrder1;
            }
            if (loopOrderComparator.compare(loopOrder2, minOrder) >= 0) continue;
            minOrder = loopOrder2;
        }
        return minOrder;
    }

    @VisibleForTesting
    static List<S2Point> pruneDegeneracies(List<S2Point> input) {
        ArrayList loop = Lists.newArrayListWithCapacity((int)input.size());
        for (S2Point p : input) {
            if (!loop.isEmpty() && p.equalsPoint((S2Point)Iterables.getLast((Iterable)loop))) continue;
            if (loop.size() >= 2 && p.equalsPoint((S2Point)loop.get(loop.size() - 2))) {
                loop.remove(loop.size() - 1);
                continue;
            }
            loop.add(p);
        }
        if (loop.size() < 3) {
            return ImmutableList.of();
        }
        if (((S2Point)loop.get(0)).equalsPoint((S2Point)Iterables.getLast((Iterable)loop))) {
            loop.remove(loop.size() - 1);
        }
        int i = 0;
        while (((S2Point)loop.get(i + 1)).equalsPoint((S2Point)loop.get(loop.size() - i - 1))) {
            ++i;
        }
        return loop.subList(i, loop.size() - i);
    }

    public static S2Point centroid(S2Shape shape) {
        S2Point.Builder builder = new S2Point.Builder();
        int dimension = shape.dimension();
        int numChains = shape.numChains();
        switch (dimension) {
            case 0: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(shape.getChainVertex(chainId, 0));
                }
                break;
            }
            case 1: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(S2ShapeMeasures.polylineCentroid(shape, chainId));
                }
                break;
            }
            case 2: {
                for (int chainId = 0; chainId < numChains; ++chainId) {
                    builder.add(S2ShapeMeasures.loopCentroid(shape, chainId));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected S2Shape dimension: " + shape.dimension());
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static S2Point polylineCentroid(S2Shape shape, int chainId) {
        S2Point.Builder builder = new S2Point.Builder();
        S2ShapeMeasures.forEachChainEdge(shape, chainId, (a, b) -> builder.add(S2.trueCentroid(a, b)));
        return builder.build();
    }

    @VisibleForTesting
    static S2Point loopCentroid(S2Shape shape, int chainId) {
        S2ShapeUtil.CentroidMeasure centroidMeasure = new S2ShapeUtil.CentroidMeasure();
        S2ShapeUtil.visitSurfaceIntegral(S2ShapeMeasures.vertices(shape, chainId), centroidMeasure);
        return centroidMeasure.value();
    }

    private static List<S2Point> vertices(final S2Shape shape, final int chainId) {
        return new AbstractList<S2Point>(){
            int size;
            {
                this.size = shape.getChainLength(chainId);
            }

            @Override
            public S2Point get(int i) {
                return shape.getChainVertex(chainId, i);
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    private static void forEachChainEdge(S2Shape shape, int chainId, BiConsumer<S2Point, S2Point> edgeConsumer) {
        int chainLength = shape.getChainLength(chainId);
        if (chainLength == 0) {
            return;
        }
        S2Point prev = shape.getChainVertex(chainId, 0);
        for (int edgeOffset = 1; edgeOffset <= chainLength; ++edgeOffset) {
            S2Point next = shape.getChainVertex(chainId, edgeOffset);
            edgeConsumer.accept(prev, next);
            prev = next;
        }
    }

    private static interface BiConsumer<T, U> {
        public void accept(T var1, U var2);
    }

    private strictfp static class MutableDouble {
        double d = 0.0;

        private MutableDouble() {
        }
    }

    @VisibleForTesting
    strictfp static class LoopOrder {
        final int first;
        final int dir;

        LoopOrder(int first, int dir) {
            this.first = first;
            this.dir = dir;
        }

        boolean equalsLoopOrder(LoopOrder other) {
            return this.first == other.first && this.dir == other.dir;
        }

        public boolean equals(Object other) {
            return other instanceof LoopOrder && this.equalsLoopOrder((LoopOrder)other);
        }

        public int hashCode() {
            return this.first + this.dir;
        }
    }

    private strictfp static class LoopOrderComparator
    implements Comparator<LoopOrder> {
        private final List<S2Point> loop;
        private final IntFunction<S2Point> vertex;

        LoopOrderComparator(List<S2Point> loop) {
            this.loop = loop;
            this.vertex = i -> (S2Point)loop.get(i % loop.size());
        }

        @Override
        public int compare(LoopOrder loopOrder1, LoopOrder loopOrder2) {
            if (loopOrder1.equalsLoopOrder(loopOrder2)) {
                return 0;
            }
            assert (this.vertex.apply(loopOrder1.first).equalsPoint(this.vertex.apply(loopOrder2.first)));
            int i1 = loopOrder1.first;
            int i2 = loopOrder2.first;
            int n = this.loop.size();
            while (--n > 0) {
                int compare = this.vertex.apply(i1 += loopOrder1.dir).compareTo(this.vertex.apply(i2 += loopOrder2.dir));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
    }

    private static interface IntFunction<T> {
        public T apply(int var1);
    }
}

