/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.PrimitiveArrays;
import com.google.appengine.repackaged.com.google.common.geometry.S2Coder;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolygonShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2LaxPolylineShape;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@GwtIncompatible(value="S2LaxPolylineShape and S2LaxPolygonShape")
public class S2TaggedShapeCoder
implements S2Coder<S2Shape> {
    private static final int POLYGON_TYPE_TAG = 1;
    private static final int POLYLINE_TYPE_TAG = 2;
    private static final int POINT_TYPE_TAG = 3;
    private static final int LAX_POLYLINE_TYPE_TAG = 4;
    private static final int LAX_POLYGON_TYPE_TAG = 5;
    private static final ImmutableList<Class<? extends S2Polygon.Shape>> POLYGON_SHAPE_CLASSES = ImmutableList.of(new S2Polygon().binarySearchShape().getClass(), new S2Polygon().linearSearchShape().getClass());
    private static final ImmutableList<Class<? extends S2Point.Shape>> POINT_SHAPE_CLASSES = ImmutableList.of(S2Point.Shape.class, S2Point.Shape.singleton(S2Point.ORIGIN).getClass(), S2Point.Shape.fromList((List<S2Point>)ImmutableList.of((Object)S2Point.ORIGIN, (Object)S2Point.ORIGIN)).getClass());
    private static final ImmutableList<Class<? extends S2LaxPolylineShape>> LAX_POLYLINE_SHAPE_CLASSES = ImmutableList.of(S2LaxPolylineShape.SimpleArray.class, S2LaxPolylineShape.SimpleList.class, S2LaxPolylineShape.SimplePacked.class, S2LaxPolylineShape.SimpleSnapped.class);
    private static final ImmutableList<Class<? extends S2LaxPolygonShape>> LAX_POLYGON_SHAPE_CLASSES = ImmutableList.of(S2LaxPolygonShape.SimpleArray.class, S2LaxPolygonShape.SimpleList.class, S2LaxPolygonShape.SimplePacked.class, S2LaxPolygonShape.SimpleSnapped.class, S2LaxPolygonShape.MultiArray.class, S2LaxPolygonShape.MultiList.class, S2LaxPolygonShape.MultiPacked.class, S2LaxPolygonShape.MultiSnapped.class);
    public static final S2TaggedShapeCoder FAST = new Builder(true).add(POLYGON_SHAPE_CLASSES, S2Polygon.Shape.FAST_CODER, 1).add(S2Polyline.class, S2Polyline.FAST_CODER, 2).add(POINT_SHAPE_CLASSES, S2Point.Shape.Coder.FAST, 3).add(LAX_POLYLINE_SHAPE_CLASSES, S2LaxPolylineShape.FAST_CODER, 4).add(LAX_POLYGON_SHAPE_CLASSES, S2LaxPolygonShape.FAST_CODER, 5).build();
    public static final S2TaggedShapeCoder COMPACT = new Builder(true).add(POLYGON_SHAPE_CLASSES, S2Polygon.Shape.COMPACT_CODER, 1).add(S2Polyline.class, S2Polyline.COMPACT_CODER, 2).add(POINT_SHAPE_CLASSES, S2Point.Shape.Coder.COMPACT, 3).add(LAX_POLYLINE_SHAPE_CLASSES, S2LaxPolylineShape.COMPACT_CODER, 4).add(LAX_POLYGON_SHAPE_CLASSES, S2LaxPolygonShape.COMPACT_CODER, 5).build();
    private final IdentityHashMap<Class<? extends S2Shape>, Integer> classToTypeTag;
    private final Map<Integer, S2Coder<? extends S2Shape>> typeTagToCoder;

    private S2TaggedShapeCoder(IdentityHashMap<Class<? extends S2Shape>, Integer> classToTypeTag, Map<Integer, S2Coder<? extends S2Shape>> typeTagToCoder) {
        this.classToTypeTag = classToTypeTag;
        this.typeTagToCoder = typeTagToCoder;
    }

    @Override
    public void encode(S2Shape value, OutputStream output) throws IOException {
        if (value == null) {
            return;
        }
        Integer typeTag = this.classToTypeTag.get(value.getClass());
        Preconditions.checkArgument((typeTag != null ? 1 : 0) != 0, (String)"No S2Coder matched S2Shape with type %s", (Object)value.getClass().getName());
        EncodedInts.writeVarint64(output, typeTag.intValue());
        this.typeTagToCoder.get(typeTag).encode(value, output);
    }

    @Override
    @Nullable
    public S2Shape decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
        if (cursor.remaining() == 0L) {
            return null;
        }
        int typeTag = Ints.checkedCast((long)data.readVarint64(cursor));
        S2Coder<? extends S2Shape> coder = this.typeTagToCoder.get(typeTag);
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (String)"No S2Coder matched type tag %s", (int)typeTag);
        return this.typeTagToCoder.get(typeTag).decode(data, cursor);
    }

    public static Builder builder() {
        return new Builder(false);
    }

    public Builder toBuilder() {
        return new Builder(this.classToTypeTag, this.typeTagToCoder);
    }

    public static class Builder {
        public static final int MIN_USER_TYPE_TAG = 8192;
        private final boolean allowReservedTags;
        private final IdentityHashMap<Class<? extends S2Shape>, Integer> classToTypeTag;
        private final Map<Integer, S2Coder<? extends S2Shape>> typeTagToCoder;

        private Builder(boolean allowReservedTags) {
            this.allowReservedTags = allowReservedTags;
            this.classToTypeTag = new IdentityHashMap();
            this.typeTagToCoder = new HashMap<Integer, S2Coder<? extends S2Shape>>();
        }

        private Builder(IdentityHashMap<Class<? extends S2Shape>, Integer> classToTypeTag, Map<Integer, S2Coder<? extends S2Shape>> typeTagToCoder) {
            this.allowReservedTags = false;
            this.classToTypeTag = classToTypeTag;
            this.typeTagToCoder = typeTagToCoder;
        }

        @CanIgnoreReturnValue
        <T extends S2Shape> Builder add(Class<? extends T> clazz, S2Coder<T> coder, int typeTag) {
            this.validateTypeTag(typeTag);
            this.validateClass(clazz);
            this.classToTypeTag.put(clazz, typeTag);
            this.typeTagToCoder.put(typeTag, coder);
            return this;
        }

        @CanIgnoreReturnValue
        <T extends S2Shape> Builder add(List<Class<? extends T>> clazzes, S2Coder<T> coder, int typeTag) {
            this.validateTypeTag(typeTag);
            for (Class<T> clazz : clazzes) {
                this.validateClass(clazz);
                this.classToTypeTag.put(clazz, typeTag);
            }
            this.typeTagToCoder.put(typeTag, coder);
            return this;
        }

        private void validateTypeTag(int typeTag) {
            Preconditions.checkArgument((this.allowReservedTags || typeTag >= 8192 ? 1 : 0) != 0, (String)"Type tag must be greater than %s, got: %s", (int)8192, (int)typeTag);
            Preconditions.checkArgument((!this.typeTagToCoder.containsKey(typeTag) ? 1 : 0) != 0, (String)"Duplicate type tag: %s", (int)typeTag);
        }

        private <T extends S2Shape> void validateClass(Class<? extends T> clazz) {
            Preconditions.checkArgument((!this.classToTypeTag.containsKey(clazz) ? 1 : 0) != 0, (String)"Duplicate class: %s", (Object)clazz.getName());
        }

        S2TaggedShapeCoder build() {
            return new S2TaggedShapeCoder(this.classToTypeTag, this.typeTagToCoder);
        }
    }
}

