/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.LocalURLFetchServiceStreamHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StreamHandlerFactory
implements URLStreamHandlerFactory {
    private static boolean factoryIsInstalled;
    private static final @Nullable Method GET_URL_STREAM_HANDLER;
    private Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Class<StreamHandlerFactory> clazz = StreamHandlerFactory.class;
        synchronized (StreamHandlerFactory.class) {
            if (!factoryIsInstalled) {
                StreamHandlerFactory factory = new StreamHandlerFactory();
                try {
                    URL.setURLStreamHandlerFactory(factory);
                }
                catch (Error e) {
                    Object currentFactory;
                    try {
                        Field f = URL.class.getDeclaredField("factory");
                        f.setAccessible(true);
                        currentFactory = f.get(null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to find the currently installed factory", ex);
                    }
                    if (currentFactory == null) {
                        throw new RuntimeException("The current factory is null, but we were unable to set a new factory", e);
                    }
                    String currentFactoryType = currentFactory.getClass().getName();
                    if (currentFactoryType.equals(StreamHandlerFactory.class.getName())) {
                        factoryIsInstalled = true;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    throw new IllegalStateException("A factory of type " + currentFactoryType + " has already been installed");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private StreamHandlerFactory() {
        for (String protocol : Arrays.asList("http", "https")) {
            URLStreamHandler fallbackHandler = StreamHandlerFactory.getFallbackStreamHandler(protocol);
            this.handlers.put(protocol, (URLStreamHandler)((Object)new LocalURLFetchServiceStreamHandler(fallbackHandler)));
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return this.handlers.get(protocol);
    }

    private static URLStreamHandler getFallbackStreamHandler(String protocol) {
        if (GET_URL_STREAM_HANDLER == null) {
            return null;
        }
        URLStreamHandler existingHandler = (URLStreamHandler)StreamHandlerFactory.invoke(null, GET_URL_STREAM_HANDLER, protocol);
        if (existingHandler.getClass().getName().equals(LocalURLFetchServiceStreamHandler.class.getName())) {
            Method getFallbackHandler = StreamHandlerFactory.getDeclaredMethod(existingHandler.getClass(), "getFallbackHandler", new Class[0]);
            return (URLStreamHandler)StreamHandlerFactory.invoke(existingHandler, getFallbackHandler, new Object[0]);
        }
        return existingHandler;
    }

    static Object invoke(Object target, Method m, Object ... args) {
        try {
            return m.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    static Method getDeclaredMethod(Class<?> cls, String methodName, Class<?> ... args) {
        try {
            Method m = cls.getDeclaredMethod(methodName, args);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method m = null;
        try {
            m = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(StreamHandlerFactory.class.getName()).info("Unable to register default URLStreamHandlers.  You will be unable to access http and https URLs outside the App Engine environment.");
        }
        GET_URL_STREAM_HANDLER = m;
    }
}

