/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

public final class BlobUploadSessionStorage {
    static final String SUCCESS_PATH = "success_path";
    static final String MAX_UPLOAD_BYTES_PER_BLOB = "max_bytes_per_blob";
    static final String MAX_UPLOAD_BYTES = "max_bytes_total";
    static final String GOOGLE_STORAGE_BUCKET = "gs_bucket_name";
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSession(BlobUploadSession session) {
        Entity entity;
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            entity = new Entity("__BlobUploadSession__");
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
        entity.setProperty(SUCCESS_PATH, (Object)session.getSuccessPath());
        if (session.hasMaxUploadSizeBytesPerBlob()) {
            entity.setProperty(MAX_UPLOAD_BYTES_PER_BLOB, (Object)session.getMaxUploadSizeBytesPerBlob());
        }
        if (session.hasMaxUploadSizeBytes()) {
            entity.setProperty(MAX_UPLOAD_BYTES, (Object)session.getMaxUploadSizeBytes());
        }
        if (session.hasGoogleStorageBucketName()) {
            entity.setProperty(GOOGLE_STORAGE_BUCKET, (Object)session.getGoogleStorageBucketName());
        }
        this.datastoreService.put(entity);
        return KeyFactory.keyToString((Key)entity.getKey());
    }

    public BlobUploadSession loadSession(String sessionId) {
        try {
            return this.convertFromEntity(this.datastoreService.get(this.getKeyForSession(sessionId)));
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
    }

    public void deleteSession(String sessionId) {
        this.datastoreService.delete(new Key[]{this.getKeyForSession(sessionId)});
    }

    private BlobUploadSession convertFromEntity(Entity entity) {
        BlobUploadSession session = new BlobUploadSession((String)entity.getProperty(SUCCESS_PATH));
        if (entity.getProperty(MAX_UPLOAD_BYTES_PER_BLOB) != null) {
            session.setMaxUploadSizeBytesPerBlob((Long)entity.getProperty(MAX_UPLOAD_BYTES_PER_BLOB));
        }
        if (entity.getProperty(MAX_UPLOAD_BYTES) != null) {
            session.setMaxUploadSizeBytes((Long)entity.getProperty(MAX_UPLOAD_BYTES));
        }
        if (entity.getProperty(GOOGLE_STORAGE_BUCKET) != null) {
            session.setGoogleStorageBucketName((String)entity.getProperty(GOOGLE_STORAGE_BUCKET));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKeyForSession(String sessionId) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Key key = KeyFactory.stringToKey((String)sessionId);
            return key;
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }
}

