/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.Collection;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdJobRunShellFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class DirectSchedulerFactory
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    private boolean initialized = false;
    private static DirectSchedulerFactory instance = new DirectSchedulerFactory();
    static /* synthetic */ Class class$org$quartz$impl$DirectSchedulerFactory;

    private Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$impl$DirectSchedulerFactory == null ? (class$org$quartz$impl$DirectSchedulerFactory = DirectSchedulerFactory.class$("org.quartz.impl.DirectSchedulerFactory")) : class$org$quartz$impl$DirectSchedulerFactory));
    }

    protected DirectSchedulerFactory() {
    }

    public static DirectSchedulerFactory getInstance() {
        return instance;
    }

    public void createVolatileScheduler(int maxThreads) throws SchedulerException {
        SimpleThreadPool threadPool = new SimpleThreadPool(maxThreads, 5);
        threadPool.initialize();
        RAMJobStore jobStore = new RAMJobStore();
        this.createScheduler(threadPool, jobStore);
    }

    public void createVolatileSchduler(int maxThreads) throws SchedulerException {
        this.createVolatileScheduler(maxThreads);
    }

    public void createRemoteScheduler(String rmiHost, int rmiPort) throws SchedulerException {
        this.createRemoteScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, rmiHost, rmiPort);
        this.initialized = true;
    }

    protected void createRemoteScheduler(String schedulerName, String schedulerInstanceId, String rmiHost, int rmiPort) throws SchedulerException {
        SchedulingContext schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(schedulerInstanceId);
        String uid = QuartzSchedulerResources.getUniqueIdentifier(schedulerName, schedulerInstanceId);
        RemoteScheduler remoteScheduler = new RemoteScheduler(schedCtxt, uid, rmiHost, rmiPort);
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        schedRep.bind(remoteScheduler);
    }

    public void createScheduler(ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, threadPool, jobStore);
        this.initialized = true;
    }

    public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(schedulerName, schedulerInstanceId, threadPool, jobStore, null, 0, -1L, -1L);
    }

    public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore, String rmiRegistryHost, int rmiRegistryPort, long idleWaitTime, long dbFailureRetryInterval) throws SchedulerException {
        StdJobRunShellFactory jrsf = new StdJobRunShellFactory();
        SchedulingContext schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(schedulerInstanceId);
        QuartzSchedulerResources qrs = new QuartzSchedulerResources();
        qrs.setName(schedulerName);
        qrs.setInstanceId(schedulerInstanceId);
        qrs.setJobRunShellFactory(jrsf);
        qrs.setThreadPool(threadPool);
        qrs.setJobStore(jobStore);
        qrs.setRMIRegistryHost(rmiRegistryHost);
        qrs.setRMIRegistryPort(rmiRegistryPort);
        QuartzScheduler qs = new QuartzScheduler(qrs, schedCtxt, idleWaitTime, dbFailureRetryInterval);
        CascadingClassLoadHelper cch = new CascadingClassLoadHelper();
        cch.initialize();
        jobStore.initialize(cch, qs.getSchedulerSignaler());
        StdScheduler scheduler = new StdScheduler(qs, schedCtxt);
        jrsf.initialize(scheduler, schedCtxt);
        this.getLog().info((Object)("Quartz scheduler '" + scheduler.getSchedulerName()));
        this.getLog().info((Object)("Quartz scheduler version: " + qs.getVersion()));
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        qs.addNoGCObject(schedRep);
        schedRep.bind(scheduler);
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        return schedRep.lookup(DEFAULT_SCHEDULER_NAME);
    }

    public Scheduler getScheduler(String schedName) throws SchedulerException {
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        return schedRep.lookup(schedName);
    }

    public Collection getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

