/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.tools.development.ClassLoaderUtil;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IsolatedAppClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(IsolatedAppClassLoader.class.getName());
    private static final String WEB_DEFAULT_LOCATION_DEVAPPSERVER1 = "com/google/appengine/tools/development/jetty9/webdefault.xml";
    private static final String DEFERRED_TASK_SERVLET = "com.google.apphosting.utils.servlet.DeferredTaskServlet";
    private static final String SESSION_DATA_CLASS = "com.google.apphosting.runtime.SessionData";
    private final ClassLoader devAppServerClassLoader;
    private final Set<URL> sharedCodeLibs;
    private final ImmutableSet<String> classesToBeLoadedByTheRuntimeClassLoader;

    public IsolatedAppClassLoader(File appRoot, File externalResourceDir, URL[] urls, ClassLoader devAppServerClassLoader) {
        super(urls, ClassLoaderUtil.getPlatformClassLoader());
        IsolatedAppClassLoader.checkWorkingDirectory(appRoot, externalResourceDir);
        this.devAppServerClassLoader = devAppServerClassLoader;
        this.sharedCodeLibs = new HashSet<URL>(AppengineSdk.getSdk().getSharedLibs());
        this.classesToBeLoadedByTheRuntimeClassLoader = new ImmutableSet.Builder().add((Object)SESSION_DATA_CLASS).addAll(IsolatedAppClassLoader.getServletAndFilterClasses(IsolatedAppClassLoader.class.getClassLoader().getResourceAsStream(WEB_DEFAULT_LOCATION_DEVAPPSERVER1))).build();
    }

    private static void checkWorkingDirectory(File appRoot, File externalResourceDir) {
        File workingDir = new File(System.getProperty("user.dir"));
        String canonicalWorkingDir = null;
        String canonicalAppRoot = null;
        String canonicalExternalResourceDir = null;
        try {
            canonicalWorkingDir = workingDir.getCanonicalPath();
            canonicalAppRoot = appRoot.getCanonicalPath();
            if (externalResourceDir != null) {
                canonicalExternalResourceDir = externalResourceDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Unable to compare the working directory and app root.", e);
        }
        if (canonicalWorkingDir != null && !canonicalWorkingDir.equals(canonicalAppRoot)) {
            if (canonicalExternalResourceDir != null && canonicalWorkingDir.equals(canonicalExternalResourceDir)) {
                return;
            }
            String newLine = System.getProperty("line.separator");
            String workDir = workingDir.getAbsolutePath();
            String appDir = appRoot.getAbsolutePath();
            String msg = "Your working directory, (" + workDir + ") is not equal to your " + newLine + "web application root (" + appDir + ")" + newLine + "You will not be able to access files from your working directory on the production server." + newLine;
            logger.warning(msg);
        }
    }

    @Override
    public URL getResource(String name) {
        int bang;
        URL resource = this.devAppServerClassLoader.getResource(name);
        if (resource != null && resource.getProtocol().equals("jar") && (bang = resource.getPath().indexOf(33)) > 0) {
            try {
                URL url = new URL(resource.getPath().substring(0, bang));
                if (this.sharedCodeLibs.contains(url)) {
                    return resource;
                }
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, "Unexpected exception while loading " + name, ex);
            }
        }
        return super.getResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.equals(DEFERRED_TASK_SERVLET)) {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            final Class<?> c = this.devAppServerClassLoader.loadClass(name);
            CodeSource source = AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

                @Override
                public CodeSource run() {
                    return c.getProtectionDomain().getCodeSource();
                }
            });
            if (source == null) {
                return c;
            }
            String systemClassPrefix = System.getProperty("com.google.appengine.system.class.prefix", "///");
            if (this.classCanBeLoadedByRuntimeClassLoader(source.getLocation(), name) || name.startsWith(systemClassPrefix) || name.startsWith("org.jacoco.agent.")) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @VisibleForTesting
    static Set<String> getServletAndFilterClasses(InputStream inputStream) {
        int i;
        ImmutableSet.Builder servletsAndFilters = ImmutableSet.builder();
        Element topElement = XmlUtils.parseXml((InputStream)inputStream, null).getDocumentElement();
        NodeList nodeList = topElement.getElementsByTagName("filter-class");
        for (i = 0; i < nodeList.getLength(); ++i) {
            servletsAndFilters.add((Object)nodeList.item(i).getTextContent().trim());
        }
        nodeList = topElement.getElementsByTagName("servlet-class");
        for (i = 0; i < nodeList.getLength(); ++i) {
            servletsAndFilters.add((Object)nodeList.item(i).getTextContent().trim());
        }
        return servletsAndFilters.build();
    }

    private boolean classCanBeLoadedByRuntimeClassLoader(URL location, String name) {
        if (this.sharedCodeLibs.contains(location)) {
            return true;
        }
        return this.classesToBeLoadedByTheRuntimeClassLoader.contains((Object)name);
    }
}

