/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.appengine.api.search.dev;

import com.google.appengine.repackaged.org.apache.lucene.document.Document;

/**
 * Numeric expression which evaluates to default value if the child expression
 * cannot be evaluated.
 */
public class NumericDefaultExpression extends NumericExpression {
  private final NumericExpression expression;
  private final Double defaultValue;

  public NumericDefaultExpression(NumericExpression expression, Double defaultValue) {
    this.expression = expression;
    this.defaultValue = defaultValue;
  }

  @Override
  public double evalDouble(Document doc) throws EvaluationException {
    try {
      return expression.evalDouble(doc);
    } catch (EvaluationException e) {
      return defaultValue;
    }
  }
}
