/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServerImpl;

public class ContainerUtils {
    private static final String JETTY9SERVICE = "com.google.appengine.tools.development.jetty9.JettyContainerService";
    private static final String JETTY12SERVICE = "com.google.appengine.tools.development.jetty.JettyContainerService";

    public static ContainerService loadContainer() {
        ContainerService result;
        if (Boolean.getBoolean("appengine.use.jetty12")) {
            ContainerService result2;
            try {
                result2 = (ContainerService)Class.forName(JETTY12SERVICE, true, DevAppServerImpl.class.getClassLoader()).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot load any servlet container.", e);
            }
            return result2;
        }
        try {
            result = (ContainerService)Class.forName(JETTY9SERVICE, true, DevAppServerImpl.class.getClassLoader()).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot load any servlet container.", e);
        }
        return result;
    }

    public static String getServerInfo() {
        return "Google App Engine Development/dev";
    }

    private ContainerUtils() {
    }
}

