/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.modules.dev.LocalModulesService;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.BackendServers;
import com.google.appengine.tools.development.DelegatingModulesFilterHelper;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerDatastorePropertyHelper;
import com.google.appengine.tools.development.DevAppServerPortPropertyHelper;
import com.google.appengine.tools.development.DevLogService;
import com.google.appengine.tools.development.DevServices;
import com.google.appengine.tools.development.EnvironmentVariableChecker;
import com.google.appengine.tools.development.Module;
import com.google.appengine.tools.development.Modules;
import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.EarHelper;
import java.io.File;
import java.net.BindException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

class DevAppServerImpl
implements DevAppServer {
    public static final String MODULES_FILTER_HELPER_PROPERTY = "com.google.appengine.tools.development.modules_filter_helper";
    private static final Logger logger = Logger.getLogger(DevAppServerImpl.class.getName());
    private final ApplicationConfigurationManager applicationConfigurationManager;
    private final Modules modules;
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private final Map<String, Object> containerConfigProperties;
    private final int requestedPort;
    private final String customApplicationId;
    private ServerState serverState = ServerState.INITIALIZING;
    private final BackendServers backendContainer;
    private ApiProxyLocal apiProxyLocal;
    private final AppEngineConfigException configurationException;
    private final ScheduledExecutorService shutdownScheduler = Executors.newScheduledThreadPool(1);
    private CountDownLatch shutdownLatch = null;

    public DevAppServerImpl(File appDir, File externalResourceDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, Map<String, Object> requestedContainerConfigProperties, String applicationId) {
        if (useCustomStreamHandler) {
            StreamHandlerFactory.install();
        }
        this.backendContainer = BackendServers.getInstance();
        this.requestedPort = port;
        this.customApplicationId = applicationId;
        ApplicationConfigurationManager tempManager = null;
        File schemaFile = new File(AppengineSdk.getSdk().getResourcesDirectory(), "appengine-application.xsd");
        try {
            if (EarHelper.isEar((String)appDir.getAbsolutePath())) {
                tempManager = ApplicationConfigurationManager.newEarConfigurationManager(appDir, "dev", schemaFile);
                String contextRootWarning = "Ignoring application.xml context-root element, for details see https://developers.google.com/appengine/docs/java/modules/#config";
                logger.info(contextRootWarning);
            } else {
                tempManager = ApplicationConfigurationManager.newWarConfigurationManager(appDir, appEngineWebXmlLocation, webXmlLocation, externalResourceDir, "dev");
            }
        }
        catch (AppEngineConfigException configurationException) {
            this.modules = null;
            this.applicationConfigurationManager = null;
            this.containerConfigProperties = null;
            this.configurationException = configurationException;
            return;
        }
        this.applicationConfigurationManager = tempManager;
        this.modules = Modules.createModules(this.applicationConfigurationManager, "dev", externalResourceDir, address, this);
        DelegatingModulesFilterHelper modulesFilterHelper = new DelegatingModulesFilterHelper(this.backendContainer, this.modules);
        this.containerConfigProperties = ImmutableMap.builder().putAll(requestedContainerConfigProperties).put((Object)MODULES_FILTER_HELPER_PROPERTY, (Object)modulesFilterHelper).put((Object)"devappserver.portMappingProvider", (Object)this.backendContainer).buildOrThrow();
        this.backendContainer.init(address, this.applicationConfigurationManager.getPrimaryModuleConfigurationHandle(), externalResourceDir, this.containerConfigProperties, this);
        this.configurationException = null;
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        if (this.serverState != ServerState.INITIALIZING) {
            String msg = "Cannot set service properties after the server has been started.";
            throw new IllegalStateException(msg);
        }
        if (this.configurationException == null) {
            this.serviceProperties = new ConcurrentHashMap<String, String>(properties);
            if (this.requestedPort != 0) {
                DevAppServerPortPropertyHelper.setPort(this.modules.getMainModule().getModuleName(), this.requestedPort, this.serviceProperties);
            }
            this.backendContainer.setServiceProperties(properties);
            DevAppServerDatastorePropertyHelper.setDefaultProperties(this.serviceProperties);
        }
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    @Override
    public CountDownLatch start() throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CountDownLatch>(){

                @Override
                public CountDownLatch run() throws Exception {
                    return DevAppServerImpl.this.doStart();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch doStart() throws Exception {
        if (this.serverState != ServerState.INITIALIZING) {
            throw new IllegalStateException("Cannot start a server that has already been started.");
        }
        this.reportDeferredConfigurationException();
        this.initializeLogging();
        this.modules.configure(this.containerConfigProperties);
        try {
            this.modules.createConnections();
        }
        catch (BindException ex) {
            System.err.println();
            System.err.println("************************************************");
            System.err.println("Could not open the requested socket: " + ex.getMessage());
            System.err.println("Try overriding --address and/or --port.");
            System.exit(2);
        }
        ApiProxyLocalFactory factory = new ApiProxyLocalFactory();
        if (this.customApplicationId != null) {
            this.applicationConfigurationManager.getPrimaryModuleConfigurationHandle().getModule().getAppEngineWebXml().setAppId(this.customApplicationId);
        }
        String applicationName = this.applicationConfigurationManager.getPrimaryModuleConfigurationHandle().getModule().getAppEngineWebXml().getAppId();
        this.apiProxyLocal = factory.create(this.modules.getLocalServerEnvironment(), applicationName);
        this.setInboundServicesProperty();
        this.apiProxyLocal.setProperties(this.serviceProperties);
        ApiProxy.setDelegate((ApiProxy.Delegate)this.apiProxyLocal);
        LocalModulesService localModulesService = (LocalModulesService)this.apiProxyLocal.getService("modules");
        localModulesService.setModulesController(this.modules);
        this.installLoggingServiceHandler((DevServices)((Object)this.apiProxyLocal));
        TimeZone currentTimeZone = null;
        try {
            currentTimeZone = this.setServerTimeZone();
            this.backendContainer.configureAll(this.apiProxyLocal);
            this.modules.setApiProxyDelegate(this.apiProxyLocal);
            this.modules.startup();
            Module mainServer = this.modules.getMainModule();
            Map<String, String> portMapping = this.backendContainer.getPortMapping();
            AbstractContainerService.installLocalInitializationEnvironment(mainServer.getMainContainer().getAppEngineWebXmlConfig(), -1, this.getPort(), this.getPort(), null, -1, portMapping);
            this.backendContainer.startupAll();
        }
        finally {
            ApiProxy.clearEnvironmentForCurrentThread();
            this.restoreLocalTimeZone(currentTimeZone);
        }
        this.shutdownLatch = new CountDownLatch(1);
        this.serverState = ServerState.RUNNING;
        logger.info("Dev App Server is now running");
        return this.shutdownLatch;
    }

    private void installLoggingServiceHandler(DevServices proxy) {
        Logger root = Logger.getLogger("");
        DevLogService logService = proxy.getLogService();
        root.addHandler(logService.getLogHandler());
        Handler[] handlers = root.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                handler.setLevel(Level.FINEST);
            }
        }
    }

    public void setInboundServicesProperty() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle : this.applicationConfigurationManager.getModuleConfigurationHandles()) {
            setBuilder.addAll((Iterable)moduleConfigurationHandle.getModule().getAppEngineWebXml().getInboundServices());
        }
        this.serviceProperties.put("appengine.dev.inbound-services", Joiner.on((String)",").join((Iterable)setBuilder.build()));
    }

    private TimeZone setServerTimeZone() {
        String sysTimeZone = this.serviceProperties.get("appengine.user.timezone.impl");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return null;
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        assert (utc.getID().equals("UTC")) : "Unable to retrieve the UTC TimeZone";
        TimeZone previousZone = TimeZone.getDefault();
        TimeZone.setDefault(utc);
        return previousZone;
    }

    private void restoreLocalTimeZone(TimeZone timeZone) {
        String sysTimeZone = this.serviceProperties.get("appengine.user.timezone.impl");
        if (sysTimeZone != null && sysTimeZone.trim().length() > 0) {
            return;
        }
        TimeZone.setDefault(timeZone);
    }

    @Override
    public CountDownLatch restart() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot restart a server that is not currently running.");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CountDownLatch>(){

                @Override
                public CountDownLatch run() throws Exception {
                    DevAppServerImpl.this.modules.shutdown();
                    DevAppServerImpl.this.backendContainer.shutdownAll();
                    DevAppServerImpl.this.shutdownLatch.countDown();
                    DevAppServerImpl.this.modules.createConnections();
                    DevAppServerImpl.this.backendContainer.configureAll(DevAppServerImpl.this.apiProxyLocal);
                    DevAppServerImpl.this.modules.setApiProxyDelegate(DevAppServerImpl.this.apiProxyLocal);
                    DevAppServerImpl.this.modules.startup();
                    DevAppServerImpl.this.backendContainer.startupAll();
                    DevAppServerImpl.this.shutdownLatch = new CountDownLatch(1);
                    return DevAppServerImpl.this.shutdownLatch;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.serverState != ServerState.RUNNING) {
            throw new IllegalStateException("Cannot shutdown a server that is not currently running.");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DevAppServerImpl.this.modules.shutdown();
                    DevAppServerImpl.this.backendContainer.shutdownAll();
                    ApiProxy.setDelegate(null);
                    DevAppServerImpl.this.apiProxyLocal = null;
                    DevAppServerImpl.this.serverState = ServerState.SHUTDOWN;
                    DevAppServerImpl.this.shutdownLatch.countDown();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public void gracefulShutdown() throws IllegalStateException {
        AccessController.doPrivileged(new PrivilegedAction<Future<Void>>(){

            @Override
            public Future<Void> run() {
                return DevAppServerImpl.this.shutdownScheduler.schedule(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        DevAppServerImpl.this.shutdown();
                        return null;
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public int getPort() {
        this.reportDeferredConfigurationException();
        return this.modules.getMainModule().getMainContainer().getPort();
    }

    protected void reportDeferredConfigurationException() {
        if (this.configurationException != null) {
            throw new AppEngineConfigException("Invalid configuration", (Throwable)this.configurationException);
        }
    }

    @Override
    public AppContext getAppContext() {
        this.reportDeferredConfigurationException();
        return this.modules.getMainModule().getMainContainer().getAppContext();
    }

    @Override
    public AppContext getCurrentAppContext() {
        AppContext result = null;
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env != null && env.getVersionId() != null) {
            String moduleName = env.getModuleId();
            result = this.modules.getModule(moduleName).getMainContainer().getAppContext();
        }
        return result;
    }

    @Override
    public void setThrowOnEnvironmentVariableMismatch(boolean throwOnMismatch) {
        if (this.configurationException == null) {
            this.applicationConfigurationManager.setEnvironmentVariableMismatchReportingPolicy(throwOnMismatch ? EnvironmentVariableChecker.MismatchReportingPolicy.EXCEPTION : EnvironmentVariableChecker.MismatchReportingPolicy.LOG);
        }
    }

    private void initializeLogging() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINEST);
        }
    }

    ServerState getServerState() {
        return this.serverState;
    }

    static enum ServerState {
        INITIALIZING,
        RUNNING,
        STOPPING,
        SHUTDOWN;

    }
}

