package com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.document;

import java.io.IOException;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlConfig.WriteConfig;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.parser.ScalarEvent;

public class YamlScalar extends YamlElement {

	String value;
	
	public YamlScalar() {
	}
	
	public YamlScalar(Object value) {
		this.value = String.valueOf(value);
	}

	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		if(anchor!=null) {
			sb.append('&');
			sb.append(anchor);
			sb.append(' ');
		}
		sb.append(value);
		if(tag!=null) {
			sb.append(" !");
			sb.append(tag);
		}
		return sb.toString();
	}
	
	@Override
	public void emitEvent(Emitter emitter, WriteConfig config) throws EmitterException, IOException {
		emitter.emit(new ScalarEvent(anchor, tag, new boolean[] {true, true}, value, config.getQuote().getStyle()));
	}
}
