/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.search.DocIdSetIterator;
import com.google.appengine.repackaged.org.apache.lucene.search.Explanation;
import com.google.appengine.repackaged.org.apache.lucene.search.Scorer;
import java.io.IOException;

class ReqExclScorer
extends Scorer {
    private Scorer reqScorer;
    private DocIdSetIterator exclDisi;
    private int doc = -1;

    public ReqExclScorer(Scorer reqScorer, DocIdSetIterator exclDisi) {
        super(null);
        this.reqScorer = reqScorer;
        this.exclDisi = exclDisi;
    }

    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    public int nextDoc() throws IOException {
        if (this.reqScorer == null) {
            return this.doc;
        }
        this.doc = this.reqScorer.nextDoc();
        if (this.doc == Integer.MAX_VALUE) {
            this.reqScorer = null;
            return this.doc;
        }
        if (this.exclDisi == null) {
            return this.doc;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }

    private int toNonExcluded() throws IOException {
        int exclDoc = this.exclDisi.docID();
        int reqDoc = this.reqScorer.docID();
        do {
            if (reqDoc < exclDoc) {
                return reqDoc;
            }
            if (reqDoc <= exclDoc) continue;
            exclDoc = this.exclDisi.advance(reqDoc);
            if (exclDoc == Integer.MAX_VALUE) {
                this.exclDisi = null;
                return reqDoc;
            }
            if (exclDoc <= reqDoc) continue;
            return reqDoc;
        } while ((reqDoc = this.reqScorer.nextDoc()) != Integer.MAX_VALUE);
        this.reqScorer = null;
        return Integer.MAX_VALUE;
    }

    public int doc() {
        return this.reqScorer.doc();
    }

    public int docID() {
        return this.doc;
    }

    public float score() throws IOException {
        return this.reqScorer.score();
    }

    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    public int advance(int target) throws IOException {
        if (this.reqScorer == null) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (this.exclDisi == null) {
            this.doc = this.reqScorer.advance(target);
            return this.doc;
        }
        if (this.reqScorer.advance(target) == Integer.MAX_VALUE) {
            this.reqScorer = null;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        if (this.exclDisi.advance(doc) == doc) {
            res.setDescription("excluded");
        } else {
            res.setDescription("not excluded");
            res.addDetail(this.reqScorer.explain(doc));
        }
        return res;
    }
}

