/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.modules.dev;

import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.api.modules.ModulesServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ModulesController;
import com.google.auto.service.AutoService;
import java.util.Map;

@AutoService(value={LocalRpcService.class})
public class LocalModulesService
extends AbstractLocalRpcService {
    private static final int MAIN_INSTANCE = -1;
    public static final String PACKAGE = "modules";
    private ModulesController modulesController;
    private ModulesService modulesService;
    private String serverHostName;

    @Override
    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 20.0;
    }

    @Override
    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 40.0;
    }

    @Override
    public void init(LocalServiceContext context, Map<String, String> properties) {
        super.init(context, properties);
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        Preconditions.checkArgument((context.getLocalServerEnvironment() != null ? 1 : 0) != 0, (Object)"context.getLocalServerEnvironment() must not be null");
        Preconditions.checkArgument((context.getLocalServerEnvironment().getHostName() != null ? 1 : 0) != 0, (Object)"context.getLocalServerEnvironment() must not be null");
        this.serverHostName = context.getLocalServerEnvironment().getHostName();
    }

    @Override
    public String getPackage() {
        return PACKAGE;
    }

    public ModulesServicePb.GetModulesResponse getModules(LocalRpcService.Status status, ModulesServicePb.GetModulesRequest request) {
        ModulesServicePb.GetModulesResponse.Builder result = ModulesServicePb.GetModulesResponse.newBuilder();
        for (String moduleName : this.modulesController.getModuleNames()) {
            result.addModule(moduleName);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetVersionsResponse getVersions(LocalRpcService.Status status, ModulesServicePb.GetVersionsRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetVersionsResponse.Builder result = ModulesServicePb.GetVersionsResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        Iterable<String> versions = this.modulesController.getVersions(moduleName);
        for (String version : versions) {
            result.addVersion(version);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetDefaultVersionResponse getDefaultVersion(LocalRpcService.Status status, ModulesServicePb.GetDefaultVersionRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetDefaultVersionResponse.Builder result = ModulesServicePb.GetDefaultVersionResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.modulesController.getDefaultVersion(moduleName);
        result.setVersion(version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetNumInstancesResponse getNumInstances(LocalRpcService.Status status, ModulesServicePb.GetNumInstancesRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetNumInstancesResponse.Builder result = ModulesServicePb.GetNumInstancesResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.getVersionOrCurrent(request.hasVersion() ? request.getVersion() : null);
        int numInstances = this.modulesController.getNumInstances(moduleName, version);
        result.setInstances((long)numInstances);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.SetNumInstancesResponse setNumInstances(LocalRpcService.Status status, ModulesServicePb.SetNumInstancesRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.SetNumInstancesResponse.Builder result = ModulesServicePb.SetNumInstancesResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.getVersionOrCurrent(request.hasVersion() ? request.getVersion() : null);
        int numInstances = (int)request.getInstances();
        this.modulesController.setNumInstances(moduleName, version, numInstances);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.StartModuleResponse startModule(LocalRpcService.Status status, ModulesServicePb.StartModuleRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.StartModuleResponse.Builder result = ModulesServicePb.StartModuleResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.getVersionOrCurrent(request.hasVersion() ? request.getVersion() : null);
        this.modulesController.startModule(moduleName, version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.StopModuleResponse stopModule(LocalRpcService.Status status, ModulesServicePb.StopModuleRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.StopModuleResponse.Builder result = ModulesServicePb.StopModuleResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.getVersionOrCurrent(request.hasVersion() ? request.getVersion() : null);
        this.modulesController.stopModule(moduleName, version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetHostnameResponse getHostname(LocalRpcService.Status status, ModulesServicePb.GetHostnameRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetHostnameResponse.Builder result = ModulesServicePb.GetHostnameResponse.newBuilder();
        String moduleName = this.getModuleOrCurrent(request.hasModule() ? request.getModule() : null);
        String version = this.getVersionOrCurrent(request.hasVersion() ? request.getVersion() : null);
        int instance = request.hasInstance() ? Integer.parseInt(request.getInstance()) : -1;
        result.setHostname(this.modulesController.getHostname(moduleName, version, instance));
        status.setSuccessful(true);
        return result.build();
    }

    public void setModulesController(ModulesController modulesController) {
        this.modulesController = modulesController;
    }

    public String getServerHostname() {
        return this.serverHostName;
    }

    private synchronized ModulesService getModulesService() {
        if (this.modulesService == null) {
            this.modulesService = ModulesServiceFactory.getModulesService();
        }
        return this.modulesService;
    }

    private String getModuleOrCurrent(String module) {
        if (module == null) {
            module = this.getModulesService().getCurrentModule();
        }
        return module;
    }

    private String getVersionOrCurrent(String version) {
        if (version == null) {
            version = this.getModulesService().getCurrentVersion();
        }
        return version;
    }
}

