/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.AbstractIterator;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import java.util.Iterator;

@GwtCompatible
public class S2ContainsPointQuery {
    private final Options options;
    private final S2Iterator<S2ShapeIndex.Cell> it;

    public S2ContainsPointQuery(S2ShapeIndex index) {
        this(index, Options.SEMI_OPEN);
    }

    public S2ContainsPointQuery(S2ShapeIndex index, Options options) {
        this.it = index.iterator();
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public boolean contains(S2Point p) {
        if (!this.it.locate(p)) {
            return false;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        int numClipped = cell.numShapes();
        for (int s = 0; s < numClipped; ++s) {
            if (!this.options.vertexModel().shapeContains(center, cell.clipped(s), p)) continue;
            return true;
        }
        return false;
    }

    public boolean shapeContains(S2Shape shape, S2Point p) {
        if (!this.it.locate(p)) {
            return false;
        }
        S2ShapeIndex.S2ClippedShape clipped = this.it.entry().findClipped(shape);
        if (clipped == null) {
            return false;
        }
        return this.options.vertexModel().shapeContains(this.it.center(), clipped, p);
    }

    boolean visitContainingShapes(S2Point p, ShapeVisitor visitor) {
        if (!this.it.locate(p)) {
            return true;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        int numClipped = cell.numShapes();
        for (int s = 0; s < numClipped; ++s) {
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
            if (!this.options.vertexModel().shapeContains(center, clipped, p) || visitor.apply(clipped.shape())) continue;
            return false;
        }
        return true;
    }

    public Iterable<S2Shape> getContainingShapes(final S2Point p) {
        if (!this.it.locate(p)) {
            return ImmutableList.of();
        }
        final S2ShapeIndex.Cell cell = this.it.entry();
        final S2Point center = this.it.center();
        return new Iterable<S2Shape>(){

            @Override
            public Iterator<S2Shape> iterator() {
                return new AbstractIterator<S2Shape>(){
                    int i = 0;

                    protected S2Shape computeNext() {
                        while (this.i < cell.numShapes()) {
                            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(this.i++);
                            if (!S2ContainsPointQuery.this.options.vertexModel().shapeContains(center, clipped, p)) continue;
                            return clipped.shape();
                        }
                        return (S2Shape)this.endOfData();
                    }
                };
            }
        };
    }

    boolean visitIncidentEdges(S2Point p, EdgeVisitor visitor, S2Shape.MutableEdge tmp) {
        if (!this.it.locate(p)) {
            return true;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        int numClipped = cell.numShapes();
        for (int s = 0; s < numClipped; ++s) {
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s);
            int numEdges = clipped.numEdges();
            if (numEdges == 0) continue;
            S2Shape shape = clipped.shape();
            for (int i = 0; i < numEdges; ++i) {
                int edgeId = clipped.edge(i);
                shape.getEdge(edgeId, tmp);
                if (!tmp.isEndpoint(p) || visitor.test(shape, edgeId, tmp.a, tmp.b)) continue;
                return false;
            }
        }
        return true;
    }

    static interface EdgeVisitor {
        public boolean test(S2Shape var1, int var2, S2Point var3, S2Point var4);
    }

    static interface ShapeVisitor
    extends Predicate<S2Shape> {
    }

    public static enum S2VertexModel {
        OPEN,
        SEMI_OPEN,
        CLOSED;


        public boolean shapeContains(S2Point cellCenter, S2ShapeIndex.S2ClippedShape clipped, S2Point p) {
            boolean inside = clipped.containsCenter();
            int numEdges = clipped.numEdges();
            if (numEdges > 0) {
                S2Shape shape = clipped.shape();
                if (!shape.hasInterior() && this != CLOSED) {
                    return false;
                }
                S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(cellCenter, p);
                S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                block4: for (int i = 0; i < numEdges; ++i) {
                    boolean crossing;
                    shape.getEdge(clipped.edge(i), edge);
                    switch (crosser.robustCrossing(edge.a, edge.b)) {
                        case -1: {
                            continue block4;
                        }
                        case 1: {
                            crossing = true;
                            break;
                        }
                        default: {
                            if (this != SEMI_OPEN && edge.isEndpoint(p)) {
                                return this == CLOSED;
                            }
                            crossing = S2EdgeUtil.vertexCrossing(cellCenter, p, edge.a, edge.b);
                        }
                    }
                    inside ^= crossing;
                }
            }
            return inside;
        }
    }

    public static final class Options {
        public static final Options OPEN = new Options(S2VertexModel.OPEN);
        public static final Options SEMI_OPEN = new Options(S2VertexModel.SEMI_OPEN);
        public static final Options CLOSED = new Options(S2VertexModel.CLOSED);
        private final S2VertexModel vertexModel;

        private Options(S2VertexModel vertexModel) {
            this.vertexModel = vertexModel;
        }

        public S2VertexModel vertexModel() {
            return this.vertexModel;
        }
    }
}

