/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.ee10;

import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.BackendServersBase;
import com.google.appengine.tools.development.DevAppServerModulesCommon;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.ModulesFilterHelper;
import com.google.appengine.tools.development.ee10.ModulesFilterHelperEE10;
import com.google.apphosting.api.ApiProxy;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DevAppServerModulesFilter
extends DevAppServerModulesCommon
implements Filter {
    static final int INSTANCE_BUSY_ERROR_CODE = 500;
    static final int MODULE_STOPPED_ERROR_CODE = 404;
    static final int MODULE_MISSING_ERROR_CODE = 502;

    @VisibleForTesting
    DevAppServerModulesFilter(BackendServersBase backendServers, ModulesService modulesService) {
        super(backendServers, modulesService);
    }

    public DevAppServerModulesFilter() {
        this(BackendServersBase.getInstance(), ModulesServiceFactory.getModulesService());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        DevAppServerModulesCommon.RequestType requestType = this.getRequestType(hrequest);
        switch (requestType) {
            case DIRECT_MODULE_REQUEST: {
                this.doDirectModuleRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECT_REQUESTED: {
                this.doRedirect(hrequest, hresponse);
                break;
            }
            case DIRECT_BACKEND_REQUEST: {
                this.doDirectBackendRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECTED_BACKEND_REQUEST: {
                this.doRedirectedBackendRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECTED_MODULE_REQUEST: {
                this.doRedirectedModuleRequest(hrequest, hresponse, chain);
                break;
            }
            case STARTUP_REQUEST: {
                this.doStartupRequest(hrequest, hresponse, chain);
            }
        }
    }

    @VisibleForTesting
    DevAppServerModulesCommon.RequestType getRequestType(HttpServletRequest hrequest) {
        int instancePort = hrequest.getServerPort();
        String backendServerName = this.backendServersManager.getServerNameFromPort(instancePort);
        if (hrequest.getRequestURI().equals("/_ah/start") && this.expectsGeneratedStartRequests(backendServerName, instancePort)) {
            return DevAppServerModulesCommon.RequestType.STARTUP_REQUEST;
        }
        if (hrequest.getAttribute("com.google.appengine.backend.BackendName") instanceof String) {
            return DevAppServerModulesCommon.RequestType.REDIRECTED_BACKEND_REQUEST;
        }
        if (hrequest.getAttribute("com.google.appengine.module.ModuleInstance") instanceof Integer) {
            return DevAppServerModulesCommon.RequestType.REDIRECTED_MODULE_REQUEST;
        }
        if (backendServerName != null) {
            int backendInstance = this.backendServersManager.getServerInstanceFromPort(instancePort);
            if (backendInstance == -1) {
                return DevAppServerModulesCommon.RequestType.REDIRECT_REQUESTED;
            }
            return DevAppServerModulesCommon.RequestType.DIRECT_BACKEND_REQUEST;
        }
        String serverRedirectHeader = DevAppServerModulesFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        if (serverRedirectHeader == null && !this.isLoadBalancingRequest()) {
            return DevAppServerModulesCommon.RequestType.DIRECT_MODULE_REQUEST;
        }
        return DevAppServerModulesCommon.RequestType.REDIRECT_REQUESTED;
    }

    private boolean tryToAcquireServingPermit(String moduleOrBackendName, int instance, HttpServletResponse hresponse) throws IOException {
        ModulesFilterHelperEE10 modulesFilterHelper = (ModulesFilterHelperEE10)this.getModulesFilterHelper();
        if (!modulesFilterHelper.checkInstanceExists(moduleOrBackendName, instance)) {
            String msg = String.format("Got request to non-configured instance: %d.%s", instance, moduleOrBackendName);
            this.logger.warning(msg);
            hresponse.sendError(502, msg);
            return false;
        }
        if (modulesFilterHelper.checkInstanceStopped(moduleOrBackendName, instance)) {
            String msg = String.format("Got request to stopped instance: %d.%s", instance, moduleOrBackendName);
            this.logger.warning(msg);
            hresponse.sendError(404, msg);
            return false;
        }
        if (!modulesFilterHelper.acquireServingPermit(moduleOrBackendName, instance, true)) {
            String msg = String.format("Got request to module %d.%s but the instance is busy.", instance, moduleOrBackendName);
            this.logger.finer(msg);
            hresponse.sendError(500, msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRedirect(HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        String moduleOrBackendName = this.backendServersManager.getServerNameFromPort(hrequest.getServerPort());
        if (moduleOrBackendName == null) {
            moduleOrBackendName = DevAppServerModulesFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        }
        boolean isLoadBalancingModuleInstance = false;
        if (moduleOrBackendName == null) {
            ModulesService modulesService = ModulesServiceFactory.getModulesService();
            moduleOrBackendName = modulesService.getCurrentModule();
            isLoadBalancingModuleInstance = true;
        }
        ModulesFilterHelperEE10 modulesFilterHelper = (ModulesFilterHelperEE10)this.getModulesFilterHelper();
        int instance = DevAppServerModulesFilter.getInstanceIdFromRequest(hrequest);
        this.logger.finest(String.format("redirect request to module: %d.%s", instance, moduleOrBackendName));
        if (instance != -1) {
            if (!this.tryToAcquireServingPermit(moduleOrBackendName, instance, hresponse)) {
                return;
            }
        } else {
            if (!modulesFilterHelper.checkModuleExists(moduleOrBackendName)) {
                String msg = String.format("Got request to non-configured module: %s", moduleOrBackendName);
                this.logger.warning(msg);
                hresponse.sendError(502, msg);
                return;
            }
            if (modulesFilterHelper.checkModuleStopped(moduleOrBackendName)) {
                String msg = String.format("Got request to stopped module: %s", moduleOrBackendName);
                this.logger.warning(msg);
                hresponse.sendError(404, msg);
                return;
            }
            instance = modulesFilterHelper.getAndReserveFreeInstance(moduleOrBackendName);
            if (instance == -1) {
                String msg = String.format("all instances of module %s are busy", moduleOrBackendName);
                this.logger.finest(msg);
                hresponse.sendError(500, msg);
                return;
            }
        }
        try {
            if (isLoadBalancingModuleInstance) {
                this.logger.finer(String.format("forwarding request to module: %d.%s", instance, moduleOrBackendName));
                hrequest.setAttribute("com.google.appengine.module.ModuleInstance", (Object)instance);
            } else {
                this.logger.finer(String.format("forwarding request to backend: %d.%s", instance, moduleOrBackendName));
                hrequest.setAttribute("com.google.appengine.backend.BackendName", (Object)moduleOrBackendName);
                hrequest.setAttribute("com.google.appengine.backend.BackendInstance", (Object)instance);
            }
            modulesFilterHelper.forwardToInstance(moduleOrBackendName, instance, hrequest, hresponse);
        }
        finally {
            modulesFilterHelper.returnServingPermit(moduleOrBackendName, instance);
        }
    }

    private void doDirectBackendRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int instancePort = hrequest.getServerPort();
        String requestedBackend = this.backendServersManager.getServerNameFromPort(instancePort);
        int requestedInstance = this.backendServersManager.getServerInstanceFromPort(instancePort);
        this.injectApiInfo(requestedBackend, requestedInstance);
        this.doDirectRequest(requestedBackend, requestedInstance, hrequest, hresponse, chain);
    }

    private void doDirectModuleRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        String requestedModule = this.modulesService.getCurrentModule();
        int requestedInstance = this.getCurrentModuleInstance();
        this.injectApiInfo(null, -1);
        this.doDirectRequest(requestedModule, requestedInstance, hrequest, hresponse, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDirectRequest(String moduleOrBackendName, int instance, HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        this.logger.finest("request to specific module instance: " + instance + "." + moduleOrBackendName);
        if (!this.tryToAcquireServingPermit(moduleOrBackendName, instance, hresponse)) {
            return;
        }
        try {
            this.logger.finest("Acquired serving permit for: " + instance + "." + moduleOrBackendName);
            this.injectApiInfo(null, -1);
            chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
        }
        finally {
            ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
            modulesFilterHelper.returnServingPermit(moduleOrBackendName, instance);
        }
    }

    private void doRedirectedBackendRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        String backendServer = (String)hrequest.getAttribute("com.google.appengine.backend.BackendName");
        Integer instance = (Integer)hrequest.getAttribute("com.google.appengine.backend.BackendInstance");
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        int port = modulesFilterHelper.getPort(backendServer, instance);
        LocalEnvironment.setPort(ApiProxy.getCurrentEnvironment().getAttributes(), port);
        this.injectApiInfo(backendServer, instance);
        this.logger.finest("redirected request to backend server instance: " + instance + "." + backendServer);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private void doRedirectedModuleRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        Integer instance = (Integer)hrequest.getAttribute("com.google.appengine.module.ModuleInstance");
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        String moduleName = this.modulesService.getCurrentModule();
        int port = modulesFilterHelper.getPort(moduleName, instance);
        LocalEnvironment.setInstance(ApiProxy.getCurrentEnvironment().getAttributes(), instance);
        LocalEnvironment.setPort(ApiProxy.getCurrentEnvironment().getAttributes(), port);
        this.injectApiInfo(null, -1);
        this.logger.finest("redirected request to module instance: " + instance + "." + ApiProxy.getCurrentEnvironment().getModuleId() + " " + ApiProxy.getCurrentEnvironment().getVersionId());
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private void doStartupRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int instancePort = hrequest.getServerPort();
        String backendServer = this.backendServersManager.getServerNameFromPort(instancePort);
        int instance = this.backendServersManager.getServerInstanceFromPort(instancePort);
        this.logger.finest("startup request to: " + instance + "." + backendServer);
        this.injectApiInfo(backendServer, instance);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @VisibleForTesting
    static String getHeaderOrParameter(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value != null) {
            return value;
        }
        if ("GET".equals(request.getMethod())) {
            return request.getParameter(key);
        }
        return null;
    }

    @VisibleForTesting
    static int getInstanceIdFromRequest(HttpServletRequest request) {
        try {
            return Integer.parseInt(DevAppServerModulesFilter.getHeaderOrParameter(request, "X-AppEngine-BackendInstance"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

