/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.ee10;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class HeaderVerificationFilter
implements Filter {
    private static final String CONTENT_LENGTH = "Content-Length";

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.doFilterInternal(request, response)) {
            chain.doFilter(request, response);
        }
    }

    private boolean doFilterInternal(ServletRequest request, ServletResponse response) throws IOException {
        if (!(request instanceof HttpServletRequest)) {
            return true;
        }
        if (!(response instanceof HttpServletResponse)) {
            return true;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getMethod().equals("POST") && httpRequest.getHeader(CONTENT_LENGTH) == null) {
            httpResponse.sendError(411, "Length required");
            return false;
        }
        return true;
    }
}

