/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.ee10;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.users.dev.ee10.LoginCookieUtils;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.ModulesFilterHelper;
import jakarta.servlet.http.HttpServletRequest;

public class LocalHttpRequestEnvironment
extends LocalEnvironment {
    static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
    static final String CURRENT_NAMESPACE_HEADER = "X-AppEngine-Current-Namespace";
    private static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    private static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    private static final String USER_ORGANIZATION_KEY = "com.google.appengine.api.users.UserService.user_organization";
    private static final String X_APPENGINE_QUEUE_NAME = "X-AppEngine-QueueName";
    private final LoginCookieUtils.CookieData loginCookieData;

    public LocalHttpRequestEnvironment(String appId, String serverName, String majorVersionId, int instance, Integer port, HttpServletRequest request, Long deadlineMillis, ModulesFilterHelper modulesFilterHelper) {
        super(appId, serverName, majorVersionId, instance, port, deadlineMillis);
        String currentNamespace;
        this.loginCookieData = LoginCookieUtils.getCookieData(request);
        String requestNamespace = request.getHeader(DEFAULT_NAMESPACE_HEADER);
        if (requestNamespace != null) {
            this.attributes.put(APPS_NAMESPACE_KEY, requestNamespace);
        }
        if ((currentNamespace = request.getHeader(CURRENT_NAMESPACE_HEADER)) != null) {
            this.attributes.put(CURRENT_NAMESPACE_KEY, currentNamespace);
        } else {
            this.attributes.put(CURRENT_NAMESPACE_KEY, "");
        }
        if (this.loginCookieData != null) {
            this.attributes.put(USER_ID_KEY, this.loginCookieData.getUserId());
            this.attributes.put(USER_ORGANIZATION_KEY, "");
        }
        if (request.getHeader(X_APPENGINE_QUEUE_NAME) != null) {
            this.attributes.put("com.google.appengine.request.offline", Boolean.TRUE);
        }
        this.attributes.put("com.google.appengine.http_servlet_request", request);
        if (modulesFilterHelper != null) {
            this.attributes.put("com.google.appengine.tools.development.modules_filter_helper", modulesFilterHelper);
        }
    }

    public boolean isLoggedIn() {
        return this.loginCookieData != null;
    }

    public String getEmail() {
        if (this.loginCookieData == null) {
            return null;
        }
        return this.loginCookieData.getEmail();
    }

    public boolean isAdmin() {
        if (this.loginCookieData == null) {
            return false;
        }
        return this.loginCookieData.isAdmin();
    }
}

