/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.blobstore.dev.BlobUploadSessionStorage;
import com.google.appengine.api.blobstore.dev.MemoryBlobStorage;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.io.Closeables;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.api.ApiBasePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.auto.service.AutoService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@AutoService(value={LocalRpcService.class})
public final class LocalBlobstoreService
extends AbstractLocalRpcService {
    private static final String PORT_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.port";
    private static final Logger logger = Logger.getLogger(LocalBlobstoreService.class.getName());
    public static final String BACKING_STORE_PROPERTY = "blobstore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "blobstore.no_storage";
    public static final String PACKAGE = "blobstore";
    public static final String GOOGLE_STORAGE_KEY_PREFIX = "encoded_gs_key:";
    static final String UPLOAD_URL_PREFIX = "/_ah/upload/";
    private BlobStorage blobStorage;
    private BlobUploadSessionStorage uploadSessionStorage;
    private String serverHostName;

    @Override
    public String getPackage() {
        return PACKAGE;
    }

    @Override
    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.uploadSessionStorage = new BlobUploadSessionStorage();
        String noStorage = properties.get(NO_STORAGE_PROPERTY);
        if (noStorage != null && Boolean.parseBoolean(noStorage)) {
            BlobStorageFactory.setMemoryBlobStorage();
        } else {
            File file;
            String filePath = properties.get(BACKING_STORE_PROPERTY);
            if (filePath != null) {
                logger.log(Level.INFO, "Creating blobstore backing store at " + filePath);
                file = new File(filePath);
            } else {
                file = GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            }
            file.mkdirs();
            if (!file.canWrite()) {
                logger.log(Level.WARNING, "Default blobstore file location is not writable, creating a temporary directory. State will not be persisted between restarts.");
                file = Files.createTempDir();
            }
            BlobStorageFactory.setFileBlobStorage(file);
        }
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        this.serverHostName = context.getLocalServerEnvironment().getHostName();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.blobStorage instanceof MemoryBlobStorage) {
            ((MemoryBlobStorage)this.blobStorage).deleteAllBlobs();
        }
    }

    public BlobstoreServicePb.CreateUploadURLResponse createUploadURL(LocalRpcService.Status status, BlobstoreServicePb.CreateUploadURLRequest request) {
        BlobUploadSession session = new BlobUploadSession(request.getSuccessPath());
        if (request.hasMaxUploadSizePerBlobBytes()) {
            session.setMaxUploadSizeBytesPerBlob(request.getMaxUploadSizePerBlobBytes());
        }
        if (request.hasMaxUploadSizeBytes()) {
            session.setMaxUploadSizeBytes(request.getMaxUploadSizeBytes());
        }
        if (request.hasGsBucketName()) {
            session.setGoogleStorageBucketName(request.getGsBucketName());
        }
        String sessionId = this.uploadSessionStorage.createSession(session);
        BlobstoreServicePb.CreateUploadURLResponse.Builder response = BlobstoreServicePb.CreateUploadURLResponse.newBuilder();
        String url = String.format("http://%s:%s%s%s", this.serverHostName, this.getCurrentInstancePort(), UPLOAD_URL_PREFIX, sessionId);
        response.setUrl(url);
        return response.build();
    }

    public ApiBasePb.VoidProto deleteBlob(LocalRpcService.Status status, BlobstoreServicePb.DeleteBlobRequest request) {
        for (String blobKeyString : request.getBlobKeyList()) {
            BlobKey blobKey = new BlobKey(blobKeyString);
            if (!this.blobStorage.hasBlob(blobKey)) continue;
            try {
                this.blobStorage.deleteBlob(blobKey);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Could not delete blob: " + blobKey, ex);
                throw new ApiProxy.ApplicationException(1, ex.toString());
            }
        }
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobstoreServicePb.FetchDataResponse fetchData(LocalRpcService.Status status, BlobstoreServicePb.FetchDataRequest request) {
        if (request.getStartIndex() < 0L) {
            throw new ApiProxy.ApplicationException(5, "Start index must be >= 0.");
        }
        if (request.getEndIndex() < request.getStartIndex()) {
            throw new ApiProxy.ApplicationException(5, "End index must be >= startIndex.");
        }
        long fetchSize = request.getEndIndex() - request.getStartIndex() + 1L;
        if (fetchSize > 1015808L) {
            throw new ApiProxy.ApplicationException(6, "Blob fetch size too large.");
        }
        BlobstoreServicePb.FetchDataResponse.Builder response = BlobstoreServicePb.FetchDataResponse.newBuilder();
        BlobInfoStorage blobInfoStorage = new BlobInfoStorage();
        BlobKey blobKey = new BlobKey(request.getBlobKey());
        BlobInfo blobInfo = blobInfoStorage.loadBlobInfo(blobKey);
        if (blobInfo == null) {
            blobInfo = blobInfoStorage.loadGsFileInfo(blobKey);
        }
        if (blobInfo == null) {
            throw new ApiProxy.ApplicationException(4, "Blob not found.");
        }
        long endIndex = request.getEndIndex() > blobInfo.getSize() - 1L ? blobInfo.getSize() - 1L : request.getEndIndex();
        if (request.getStartIndex() > endIndex) {
            response.setData(ByteString.copyFromUtf8((String)""));
        } else {
            byte[] data = new byte[(int)(endIndex - request.getStartIndex() + 1L)];
            try {
                boolean swallowDueToThrow = true;
                InputStream stream = this.blobStorage.fetchBlob(blobKey);
                try {
                    ByteStreams.skipFully((InputStream)stream, (long)request.getStartIndex());
                    ByteStreams.readFully((InputStream)stream, (byte[])data);
                    swallowDueToThrow = false;
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)swallowDueToThrow);
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Could not fetch data: " + blobKey, ex);
                throw new ApiProxy.ApplicationException(1, ex.toString());
            }
            response.setData(ByteString.copyFrom((byte[])data));
        }
        return response.build();
    }

    public BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse createEncodedGoogleStorageKey(LocalRpcService.Status status, BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest request) {
        String encoded = BaseEncoding.base64Url().omitPadding().encode(request.getFilename().getBytes());
        return BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse.newBuilder().setBlobKey(GOOGLE_STORAGE_KEY_PREFIX + encoded).build();
    }

    private String getCurrentInstancePort() {
        Integer port = (Integer)ApiProxy.getCurrentEnvironment().getAttributes().get(PORT_ID_ENV_ATTRIBUTE);
        return port.toString();
    }
}

