/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.AutoValue_LocalDatastoreService_NameValue;
import com.google.appengine.api.datastore.dev.AutoValue_LocalDatastoreService_VersionedEntity;
import com.google.appengine.api.datastore.dev.DefaultHighRepJobPolicy;
import com.google.appengine.api.datastore.dev.EntityGroupPseudoKind;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.appengine.api.datastore.dev.KindPseudoKind;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.LocalDatastoreCostAnalysis;
import com.google.appengine.api.datastore.dev.LocalDatastoreJob;
import com.google.appengine.api.datastore.dev.NamespacePseudoKind;
import com.google.appengine.api.datastore.dev.PropertyPseudoKind;
import com.google.appengine.api.datastore.dev.PseudoKinds;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.MultimapBuilder;
import com.google.appengine.repackaged.com.google.common.collect.SetMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.api.proto2api.DatastorePb;
import com.google.apphosting.base.protos.api.ApiBasePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.appengv3.EntityStorageConversions;
import com.google.cloud.datastore.core.appengv3.converter.CursorModernizer;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public abstract class LocalDatastoreService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    static final double DEFAULT_DEADLINE_SECONDS = 30.0;
    static final double MAX_DEADLINE_SECONDS = 30.0;
    static final int DEFAULT_BATCH_SIZE = 20;
    public static final int MAX_QUERY_RESULTS = 300;
    public static final String PACKAGE = "datastore_v3";
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 30000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 300000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    static final int MAX_STRING_LENGTH = 1500;
    static final int MAX_LINK_LENGTH = 2083;
    static final int MAX_BLOB_LENGTH = 1048487;
    public static final int MAX_EG_PER_TXN = 25;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    private static final long CURRENT_STORAGE_VERSION = 2L;
    public static final String EMULATE_VNEXT_FEATURES = "datastore.use_vnext";
    public static final String NO_INDEX_AUTO_GEN_PROP = "datastore.no_index_auto_gen";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    public static final String HIGH_REP_JOB_POLICY_CLASS_PROPERTY = "datastore.high_replication_job_policy_class";
    public static final String FORCE_IS_HIGH_REP_PROPERTY = "datastore.force_is_high_replication";
    public static final String INDEX_CONFIGURATION_FORMAT_PROPERTY = "datastore.index_configuration_format";
    private static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");
    private static final String SUBSCRIPTION_MAP_KIND = "__ProspectiveSearchSubscriptions__";
    static final ImmutableSet<String> RESERVED_KIND_ALLOWLIST = ImmutableSet.of((Object)"__BlobUploadSession__", (Object)"__GsFileInfo__", (Object)"__BlobInfo__", (Object)"__ProspectiveSearchSubscriptions__", (Object)"__BlobServingUrl__");
    static final String ENTITY_GROUP_MESSAGE = "cross-group transaction need to be explicitly specified, see TransactionOptions.Builder.withXG";
    static final String TOO_MANY_ENTITY_GROUP_MESSAGE = "operating on too many entity groups in a single transaction.";
    static final String MULTI_EG_TXN_NOT_ALLOWED = "transactions on multiple entity groups only allowed in High Replication applications";
    static final String CONTENTION_MESSAGE = "too much contention on these datastore entities. please try again.";
    static final String TRANSACTION_CLOSED = "transaction closed";
    static final String TRANSACTION_NOT_FOUND = "transaction has expired or is invalid";
    static final String TRANSACTION_RETRY_ON_READ_ONLY = "specifying a previous transaction handle on a read-only transaction is not allowed";
    static final String TRANSACTION_RETRY_ON_PREVIOUSLY_READ_ONLY = "Cannot retry a read-only transaction.";
    static final String TRANSACTION_OPTIONS_CHANGED_ON_RESET = "Transaction options should be the same as specified previous transaction.";
    static final String NAME_TOO_LONG = "The key path element name is longer than 1500 bytes.";
    static final String QUERY_NOT_FOUND = "query has expired or is invalid. Please restart it with the last cursor to read more results.";
    static final String VNEXT_POLICY_DISALLOWED = "custom job policies are disallowed when using vnext features as vnext must be strongly consistent.";
    private static final long MAX_SEQUENTIAL_BIT = 52L;
    private static final long MAX_SEQUENTIAL_COUNTER = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SEQUENTIAL_ID = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SCATTERED_COUNTER = 0x7FFFFFFFFFFFFL;
    private static final long SCATTER_SHIFT = 13L;
    public static final String AUTO_ID_ALLOCATION_POLICY_PROPERTY = "datastore.auto_id_allocation_policy";
    private final AtomicLong entityIdSequential = new AtomicLong(1L);
    private final AtomicLong entityIdScattered = new AtomicLong(1L);
    private AutoIdAllocationPolicy autoIdAllocationPolicy = AutoIdAllocationPolicy.SEQUENTIAL;
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private final Map<String, Profile> profiles = Collections.synchronizedMap(new HashMap());
    private final Map<String, SpecialProperty> specialPropertyMap = Maps.newHashMap();
    private Clock clock;
    private static final long MAX_BATCH_GET_KEYS = 1000000000L;
    private static final long MAX_ACTIONS_PER_TXN = 5L;
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private static final int BACKGROUND_THREAD_COUNT = 10;
    private static final ScheduledThreadPoolExecutor scheduler = LocalDatastoreService.createScheduler();
    private static final Set<LocalDatastoreService> activeServices = Sets.newConcurrentHashSet();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private volatile boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private PseudoKinds pseudoKinds;
    private HighRepJobPolicy highRepJobPolicy;
    private boolean spannerBacked;
    private LocalDatastoreCostAnalysis costAnalysis;
    private final List<ScheduledFuture<?>> scheduledTasks = new ArrayList();

    protected abstract void addActionImpl(TaskQueuePb.TaskQueueAddRequest var1);

    public void clearProfiles() {
        this.profiles.clear();
    }

    public void clearQueryHistory() {
        LocalCompositeIndexManager.getInstance().clearQueryHistory();
    }

    private static ScheduledThreadPoolExecutor createScheduler() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LocalDatastoreService-%d").build());
        scheduler.setRemoveOnCancelPolicy(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LocalDatastoreService.cleanupActiveServices();
            }
        });
        return scheduler;
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(30000);
        this.setMaxTransactionLifetime(300000);
        this.setStoreDelay(30000);
        this.enableScatterProperty(true);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.init(context.getLocalServerEnvironment().getAppDir(), context.getClock(), properties);
    }

    public void init(File appDirectory, Clock clock, Map<String, String> properties) {
        String vnextPropStr;
        this.clock = clock;
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.parseBoolean(noStorageProp);
        }
        if (storeFile == null && !this.noStorage) {
            File dir = GenerationDirectory.getGenerationDirectory((File)appDirectory);
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.autoIdAllocationPolicy = LocalDatastoreService.getEnumProperty(properties, AutoIdAllocationPolicy.class, AUTO_ID_ALLOCATION_POLICY_PROPERTY, this.autoIdAllocationPolicy);
        LocalCompositeIndexManager.IndexConfigurationFormat indexConfigurationFormat = LocalDatastoreService.getEnumProperty(properties, LocalCompositeIndexManager.IndexConfigurationFormat.class, INDEX_CONFIGURATION_FORMAT_PROPERTY, LocalCompositeIndexManager.IndexConfigurationFormat.DEFAULT);
        LocalCompositeIndexManager.init(indexConfigurationFormat);
        LocalCompositeIndexManager.getInstance().setAppDir(appDirectory);
        LocalCompositeIndexManager.getInstance().setClock(clock);
        String noIndexAutoGenProp = properties.get(NO_INDEX_AUTO_GEN_PROP);
        if (noIndexAutoGenProp != null) {
            LocalCompositeIndexManager.getInstance().setStoreIndexConfiguration(!Boolean.parseBoolean(noIndexAutoGenProp));
        }
        this.spannerBacked = (vnextPropStr = properties.get(EMULATE_VNEXT_FEATURES)) != null ? Boolean.parseBoolean(vnextPropStr) : false;
        this.initHighRepJobPolicy(properties);
        this.pseudoKinds = new PseudoKinds();
        this.pseudoKinds.register(new KindPseudoKind(this));
        this.pseudoKinds.register(new PropertyPseudoKind(this));
        this.pseudoKinds.register(new NamespacePseudoKind(this));
        if (!this.spannerBacked()) {
            this.pseudoKinds.register(new EntityGroupPseudoKind());
        }
        this.costAnalysis = new LocalDatastoreCostAnalysis(LocalCompositeIndexManager.getInstance());
        logger.info(String.format("Local Datastore initialized: \n\tType: %s\n\tStorage: %s", this.spannerBacked() ? "VNext" : "High Replication", this.noStorage ? "In-memory" : this.backingStore));
    }

    private static <T extends Enum<T>> T getEnumProperty(Map<String, String> properties, Class<T> enumType, String propertyName, T defaultIfNotSet) {
        String propertyValue = properties.get(propertyName);
        if (propertyValue == null) {
            return defaultIfNotSet;
        }
        try {
            return Enum.valueOf(enumType, propertyValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid value \"%s\" for property \"%s\"", propertyValue, propertyName), e);
        }
    }

    boolean spannerBacked() {
        return this.spannerBacked;
    }

    private void initHighRepJobPolicy(Map<String, String> properties) {
        String highRepJobPolicyStr = properties.get(HIGH_REP_JOB_POLICY_CLASS_PROPERTY);
        if (highRepJobPolicyStr == null) {
            if (this.spannerBacked()) {
                this.highRepJobPolicy = new SpannerJobPolicy();
            } else {
                DefaultHighRepJobPolicy defaultPolicy = new DefaultHighRepJobPolicy(properties);
                this.spannerBacked = false;
                this.highRepJobPolicy = defaultPolicy;
            }
        } else {
            if (this.spannerBacked()) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, VNEXT_POLICY_DISALLOWED);
            }
            try {
                Class<?> highRepJobPolicyCls = Class.forName(highRepJobPolicyStr);
                Constructor<?> ctor = highRepJobPolicyCls.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                this.highRepJobPolicy = (HighRepJobPolicy)ctor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        this.startInternal();
    }

    private synchronized void startInternal() {
        if (activeServices.contains(this)) {
            return;
        }
        this.load();
        activeServices.add(this);
        this.scheduledTasks.add(scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LocalDatastoreService.this.removeStaleQueries(LocalDatastoreService.this.clock.getCurrentTime());
            }
        }, (long)this.maxQueryLifetimeMs * 5L, (long)this.maxQueryLifetimeMs * 5L, TimeUnit.MILLISECONDS));
        this.scheduledTasks.add(scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LocalDatastoreService.this.removeStaleTransactions(LocalDatastoreService.this.clock.getCurrentTime());
            }
        }, (long)this.maxTransactionLifetimeMs * 5L, (long)this.maxTransactionLifetimeMs * 5L, TimeUnit.MILLISECONDS));
        if (!this.noStorage) {
            this.scheduledTasks.add(scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    LocalDatastoreService.this.persist();
                }
            }, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS));
        }
    }

    public synchronized void stop() {
        if (!activeServices.contains(this)) {
            return;
        }
        activeServices.remove(this);
        if (!this.noStorage) {
            this.rollForwardAllUnappliedJobs();
            this.persist();
        }
        this.clearProfiles();
        this.clearQueryHistory();
        for (ScheduledFuture<?> scheduledTask : this.scheduledTasks) {
            scheduledTask.cancel(false);
        }
        this.scheduledTasks.clear();
    }

    private void rollForwardAllUnappliedJobs() {
        for (Profile profile : this.profiles.values()) {
            if (profile.getGroups() == null) continue;
            for (Profile.EntityGroup eg : profile.getGroups().values()) {
                eg.rollForwardUnappliedJobs();
            }
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public void enableScatterProperty(boolean enable) {
        if (enable) {
            this.specialPropertyMap.put("__scatter__", SpecialProperty.SCATTER);
        } else {
            this.specialPropertyMap.remove("__scatter__");
        }
    }

    public String getPackage() {
        return PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.GetResponse get(LocalRpcService.Status status, DatastorePb.GetRequest request) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Profile profile;
            this.validatePathComplete(key);
            String app = key.getApp();
            OnestoreEntity.Path groupPath = this.getGroup(key);
            DatastorePb.GetResponse.Entity responseEntity = response.addEntity();
            Profile profile2 = profile = this.getOrCreateProfile(app);
            synchronized (profile2) {
                boolean eventualConsistency;
                OnestoreEntity.EntityProto entity;
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                }
                if ((entity = this.pseudoKinds.get(liveTxn, eg, key, eventualConsistency = request.hasFailoverMs() && liveTxn == null)) == PseudoKinds.NOT_A_PSEUDO_KIND) {
                    VersionedEntity versionedEntity = eg.get(liveTxn, key, eventualConsistency);
                    if (versionedEntity == null) {
                        entity = null;
                        if (!eventualConsistency) {
                            responseEntity.setVersion(profile.getReadTimestamp());
                        }
                    } else {
                        entity = versionedEntity.entityProto();
                        responseEntity.setVersion(versionedEntity.version());
                    }
                }
                if (entity != null) {
                    responseEntity.getMutableEntity().copyFrom((ProtocolMessage)entity);
                    this.postprocessEntity(responseEntity.getMutableEntity());
                } else {
                    responseEntity.getMutableKey().copyFrom((ProtocolMessage)key);
                }
                profile.groom();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse put(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        this.globalLock.readLock().lock();
        try {
            DatastorePb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private void preprocessEntity(OnestoreEntity.EntityProto entity) {
        EntityStorageConversions.preprocessIndexesWithoutEmptyListSupport(entity);
        this.processEntityForSpecialProperties(entity, true);
    }

    private void postprocessEntity(OnestoreEntity.EntityProto entity) {
        this.processEntityForSpecialProperties(entity, false);
        EntityStorageConversions.postprocessIndexes(entity);
    }

    private void processEntityForSpecialProperties(OnestoreEntity.EntityProto entity, boolean store) {
        Iterator iter = entity.mutablePropertys().iterator();
        while (iter.hasNext()) {
            if (!this.specialPropertyMap.containsKey(((OnestoreEntity.Property)iter.next()).getName())) continue;
            iter.remove();
        }
        for (SpecialProperty specialProp : this.specialPropertyMap.values()) {
            OnestoreEntity.PropertyValue value;
            if (!(store ? specialProp.isStored() : specialProp.isVisible()) || (value = specialProp.getValue(entity)) == null) continue;
            entity.addProperty(specialProp.getProperty(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse putImpl(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        if (request.entitySize() == 0) {
            return response;
        }
        DatastorePb.Cost totalCost = response.getMutableCost();
        String app = ((OnestoreEntity.EntityProto)request.entitys().get(0)).getKey().getApp();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            this.validateAndProcessEntityProto(entity);
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            Preconditions.checkArgument((boolean)clone.hasKey());
            OnestoreEntity.Reference key = clone.getKey();
            Preconditions.checkArgument((key.getPath().elementSize() > 0 ? 1 : 0) != 0);
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = Utils.getLastElement(key);
            if (lastPath.getId() == 0L && !lastPath.hasName()) {
                if (this.autoIdAllocationPolicy == AutoIdAllocationPolicy.SEQUENTIAL) {
                    lastPath.setId(this.entityIdSequential.getAndIncrement());
                } else {
                    lastPath.setId(LocalDatastoreService.toScatteredId(this.entityIdScattered.getAndIncrement()));
                }
            }
            this.preprocessEntity(clone);
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path group = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element element = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = group.addElement();
                pathElement.setType(element.getType());
                if (element.hasName()) {
                    pathElement.setName(element.getName());
                    continue;
                }
                pathElement.setId(element.getId());
                continue;
            }
            Preconditions.checkState((clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0 ? 1 : 0) != 0);
        }
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>> entitiesByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>>();
        HashMap<OnestoreEntity.Reference, Long> writtenVersions = new HashMap<OnestoreEntity.Reference, Long>();
        Profile profile = this.getOrCreateProfile(app);
        Profile profile2 = profile;
        synchronized (profile2) {
            Profile.EntityGroup eg;
            LiveTxn liveTxn = null;
            for (OnestoreEntity.EntityProto entityProto : clones) {
                eg = profile.getGroup(entityProto.getEntityGroup());
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    Utils.checkRequest(!liveTxn.isReadOnly(), "Cannot modify entities in a read-only transaction.");
                    eg.addTransaction(liveTxn).addWrittenEntity(entityProto);
                } else {
                    ArrayList<OnestoreEntity.EntityProto> entities = (ArrayList<OnestoreEntity.EntityProto>)entitiesByEntityGroup.get(entityProto.getEntityGroup());
                    if (entities == null) {
                        entities = new ArrayList<OnestoreEntity.EntityProto>();
                        entitiesByEntityGroup.put(entityProto.getEntityGroup(), entities);
                    }
                    entities.add(entityProto);
                }
                response.mutableKeys().add(entityProto.getKey());
            }
            for (Map.Entry entry : entitiesByEntityGroup.entrySet()) {
                eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                WriteJob job = new WriteJob(this.highRepJobPolicy, eg, profile, (Iterable)entry.getValue(), Collections.emptyList());
                LocalDatastoreService.addTo(totalCost, ((LocalDatastoreJob)job).calculateJobCost());
                eg.addJob(job);
                for (OnestoreEntity.EntityProto entity : (List)entry.getValue()) {
                    writtenVersions.put(entity.getKey(), ((LocalDatastoreJob)job).getMutationTimestamp(entity.getKey()));
                }
            }
        }
        if (!request.hasTransaction()) {
            logger.fine("put: " + request.entitySize() + " entities");
            for (OnestoreEntity.Reference key : response.keys()) {
                response.addVersion(((Long)writtenVersions.get(key)).longValue());
            }
        }
        response.setCost(totalCost);
        return response;
    }

    private void validateAndProcessEntityProto(OnestoreEntity.EntityProto entity) {
        this.validatePathForPut(entity.getKey());
        for (OnestoreEntity.Property prop : entity.propertys()) {
            this.validateAndProcessProperty(prop);
            this.validateLengthLimit(prop);
        }
        for (OnestoreEntity.Property prop : entity.rawPropertys()) {
            this.validateAndProcessProperty(prop);
            this.validateRawPropLengthLimit(prop);
        }
    }

    private void validatePathComplete(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        for (OnestoreEntity.Path.Element ele : path.elements()) {
            if (!ele.getName().isEmpty() || ele.getId() != 0L) continue;
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, String.format("Incomplete key.path.element: %s", ele));
        }
    }

    private void validatePathForPut(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        for (OnestoreEntity.Path.Element ele : path.elements()) {
            String type = ele.getType();
            if (RESERVED_NAME.matcher(type).matches() && !RESERVED_KIND_ALLOWLIST.contains((Object)type)) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, String.format("The key path element kind \"%s\" is reserved.", ele.getType()));
            }
            if (!ele.hasName() || ele.getNameAsBytes().length <= 1500) continue;
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, NAME_TOO_LONG);
        }
    }

    private void validateAndProcessProperty(OnestoreEntity.Property prop) {
        if (RESERVED_NAME.matcher(prop.getName()).matches()) {
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, String.format("illegal property.name: %s", prop.getName()));
        }
        OnestoreEntity.PropertyValue val = prop.getMutableValue();
        if (val.hasUserValue() && !val.getUserValue().hasObfuscatedGaiaid()) {
            OnestoreEntity.PropertyValue.UserValue userVal = val.getMutableUserValue();
            userVal.setObfuscatedGaiaid(Integer.toString(userVal.getEmail().hashCode()));
        }
    }

    private void validateLengthLimit(OnestoreEntity.Property property) {
        String name = property.getName();
        OnestoreEntity.PropertyValue value = property.getValue();
        if (value.hasStringValue()) {
            if (property.hasMeaning() && property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ATOM_LINK) {
                if (value.getStringValueAsBytes().length > 2083) {
                    throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "Link property " + name + " is too long. Use TEXT for links over " + 2083 + " bytes.");
                }
            } else if (property.hasMeaning() && property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                if (value.getStringValueAsBytes().length > 1048487) {
                    throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "embedded entity property " + name + " is too big.  It cannot exceed " + 1048487 + " bytes.");
                }
            } else if (value.getStringValueAsBytes().length > 1500) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "string property " + name + " is too long.  It cannot exceed " + 1500 + " bytes.");
            }
        }
    }

    private void validateRawPropLengthLimit(OnestoreEntity.Property property) {
        String name = property.getName();
        OnestoreEntity.PropertyValue value = property.getValue();
        if (!value.hasStringValue() || !property.hasMeaning()) {
            return;
        }
        if ((property.getMeaningEnum() == OnestoreEntity.Property.Meaning.BLOB || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.TEXT) && value.getStringValueAsBytes().length > 1048487) {
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "Property " + name + " is too long. It cannot exceed " + 1048487 + " bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse delete(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        this.globalLock.readLock().lock();
        try {
            DatastorePb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    public ApiBasePb.VoidProto addActions(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        this.globalLock.readLock().lock();
        try {
            this.addActionsImpl(status, request);
        }
        finally {
            this.globalLock.readLock().unlock();
        }
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        DatastorePb.DeleteResponse response = new DatastorePb.DeleteResponse();
        if (request.keySize() == 0) {
            return response;
        }
        DatastorePb.Cost totalCost = response.getMutableCost();
        String app = ((OnestoreEntity.Reference)request.keys().get(0)).getApp();
        Profile profile = this.getOrCreateProfile(app);
        LiveTxn liveTxn = null;
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>> keysByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>>();
        HashMap<OnestoreEntity.Reference, Long> writtenVersions = new HashMap<OnestoreEntity.Reference, Long>();
        Profile profile2 = profile;
        synchronized (profile2) {
            for (OnestoreEntity.Reference reference : request.keys()) {
                this.validatePathComplete(reference);
                OnestoreEntity.Path group = this.getGroup(reference);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    Utils.checkRequest(!liveTxn.isReadOnly(), "Cannot modify entities in a read-only transaction.");
                    Profile.EntityGroup eg = profile.getGroup(group);
                    eg.addTransaction(liveTxn).addDeletedEntity(reference);
                    continue;
                }
                ArrayList<OnestoreEntity.Reference> keysToDelete = (ArrayList<OnestoreEntity.Reference>)keysByEntityGroup.get(group);
                if (keysToDelete == null) {
                    keysToDelete = new ArrayList<OnestoreEntity.Reference>();
                    keysByEntityGroup.put(group, keysToDelete);
                }
                keysToDelete.add(reference);
            }
            for (Map.Entry entry : keysByEntityGroup.entrySet()) {
                Profile.EntityGroup eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                WriteJob job = new WriteJob(this.highRepJobPolicy, eg, profile, Collections.emptyList(), (Iterable)entry.getValue());
                LocalDatastoreService.addTo(totalCost, ((LocalDatastoreJob)job).calculateJobCost());
                eg.addJob(job);
                for (OnestoreEntity.Reference deletedKey : (List)entry.getValue()) {
                    writtenVersions.put(deletedKey, ((LocalDatastoreJob)job).getMutationTimestamp(deletedKey));
                }
            }
        }
        if (!request.hasTransaction()) {
            for (OnestoreEntity.Reference key : request.keys()) {
                response.addVersion(((Long)writtenVersions.get(key)).longValue());
            }
        }
        return response;
    }

    private void addActionsImpl(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        DatastorePb.Transaction transaction;
        if (request.getAddRequestCount() == 0) {
            return;
        }
        ArrayList<TaskQueuePb.TaskQueueAddRequest> addRequests = new ArrayList<TaskQueuePb.TaskQueueAddRequest>(request.getAddRequestCount());
        for (TaskQueuePb.TaskQueueAddRequest addRequest : request.getAddRequestList()) {
            addRequests.add(addRequest.toBuilder().clearTransaction().clearDatastoreTransaction().build());
        }
        if (((TaskQueuePb.TaskQueueAddRequest)request.getAddRequestList().get(0)).hasDatastoreTransaction()) {
            ByteString datastoreTransaction = ((TaskQueuePb.TaskQueueAddRequest)request.getAddRequestList().get(0)).getDatastoreTransaction();
            try {
                transaction = (DatastorePb.Transaction)DatastorePb.Transaction.parser().parseFrom(datastoreTransaction);
            }
            catch (InvalidProtocolBufferException e) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "Invalid transaction");
            }
        } else {
            transaction = LocalDatastoreService.toProto1(request.getAddRequest(0).getTransaction());
        }
        Profile profile = this.profiles.get(transaction.getApp());
        LiveTxn liveTxn = profile.getTxn(transaction.getHandle());
        liveTxn.addActions(addRequests);
    }

    static DatastorePb.Transaction toProto1(DatastorePb.Transaction txn) {
        DatastorePb.Transaction txnProto = new DatastorePb.Transaction();
        boolean unused = txnProto.mergeFrom(txn.toByteArray());
        return txnProto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.QueryResult runQuery(LocalRpcService.Status status, DatastorePb.Query query) {
        Profile profile;
        LocalCompositeIndexManager.ValidatedQuery validatedQuery = new LocalCompositeIndexManager.ValidatedQuery(query);
        query = validatedQuery.getV3Query();
        try {
            CursorModernizer.modernizeQueryCursors(query);
        }
        catch (InvalidConversionException e) {
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "Invalid cursor");
        }
        String app = query.getApp();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            if (query.hasTransaction() && !app.equals(query.getTransaction().getApp())) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.INTERNAL_ERROR, "Can't query app " + app + "in a transaction on app " + query.getTransaction().getApp());
            }
            if (query.hasAncestor()) {
                OnestoreEntity.Path groupPath = this.getGroup(query.getAncestor());
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (query.hasTransaction()) {
                    LiveTxn liveTxn = profile.getTxn(query.getTransaction().getHandle());
                    eg.addTransaction(liveTxn);
                    profile = eg.getSnapshot(liveTxn);
                }
                if (query.hasTransaction() || !query.hasFailoverMs()) {
                    eg.rollForwardUnappliedJobs();
                }
            }
            if (query.hasSearchQuery()) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "full-text search unsupported");
            }
            List<Object> queryEntities = this.pseudoKinds.runQuery(query);
            HashMap<OnestoreEntity.Reference, Long> versions = null;
            if (queryEntities == null) {
                Collection<VersionedEntity> versionedEntities = null;
                Map<String, Extent> extents = profile.getExtents();
                Extent extent = extents.get(query.getKind());
                if (extent != null) {
                    versionedEntities = extent.getAllEntities();
                } else if (!query.hasKind()) {
                    versionedEntities = profile.getAllEntities();
                    if (query.orderSize() == 0) {
                        query.addOrder(new DatastorePb.Query.Order().setDirection(DatastorePb.Query.Order.Direction.ASCENDING).setProperty("__key__"));
                    }
                }
                if (versionedEntities != null) {
                    queryEntities = new ArrayList<OnestoreEntity.EntityProto>();
                    versions = new HashMap<OnestoreEntity.Reference, Long>();
                    for (VersionedEntity entity : versionedEntities) {
                        queryEntities.add(entity.entityProto());
                        versions.put(entity.entityProto().getKey(), entity.version());
                    }
                }
            }
            profile.groom();
            if (queryEntities == null) {
                queryEntities = Collections.emptyList();
            }
            ArrayList<Object> predicates = new ArrayList<Object>();
            if (query.hasAncestor()) {
                final List ancestorPath = query.getAncestor().getPath().elements();
                predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                    public boolean apply(OnestoreEntity.EntityProto entity) {
                        List path = entity.getKey().getPath().elements();
                        return path.size() >= ancestorPath.size() && path.subList(0, ancestorPath.size()).equals(ancestorPath);
                    }
                });
            }
            if (query.isShallow()) {
                final long keyPathLength = query.hasAncestor() ? (long)(query.getAncestor().getPath().elementSize() + 1) : 1L;
                predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                    public boolean apply(OnestoreEntity.EntityProto entity) {
                        return (long)entity.getKey().getPath().elementSize() == keyPathLength;
                    }
                });
            }
            final boolean hasNamespace = query.hasNameSpace();
            final String namespace = query.getNameSpace();
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    OnestoreEntity.Reference ref = entity.getKey();
                    return !(hasNamespace ? !ref.hasNameSpace() || !namespace.equals(ref.getNameSpace()) : ref.hasNameSpace());
                }
            });
            final EntityProtoComparators.EntityProtoComparator entityComparator = new EntityProtoComparators.EntityProtoComparator(validatedQuery.getQuery().orders(), validatedQuery.getQuery().filters());
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    return entityComparator.matches(entity);
                }
            });
            Predicate queryPredicate = Predicates.not((Predicate)Predicates.and(predicates));
            Iterables.removeIf(queryEntities, (Predicate)queryPredicate);
            if (query.propertyNameSize() > 0) {
                queryEntities = this.createIndexOnlyQueryResults(queryEntities, entityComparator);
            }
            Collections.sort(queryEntities, entityComparator);
            queryEntities = this.applyGroupByProperties(queryEntities, query);
            LiveQuery liveQuery = new LiveQuery(queryEntities, versions, query, entityComparator, this.clock);
            LocalCompositeIndexManager.getInstance().processQuery(validatedQuery.getV3Query());
            DatastorePb.QueryResult result = liveQuery.nextResult(query.hasOffset() ? Integer.valueOf(query.getOffset()) : null, query.hasCount() ? Integer.valueOf(query.getCount()) : null, query.isCompile());
            if (query.isCompile()) {
                result.setCompiledQuery(liveQuery.compileQuery());
            }
            if (result.isMoreResults()) {
                long cursor = this.queryId.getAndIncrement();
                profile.addQuery(cursor, liveQuery);
                result.getMutableCursor().setApp(query.getApp()).setCursor(cursor);
            }
            for (OnestoreEntity.Index index : LocalCompositeIndexManager.getInstance().queryIndexList(query)) {
                result.addIndex(this.wrapIndexInCompositeIndex(app, index));
            }
            return result;
        }
    }

    private List<OnestoreEntity.EntityProto> applyGroupByProperties(List<OnestoreEntity.EntityProto> queryEntities, DatastorePb.Query query) {
        HashSet groupByProperties = Sets.newHashSet((Iterable)query.groupByPropertyNames());
        if (groupByProperties.isEmpty()) {
            return queryEntities;
        }
        HashSet lastEntity = Sets.newHashSet();
        ArrayList results = Lists.newArrayList();
        for (OnestoreEntity.EntityProto entity : queryEntities) {
            boolean isFirst = false;
            for (OnestoreEntity.Property prop : entity.propertys()) {
                if (!groupByProperties.contains(prop.getName()) || lastEntity.contains(NameValue.of(prop.getName(), prop.getValue()))) continue;
                isFirst = true;
                break;
            }
            if (!isFirst) continue;
            results.add(entity);
            lastEntity.clear();
            for (OnestoreEntity.Property prop : entity.propertys()) {
                if (!groupByProperties.contains(prop.getName())) continue;
                lastEntity.add(NameValue.of(prop.getName(), prop.getValue()));
            }
        }
        return results;
    }

    private List<OnestoreEntity.EntityProto> createIndexOnlyQueryResults(List<OnestoreEntity.EntityProto> queryEntities, EntityProtoComparators.EntityProtoComparator entityComparator) {
        HashSet postfixProps = Sets.newHashSetWithExpectedSize((int)entityComparator.getAdjustedOrders().size());
        for (DatastorePb.Query.Order order : entityComparator.getAdjustedOrders()) {
            postfixProps.add(order.getProperty());
        }
        ArrayList results = Lists.newArrayListWithExpectedSize((int)queryEntities.size());
        for (OnestoreEntity.EntityProto entity : queryEntities) {
            ImmutableList<OnestoreEntity.EntityProto> indexEntities = this.createIndexEntities(entity, postfixProps, entityComparator);
            results.addAll(indexEntities);
        }
        return results;
    }

    private ImmutableList<OnestoreEntity.EntityProto> createIndexEntities(OnestoreEntity.EntityProto entity, Set<String> postfixProps, EntityProtoComparators.EntityProtoComparator entityComparator) {
        SetMultimap toSplit = MultimapBuilder.hashKeys((int)postfixProps.size()).hashSetValues(1).build();
        HashSet seen = Sets.newHashSet();
        boolean splitRequired = false;
        for (OnestoreEntity.Property prop : entity.propertys()) {
            if (!postfixProps.contains(prop.getName())) continue;
            splitRequired |= !seen.add(prop.getName());
            if (!entityComparator.matches(prop)) continue;
            toSplit.put((Object)prop.getName(), (Object)prop.getValue());
        }
        if (!splitRequired) {
            return ImmutableList.of((Object)entity);
        }
        OnestoreEntity.EntityProto clone = new OnestoreEntity.EntityProto();
        clone.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
        clone.getMutableEntityGroup();
        ArrayList results = Lists.newArrayList((Object[])new OnestoreEntity.EntityProto[]{clone});
        for (Map.Entry entry : toSplit.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                for (OnestoreEntity.EntityProto result : results) {
                    result.addProperty().setName((String)entry.getKey()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).getMutableValue().copyFrom((ProtocolMessage)((OnestoreEntity.PropertyValue)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()))));
                }
                continue;
            }
            ArrayList splitResults = Lists.newArrayListWithCapacity((int)(results.size() * ((Collection)entry.getValue()).size()));
            for (OnestoreEntity.PropertyValue value : (Collection)entry.getValue()) {
                for (OnestoreEntity.EntityProto result : results) {
                    OnestoreEntity.EntityProto split = (OnestoreEntity.EntityProto)result.clone();
                    split.addProperty().setName((String)entry.getKey()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).getMutableValue().copyFrom((ProtocolMessage)value);
                    splitResults.add(split);
                }
            }
            results = splitResults;
        }
        return ImmutableList.copyOf((Collection)results);
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key, String errorMsg) {
        T value = map.get(key);
        if (value == null) {
            throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, errorMsg);
        }
        return value;
    }

    public DatastorePb.QueryResult next(LocalRpcService.Status status, DatastorePb.NextRequest request) {
        Profile profile = this.profiles.get(request.getCursor().getApp());
        LiveQuery liveQuery = profile.getQuery(request.getCursor().getCursor());
        DatastorePb.QueryResult result = liveQuery.nextResult(request.hasOffset() ? Integer.valueOf(request.getOffset()) : null, request.hasCount() ? Integer.valueOf(request.getCount()) : null, request.isCompile());
        if (result.isMoreResults()) {
            result.setCursor(request.getCursor());
        } else {
            profile.removeQuery(request.getCursor().getCursor());
        }
        return result;
    }

    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastorePb.Cursor request) {
        Profile profile = this.profiles.get(request.getApp());
        profile.removeQuery(request.getCursor());
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.Transaction beginTransaction(LocalRpcService.Status status, DatastorePb.BeginTransactionRequest req) {
        Profile profile = this.getOrCreateProfile(req.getApp());
        if (req.hasPreviousTransaction()) {
            if (req.getModeEnum() == DatastorePb.BeginTransactionRequest.TransactionMode.READ_ONLY) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, TRANSACTION_RETRY_ON_READ_ONLY);
            }
            Profile profile2 = profile;
            synchronized (profile2) {
                LiveTxn previousTransaction = profile.getTxnQuietly(req.getPreviousTransaction().getHandle());
                if (previousTransaction != null) {
                    if (previousTransaction.concurrencyMode == LiveTxn.ConcurrencyMode.READ_ONLY) {
                        throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, TRANSACTION_RETRY_ON_PREVIOUSLY_READ_ONLY);
                    }
                    if (previousTransaction.allowMultipleEg != req.isAllowMultipleEg()) {
                        throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, TRANSACTION_OPTIONS_CHANGED_ON_RESET);
                    }
                    profile.removeTxn(req.getPreviousTransaction().getHandle());
                }
            }
        }
        DatastorePb.Transaction txn = new DatastorePb.Transaction().setApp(req.getApp()).setHandle((long)this.transactionHandleProvider.getAndIncrement());
        LiveTxn.ConcurrencyMode mode = LocalDatastoreService.toConcurrencyMode(req.getModeEnum());
        profile.addTxn(txn.getHandle(), new LiveTxn(this.clock, req.isAllowMultipleEg(), req.getModeEnum()));
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.CommitResponse commit(LocalRpcService.Status status, DatastorePb.Transaction req) {
        Profile profile = this.profiles.get(req.getApp());
        Preconditions.checkNotNull((Object)profile);
        DatastorePb.CommitResponse response = new DatastorePb.CommitResponse();
        this.globalLock.readLock().lock();
        Profile profile2 = profile;
        synchronized (profile2) {
            LiveTxn liveTxn;
            try {
                liveTxn = profile.removeTxn(req.getHandle());
                try {
                    if (liveTxn.isDirty()) {
                        response = this.commitImpl(liveTxn, profile);
                    } else {
                        response.setCost(new DatastorePb.Cost().setEntityWrites(0).setIndexWrites(0));
                    }
                }
                catch (ApiProxy.ApplicationException e) {
                    profile.addTxn(req.getHandle(), new LiveTxn(this.clock, liveTxn.allowMultipleEg, liveTxn.originalTransactionMode, true));
                    throw e;
                }
            }
            finally {
                this.globalLock.readLock().unlock();
            }
            for (TaskQueuePb.TaskQueueAddRequest action : liveTxn.getActions()) {
                try {
                    this.addActionImpl(action);
                }
                catch (ApiProxy.ApplicationException e) {
                    logger.log(Level.WARNING, "Transactional task: " + action + " has been dropped.", e);
                }
            }
        }
        return response;
    }

    private DatastorePb.CommitResponse commitImpl(LiveTxn liveTxn, Profile profile) {
        DatastorePb.CommitResponse response = new DatastorePb.CommitResponse();
        for (EntityGroupTracker tracker : liveTxn.getAllTrackers()) {
            tracker.checkEntityGroupVersion();
        }
        int deleted = 0;
        int written = 0;
        DatastorePb.Cost totalCost = new DatastorePb.Cost();
        long commitTimestamp = profile.incrementAndGetCommitTimestamp();
        for (EntityGroupTracker tracker : liveTxn.getAllTrackers()) {
            Profile.EntityGroup eg = tracker.getEntityGroup();
            eg.incrementVersion();
            Collection<OnestoreEntity.EntityProto> writtenEntities = tracker.getWrittenEntities();
            Collection<OnestoreEntity.Reference> deletedKeys = tracker.getDeletedKeys();
            WriteJob job = new WriteJob(this.highRepJobPolicy, eg, profile, commitTimestamp, writtenEntities, deletedKeys);
            LocalDatastoreService.addTo(totalCost, ((LocalDatastoreJob)job).calculateJobCost());
            eg.addJob(job);
            deleted += deletedKeys.size();
            written += writtenEntities.size();
            for (OnestoreEntity.EntityProto writtenEntity : writtenEntities) {
                response.addVersion().setRootEntityKey(writtenEntity.getKey()).setVersion(((LocalDatastoreJob)job).getMutationTimestamp(writtenEntity.getKey()));
            }
            for (OnestoreEntity.Reference deletedKey : deletedKeys) {
                response.addVersion().setRootEntityKey(deletedKey).setVersion(((LocalDatastoreJob)job).getMutationTimestamp(deletedKey));
            }
        }
        logger.fine("committed: " + written + " puts, " + deleted + " deletes in " + liveTxn.getAllTrackers().size() + " entity groups");
        response.setCost(totalCost);
        return response;
    }

    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastorePb.Transaction req) {
        this.profiles.get(req.getApp()).removeTxn(req.getHandle());
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private OnestoreEntity.CompositeIndex wrapIndexInCompositeIndex(String app, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.Index index) {
        OnestoreEntity.CompositeIndex ci = new OnestoreEntity.CompositeIndex().setAppId(app).setState(OnestoreEntity.CompositeIndex.State.READ_WRITE);
        if (index != null) {
            ci.setDefinition(index);
        }
        return ci;
    }

    public DatastorePb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        Set<OnestoreEntity.Index> indexSet = LocalCompositeIndexManager.getInstance().getIndexes();
        DatastorePb.CompositeIndices answer = new DatastorePb.CompositeIndices();
        for (OnestoreEntity.Index index : indexSet) {
            OnestoreEntity.CompositeIndex ci = this.wrapIndexInCompositeIndex(req.getValue(), index);
            answer.addIndex(ci);
        }
        return answer;
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastorePb.AllocateIdsRequest req) {
        this.globalLock.readLock().lock();
        try {
            DatastorePb.AllocateIdsResponse allocateIdsResponse = this.allocateIdsImpl(req);
            return allocateIdsResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private DatastorePb.AllocateIdsResponse allocateIdsImpl(DatastorePb.AllocateIdsRequest req) {
        if (req.hasSize()) {
            if (req.getSize() > 1000000000L) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "cannot get more than 1000000000 keys in a single call");
            }
            long start = this.entityIdSequential.getAndAdd(req.getSize());
            return new DatastorePb.AllocateIdsResponse().setStart(start).setEnd(start + req.getSize() - 1L);
        }
        long current = this.entityIdSequential.get();
        while (current <= req.getMax() && !this.entityIdSequential.compareAndSet(current, req.getMax() + 1L)) {
            current = this.entityIdSequential.get();
        }
        return new DatastorePb.AllocateIdsResponse().setStart(current).setEnd(Math.max(req.getMax(), current - 1L));
    }

    static long toScatteredId(long counter) {
        if (counter >= 0x7FFFFFFFFFFFFL) {
            throw Utils.newError(DatastorePb.Error.ErrorCode.INTERNAL_ERROR, "Maximum scattered ID counter value exceeded");
        }
        return 0x10000000000000L + Long.reverse(counter << 13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Preconditions.checkArgument((app != null && app.length() > 0 ? 1 : 0) != 0, (Object)"appId not set");
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.noStorage) {
            return;
        }
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. It will be created.");
            backingStoreFile.getParentFile().mkdirs();
            return;
        }
        long start = this.clock.getCurrentTime();
        try (ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));){
            long version = -objectIn.readLong();
            if (version < 0L) {
                this.entityIdSequential.set(-version);
            } else {
                this.entityIdSequential.set(objectIn.readLong());
                this.entityIdScattered.set(objectIn.readLong());
            }
            Map profilesOnDisk = (Map)objectIn.readObject();
            Map<String, Profile> map = this.profiles;
            synchronized (map) {
                this.profiles.clear();
                this.profiles.putAll(profilesOnDisk);
            }
            long end = this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException | ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    static int pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        int numPrunedObjects = 0;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
            ++numPrunedObjects;
        }
        return numPrunedObjects;
    }

    Map<String, SpecialProperty> getSpecialPropertyMap() {
        return Collections.unmodifiableMap(this.specialPropertyMap);
    }

    private void persist() {
        this.globalLock.writeLock().lock();
        try {
            if (this.noStorage || !this.dirty) {
                return;
            }
            long start = this.clock.getCurrentTime();
            try (ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.backingStore)));){
                objectOut.writeLong(-2L);
                objectOut.writeLong(this.entityIdSequential.get());
                objectOut.writeLong(this.entityIdScattered.get());
                objectOut.writeObject(this.profiles);
            }
            this.dirty = false;
            long end = this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (!(t instanceof IOException)) {
                throw new RuntimeException(e);
            }
            logger.log(Level.SEVERE, "Unable to save the datastore", e);
            throw new RuntimeException(t);
        }
        finally {
            this.globalLock.writeLock().unlock();
        }
    }

    int expireOutstandingQueries() {
        return this.removeStaleQueries((long)this.maxQueryLifetimeMs * 2L + this.clock.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeStaleQueries(long currentTime) {
        int totalPruned = 0;
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            for (Profile profile : this.profiles.values()) {
                Map map2 = profile.getQueries();
                synchronized (map2) {
                    totalPruned += LocalDatastoreService.pruneHasCreationTimeMap(currentTime, this.maxQueryLifetimeMs, profile.getQueries());
                }
            }
        }
        return totalPruned;
    }

    int expireOutstandingTransactions() {
        return this.removeStaleTransactions((long)this.maxTransactionLifetimeMs * 2L + this.clock.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeStaleTransactions(long currentTime) {
        int totalPruned = 0;
        for (Profile profile : this.profiles.values()) {
            Map map = profile.getTxns();
            synchronized (map) {
                totalPruned += LocalDatastoreService.pruneHasCreationTimeMap(currentTime, this.maxTransactionLifetimeMs, profile.getTxns());
            }
        }
        return totalPruned;
    }

    static int cleanupActiveServices() {
        int cleanedUpServices = 0;
        logger.info("scheduler shutting down.");
        for (LocalDatastoreService service : activeServices) {
            ++cleanedUpServices;
            service.stop();
        }
        scheduler.shutdownNow();
        logger.info("scheduler finished shutting down.");
        return cleanedUpServices;
    }

    static int getActiveServiceCount() {
        return activeServices.size();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    static boolean equalProperties(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto entity1, OnestoreEntity.EntityProto entity2) {
        return entity1 != null && entity1.propertys().equals(entity2.propertys()) && entity1.rawPropertys().equals(entity2.rawPropertys());
    }

    private static void addTo(DatastorePb.Cost target, DatastorePb.Cost addMe) {
        target.setEntityWrites(target.getEntityWrites() + addMe.getEntityWrites());
        target.setIndexWrites(target.getIndexWrites() + addMe.getIndexWrites());
    }

    private static LiveTxn.ConcurrencyMode toConcurrencyMode(DatastorePb.BeginTransactionRequest.TransactionMode transactionMode) {
        switch (transactionMode) {
            case UNKNOWN: 
            case READ_WRITE: {
                return LiveTxn.ConcurrencyMode.OPTIMISTIC;
            }
            case READ_ONLY: {
                return LiveTxn.ConcurrencyMode.READ_ONLY;
            }
        }
        throw new IllegalArgumentException("Unknown transaction mode: " + transactionMode);
    }

    static class LiveTxn
    extends HasCreationTime {
        private final Map<Profile.EntityGroup, EntityGroupTracker> entityGroups = new HashMap<Profile.EntityGroup, EntityGroupTracker>();
        private final List<TaskQueuePb.TaskQueueAddRequest> actions = new ArrayList<TaskQueuePb.TaskQueueAddRequest>();
        private final boolean allowMultipleEg;
        private boolean failed = false;
        private final ConcurrencyMode concurrencyMode;
        private final DatastorePb.BeginTransactionRequest.TransactionMode originalTransactionMode;

        LiveTxn(Clock clock, boolean allowMultipleEg, DatastorePb.BeginTransactionRequest.TransactionMode transactionMode) {
            this(clock, allowMultipleEg, transactionMode, false);
        }

        LiveTxn(Clock clock, boolean allowMultipleEg, DatastorePb.BeginTransactionRequest.TransactionMode transactionMode, boolean failed) {
            super(clock.getCurrentTime());
            this.originalTransactionMode = transactionMode;
            ConcurrencyMode concurrencyMode = LocalDatastoreService.toConcurrencyMode(transactionMode);
            Preconditions.checkArgument((concurrencyMode != ConcurrencyMode.PESSIMISTIC && concurrencyMode != ConcurrencyMode.SHARED_READ ? 1 : 0) != 0);
            this.allowMultipleEg = allowMultipleEg;
            this.concurrencyMode = concurrencyMode;
            this.failed = failed;
        }

        synchronized EntityGroupTracker trackEntityGroup(Profile.EntityGroup newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            this.checkFailed();
            EntityGroupTracker tracker = this.entityGroups.get(newEntityGroup);
            if (tracker == null) {
                if (this.allowMultipleEg) {
                    if (this.entityGroups.size() >= 25) {
                        throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, LocalDatastoreService.TOO_MANY_ENTITY_GROUP_MESSAGE);
                    }
                } else if (this.entityGroups.size() >= 1) {
                    Profile.EntityGroup entityGroup = this.entityGroups.keySet().iterator().next();
                    throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "cross-group transaction need to be explicitly specified, see TransactionOptions.Builder.withXGfound both " + entityGroup + " and " + newEntityGroup);
                }
                for (EntityGroupTracker other : this.getAllTrackers()) {
                    try {
                        other.checkEntityGroupVersion();
                    }
                    catch (ApiProxy.ApplicationException e) {
                        this.failed = true;
                        throw e;
                    }
                }
                tracker = new EntityGroupTracker(newEntityGroup, this.isReadOnly());
                this.entityGroups.put(newEntityGroup, tracker);
            }
            return tracker;
        }

        synchronized Collection<EntityGroupTracker> getAllTrackers() {
            return this.entityGroups.values();
        }

        synchronized void addActions(Collection<TaskQueuePb.TaskQueueAddRequest> newActions) {
            this.checkFailed();
            if ((long)(this.actions.size() + newActions.size()) > 5L) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "Too many messages, maximum allowed: 5");
            }
            this.actions.addAll(newActions);
        }

        synchronized Collection<TaskQueuePb.TaskQueueAddRequest> getActions() {
            return new ArrayList<TaskQueuePb.TaskQueueAddRequest>(this.actions);
        }

        synchronized boolean isDirty() {
            this.checkFailed();
            for (EntityGroupTracker tracker : this.getAllTrackers()) {
                if (!tracker.isDirty()) continue;
                return true;
            }
            return false;
        }

        synchronized void close() {
            for (EntityGroupTracker tracker : this.getAllTrackers()) {
                tracker.getEntityGroup().removeTransaction(this);
            }
        }

        synchronized boolean isReadOnly() {
            return this.concurrencyMode == ConcurrencyMode.READ_ONLY;
        }

        private void checkFailed() {
            if (this.failed) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, LocalDatastoreService.TRANSACTION_CLOSED);
            }
        }

        static enum ConcurrencyMode {
            OPTIMISTIC,
            PESSIMISTIC,
            SHARED_READ,
            READ_ONLY;

        }
    }

    public static enum AutoIdAllocationPolicy {
        SEQUENTIAL,
        SCATTERED;

    }

    static class SpannerJobPolicy
    implements HighRepJobPolicy {
        SpannerJobPolicy() {
        }

        @Override
        public boolean shouldApplyNewJob(Key entityGroup) {
            return true;
        }

        @Override
        public boolean shouldRollForwardExistingJob(Key entityGroup) {
            return true;
        }
    }

    static class Profile
    implements Serializable {
        private static final long MINIMUM_VERSION = 1L;
        private static final long serialVersionUID = -4667954926644227154L;
        private long lastCommitTimestamp = 1L;
        private final Map<String, Extent> extents = Collections.synchronizedMap(new HashMap());
        private transient Map<OnestoreEntity.Path, EntityGroup> groups;
        private transient Set<OnestoreEntity.Path> groupsWithUnappliedJobs;
        private transient Map<Long, LiveQuery> queries;
        private transient Map<Long, LiveTxn> txns;

        Profile() {
        }

        public synchronized List<VersionedEntity> getAllEntities() {
            ArrayList<VersionedEntity> entities = new ArrayList<VersionedEntity>();
            for (Extent extent : this.extents.values()) {
                entities.addAll(extent.getAllEntities());
            }
            return entities;
        }

        public long getReadTimestamp() {
            return this.lastCommitTimestamp;
        }

        private long incrementAndGetCommitTimestamp() {
            return ++this.lastCommitTimestamp;
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }

        public synchronized EntityGroup getGroup(OnestoreEntity.Path path) {
            Map<OnestoreEntity.Path, EntityGroup> map = this.getGroups();
            EntityGroup group = map.get(path);
            if (group == null) {
                group = new EntityGroup(path);
                map.put(path, group);
            }
            return group;
        }

        private synchronized void groom() {
            for (OnestoreEntity.Path path : new LinkedHashSet<OnestoreEntity.Path>(this.getGroupsWithUnappliedJobs())) {
                EntityGroup eg = this.getGroup(path);
                eg.maybeRollForwardUnappliedJobs();
            }
        }

        public synchronized LiveQuery getQuery(long cursor) {
            return (LiveQuery)LocalDatastoreService.safeGetFromExpiringMap(this.getQueries(), cursor, LocalDatastoreService.QUERY_NOT_FOUND);
        }

        public synchronized void addQuery(long cursor, LiveQuery query) {
            this.getQueries().put(cursor, query);
        }

        private synchronized LiveQuery removeQuery(long cursor) {
            LiveQuery query = this.getQuery(cursor);
            this.queries.remove(cursor);
            return query;
        }

        private synchronized Map<Long, LiveQuery> getQueries() {
            if (this.queries == null) {
                this.queries = new HashMap<Long, LiveQuery>();
            }
            return this.queries;
        }

        public synchronized LiveTxn getTxn(long handle) {
            return (LiveTxn)LocalDatastoreService.safeGetFromExpiringMap(this.getTxns(), handle, LocalDatastoreService.TRANSACTION_NOT_FOUND);
        }

        public synchronized @Nullable LiveTxn getTxnQuietly(long handle) {
            return this.getTxns().get(handle);
        }

        public synchronized void addTxn(long handle, LiveTxn txn) {
            this.getTxns().put(handle, txn);
        }

        private synchronized LiveTxn removeTxn(long handle) {
            LiveTxn txn = this.getTxn(handle);
            txn.close();
            this.txns.remove(handle);
            return txn;
        }

        private synchronized Map<Long, LiveTxn> getTxns() {
            if (this.txns == null) {
                this.txns = new HashMap<Long, LiveTxn>();
            }
            return this.txns;
        }

        private synchronized Map<OnestoreEntity.Path, EntityGroup> getGroups() {
            if (this.groups == null) {
                this.groups = new LinkedHashMap<OnestoreEntity.Path, EntityGroup>();
            }
            return this.groups;
        }

        private synchronized Set<OnestoreEntity.Path> getGroupsWithUnappliedJobs() {
            if (this.groupsWithUnappliedJobs == null) {
                this.groupsWithUnappliedJobs = new LinkedHashSet<OnestoreEntity.Path>();
            }
            return this.groupsWithUnappliedJobs;
        }

        class EntityGroup {
            private final OnestoreEntity.Path path;
            private final AtomicLong version = new AtomicLong();
            private final WeakHashMap<LiveTxn, Profile> snapshots = new WeakHashMap();
            private final LinkedList<LocalDatastoreJob> unappliedJobs = new LinkedList();

            private EntityGroup(OnestoreEntity.Path path) {
                this.path = path;
            }

            public long getVersion() {
                return this.version.get();
            }

            public void incrementVersion() {
                long oldVersion = this.version.getAndIncrement();
                Profile snapshot = null;
                for (Map.Entry<LiveTxn, Profile> entry : this.snapshots.entrySet()) {
                    LiveTxn txn = entry.getKey();
                    if (txn.trackEntityGroup(this).getEntityGroupVersion() != oldVersion) continue;
                    if (snapshot == null) {
                        snapshot = this.takeSnapshot();
                    }
                    entry.setValue(snapshot);
                }
            }

            public VersionedEntity get(@Nullable LiveTxn liveTxn, OnestoreEntity.Reference key, boolean eventualConsistency) {
                Profile profile;
                Map<String, Extent> extents;
                Extent extent;
                if (!eventualConsistency) {
                    this.rollForwardUnappliedJobs();
                }
                if ((extent = (extents = (profile = this.getSnapshot(liveTxn)).getExtents()).get(Utils.getKind(key))) != null) {
                    return extent.getEntityByKey(key);
                }
                return null;
            }

            public EntityGroupTracker addTransaction(LiveTxn txn) {
                EntityGroupTracker tracker = txn.trackEntityGroup(this);
                if (!this.snapshots.containsKey(txn)) {
                    this.snapshots.put(txn, null);
                }
                return tracker;
            }

            public void removeTransaction(LiveTxn txn) {
                this.snapshots.remove(txn);
            }

            private Profile getSnapshot(@Nullable LiveTxn txn) {
                if (txn == null) {
                    return Profile.this;
                }
                Profile snapshot = this.snapshots.get(txn);
                if (snapshot == null) {
                    return Profile.this;
                }
                return snapshot;
            }

            private Profile takeSnapshot() {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(Profile.this);
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    return (Profile)ois.readObject();
                }
                catch (IOException | ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
            }

            public String toString() {
                return this.path.toString();
            }

            public @Nullable LocalDatastoreJob getLastJob() {
                return this.unappliedJobs.isEmpty() ? null : this.unappliedJobs.getLast();
            }

            public void addJob(LocalDatastoreJob job) {
                this.unappliedJobs.addLast(job);
                Profile.this.getGroupsWithUnappliedJobs().add(this.path);
                this.maybeRollForwardUnappliedJobs();
            }

            public void rollForwardUnappliedJobs() {
                if (!this.unappliedJobs.isEmpty()) {
                    for (LocalDatastoreJob applyJob : this.unappliedJobs) {
                        applyJob.apply();
                    }
                    this.unappliedJobs.clear();
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                    logger.fine("Rolled forward unapplied jobs for " + this.path);
                }
            }

            public void maybeRollForwardUnappliedJobs() {
                int jobsAtStart = this.unappliedJobs.size();
                logger.fine(String.format("Maybe rolling forward %d unapplied jobs for %s.", jobsAtStart, this.path));
                int applied = 0;
                Iterator iter = this.unappliedJobs.iterator();
                while (iter.hasNext() && ((LocalDatastoreJob)iter.next()).tryApply()) {
                    iter.remove();
                    ++applied;
                }
                if (this.unappliedJobs.isEmpty()) {
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                }
                logger.fine(String.format("Rolled forward %d of %d jobs for %s", applied, jobsAtStart, this.path));
            }

            public Key pathAsKey() {
                OnestoreEntity.Reference entityGroupRef = new OnestoreEntity.Reference();
                entityGroupRef.setPath(this.path);
                return LocalCompositeIndexManager.KeyTranslator.createFromPb((OnestoreEntity.Reference)entityGroupRef);
            }
        }
    }

    static enum SpecialProperty {
        SCATTER(false, true, OnestoreEntity.Property.Meaning.BYTESTRING){
            private static final int SMALL_LENGTH = 2;

            @Override
            OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
                int hashCode = 0;
                for (OnestoreEntity.Path.Element elem : entity.getKey().getPath().elements()) {
                    if (elem.hasId()) {
                        hashCode = (int)((long)hashCode ^ elem.getId());
                        continue;
                    }
                    if (elem.hasName()) {
                        hashCode ^= elem.getName().hashCode();
                        continue;
                    }
                    throw new IllegalStateException("Couldn't find name or id for entity " + entity.getKey());
                }
                try {
                    byte[] digest = MessageDigest.getInstance("MD5").digest(("" + hashCode).getBytes(StandardCharsets.UTF_8));
                    byte[] miniDigest = new byte[2];
                    System.arraycopy(digest, 0, miniDigest, 0, 2);
                    if ((miniDigest[0] & 1) != 0) {
                        OnestoreEntity.PropertyValue value = new OnestoreEntity.PropertyValue();
                        value.setStringValueAsBytes(miniDigest);
                        return value;
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    Logger logger = Logger.getLogger(SpecialProperty.class.getName());
                    logger.log(Level.WARNING, "Your JDK doesn't have an MD5 implementation, which is required for scatter  property support.");
                }
                return null;
            }
        };

        private final String name = "__" + this.name().toLowerCase() + "__";
        private final boolean isVisible;
        private final boolean isStored;
        private final OnestoreEntity.Property.Meaning meaning;

        private SpecialProperty(boolean isVisible, boolean isStored, OnestoreEntity.Property.Meaning meaning) {
            this.isVisible = isVisible;
            this.isStored = isStored;
            this.meaning = meaning;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        final boolean isStored() {
            return this.isStored;
        }

        OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
            throw new UnsupportedOperationException();
        }

        OnestoreEntity.Property getProperty(OnestoreEntity.PropertyValue value) {
            OnestoreEntity.Property processedProp = new OnestoreEntity.Property();
            processedProp.setName(this.getName());
            processedProp.setValue(value);
            processedProp.setMultiple(false);
            processedProp.setMeaning(this.meaning);
            return processedProp;
        }
    }

    static class EntityGroupTracker {
        private final Profile.EntityGroup entityGroup;
        private final Long entityGroupVersion;
        private final boolean readOnly;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> written = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private final Set<OnestoreEntity.Reference> deleted = new HashSet<OnestoreEntity.Reference>();

        EntityGroupTracker(Profile.EntityGroup entityGroup, boolean readOnly) {
            this.entityGroup = entityGroup;
            this.entityGroupVersion = entityGroup.getVersion();
            this.readOnly = readOnly;
        }

        synchronized Profile.EntityGroup getEntityGroup() {
            return this.entityGroup;
        }

        synchronized void checkEntityGroupVersion() {
            if (!this.entityGroupVersion.equals(this.entityGroup.getVersion())) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION, LocalDatastoreService.CONTENTION_MESSAGE);
            }
        }

        synchronized Long getEntityGroupVersion() {
            return this.entityGroupVersion;
        }

        synchronized void addWrittenEntity(OnestoreEntity.EntityProto entity) {
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0);
            OnestoreEntity.Reference key = entity.getKey();
            this.written.put(key, entity);
            this.deleted.remove(key);
        }

        synchronized void addDeletedEntity(OnestoreEntity.Reference key) {
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0);
            this.deleted.add(key);
            this.written.remove(key);
        }

        synchronized Collection<OnestoreEntity.EntityProto> getWrittenEntities() {
            return new ArrayList<OnestoreEntity.EntityProto>(this.written.values());
        }

        synchronized Collection<OnestoreEntity.Reference> getDeletedKeys() {
            return new ArrayList<OnestoreEntity.Reference>(this.deleted);
        }

        synchronized boolean isDirty() {
            return this.written.size() + this.deleted.size() > 0;
        }
    }

    @AutoValue
    static abstract class VersionedEntity {
        VersionedEntity() {
        }

        public abstract OnestoreEntity.EntityProto entityProto();

        public abstract long version();

        public static VersionedEntity create(OnestoreEntity.EntityProto entityProto, long version) {
            return new AutoValue_LocalDatastoreService_VersionedEntity(entityProto, version);
        }
    }

    class WriteJob
    extends LocalDatastoreJob {
        private final Profile profile;
        private @Nullable LocalDatastoreJob previousJob;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> puts;
        private final Set<OnestoreEntity.Reference> deletes;

        WriteJob(HighRepJobPolicy jobPolicy, Profile.EntityGroup entityGroup, Profile profile, Iterable<OnestoreEntity.EntityProto> puts, Iterable<OnestoreEntity.Reference> deletes) {
            this(jobPolicy, entityGroup, profile, ((Profile)Preconditions.checkNotNull((Object)profile)).incrementAndGetCommitTimestamp(), puts, deletes);
        }

        WriteJob(HighRepJobPolicy jobPolicy, Profile.EntityGroup entityGroup, Profile profile, long commitTimestamp, Iterable<OnestoreEntity.EntityProto> puts, Iterable<OnestoreEntity.Reference> deletes) {
            super(jobPolicy, entityGroup.pathAsKey(), commitTimestamp);
            this.profile = (Profile)Preconditions.checkNotNull((Object)profile);
            this.previousJob = entityGroup.getLastJob();
            this.deletes = ImmutableSet.copyOf(deletes);
            HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto> dedupePuts = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
            for (OnestoreEntity.EntityProto put : puts) {
                dedupePuts.put(put.getKey(), put);
            }
            this.puts = ImmutableMap.copyOf(dedupePuts);
        }

        @Override
        OnestoreEntity.EntityProto getEntity(OnestoreEntity.Reference key) {
            if (this.deletes.contains(key)) {
                return null;
            }
            if (this.puts.containsKey(key)) {
                return this.puts.get(key);
            }
            return this.getSnapshotEntity(key);
        }

        @Override
        OnestoreEntity.EntityProto getSnapshotEntity(OnestoreEntity.Reference key) {
            if (this.previousJob != null) {
                return this.previousJob.getEntity(key);
            }
            Extent extent = this.profile.getExtents().get(Utils.getKind(key));
            return extent == null ? null : extent.getEntityProtoByKey(key);
        }

        @Override
        DatastorePb.Cost calculateJobCost() {
            OnestoreEntity.EntityProto oldEntity;
            DatastorePb.Cost totalCost = new DatastorePb.Cost();
            for (OnestoreEntity.Reference key : this.deletes) {
                oldEntity = this.getSnapshotEntity(key);
                if (oldEntity == null) continue;
                LocalDatastoreService.addTo(totalCost, LocalDatastoreService.this.costAnalysis.getWriteCost(oldEntity));
            }
            for (OnestoreEntity.EntityProto entity : this.puts.values()) {
                oldEntity = this.getSnapshotEntity(entity.getKey());
                LocalDatastoreService.addTo(totalCost, LocalDatastoreService.this.costAnalysis.getWriteOps(oldEntity, entity));
            }
            return totalCost;
        }

        @Override
        void applyInternal() {
            Extent extent;
            this.previousJob = null;
            for (OnestoreEntity.Reference reference : this.deletes) {
                extent = this.profile.getExtents().get(Utils.getKind(reference));
                if (extent == null) continue;
                extent.removeEntity(reference);
            }
            for (Map.Entry entry : this.puts.entrySet()) {
                if (this.isNoOpWrite((OnestoreEntity.Reference)entry.getKey())) continue;
                extent = LocalDatastoreService.this.getOrCreateExtent(this.profile, Utils.getKind((OnestoreEntity.Reference)entry.getKey()));
                extent.putEntity(VersionedEntity.create((OnestoreEntity.EntityProto)entry.getValue(), this.timestamp));
            }
            LocalDatastoreService.this.dirty = true;
        }

        @Override
        public long getMutationTimestamp(OnestoreEntity.Reference key) {
            if (this.isNoOpWrite(key)) {
                VersionedEntity entity;
                if (this.previousJob != null) {
                    return this.previousJob.getMutationTimestamp(key);
                }
                Extent extent = this.profile.getExtents().get(Utils.getKind(key));
                if (extent != null && (entity = extent.getEntityByKey(key)) != null) {
                    return entity.version();
                }
                return this.profile.getReadTimestamp();
            }
            return this.timestamp;
        }

        public boolean isNoOpWrite(OnestoreEntity.Reference key) {
            if (this.deletes.contains(key)) {
                return this.getSnapshotEntity(key) == null;
            }
            if (this.puts.containsKey(key)) {
                return LocalDatastoreService.equalProperties(this.getSnapshotEntity(key), this.puts.get(key));
            }
            return true;
        }
    }

    static class Extent
    implements Serializable {
        private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private Map<OnestoreEntity.Reference, Long> versions = new HashMap<OnestoreEntity.Reference, Long>();
        private static final long serialVersionUID = 1199103439874512494L;
        private static final String ENTITY_VERSION_RESERVED_PROPERTY = "__entity_version__";

        Extent() {
        }

        public Collection<VersionedEntity> getAllEntities() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (OnestoreEntity.Reference key : this.entities.keySet()) {
                builder.add((Object)this.getEntityByKey(key));
            }
            return builder.build();
        }

        public Collection<OnestoreEntity.EntityProto> getAllEntityProtos() {
            return this.entities.values();
        }

        public VersionedEntity getEntityByKey(OnestoreEntity.Reference key) {
            OnestoreEntity.EntityProto entity = this.entities.get(key);
            Long version = this.versions.get(key);
            return entity == null ? null : VersionedEntity.create(entity, version);
        }

        public OnestoreEntity.EntityProto getEntityProtoByKey(OnestoreEntity.Reference key) {
            return this.entities.get(key);
        }

        public void removeEntity(OnestoreEntity.Reference key) {
            this.versions.remove(key);
            this.entities.remove(key);
        }

        public void putEntity(VersionedEntity entity) {
            OnestoreEntity.Reference key = entity.entityProto().getKey();
            this.entities.put(key, entity.entityProto());
            this.versions.put(key, entity.version());
        }

        private byte[] serializeEntity(VersionedEntity entity) {
            OnestoreEntity.EntityProto stored = new OnestoreEntity.EntityProto();
            stored.copyFrom((ProtocolMessage)entity.entityProto());
            OnestoreEntity.Property version = stored.addProperty();
            version.setName(ENTITY_VERSION_RESERVED_PROPERTY);
            version.setValue(new OnestoreEntity.PropertyValue().setInt64Value(entity.version()));
            return stored.toByteArray();
        }

        private VersionedEntity deserializeEntity(byte[] serialized) throws IOException {
            OnestoreEntity.EntityProto entityProto = new OnestoreEntity.EntityProto();
            if (!entityProto.parseFrom(serialized)) {
                throw new IOException("Corrupt or incomplete EntityProto");
            }
            long version = 1L;
            Iterator iter = entityProto.mutablePropertys().iterator();
            while (iter.hasNext()) {
                OnestoreEntity.Property property = (OnestoreEntity.Property)iter.next();
                if (!property.getName().equals(ENTITY_VERSION_RESERVED_PROPERTY)) continue;
                version = property.getValue().getInt64Value();
                iter.remove();
                break;
            }
            return VersionedEntity.create(entityProto, version);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.putFields();
            out.writeFields();
            out.writeLong(2L);
            out.writeInt(this.entities.size());
            for (VersionedEntity entity : this.getAllEntities()) {
                out.writeObject(this.serializeEntity(entity));
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField fields = in.readFields();
            if (fields.get("entities", null) != null) {
                LinkedHashMap legacy;
                this.entities = legacy = (LinkedHashMap)fields.get("entities", null);
                this.versions = new HashMap<OnestoreEntity.Reference, Long>();
                for (OnestoreEntity.Reference key : this.entities.keySet()) {
                    this.versions.put(key, 1L);
                }
            } else {
                this.entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
                this.versions = new HashMap<OnestoreEntity.Reference, Long>();
                long version = in.readLong();
                if (version == 2L) {
                    int entityCount = in.readInt();
                    for (int i = 0; i < entityCount; ++i) {
                        VersionedEntity entity = this.deserializeEntity((byte[])in.readObject());
                        OnestoreEntity.Reference key = entity.entityProto().getKey();
                        this.entities.put(key, entity.entityProto());
                        this.versions.put(key, entity.version());
                    }
                } else {
                    throw new IOException(String.format("Unsupported storage format [%d]", version));
                }
            }
        }
    }

    class LiveQuery
    extends HasCreationTime {
        private final Set<String> orderProperties;
        private final Set<String> projectedProperties;
        private final Set<String> groupByProperties;
        private final DatastorePb.Query query;
        private final List<OnestoreEntity.EntityProto> entities;
        private final Map<OnestoreEntity.Reference, Long> versions;
        private OnestoreEntity.EntityProto lastResult;
        private int remainingOffset;

        public LiveQuery(@Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
        OnestoreEntity.EntityProto> entities, Map<OnestoreEntity.Reference, Long> versions, DatastorePb.Query query, EntityProtoComparators.EntityProtoComparator entityComparator, Clock clock) {
            int toIndex;
            super(clock.getCurrentTime());
            this.lastResult = null;
            this.remainingOffset = 0;
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.query = query;
            this.remainingOffset = query.getOffset();
            this.orderProperties = new HashSet<String>();
            for (Object order : entityComparator.getAdjustedOrders()) {
                if ("__key__".equals(order.getProperty())) continue;
                this.orderProperties.add(order.getProperty());
            }
            this.groupByProperties = Sets.newHashSet((Iterable)query.groupByPropertyNames());
            this.projectedProperties = Sets.newHashSet((Iterable)query.propertyNames());
            this.entities = Lists.newArrayList(entities);
            ImmutableMap.Builder versionsBuilder = ImmutableMap.builder();
            if (this.projectedProperties.isEmpty() && !this.query.isKeysOnly() && versions != null) {
                for (OnestoreEntity.EntityProto entity : this.entities) {
                    OnestoreEntity.Reference key = entity.getKey();
                    Preconditions.checkArgument((boolean)versions.containsKey(key));
                    versionsBuilder.put((Object)key, (Object)versions.get(key));
                }
            }
            this.versions = versionsBuilder.buildOrThrow();
            DecompiledCursor startCursor = new DecompiledCursor(query.hasCompiledCursor() ? query.getCompiledCursor() : null, true);
            DecompiledCursor endCursor = new DecompiledCursor(query.hasEndCompiledCursor() ? query.getEndCompiledCursor() : null, false);
            this.lastResult = startCursor.getCursorEntity();
            int endCursorPos = Math.min(endCursor.getPosition(entityComparator), this.entities.size());
            int startCursorPos = Math.min(endCursorPos, startCursor.getPosition(entityComparator));
            if (endCursorPos < this.entities.size()) {
                this.entities.subList(endCursorPos, this.entities.size()).clear();
            }
            this.entities.subList(0, startCursorPos).clear();
            if (query.hasLimit() && (toIndex = (int)Math.min((long)query.getLimit() + (long)query.getOffset(), Integer.MAX_VALUE)) < this.entities.size()) {
                this.entities.subList(toIndex, this.entities.size()).clear();
            }
        }

        private int offsetResults(int offset) {
            int realOffset = Math.min(Math.min(offset, this.entities.size()), 300);
            if (realOffset > 0) {
                this.lastResult = this.entities.get(realOffset - 1);
                this.entities.subList(0, realOffset).clear();
                this.remainingOffset -= realOffset;
            }
            return realOffset;
        }

        public DatastorePb.QueryResult nextResult(Integer offset, Integer count, boolean compile) {
            DatastorePb.QueryResult result = new DatastorePb.QueryResult();
            if (count == null) {
                count = this.query.hasCount() ? Integer.valueOf(this.query.getCount()) : Integer.valueOf(20);
            }
            if (offset != null && offset != this.remainingOffset) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "offset mismatch");
            }
            offset = this.remainingOffset;
            if (offset > 0) {
                result.setSkippedResults(this.offsetResults(offset));
                if (compile) {
                    result.getMutableSkippedResultsCompiledCursor().setPostfixPosition(this.compilePosition(this.lastResult));
                }
            }
            if (offset.intValue() == result.getSkippedResults()) {
                List<OnestoreEntity.EntityProto> entities = this.removeEntities(Math.min(300, count));
                for (OnestoreEntity.EntityProto entity : entities) {
                    result.mutableResults().add(this.postProcessEntityForQuery(entity));
                    if (!this.versions.isEmpty()) {
                        result.mutableVersions().add(this.versions.get(entity.getKey()));
                    }
                    if (!compile) continue;
                    result.addResultCompiledCursor().setPostfixPosition(this.compilePosition(entity));
                }
            }
            result.setMoreResults(!this.entities.isEmpty());
            result.setKeysOnly(this.query.isKeysOnly());
            result.setIndexOnly(this.query.propertyNameSize() > 0);
            if (compile) {
                result.getMutableCompiledCursor().setPostfixPosition(this.compilePosition(this.lastResult));
            }
            return result;
        }

        private List<OnestoreEntity.EntityProto> removeEntities(int count) {
            List<OnestoreEntity.EntityProto> subList = this.entities.subList(0, Math.min(count, this.entities.size()));
            if (!subList.isEmpty()) {
                this.lastResult = subList.get(subList.size() - 1);
            }
            ArrayList<OnestoreEntity.EntityProto> results = new ArrayList<OnestoreEntity.EntityProto>(subList);
            subList.clear();
            return results;
        }

        private OnestoreEntity.EntityProto postProcessEntityForQuery(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.EntityProto result;
            if (!this.projectedProperties.isEmpty()) {
                result = new OnestoreEntity.EntityProto();
                result.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
                result.getMutableEntityGroup();
                HashSet seenProps = Sets.newHashSetWithExpectedSize((int)this.query.propertyNameSize());
                for (OnestoreEntity.Property prop : entity.propertys()) {
                    if (!this.projectedProperties.contains(prop.getName())) continue;
                    if (!seenProps.add(prop.getName())) {
                        throw Utils.newError(DatastorePb.Error.ErrorCode.INTERNAL_ERROR, "LocalDatastoreServer produced invalid results.");
                    }
                    result.addProperty().setName(prop.getName()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).setMultiple(false).getMutableValue().copyFrom((ProtocolMessage)prop.getValue());
                }
            } else if (this.query.isKeysOnly()) {
                result = new OnestoreEntity.EntityProto();
                result.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
                result.getMutableEntityGroup();
            } else {
                result = (OnestoreEntity.EntityProto)entity.clone();
            }
            LocalDatastoreService.this.postprocessEntity(result);
            return result;
        }

        private OnestoreEntity.EntityProto decompilePosition(OnestoreEntity.IndexPostfix position) {
            OnestoreEntity.EntityProto result = new OnestoreEntity.EntityProto();
            if (position.hasKey()) {
                String cursorKind;
                String queryKind;
                if (this.query.hasKind() && !(queryKind = this.query.getKind()).equals(cursorKind = ((OnestoreEntity.Path.Element)Iterables.getLast((Iterable)position.getKey().getPath().elements())).getType())) {
                    throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, String.format("The query kind is %s but cursor.postfix_position.key kind is %s.", queryKind, cursorKind));
                }
                result.setKey(position.getKey());
            }
            Set<String> cursorProperties = this.groupByProperties.isEmpty() ? this.orderProperties : this.groupByProperties;
            HashSet<String> remainingProperties = new HashSet<String>(cursorProperties);
            for (OnestoreEntity.IndexPostfix_IndexValue prop : position.indexValues()) {
                if (!cursorProperties.contains(prop.getPropertyName())) {
                    throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "cursor does not match query");
                }
                remainingProperties.remove(prop.getPropertyName());
                result.addProperty().setName(prop.getPropertyName()).setValue(prop.getValue());
            }
            if (!remainingProperties.isEmpty()) {
                throw Utils.newError(DatastorePb.Error.ErrorCode.BAD_REQUEST, "cursor does not match query");
            }
            return result;
        }

        private OnestoreEntity.IndexPostfix compilePosition(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.IndexPostfix position = new OnestoreEntity.IndexPostfix();
            if (entity != null) {
                HashSet cursorProperties;
                if (this.groupByProperties.isEmpty()) {
                    cursorProperties = Sets.newHashSet(this.orderProperties);
                    cursorProperties.add("__key__");
                    position.setKey(entity.getKey());
                } else {
                    cursorProperties = this.groupByProperties;
                }
                for (OnestoreEntity.Property prop : entity.propertys()) {
                    if (!cursorProperties.contains(prop.getName())) continue;
                    position.addIndexValue().setPropertyName(prop.getName()).setValue(prop.getValue());
                }
                position.setBefore(false);
                CursorModernizer.setBeforeAscending(position, CursorModernizer.firstSortDirection(this.query));
            }
            return position;
        }

        public DatastorePb.CompiledQuery compileQuery() {
            DatastorePb.CompiledQuery result = new DatastorePb.CompiledQuery();
            DatastorePb.CompiledQuery.PrimaryScan scan = result.getMutablePrimaryScan();
            scan.setIndexNameAsBytes(this.query.toByteArray());
            return result;
        }

        class DecompiledCursor {
            final OnestoreEntity.EntityProto cursorEntity;
            final boolean inclusive;
            final boolean isStart;

            public DecompiledCursor(DatastorePb.CompiledCursor compiledCursor, boolean isStart) {
                if (compiledCursor == null) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    this.isStart = isStart;
                    return;
                }
                OnestoreEntity.IndexPostfix position = compiledCursor.getPostfixPosition();
                if (!position.hasKey() && position.indexValueSize() <= 0) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    this.isStart = true;
                    return;
                }
                this.cursorEntity = LiveQuery.this.decompilePosition(position);
                this.inclusive = position.isBefore();
                this.isStart = isStart;
            }

            public int getPosition(EntityProtoComparators.EntityProtoComparator entityComparator) {
                if (this.cursorEntity == null) {
                    return this.isStart ? 0 : Integer.MAX_VALUE;
                }
                int loc = Collections.binarySearch(LiveQuery.this.entities, this.cursorEntity, entityComparator);
                if (loc < 0) {
                    return -(loc + 1);
                }
                return this.inclusive ? loc : loc + 1;
            }

            public OnestoreEntity.EntityProto getCursorEntity() {
                return this.cursorEntity;
            }
        }
    }

    @AutoValue
    static abstract class NameValue {
        NameValue() {
        }

        public abstract String name();

        public abstract OnestoreEntity.PropertyValue value();

        public static NameValue of(String name, OnestoreEntity.PropertyValue value) {
            return new AutoValue_LocalDatastoreService_NameValue(name, value);
        }
    }

    static class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }
}

