/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.development.AutoValue_EnvironmentVariableChecker_Mismatch;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class EnvironmentVariableChecker {
    @VisibleForTesting
    static final Logger LOGGER = Logger.getLogger(EnvironmentVariableChecker.class.getName());
    private final MismatchReportingPolicy mismatchReportingPolicy;
    private final ImmutableList.Builder<Mismatch> mismatchListBuilder = ImmutableList.builder();

    EnvironmentVariableChecker(MismatchReportingPolicy mismatchReportingPolicy) {
        this.mismatchReportingPolicy = mismatchReportingPolicy;
    }

    void add(AppEngineWebXml appEngineWebXml, File appEngineWebXmlFile) {
        for (Map.Entry entry : appEngineWebXml.getEnvironmentVariables().entrySet()) {
            if (((String)entry.getValue()).equals(System.getenv((String)entry.getKey()))) continue;
            this.mismatchListBuilder.add((Object)Mismatch.of((String)entry.getKey(), System.getenv((String)entry.getKey()), (String)entry.getValue(), appEngineWebXmlFile));
        }
    }

    void check() throws AppEngineConfigException {
        if (Boolean.getBoolean("appengine.disableEnvironmentCheck")) {
            return;
        }
        ImmutableList mismatches = this.mismatchListBuilder.build();
        if (!mismatches.isEmpty()) {
            String msg = "One or more environment variables have been configured in appengine-web.xml that have missing or different values in your local environment. We recommend you use system properties instead, but if you are interacting with legacy code that requires specific environment variables to have specific values, please set these environment variables in your environment before running.\n" + mismatches;
            if (this.mismatchReportingPolicy == MismatchReportingPolicy.LOG) {
                LOGGER.warning(msg);
            } else if (this.mismatchReportingPolicy == MismatchReportingPolicy.EXCEPTION) {
                throw new IncorrectEnvironmentVariableException(msg, (List)mismatches);
            }
        }
    }

    public static enum MismatchReportingPolicy {
        LOG,
        EXCEPTION,
        NONE;

    }

    @VisibleForTesting
    @AutoValue
    static abstract class Mismatch {
        Mismatch() {
        }

        abstract String getEnvironmentVariableName();

        abstract @Nullable String getEnvironmentVariableValue();

        abstract String getAppEngineWebXmlValue();

        abstract File getAppEngineWebXmlFile();

        static Mismatch of(String name, String value, String appEngineWebXmlValue, File appEngineWebXmlFile) {
            return new AutoValue_EnvironmentVariableChecker_Mismatch(name, value, appEngineWebXmlValue, appEngineWebXmlFile);
        }
    }

    @VisibleForTesting
    public static class IncorrectEnvironmentVariableException
    extends AppEngineConfigException {
        private final List<Mismatch> mismatches;

        private IncorrectEnvironmentVariableException(String msg, List<Mismatch> mismatches) {
            super(msg);
            this.mismatches = mismatches;
        }

        public List<Mismatch> getMismatches() {
            return this.mismatches;
        }
    }
}

