/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ApiServlet;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpApiServer
implements Closeable {
    private static final Logger logger = Logger.getLogger(HttpApiServer.class.getName());
    private static final String API_SERVER_PORT = "--api_server_port=";
    private static final String HELP = "--help";
    private static final String HELP_MESSAGE = "Usage: com.google.appengine.tools.development.HttpApiServer [--api_server_port=8089] [--runtime_server_port=8080] [--runtime_server_host=localhost]";
    private static final String API_SERVER_PORT_ERROR_MESSAGE = "Incorrect --api_server_port value";
    private static final String RUNTIME_SERVER_PORT = "--runtime_server_port=";
    private static final String RUNTIME_SERVER_HOST = "--runtime_server_host=";
    private static final String RUNTIME_PORT_HOST_ERROR_MESSAGE = "Incorrect --runtime_server_port or --runtime_server_host value";
    private static final String REQUEST_ENDPOINT = "/rpc_http";
    private final Server server;
    private final ShutdownHandler shutdownHandler;

    public static void main(String[] args) throws IOException {
        int apiServerPort = 8089;
        int appEngineServerPort = 8080;
        String appEngineServerHost = "localhost";
        for (String element : args) {
            if (element.startsWith(API_SERVER_PORT)) {
                apiServerPort = HttpApiServer.extractValue(element, API_SERVER_PORT_ERROR_MESSAGE);
                continue;
            }
            if (element.startsWith(RUNTIME_SERVER_PORT)) {
                appEngineServerPort = HttpApiServer.extractValue(element, RUNTIME_PORT_HOST_ERROR_MESSAGE);
                continue;
            }
            if (element.startsWith(RUNTIME_SERVER_HOST)) {
                appEngineServerHost = HttpApiServer.extractStringValue(element, RUNTIME_PORT_HOST_ERROR_MESSAGE);
                continue;
            }
            if (element.startsWith(HELP)) {
                logger.info(HELP_MESSAGE);
                System.exit(0);
                continue;
            }
            logger.info(HELP_MESSAGE);
            System.exit(1);
        }
        HttpApiServer apiserver = new HttpApiServer(apiServerPort, appEngineServerHost, appEngineServerPort);
        apiserver.start(true);
    }

    public HttpApiServer(int apiServerPort, String appEngineServerHost, int appEngineServerPort) {
        this.server = new Server(apiServerPort);
        HandlerList handlers = new HandlerList();
        ServletHandler handler = new ServletHandler();
        ServletHolder servletHolder = handler.addServletWithMapping(ApiServlet.class, REQUEST_ENDPOINT);
        servletHolder.setInitParameter("java_runtime_port", Integer.toString(appEngineServerPort));
        servletHolder.setInitParameter("java_runtime_host", appEngineServerHost);
        ErrorPageErrorHandler error = new ErrorPageErrorHandler();
        error.setShowStacks(true);
        error.setServer(this.server);
        this.server.addBean((Object)error);
        this.server.setHandler((Handler)handler);
        handlers.addHandler((Handler)handler);
        this.shutdownHandler = new ShutdownHandler("stop", false, true);
        handlers.addHandler((Handler)this.shutdownHandler);
        this.server.setHandler((Handler)handlers);
    }

    public void start(boolean blocking) {
        try {
            this.server.start();
            if (blocking) {
                this.server.join();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.shutdownHandler.sendShutdown();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int extractValue(String argument, String errorMessage) {
        return Integer.parseInt(HttpApiServer.extractStringValue(argument, errorMessage));
    }

    private static String extractStringValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            logger.severe(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(indexOfEqualSign + 1);
    }
}

