/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.appengine.repackaged.com.google.errorprone.annotations.FormatMethod;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.logs.ProblemCode;
import org.jspecify.annotations.Nullable;

public class InvalidConversionException
extends ValidationException {
    public InvalidConversionException(String message) {
        super(message);
    }

    public InvalidConversionException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidConversionException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public InvalidConversionException(String message, ProblemCode problemCode) {
        super(message, problemCode);
    }

    public static void checkConversion(boolean assertion, String message) throws InvalidConversionException {
        if (!assertion) {
            throw new InvalidConversionException(message);
        }
    }

    @FormatMethod
    public static void checkConversion(boolean assertion, String message, Object ... messageArgs) throws InvalidConversionException {
        if (!assertion) {
            throw new InvalidConversionException(String.format(message, messageArgs));
        }
    }

    @FormatMethod
    public static void checkConversion(boolean assertion, ProblemCode problemCode, String message, Object ... messageArgs) throws InvalidConversionException {
        if (!assertion) {
            throw new InvalidConversionException(String.format(message, messageArgs), problemCode);
        }
    }

    @FormatMethod
    public static void checkConversionIf(boolean assertion, ProblemCode problemCode, boolean validationEnabled, @Nullable SuppressedValidationFailures suppressedFailures, String message, Object ... messageArgs) throws InvalidConversionException {
        if (assertion) {
            return;
        }
        if (validationEnabled) {
            throw new InvalidConversionException(String.format(message, messageArgs), problemCode);
        }
        if (suppressedFailures != null) {
            suppressedFailures.add(problemCode);
        }
    }

    public static InvalidConversionException unrecognizedEnumValue(String field, Enum<?> enumValue) {
        return new InvalidConversionException("Unrecognized " + field + ": " + enumValue);
    }
}

