/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHolder;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.Module;
import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public abstract class AbstractModule<I extends InstanceHolder>
implements Module {
    static final Logger LOGGER = Logger.getLogger(AbstractModule.class.getName());
    private final ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle;
    private final String serverInfo;
    private final File externalResourceDir;
    private final String address;
    private final DevAppServer devAppServer;
    private final List<I> instanceHolders;
    private ApiProxy.Delegate<?> apiProxyDelegate;
    private LocalServerEnvironment localServerEnvironment;

    protected AbstractModule(ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, String serverInfo, File externalResourceDir, String address, DevAppServer devAppServer, List<I> instanceHolders) {
        this.moduleConfigurationHandle = moduleConfigurationHandle;
        this.serverInfo = serverInfo;
        this.externalResourceDir = externalResourceDir;
        this.address = address;
        this.devAppServer = devAppServer;
        this.instanceHolders = new CopyOnWriteArrayList<I>(instanceHolders);
    }

    @Override
    public String getModuleName() {
        return this.moduleConfigurationHandle.getModule().getModuleName();
    }

    protected List<I> getInstanceHolders() {
        return this.instanceHolders;
    }

    @Override
    public LocalServerEnvironment getLocalServerEnvironment() {
        return this.localServerEnvironment;
    }

    @Override
    public final void configure(Map<String, Object> containerConfigProperties) throws Exception {
        if (this.localServerEnvironment == null) {
            this.localServerEnvironment = this.doConfigure(this.moduleConfigurationHandle, this.serverInfo, this.externalResourceDir, this.address, containerConfigProperties, this.devAppServer);
        }
    }

    @Override
    public void createConnection() throws Exception {
        for (InstanceHolder instanceHolder : this.instanceHolders) {
            instanceHolder.createConnection();
        }
    }

    @Override
    public void setApiProxyDelegate(ApiProxy.Delegate<?> apiProxyDelegate) {
        for (InstanceHolder instanceHolder : this.instanceHolders) {
            instanceHolder.getContainerService().setApiProxyDelegate(apiProxyDelegate);
        }
    }

    @Override
    public void startup() throws Exception {
        for (InstanceHolder instanceHolder : this.instanceHolders) {
            instanceHolder.startUp();
            String listeningHostAndPort = this.getHostAndPort(instanceHolder);
            if (instanceHolder.isMainInstance()) {
                LOGGER.info(String.format("Module instance %s is running at http://%s/", this.getModuleName(), listeningHostAndPort));
            } else {
                LOGGER.info(String.format("Module instance %s instance %s is running at http://%s/", this.getModuleName(), instanceHolder.getInstance(), listeningHostAndPort));
            }
            LOGGER.info("The admin console is running at http://" + listeningHostAndPort + "/_ah/admin");
        }
    }

    @Override
    public String getHostAndPort(int instance) {
        I instanceHolder = this.getInstanceHolder(instance);
        if (instanceHolder == null) {
            return null;
        }
        return this.getHostAndPort(instanceHolder);
    }

    private String getHostAndPort(I instanceHolder) {
        ContainerService containerService = instanceHolder.getContainerService();
        String prettyAddress = containerService.getAddress();
        if (prettyAddress.equals("0.0.0.0") || prettyAddress.equals("127.0.0.1")) {
            prettyAddress = "localhost";
        }
        String listeningHostAndPort = prettyAddress + ":" + containerService.getPort();
        return listeningHostAndPort;
    }

    public I getInstanceHolder(int instance) {
        if (instance < -1 || instance + 1 > this.instanceHolders.size()) {
            return null;
        }
        return (I)((InstanceHolder)this.instanceHolders.get(instance + 1));
    }

    @Override
    public void shutdown() throws Exception {
        for (InstanceHolder instanceHolder : this.instanceHolders) {
            instanceHolder.getContainerService().shutdown();
            if (instanceHolder.isMainInstance()) {
                LOGGER.info("Shutting down module instance " + this.getModuleName());
                continue;
            }
            LOGGER.info("Shutting down module instance " + this.getModuleName() + " instance " + instanceHolder.getInstance());
        }
    }

    @Override
    public ContainerService getMainContainer() {
        return ((InstanceHolder)this.instanceHolders.get(0)).getContainerService();
    }

    public I getAndReserveAvailableInstanceHolder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startServing() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopServing() throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract LocalServerEnvironment doConfigure(ApplicationConfigurationManager.ModuleConfigurationHandle var1, String var2, File var3, String var4, Map<String, Object> var5, DevAppServer var6) throws Exception;
}

