/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.quartz.utils.ConnectionProvider;

public class JNDIConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties props;
    private Object datasource;
    private boolean alwaysLookup = false;

    public JNDIConnectionProvider(String jndiUrl, boolean alwaysLookup) {
        this.url = jndiUrl;
        this.alwaysLookup = alwaysLookup;
        this.init();
    }

    public JNDIConnectionProvider(String jndiUrl, Properties jndiProps, boolean alwaysLookup) {
        this.url = jndiUrl;
        this.props = jndiProps;
        this.alwaysLookup = alwaysLookup;
        this.init();
    }

    Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.isAlwaysLookup()) return;
        InitialContext ctx = null;
        ctx = this.props != null ? new InitialContext(this.props) : new InitialContext();
        this.datasource = (DataSource)ctx.lookup(this.url);
        Object var4_2 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (Exception ignore) {}
        return;
        {
            catch (Exception e) {
                this.getLog().error((Object)("Error looking up datasource: " + e.getMessage()), (Throwable)e);
                Object var4_3 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Connection getConnection() throws SQLException {
        Context ctx;
        block15: {
            Connection connection;
            block16: {
                Object ds;
                block13: {
                    Connection connection2;
                    block14: {
                        ctx = null;
                        ds = this.datasource;
                        if (ds == null || this.isAlwaysLookup()) {
                            ctx = this.props != null ? new InitialContext(this.props) : new InitialContext();
                            ds = ctx.lookup(this.url);
                            if (!this.isAlwaysLookup()) {
                                this.datasource = ds;
                            }
                        }
                        if (ds == null) {
                            throw new SQLException("There is no object at the JNDI URL '" + this.url + "'");
                        }
                        if (!(ds instanceof XADataSource)) break block13;
                        connection2 = ((XADataSource)ds).getXAConnection().getConnection();
                        Object var5_6 = null;
                        if (ctx == null) break block14;
                        try {
                            ctx.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    return connection2;
                }
                if (!(ds instanceof DataSource)) break block15;
                connection = ((DataSource)ds).getConnection();
                Object var5_7 = null;
                if (ctx == null) break block16;
                try {
                    ctx.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            return connection;
        }
        try {
            try {
                throw new SQLException("Object at JNDI URL '" + this.url + "' is not a DataSource.");
            }
            catch (Exception e) {
                this.datasource = null;
                throw new SQLException("Could not retrieve datasource via JNDI url '" + this.url + "' " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            block17: {
                Object var5_8 = null;
                if (ctx == null) break block17;
                try {
                    ctx.close();
                }
                catch (Exception ignore) {}
            }
            throw throwable;
        }
    }

    public boolean isAlwaysLookup() {
        return this.alwaysLookup;
    }

    public void setAlwaysLookup(boolean b) {
        this.alwaysLookup = b;
    }

    public void shutdown() throws SQLException {
    }
}

