/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.blobstore.dev.BlobUploadSessionStorage;
import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.Closeables;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.utils.servlet.MultipartMimeUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public final class UploadBlobServlet
extends HttpServlet {
    private static final long serialVersionUID = -813190429684600745L;
    private static final Logger logger = Logger.getLogger(UploadBlobServlet.class.getName());
    static final String UPLOAD_HEADER = "X-AppEngine-BlobUpload";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String UPLOADED_BLOBINFO_ATTR = "com.google.appengine.api.blobstore.upload.blobinfos";
    static final String UPLOAD_TOO_LARGE_RESPONSE = "Your client issued a request that was too large.";
    static final String UPLOAD_BLOB_TOO_LARGE_RESPONSE = "Your client issued a request that was too large. Maximum upload size per blob limit exceeded.";
    static final String UPLOAD_TOTAL_TOO_LARGE_RESPONSE = "Your client issued a request that was too large. Maximum total upload size limit exceeded.";
    private BlobStorage blobStorage;
    private BlobInfoStorage blobInfoStorage;
    private BlobUploadSessionStorage uploadSessionStorage;
    private SecureRandom secureRandom;
    private ApiProxyLocal apiProxyLocal;

    public void init() throws ServletException {
        super.init();
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        this.blobInfoStorage = BlobStorageFactory.getBlobInfoStorage();
        this.uploadSessionStorage = new BlobUploadSessionStorage();
        this.secureRandom = new SecureRandom();
        this.apiProxyLocal = (ApiProxyLocal)this.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleUpload(req, resp);
    }

    private String getSessionId(HttpServletRequest req) {
        return req.getPathInfo().substring(1);
    }

    private Map<String, String> getInfoFromStorage(BlobKey key, BlobUploadSession uploadSession) {
        BlobInfo blobInfo = this.blobInfoStorage.loadBlobInfo(key);
        HashMap<String, String> info = new HashMap<String, String>(6);
        info.put("key", key.getKeyString());
        info.put("content-type", blobInfo.getContentType());
        info.put("creation-date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(blobInfo.getCreation()));
        info.put("filename", blobInfo.getFilename());
        info.put("size", Long.toString(blobInfo.getSize()));
        info.put("md5-hash", blobInfo.getMd5Hash());
        if (uploadSession.hasGoogleStorageBucketName()) {
            String encoded = key.getKeyString().substring("encoded_gs_key:".length());
            String decoded = new String(BaseEncoding.base64Url().omitPadding().decode((CharSequence)encoded));
            info.put("gs-name", decoded);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpload(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = this.getSessionId(req);
        BlobUploadSession session = this.uploadSessionStorage.loadSession(sessionId);
        if (session == null) {
            resp.sendError(404, "No upload session: " + sessionId);
            return;
        }
        HashMap<String, ArrayList<String>> blobKeys = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<Map<String, String>>> blobInfos = new HashMap<String, ArrayList<Map<String, String>>>();
        final HashMap<String, ArrayList<String>> otherParams = new HashMap<String, ArrayList<String>>();
        try {
            MimeMultipart multipart = MultipartMimeUtils.parseMultipartRequest((HttpServletRequest)req);
            int parts = multipart.getCount();
            if (session.hasMaxUploadSizeBytes() || session.hasMaxUploadSizeBytesPerBlob()) {
                int totalSize = 0;
                int largestBlobSize = 0;
                for (int i = 0; i < parts; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    if (part.getFileName() == null || part.getFileName().isEmpty()) continue;
                    int size = part.getSize();
                    if (size != -1) {
                        totalSize += size;
                        largestBlobSize = Math.max(size, largestBlobSize);
                        continue;
                    }
                    logger.log(Level.WARNING, "Unable to determine size of upload part named " + part.getFileName() + ". Upload limit checks may not be accurate.");
                }
                if (session.hasMaxUploadSizeBytesPerBlob() && session.getMaxUploadSizeBytesPerBlob() < (long)largestBlobSize) {
                    resp.sendError(413, UPLOAD_BLOB_TOO_LARGE_RESPONSE);
                    return;
                }
                if (session.hasMaxUploadSizeBytes() && session.getMaxUploadSizeBytes() < (long)totalSize) {
                    resp.sendError(413, UPLOAD_TOTAL_TOO_LARGE_RESPONSE);
                    return;
                }
            }
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String fieldName = MultipartMimeUtils.getFieldName((BodyPart)part);
                if (part.getFileName() != null) {
                    if (part.getFileName().length() <= 0) continue;
                    BlobKey blobKey = this.assignBlobKey(session);
                    ArrayList<String> keys = (ArrayList<String>)blobKeys.get(fieldName);
                    if (keys == null) {
                        keys = new ArrayList<String>();
                        blobKeys.put(fieldName, keys);
                    }
                    keys.add(blobKey.getKeyString());
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    boolean swallowDueToThrow = true;
                    OutputStream outStream = this.getBlobStorage().storeBlob(blobKey);
                    try {
                        InputStream inStream = part.getInputStream();
                        try {
                            int bytesRead;
                            int bufferSize = 65536;
                            byte[] buffer = new byte[65536];
                            while ((bytesRead = inStream.read(buffer)) != -1) {
                                outStream.write(buffer, 0, bytesRead);
                                digest.update(buffer, 0, bytesRead);
                            }
                            outStream.close();
                            byte[] hash = digest.digest();
                            StringBuilder hashString = new StringBuilder();
                            for (int j = 0; j < hash.length; ++j) {
                                String hexValue = Integer.toHexString(0xFF & hash[j]);
                                if (hexValue.length() == 1) {
                                    hashString.append("0");
                                }
                                hashString.append(hexValue);
                            }
                            String originalContentType = part.getContentType();
                            String newContentType = this.createContentType(blobKey);
                            DataSource dataSource = MultipartMimeUtils.createDataSource((String)newContentType, (byte[])new byte[0]);
                            part.setDataHandler(new DataHandler(dataSource));
                            part.addHeader("Content-type", newContentType);
                            Clock clock = this.apiProxyLocal.getClock();
                            this.blobInfoStorage.saveBlobInfo(new BlobInfo(blobKey, originalContentType, new Date(clock.getCurrentTime()), part.getFileName(), (long)part.getSize(), hashString.toString()));
                            swallowDueToThrow = false;
                        }
                        finally {
                            Closeables.close((Closeable)inStream, (boolean)swallowDueToThrow);
                        }
                    }
                    finally {
                        Closeables.close((Closeable)outStream, (boolean)swallowDueToThrow);
                    }
                    ArrayList<Map<String, String>> infos = (ArrayList<Map<String, String>>)blobInfos.get(fieldName);
                    if (infos == null) {
                        infos = new ArrayList<Map<String, String>>();
                        blobInfos.put(fieldName, infos);
                    }
                    infos.add(this.getInfoFromStorage(blobKey, session));
                    continue;
                }
                ArrayList<String> values = (ArrayList<String>)otherParams.get(fieldName);
                if (values == null) {
                    values = new ArrayList<String>();
                    otherParams.put(fieldName, values);
                }
                values.add(MultipartMimeUtils.getTextContent((BodyPart)part));
            }
            req.setAttribute(UPLOADED_BLOBKEY_ATTR, blobKeys);
            req.setAttribute(UPLOADED_BLOBINFO_ATTR, blobInfos);
            this.uploadSessionStorage.deleteSession(sessionId);
            ByteArrayOutputStream modifiedRequest = new ByteArrayOutputStream();
            String oldValue = System.setProperty("mail.mime.foldtext", "false");
            try {
                multipart.writeTo((OutputStream)modifiedRequest);
            }
            finally {
                if (oldValue == null) {
                    System.clearProperty("mail.mime.foldtext");
                } else {
                    System.setProperty("mail.mime.foldtext", oldValue);
                }
            }
            final byte[] modifiedRequestBytes = modifiedRequest.toByteArray();
            final ByteArrayInputStream modifiedRequestStream = new ByteArrayInputStream(modifiedRequestBytes);
            final BufferedReader modifiedReader = new BufferedReader(new InputStreamReader(modifiedRequestStream));
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(req){

                public String getHeader(String name) {
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)UploadBlobServlet.UPLOAD_HEADER)) {
                        return "true";
                    }
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Length")) {
                        return String.valueOf(modifiedRequestBytes.length);
                    }
                    return super.getHeader(name);
                }

                public Enumeration<String> getHeaderNames() {
                    ArrayList headers = Collections.list(super.getHeaderNames());
                    headers.add(UploadBlobServlet.UPLOAD_HEADER);
                    return Collections.enumeration(headers);
                }

                public Enumeration<String> getHeaders(String name) {
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)UploadBlobServlet.UPLOAD_HEADER)) {
                        return Collections.enumeration(ImmutableList.of((Object)"true"));
                    }
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Length")) {
                        return Collections.enumeration(ImmutableList.of((Object)String.valueOf(modifiedRequestBytes.length)));
                    }
                    return super.getHeaders(name);
                }

                public int getIntHeader(String name) {
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)UploadBlobServlet.UPLOAD_HEADER)) {
                        throw new NumberFormatException("X-AppEngine-BlobUploaddoes not have an integer value");
                    }
                    if (Ascii.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Length")) {
                        return modifiedRequestBytes.length;
                    }
                    return super.getIntHeader(name);
                }

                public ServletInputStream getInputStream() {
                    return new ServletInputStream(){

                        public int read() {
                            return modifiedRequestStream.read();
                        }

                        public void close() throws IOException {
                            modifiedRequestStream.close();
                        }

                        public boolean isFinished() {
                            return true;
                        }

                        public boolean isReady() {
                            return true;
                        }

                        public void setReadListener(ReadListener readListener) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public BufferedReader getReader() {
                    return modifiedReader;
                }

                public Map<String, String[]> getParameterMap() {
                    Map parameters = super.getParameterMap();
                    if (otherParams.isEmpty()) {
                        return parameters;
                    }
                    HashMap<String, String[]> map = new HashMap<String, String[]>(parameters);
                    for (Map.Entry entry : otherParams.entrySet()) {
                        map.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                    }
                    return Collections.unmodifiableMap(map);
                }

                public Enumeration<String> getParameterNames() {
                    ArrayList<String> allNames = new ArrayList<String>();
                    Enumeration names = super.getParameterNames();
                    while (names.hasMoreElements()) {
                        allNames.add((String)names.nextElement());
                    }
                    allNames.addAll(otherParams.keySet());
                    return Collections.enumeration(allNames);
                }

                public String[] getParameterValues(String name) {
                    if (otherParams.containsKey(name)) {
                        return ((List)otherParams.get(name)).toArray(new String[0]);
                    }
                    return super.getParameterValues(name);
                }

                public String getParameter(String name) {
                    if (otherParams.containsKey(name)) {
                        return (String)((List)otherParams.get(name)).get(0);
                    }
                    return super.getParameter(name);
                }
            };
            String successPath = session.getSuccessPath();
            this.getServletContext().getRequestDispatcher(successPath).forward((ServletRequest)wrappedRequest, (ServletResponse)resp);
        }
        catch (NoSuchAlgorithmException | MessagingException ex) {
            throw new ServletException(ex);
        }
    }

    private BlobStorage getBlobStorage() {
        if (this.blobStorage == null) {
            this.apiProxyLocal.getService("blobstore");
            this.blobStorage = BlobStorageFactory.getBlobStorage();
        }
        return this.blobStorage;
    }

    private String createContentType(BlobKey blobKey) throws ParseException {
        ContentType contentType = new ContentType("message/external-body");
        contentType.setParameter("blob-key", blobKey.getKeyString());
        return contentType.toString();
    }

    private BlobKey assignBlobKey(BlobUploadSession session) {
        byte[] bytes = new byte[16];
        this.secureRandom.nextBytes(bytes);
        Object objectName = BaseEncoding.base64Url().omitPadding().encode(bytes);
        if (session.hasGoogleStorageBucketName()) {
            String fullName = "/gs/" + session.getGoogleStorageBucketName() + "/" + (String)objectName;
            String encodedName = BaseEncoding.base64Url().omitPadding().encode(fullName.getBytes());
            objectName = "encoded_gs_key:" + encodedName;
        }
        return new BlobKey((String)objectName);
    }
}

